% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/total_differential_nd.R
\name{total_differential_nd}
\alias{total_differential_nd}
\title{Total differential of a scalar field in R^n}
\usage{
total_differential_nd(f, x0, h = NULL)
}
\arguments{
\item{f}{Function of one argument \code{x} (numeric vector) returning a
numeric scalar.}

\item{x0}{Numeric vector giving the evaluation point.}

\item{h}{Step size for finite differences. Can be \code{NULL} (automatic),
a scalar, or a vector of the same length as \code{x0}.}
}
\value{
A list with components:
\itemize{
\item \code{point}: the numeric vector \code{x0},
\item \code{value}: the numeric value \code{f(x0)},
\item \code{gradient}: numeric vector with the gradient at \code{x0},
\item \code{differential}: a function \code{d(v)} that returns
\code{sum(gradient * v)}.
}
}
\description{
Computes the gradient of a scalar field \code{f(x)} at a point \code{x0}
using central finite differences. It also returns the total differential,
understood as the linear map \code{v -> grad f(x0) \%*\% v}.
}
\details{
The function \code{f} must take a single numeric vector \code{x} and
return a single numeric value.
}
\examples{
f <- function(x) x[1]^2 + 3 * x[2]^2
out <- total_differential_nd(f, c(1, 2))
out$gradient
out$differential(c(1, 0))  # directional derivative in direction (1,0)

}
