% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xy_region.R
\name{xy_region}
\alias{xy_region}
\title{Planar region between two curves y = H1(x) and y = H2(x)}
\usage{
xy_region(
  H1,
  H2,
  a,
  b,
  D,
  plot = TRUE,
  n_curve = 800,
  fill = FALSE,
  fillcolor = "rgba(49,130,189,0.25)",
  boundary_line = list(color = "blue", width = 2),
  partition_line = list(color = "blue", width = 1),
  show_end_edges = TRUE,
  axis_equal = TRUE,
  as_3d = FALSE,
  plane_z = 0,
  n_u = 30,
  surface_colorscale = "Blues",
  surface_opacity = 0.3,
  show_surface_grid = TRUE,
  surface_grid_color = "rgba(60,80,200,0.25)",
  surface_grid_width = 1,
  scene = list(aspectmode = "data", xaxis = list(title = "x"), yaxis = list(title = "y"),
    zaxis = list(title = "z")),
  bg = list(paper = "white", plot = "white")
)
}
\arguments{
\item{H1, H2}{Functions of one variable returning the lower and upper
vertical bounds at each value of \code{x}.}

\item{a, b}{Numeric endpoints of the interval for \code{x}. It is assumed
that \code{a < b}.}

\item{D}{Integer giving the number of subdivisions in the horizontal
direction (number of vertical strips).}

\item{plot}{Logical; if \code{TRUE}, produces a visualization using
\pkg{plotly}.}

\item{n_curve}{Integer giving the number of points for sampling the
boundary curves.}

\item{fill}{Logical; if \code{TRUE}, fills the two-dimensional region.}

\item{fillcolor}{Character string defining the fill color in 2D mode.}

\item{boundary_line}{List with \pkg{plotly} style options for drawing the
boundary curves.}

\item{partition_line}{List with style parameters for vertical partition
lines.}

\item{show_end_edges}{Logical; if \code{TRUE}, draws boundary segments at
the endpoints \code{x = a} and \code{x = b}.}

\item{axis_equal}{Logical; if \code{TRUE}, enforces equal scaling on both
axes in two dimensions.}

\item{as_3d}{Logical; if \code{TRUE}, draws the region as a thin
three-dimensional plate.}

\item{plane_z}{Numeric height at which to draw the region when
\code{as_3d = TRUE}.}

\item{n_u}{Integer number of internal subdivisions used for
discretization of the region in the cross-section (between lower and
upper boundary).}

\item{surface_colorscale}{Character string specifying a \pkg{plotly}
colorscale for the three-dimensional mode.}

\item{surface_opacity}{Numeric value between 0 and 1 controlling the
transparency of the surface in 3D mode.}

\item{show_surface_grid}{Logical; if \code{TRUE}, overlays grid lines on
the plotted surface in 3D mode.}

\item{surface_grid_color}{Character string giving the color of the grid
lines in 3D mode.}

\item{surface_grid_width}{Numeric width of the grid lines in 3D mode.}

\item{scene}{Optional list of \pkg{plotly} scene parameters for
three-dimensional rendering.}

\item{bg}{Optional list defining the background colors of the figure,
typically with components \code{paper} and \code{plot}.}
}
\value{
A list containing:
\itemize{
\item \code{x}: the sample points along the horizontal axis,
\item \code{y1}, \code{y2}: the sampled boundary values,
\item \code{y_low}, \code{y_high}: the lower and upper envelopes
\code{pmin(H1,H2)} and \code{pmax(H1,H2)},
\item \code{x_part}: the partition points used in the horizontal
direction,
\item \code{fig}: a \pkg{plotly} object for visualization if
\code{plot = TRUE} and \pkg{plotly} is available; otherwise
\code{NULL}.
}
}
\description{
Constructs a numerical representation of the planar region bounded by
two functions of one variable. The region consists of all points whose
horizontal coordinate lies between \code{a} and \code{b}, and whose
vertical coordinate lies between the values returned by \code{H1(x)}
and \code{H2(x)}. Optionally, the region can be displayed either as a
two-dimensional filled subset of the plane or as a thin surface in
three dimensions using \pkg{plotly}.
}
\details{
The function samples the interval \code{[a, b]} at \code{n_curve} points
to represent the boundary curves. The interval \code{[a, b]} is also
subdivided into \code{D} vertical strips. For each strip, the values
\code{H1(x)} and \code{H2(x)} are evaluated to define the vertical bounds
of the region.

Depending on the arguments, the function can:
\itemize{
\item build a data grid suitable for numerical integration or
visualization,
\item draw a two-dimensional depiction of the region, possibly filled
with a selected color,
\item generate a simple three-dimensional visualization where the
region is drawn as a thin plate at a chosen height.
}

Additional options allow drawing grid lines, showing the boundary curves,
controlling colors and transparency, and adjusting the aspect ratio.
}
\examples{
H1 <- function(x) 0
H2 <- function(x) 1 - x
xy_region(H1, H2, a = 0, b = 1, D = 20, plot = FALSE)

}
