% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_distribution_summary.R
\name{calculate_distribution_summary}
\alias{calculate_distribution_summary}
\title{Calculate Distribution Summary Statistics}
\usage{
calculate_distribution_summary(plot_data, metric)
}
\arguments{
\item{plot_data}{A data frame containing the metric data with columns:
\itemize{
\item \code{group}: The grouping variable
\item \verb{<metric>}: The metric column (name specified in metric parameter)
}}

\item{metric}{Character string containing the name of the metric column}
}
\value{
A data frame with distribution statistics:
\itemize{
\item \code{group}: The grouping variable
\item \code{mean}: Mean of the metric
\item \code{min}: Minimum value of the metric
\item \code{p10}: 10th percentile of the metric
\item \code{p25}: 25th percentile of the metric
\item \code{p50}: 50th percentile (median) of the metric
\item \code{p75}: 75th percentile of the metric
\item \code{p90}: 90th percentile of the metric
\item \code{max}: Maximum value of the metric
\item \code{sd}: Standard deviation of the metric
\item \code{range}: Range of the metric (max - min)
\item \code{n}: Number of observations
}
}
\description{
Internal helper function to calculate comprehensive distribution statistics
for a given metric grouped by a categorical variable. Used by create_hist(),
create_density(), and create_boxplot() to ensure consistent output.
}
\keyword{internal}
