% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tables.R
\name{tab_metrics}
\alias{tab_metrics}
\title{Output a table with distribution parameters}
\usage{
tab_metrics(data, cols, cross = NULL, metric = FALSE, clean = TRUE, ...)
}
\arguments{
\item{data}{A data frame.}

\item{cols}{A tidy column selection,
e.g. a single column (without quotes)
or multiple columns selected by methods such as starts_with().}

\item{cross}{Optional, a grouping column (without quotes).}

\item{metric}{When crossing variables, the cross column parameter can contain categorical or metric values.
By default, the cross column selection is treated as categorical data.
Set metric to TRUE, to treat it as metric and calculate correlations.}

\item{clean}{Prepare data by \link{data_clean}.}

\item{...}{Other parameters passed to the appropriate table function.}
}
\value{
A volker tibble.
}
\description{
The table type depends on the number of selected columns:
\itemize{
\item One metric column: see \link{tab_metrics_one}
\item Multiple metric columns: see \link{tab_metrics_items}
}

Group comparisons:
\itemize{
\item One metric column and one grouping column: see \link{tab_metrics_one_grouped}
\item Multiple metric columns and one grouping column: see \link{tab_metrics_items_grouped}
\item Multiple metric columns and multiple grouping columns: see \link{tab_metrics_items_grouped_items} (not yet implemented)
}

By default, if you provide two column selections, the second column is treated as categorical.
Setting the metric-parameter to TRUE will call the appropriate functions for correlation analysis:
\itemize{
\item Two metric columns: see \link{tab_metrics_one_cor}
\item Multiple metric columns and one metric column: see \link{tab_metrics_items_cor}
\item Two metric column selections: see \link{tab_metrics_items_cor_items}
}

Parameters that may be passed to specific metric functions:
\itemize{
\item \strong{ci}: Add confidence intervals for means or correlation coefficients.
\item \strong{values}: The output metrics, mean (m), the standard deviation (sd) or both (the default).
\item \strong{digits}: Tables containing means and standard deviations by default round values to one digit.
Increase the number to show more digits
\item \strong{method}: By default, correlations are calculated using Pearson’s R.
You can choose Spearman’s Rho with the methods-parameter.
\item \strong{labels}: Labels are extracted from the column attributes.
Set to FALSE to output bare column names and values.
}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
library(volker)
data <- volker::chatgpt

tab_metrics(data, sd_age)

}
