% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_ghcn_stations.R
\name{import_ghcn_stations}
\alias{import_ghcn_stations}
\title{Import station metadata for the Global Historical Climatology Network}
\usage{
import_ghcn_stations(
  name = NULL,
  country = NULL,
  state = NULL,
  lat = NULL,
  lng = NULL,
  crs = 4326,
  n_max = 10L,
  database = c("hourly", "daily"),
  return = c("table", "sf", "map")
)
}
\arguments{
\item{name, country, state}{String values to use to filter the metadata for
specific site names, countries and states. \code{country} and \code{state} are
matched exactly to codes accessed using \code{\link[=import_ghcn_countries]{import_ghcn_countries()}}. \code{name}
is searched as a sub-string case insensitively.}

\item{lat, lng, n_max}{Decimal latitude (\code{lat}) and longitude (\code{lng}) (or other
Y/X coordinate if using a different \code{crs}). If provided, the \code{n_max}
closest ISD stations to this coordinate will be returned.}

\item{crs}{The coordinate reference system (CRS) of the data, passed to
\code{\link[sf:st_crs]{sf::st_crs()}}. By default this is \href{https://epsg.io/4326}{EPSG:4326}, the
CRS associated with the commonly used latitude and longitude coordinates.
Different coordinate systems can be specified using \code{crs} (e.g., \code{crs = 27700} for the \href{https://epsg.io/27700}{British National Grid}). Note that
non-lat/lng coordinate systems will be re-projected to \code{EPSG:4326} for
making comparisons with the NOAA metadata.}

\item{database}{One of \code{"hourly"} or \code{"daily"}, which defines whether to
import stations available in the GHCNh or GHCNd. Note that there is overlap
between the two, but some stations may only be available in one or the
other.}

\item{return}{The type of R object to import the GHCN stations as. One of the
following:
\itemize{
\item \code{"table"}, which returns an R \code{data.frame}.
\item \code{"sf"}, which returns a spatial \code{data.frame} from the \code{sf} package.
\item \code{"map"}, which returns an interactive \code{leaflet} map.
}}
}
\value{
One of:
\itemize{
\item a \link[tibble:tibble-package]{tibble}
\item an \link[sf:st_as_sf]{sf} object
\item an interactive \code{leaflet} map
}
}
\description{
This function accesses a full list of GHCN stations available through either
the GHCNh or GHCNd. As well as the station \code{id}, needed for importing
measurement data, useful geographic and network metadata is also returned.
}
\seealso{
Other GHCN functions: 
\code{\link{import_ghcn_countries}()},
\code{\link{import_ghcn_daily}()},
\code{\link{import_ghcn_hourly}()},
\code{\link{import_ghcn_inventory}()},
\code{\link{import_ghcn_monthly_temp}()}
}
\author{
Jack Davison
}
\concept{GHCN functions}
