% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terminate.R
\name{TerminationFactory}
\alias{TerminationFactory}
\title{Configure the termination condition(s) 
a genetic algorithm.}
\usage{
TerminationFactory(method = "NoTermination")
}
\arguments{
\item{method}{A string specifying the termination condition.}
}
\value{
A boolean function implementing the termination condition.
}
\description{
\code{TerminationFactory()} implements the selection
             of a termination method.

Current support:

\enumerate{
  \item "NoTermination" returns 
       \code{terminatedFalse}. (Default)
  \item "AbsoluteError" returns 
       \code{terminateAbsoluteError()}. 
       For benchmark functions with known global optima.
       Termination condition is fulfilled if the current 
       best solution is in the interval 
       from (globalOptimum-eps) to (globalOptimum+eps).
  \item "RelativeError" returns 
       \code{terminateRelativeError()}. 
       For benchmark functions with known global optima.
       Termination condition is fulfilled if the current 
       best solution is in the interval 
       from (globalOptimum-(globalOptimum*eps)) to 
       (globalOptimum+(globalOptimum*eps)).
       Does not specify an interval if globalOptimum is zero.
  \item "RelativeErrorZero" returns 
       \code{terminateRelativeErrorZero()}. 
       For benchmark functions with known global optima.
       Termination condition is fulfilled if the current 
       best solution is in the interval 
       from (globalOptimum-(globalOptimum*eps)) to 
       (globalOptimum+(globalOptimum*eps)).
       If the globalOptimum is zero, the interval is 
       from \code{-terminationEps} to \code{terminationEps}. 
 \item "PAC" returns \code{terminatePAC()}. Terminates, as soon as the fitness is
       is better than a confidence interval depending on the mean
       and \code{stats::qnorm(PACdelta, lower.tail=FALSE)}
       times the standard deviation of the fitness of the initial population.
 \item "GEQ" returns \code{terminateGEQ()}. Terminates as soon as the 
       phenotype value of the solution is greater equal than \code{lF$TerminationThreshol()}.
 \item "LEQ" returns \code{terminateLEQ()}. Terminates as soon as the 
       phenotype value of the solution is less equal than \code{lF$TerminationThreshol()}.
   }
}
\seealso{
Other Configuration: 
\code{\link{AcceptFactory}()},
\code{\link{ApplyFactory}()},
\code{\link{CoolingFactory}()},
\code{\link{CrossRateFactory}()},
\code{\link{MutationRateFactory}()},
\code{\link{checkTerminationFactory}()},
\code{\link{xegaAsPipelineFactory}()},
\code{\link{xegaConfiguration}()},
\code{\link{xegaEvalPopulationFactory}()}
}
\concept{Configuration}
