% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaNextPopulation.R
\name{xegaNextPopulation}
\alias{xegaNextPopulation}
\title{Computes the next population of genes.}
\usage{
xegaNextPopulation(pop, fit, lF)
}
\arguments{
\item{pop}{Population of genes.}

\item{fit}{Fitness.}

\item{lF}{Local configuration.}
}
\value{
Population of genes.
}
\description{
\code{xegaNextPopulation()} 
             builds the next population by repeatedly
             calling \code{ReplicateGene()}.
}
\details{
Generating the next population is sequential. 
         However, in order to shift more computations 
         into the evaluation step, genetic operator pipelines
         have been implemented by 
         \code{lF$ReplicateGene()}. 
         \code{xegaNextPopulation()} only has to convert 
         elitist solutions into function closures.            

         For adaptive genetic operators, population statistics and 
         the current generation are stored as constant functions 
         in \code{lF}.
}
\examples{
lFxegaGaGene$Pipeline<-function() {"NoPipe"}
lFxegaGaGene$cGeneration<-function() {0}
lFxegaGaGene$MutationRate<-MutationRateFactory(method="Const")
lFxegaGaGene$ReplicateGene<-ReplicateGene
lFxegaGaGene$Accept<-AcceptFactory(method="All")
pop10<-xegaInitPopulation(10, lFxegaGaGene)
epop10<-xegaEvalPopulation(pop10, lFxegaGaGene)
newpop<-xegaNextPopulation(epop10$pop, epop10$fit, lFxegaGaGene)

}
\seealso{
Other Population Layer: 
\code{\link{xegaBestGeneInPopulation}()},
\code{\link{xegaBestInPopulation}()},
\code{\link{xegaEvalPopulation}()},
\code{\link{xegaInitPopulation}()},
\code{\link{xegaLogEvalsPopulation}()},
\code{\link{xegaObservePopulation}()},
\code{\link{xegaRepEvalPopulation}()},
\code{\link{xegaSummaryPopulation}()}
}
\concept{Population Layer}
