% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yml_helpers.R
\name{has_field}
\alias{has_field}
\title{Check if field exists in YAML}
\usage{
has_field(.yml, field)
}
\arguments{
\item{.yml}{a \code{yml} object created by \code{yml()}, \code{as_yml()}, or returned by
a \verb{yml_*()} function}

\item{field}{A character vector, the name of the field(s) to check for}
}
\value{
logical
}
\description{
\code{has_field()} retrieves the names of all fields (including nested fields) and
checks if \code{field} is among them.
}
\examples{

has_field(yml(), "author")
has_field(yml(), "toc")

}
\seealso{
Other yml: 
\code{\link{asis_yaml_output}()},
\code{\link{bib2yml}()},
\code{\link{draw_yml_tree}()},
\code{\link{read_json}()},
\code{\link{use_yml}()},
\code{\link{use_yml_defaults}()},
\code{\link{use_yml_file}()},
\code{\link{yml_author}()},
\code{\link{yml_blogdown_opts}()},
\code{\link{yml_bookdown_opts}()},
\code{\link{yml_citations}()},
\code{\link{yml_clean}()},
\code{\link{yml_distill_opts}()},
\code{\link{yml_latex_opts}()},
\code{\link{yml_output}()},
\code{\link{yml_pagedown_opts}()},
\code{\link{yml_params}()},
\code{\link{yml_pkgdown}()},
\code{\link{yml_reference}()},
\code{\link{yml_replace}()},
\code{\link{yml_resource_files}()},
\code{\link{yml_rsconnect_email}()},
\code{\link{yml_rticles_opts}()},
\code{\link{yml_runtime}()},
\code{\link{yml_site_opts}()},
\code{\link{yml_toc}()},
\code{\link{yml_vignette}()}
}
\concept{yml}
