; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mattr=+sve -force-streaming-compatible < %s | FileCheck %s
; RUN: llc -mattr=+sme -force-streaming < %s | FileCheck %s
; RUN: llc -force-streaming-compatible < %s | FileCheck %s --check-prefix=NONEON-NOSVE


target triple = "aarch64-unknown-linux-gnu"

;
; RBIT
;

define <4 x i8> @bitreverse_v4i8(<4 x i8> %op) {
; CHECK-LABEL: bitreverse_v4i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    rbit z0.h, p0/m, z0.h
; CHECK-NEXT:    lsr z0.h, z0.h, #8
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: bitreverse_v4i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str d0, [sp, #-16]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #6]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #24
; NONEON-NOSVE-NEXT:    strh w8, [sp, #14]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #4]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #24
; NONEON-NOSVE-NEXT:    strh w8, [sp, #12]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #2]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #24
; NONEON-NOSVE-NEXT:    strh w8, [sp, #10]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #24
; NONEON-NOSVE-NEXT:    strh w8, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #8]
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call <4 x i8> @llvm.bitreverse.v4i8(<4 x i8> %op)
  ret <4 x i8> %res
}

define <8 x i8> @bitreverse_v8i8(<8 x i8> %op) {
; CHECK-LABEL: bitreverse_v8i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.b, vl8
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    rbit z0.b, p0/m, z0.b
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: bitreverse_v8i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str d0, [sp, #-16]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #7]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #24
; NONEON-NOSVE-NEXT:    strb w8, [sp, #15]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #6]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #24
; NONEON-NOSVE-NEXT:    strb w8, [sp, #14]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #5]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #24
; NONEON-NOSVE-NEXT:    strb w8, [sp, #13]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #4]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #24
; NONEON-NOSVE-NEXT:    strb w8, [sp, #12]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #3]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #24
; NONEON-NOSVE-NEXT:    strb w8, [sp, #11]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #2]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #24
; NONEON-NOSVE-NEXT:    strb w8, [sp, #10]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #1]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #24
; NONEON-NOSVE-NEXT:    strb w8, [sp, #9]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #24
; NONEON-NOSVE-NEXT:    strb w8, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #8]
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call <8 x i8> @llvm.bitreverse.v8i8(<8 x i8> %op)
  ret <8 x i8> %res
}

define <16 x i8> @bitreverse_v16i8(<16 x i8> %op) {
; CHECK-LABEL: bitreverse_v16i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.b, vl16
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    rbit z0.b, p0/m, z0.b
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: bitreverse_v16i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str q0, [sp, #-32]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #15]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #24
; NONEON-NOSVE-NEXT:    strb w8, [sp, #31]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #14]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #24
; NONEON-NOSVE-NEXT:    strb w8, [sp, #30]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #13]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #24
; NONEON-NOSVE-NEXT:    strb w8, [sp, #29]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #12]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #24
; NONEON-NOSVE-NEXT:    strb w8, [sp, #28]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #11]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #24
; NONEON-NOSVE-NEXT:    strb w8, [sp, #27]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #10]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #24
; NONEON-NOSVE-NEXT:    strb w8, [sp, #26]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #9]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #24
; NONEON-NOSVE-NEXT:    strb w8, [sp, #25]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #8]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #24
; NONEON-NOSVE-NEXT:    strb w8, [sp, #24]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #7]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #24
; NONEON-NOSVE-NEXT:    strb w8, [sp, #23]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #6]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #24
; NONEON-NOSVE-NEXT:    strb w8, [sp, #22]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #5]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #24
; NONEON-NOSVE-NEXT:    strb w8, [sp, #21]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #4]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #24
; NONEON-NOSVE-NEXT:    strb w8, [sp, #20]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #3]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #24
; NONEON-NOSVE-NEXT:    strb w8, [sp, #19]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #2]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #24
; NONEON-NOSVE-NEXT:    strb w8, [sp, #18]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #1]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #24
; NONEON-NOSVE-NEXT:    strb w8, [sp, #17]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #24
; NONEON-NOSVE-NEXT:    strb w8, [sp, #16]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #16]
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %res = call <16 x i8> @llvm.bitreverse.v16i8(<16 x i8> %op)
  ret <16 x i8> %res
}

define void @bitreverse_v32i8(ptr %a) {
; CHECK-LABEL: bitreverse_v32i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.b, vl16
; CHECK-NEXT:    rbit z0.b, p0/m, z0.b
; CHECK-NEXT:    rbit z1.b, p0/m, z1.b
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: bitreverse_v32i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #31]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #24
; NONEON-NOSVE-NEXT:    strb w8, [sp, #63]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #30]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #24
; NONEON-NOSVE-NEXT:    strb w8, [sp, #62]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #29]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #24
; NONEON-NOSVE-NEXT:    strb w8, [sp, #61]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #28]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #24
; NONEON-NOSVE-NEXT:    strb w8, [sp, #60]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #27]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #24
; NONEON-NOSVE-NEXT:    strb w8, [sp, #59]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #26]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #24
; NONEON-NOSVE-NEXT:    strb w8, [sp, #58]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #25]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #24
; NONEON-NOSVE-NEXT:    strb w8, [sp, #57]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #24]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #24
; NONEON-NOSVE-NEXT:    strb w8, [sp, #56]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #23]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #24
; NONEON-NOSVE-NEXT:    strb w8, [sp, #55]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #22]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #24
; NONEON-NOSVE-NEXT:    strb w8, [sp, #54]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #21]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #24
; NONEON-NOSVE-NEXT:    strb w8, [sp, #53]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #20]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #24
; NONEON-NOSVE-NEXT:    strb w8, [sp, #52]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #19]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #24
; NONEON-NOSVE-NEXT:    strb w8, [sp, #51]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #18]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #24
; NONEON-NOSVE-NEXT:    strb w8, [sp, #50]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #17]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #24
; NONEON-NOSVE-NEXT:    strb w8, [sp, #49]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #16]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #24
; NONEON-NOSVE-NEXT:    strb w8, [sp, #48]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #15]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #24
; NONEON-NOSVE-NEXT:    strb w8, [sp, #47]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #14]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #24
; NONEON-NOSVE-NEXT:    strb w8, [sp, #46]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #13]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #24
; NONEON-NOSVE-NEXT:    strb w8, [sp, #45]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #12]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #24
; NONEON-NOSVE-NEXT:    strb w8, [sp, #44]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #11]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #24
; NONEON-NOSVE-NEXT:    strb w8, [sp, #43]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #10]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #24
; NONEON-NOSVE-NEXT:    strb w8, [sp, #42]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #9]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #24
; NONEON-NOSVE-NEXT:    strb w8, [sp, #41]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #8]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #24
; NONEON-NOSVE-NEXT:    strb w8, [sp, #40]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #7]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #24
; NONEON-NOSVE-NEXT:    strb w8, [sp, #39]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #6]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #24
; NONEON-NOSVE-NEXT:    strb w8, [sp, #38]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #5]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #24
; NONEON-NOSVE-NEXT:    strb w8, [sp, #37]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #4]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #24
; NONEON-NOSVE-NEXT:    strb w8, [sp, #36]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #3]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #24
; NONEON-NOSVE-NEXT:    strb w8, [sp, #35]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #2]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #24
; NONEON-NOSVE-NEXT:    strb w8, [sp, #34]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #1]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #24
; NONEON-NOSVE-NEXT:    strb w8, [sp, #33]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #24
; NONEON-NOSVE-NEXT:    strb w8, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op = load <32 x i8>, ptr %a
  %res = call <32 x i8> @llvm.bitreverse.v32i8(<32 x i8> %op)
  store <32 x i8> %res, ptr %a
  ret void
}

define <2 x i16> @bitreverse_v2i16(<2 x i16> %op) {
; CHECK-LABEL: bitreverse_v2i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    rbit z0.s, p0/m, z0.s
; CHECK-NEXT:    lsr z0.s, z0.s, #16
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: bitreverse_v2i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str d0, [sp, #-16]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #4]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w9, w8, #16
; NONEON-NOSVE-NEXT:    ldr w8, [sp]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #16
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #8]
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call <2 x i16> @llvm.bitreverse.v2i16(<2 x i16> %op)
  ret <2 x i16> %res
}

define <4 x i16> @bitreverse_v4i16(<4 x i16> %op) {
; CHECK-LABEL: bitreverse_v4i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    rbit z0.h, p0/m, z0.h
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: bitreverse_v4i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str d0, [sp, #-16]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #6]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #16
; NONEON-NOSVE-NEXT:    strh w8, [sp, #14]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #4]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #16
; NONEON-NOSVE-NEXT:    strh w8, [sp, #12]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #2]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #16
; NONEON-NOSVE-NEXT:    strh w8, [sp, #10]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #16
; NONEON-NOSVE-NEXT:    strh w8, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #8]
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call <4 x i16> @llvm.bitreverse.v4i16(<4 x i16> %op)
  ret <4 x i16> %res
}

define <8 x i16> @bitreverse_v8i16(<8 x i16> %op) {
; CHECK-LABEL: bitreverse_v8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    rbit z0.h, p0/m, z0.h
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: bitreverse_v8i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str q0, [sp, #-32]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #14]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #16
; NONEON-NOSVE-NEXT:    strh w8, [sp, #30]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #12]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #16
; NONEON-NOSVE-NEXT:    strh w8, [sp, #28]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #10]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #16
; NONEON-NOSVE-NEXT:    strh w8, [sp, #26]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #8]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #16
; NONEON-NOSVE-NEXT:    strh w8, [sp, #24]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #6]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #16
; NONEON-NOSVE-NEXT:    strh w8, [sp, #22]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #4]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #16
; NONEON-NOSVE-NEXT:    strh w8, [sp, #20]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #2]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #16
; NONEON-NOSVE-NEXT:    strh w8, [sp, #18]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #16
; NONEON-NOSVE-NEXT:    strh w8, [sp, #16]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #16]
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %res = call <8 x i16> @llvm.bitreverse.v8i16(<8 x i16> %op)
  ret <8 x i16> %res
}

define void @bitreverse_v16i16(ptr %a) {
; CHECK-LABEL: bitreverse_v16i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    rbit z0.h, p0/m, z0.h
; CHECK-NEXT:    rbit z1.h, p0/m, z1.h
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: bitreverse_v16i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #30]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #16
; NONEON-NOSVE-NEXT:    strh w8, [sp, #62]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #28]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #16
; NONEON-NOSVE-NEXT:    strh w8, [sp, #60]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #26]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #16
; NONEON-NOSVE-NEXT:    strh w8, [sp, #58]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #24]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #16
; NONEON-NOSVE-NEXT:    strh w8, [sp, #56]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #22]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #16
; NONEON-NOSVE-NEXT:    strh w8, [sp, #54]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #20]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #16
; NONEON-NOSVE-NEXT:    strh w8, [sp, #52]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #18]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #16
; NONEON-NOSVE-NEXT:    strh w8, [sp, #50]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #16]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #16
; NONEON-NOSVE-NEXT:    strh w8, [sp, #48]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #14]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #16
; NONEON-NOSVE-NEXT:    strh w8, [sp, #46]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #12]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #16
; NONEON-NOSVE-NEXT:    strh w8, [sp, #44]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #10]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #16
; NONEON-NOSVE-NEXT:    strh w8, [sp, #42]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #8]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #16
; NONEON-NOSVE-NEXT:    strh w8, [sp, #40]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #6]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #16
; NONEON-NOSVE-NEXT:    strh w8, [sp, #38]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #4]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #16
; NONEON-NOSVE-NEXT:    strh w8, [sp, #36]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #2]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #16
; NONEON-NOSVE-NEXT:    strh w8, [sp, #34]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #16
; NONEON-NOSVE-NEXT:    strh w8, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op = load <16 x i16>, ptr %a
  %res = call <16 x i16> @llvm.bitreverse.v16i16(<16 x i16> %op)
  store <16 x i16> %res, ptr %a
  ret void
}

define <2 x i32> @bitreverse_v2i32(<2 x i32> %op) {
; CHECK-LABEL: bitreverse_v2i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    rbit z0.s, p0/m, z0.s
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: bitreverse_v2i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str d0, [sp, #-16]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #4]
; NONEON-NOSVE-NEXT:    rbit w9, w8
; NONEON-NOSVE-NEXT:    ldr w8, [sp]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #8]
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call <2 x i32> @llvm.bitreverse.v2i32(<2 x i32> %op)
  ret <2 x i32> %res
}

define <4 x i32> @bitreverse_v4i32(<4 x i32> %op) {
; CHECK-LABEL: bitreverse_v4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    rbit z0.s, p0/m, z0.s
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: bitreverse_v4i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str q0, [sp, #-32]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #12]
; NONEON-NOSVE-NEXT:    rbit w9, w8
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #8]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #24]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #4]
; NONEON-NOSVE-NEXT:    rbit w9, w8
; NONEON-NOSVE-NEXT:    ldr w8, [sp]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #16]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #16]
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %res = call <4 x i32> @llvm.bitreverse.v4i32(<4 x i32> %op)
  ret <4 x i32> %res
}

define void @bitreverse_v8i32(ptr %a) {
; CHECK-LABEL: bitreverse_v8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    rbit z0.s, p0/m, z0.s
; CHECK-NEXT:    rbit z1.s, p0/m, z1.s
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: bitreverse_v8i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #28]
; NONEON-NOSVE-NEXT:    rbit w9, w8
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #24]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #56]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #20]
; NONEON-NOSVE-NEXT:    rbit w9, w8
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #16]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #48]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #12]
; NONEON-NOSVE-NEXT:    rbit w9, w8
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #8]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #40]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #4]
; NONEON-NOSVE-NEXT:    rbit w9, w8
; NONEON-NOSVE-NEXT:    ldr w8, [sp]
; NONEON-NOSVE-NEXT:    rbit w8, w8
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op = load <8 x i32>, ptr %a
  %res = call <8 x i32> @llvm.bitreverse.v8i32(<8 x i32> %op)
  store <8 x i32> %res, ptr %a
  ret void
}

define <1 x i64> @bitreverse_v1i64(<1 x i64> %op) {
; CHECK-LABEL: bitreverse_v1i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl1
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    rbit z0.d, p0/m, z0.d
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: bitreverse_v1i64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #16
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    fmov x8, d0
; NONEON-NOSVE-NEXT:    rbit x8, x8
; NONEON-NOSVE-NEXT:    str x8, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #8]
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call <1 x i64> @llvm.bitreverse.v1i64(<1 x i64> %op)
  ret <1 x i64> %res
}

define <2 x i64> @bitreverse_v2i64(<2 x i64> %op) {
; CHECK-LABEL: bitreverse_v2i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    rbit z0.d, p0/m, z0.d
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: bitreverse_v2i64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str q0, [sp, #-32]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #8]
; NONEON-NOSVE-NEXT:    rbit x9, x8
; NONEON-NOSVE-NEXT:    ldr x8, [sp]
; NONEON-NOSVE-NEXT:    rbit x8, x8
; NONEON-NOSVE-NEXT:    stp x8, x9, [sp, #16]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #16]
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %res = call <2 x i64> @llvm.bitreverse.v2i64(<2 x i64> %op)
  ret <2 x i64> %res
}

define void @bitreverse_v4i64(ptr %a) {
; CHECK-LABEL: bitreverse_v4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    rbit z0.d, p0/m, z0.d
; CHECK-NEXT:    rbit z1.d, p0/m, z1.d
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: bitreverse_v4i64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #24]
; NONEON-NOSVE-NEXT:    rbit x9, x8
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #16]
; NONEON-NOSVE-NEXT:    rbit x8, x8
; NONEON-NOSVE-NEXT:    stp x8, x9, [sp, #48]
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #8]
; NONEON-NOSVE-NEXT:    rbit x9, x8
; NONEON-NOSVE-NEXT:    ldr x8, [sp]
; NONEON-NOSVE-NEXT:    rbit x8, x8
; NONEON-NOSVE-NEXT:    stp x8, x9, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op = load <4 x i64>, ptr %a
  %res = call <4 x i64> @llvm.bitreverse.v4i64(<4 x i64> %op)
  store <4 x i64> %res, ptr %a
  ret void
}

;
; REVB
;

define <2 x i16> @bswap_v2i16(<2 x i16> %op) {
; CHECK-LABEL: bswap_v2i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    revb z0.s, p0/m, z0.s
; CHECK-NEXT:    lsr z0.s, z0.s, #16
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: bswap_v2i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str d0, [sp, #-32]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #4]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #15]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #5]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #14]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #6]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #13]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #7]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #12]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #11]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #1]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #10]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #2]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #9]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #3]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #8]
; NONEON-NOSVE-NEXT:    str d0, [sp, #16]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #22]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #18]
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #24]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #24]
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %res = call <2 x i16> @llvm.bswap.v2i16(<2 x i16> %op)
  ret <2 x i16> %res
}

define <4 x i16> @bswap_v4i16(<4 x i16> %op) {
; CHECK-LABEL: bswap_v4i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    revb z0.h, p0/m, z0.h
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: bswap_v4i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str d0, [sp, #-16]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #6]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #15]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #7]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #14]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #4]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #13]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #5]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #12]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #2]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #11]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #3]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #10]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #9]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #1]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #8]
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call <4 x i16> @llvm.bswap.v4i16(<4 x i16> %op)
  ret <4 x i16> %res
}

define <8 x i16> @bswap_v8i16(<8 x i16> %op) {
; CHECK-LABEL: bswap_v8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    revb z0.h, p0/m, z0.h
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: bswap_v8i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str q0, [sp, #-32]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #14]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #31]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #15]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #30]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #12]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #29]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #13]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #28]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #10]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #27]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #11]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #26]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #8]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #25]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #9]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #24]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #6]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #23]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #7]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #22]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #4]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #21]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #5]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #20]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #2]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #19]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #3]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #18]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #17]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #1]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #16]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #16]
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %res = call <8 x i16> @llvm.bswap.v8i16(<8 x i16> %op)
  ret <8 x i16> %res
}

define void @bswap_v16i16(ptr %a) {
; CHECK-LABEL: bswap_v16i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    revb z0.h, p0/m, z0.h
; CHECK-NEXT:    revb z1.h, p0/m, z1.h
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: bswap_v16i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldr q0, [x0, #16]
; NONEON-NOSVE-NEXT:    str q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #14]
; NONEON-NOSVE-NEXT:    ldr q0, [x0]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #31]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #15]
; NONEON-NOSVE-NEXT:    str q0, [sp, #32]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #30]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #12]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #29]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #13]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #28]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #10]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #27]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #11]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #26]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #8]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #25]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #9]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #24]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #6]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #23]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #7]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #22]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #4]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #21]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #5]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #20]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #2]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #19]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #3]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #18]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #17]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #1]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #16]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #46]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #16]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #63]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #47]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #62]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #44]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #61]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #45]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #60]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #42]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #59]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #43]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #58]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #40]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #57]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #41]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #56]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #38]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #55]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #39]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #54]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #36]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #53]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #37]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #52]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #34]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #51]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #35]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #50]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #32]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #49]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #33]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #48]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #48]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op = load <16 x i16>, ptr %a
  %res = call <16 x i16> @llvm.bswap.v16i16(<16 x i16> %op)
  store <16 x i16> %res, ptr %a
  ret void
}

define <2 x i32> @bswap_v2i32(<2 x i32> %op) {
; CHECK-LABEL: bswap_v2i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    revb z0.s, p0/m, z0.s
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: bswap_v2i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str d0, [sp, #-16]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #4]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #15]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #5]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #14]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #6]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #13]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #7]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #12]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #11]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #1]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #10]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #2]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #9]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #3]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #8]
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call <2 x i32> @llvm.bswap.v2i32(<2 x i32> %op)
  ret <2 x i32> %res
}

define <4 x i32> @bswap_v4i32(<4 x i32> %op) {
; CHECK-LABEL: bswap_v4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    revb z0.s, p0/m, z0.s
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: bswap_v4i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str q0, [sp, #-32]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #12]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #31]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #13]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #30]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #14]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #29]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #15]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #28]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #8]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #27]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #9]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #26]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #10]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #25]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #11]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #24]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #4]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #23]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #5]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #22]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #6]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #21]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #7]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #20]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #19]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #1]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #18]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #2]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #17]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #3]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #16]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #16]
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %res = call <4 x i32> @llvm.bswap.v4i32(<4 x i32> %op)
  ret <4 x i32> %res
}

define void @bswap_v8i32(ptr %a) {
; CHECK-LABEL: bswap_v8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    revb z0.s, p0/m, z0.s
; CHECK-NEXT:    revb z1.s, p0/m, z1.s
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: bswap_v8i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldr q0, [x0, #16]
; NONEON-NOSVE-NEXT:    str q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #12]
; NONEON-NOSVE-NEXT:    ldr q0, [x0]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #31]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #13]
; NONEON-NOSVE-NEXT:    str q0, [sp, #32]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #30]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #14]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #29]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #15]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #28]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #8]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #27]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #9]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #26]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #10]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #25]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #11]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #24]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #4]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #23]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #5]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #22]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #6]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #21]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #7]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #20]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #19]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #1]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #18]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #2]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #17]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #3]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #16]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #44]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #16]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #63]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #45]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #62]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #46]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #61]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #47]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #60]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #40]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #59]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #41]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #58]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #42]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #57]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #43]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #56]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #36]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #55]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #37]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #54]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #38]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #53]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #39]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #52]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #32]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #51]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #33]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #50]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #34]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #49]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #35]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #48]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #48]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op = load <8 x i32>, ptr %a
  %res = call <8 x i32> @llvm.bswap.v8i32(<8 x i32> %op)
  store <8 x i32> %res, ptr %a
  ret void
}

define <1 x i64> @bswap_v1i64(<1 x i64> %op) {
; CHECK-LABEL: bswap_v1i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl1
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    revb z0.d, p0/m, z0.d
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: bswap_v1i64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str d0, [sp, #-16]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldrb w8, [sp]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #15]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #1]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #14]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #2]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #13]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #3]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #12]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #4]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #11]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #5]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #10]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #6]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #9]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #7]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #8]
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call <1 x i64> @llvm.bswap.v1i64(<1 x i64> %op)
  ret <1 x i64> %res
}

define <2 x i64> @bswap_v2i64(<2 x i64> %op) {
; CHECK-LABEL: bswap_v2i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    revb z0.d, p0/m, z0.d
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: bswap_v2i64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str q0, [sp, #-32]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #8]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #31]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #9]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #30]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #10]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #29]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #11]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #28]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #12]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #27]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #13]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #26]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #14]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #25]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #15]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #24]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #23]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #1]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #22]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #2]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #21]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #3]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #20]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #4]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #19]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #5]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #18]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #6]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #17]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #7]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #16]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #16]
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %res = call <2 x i64> @llvm.bswap.v2i64(<2 x i64> %op)
  ret <2 x i64> %res
}

define void @bswap_v4i64(ptr %a) {
; CHECK-LABEL: bswap_v4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    revb z0.d, p0/m, z0.d
; CHECK-NEXT:    revb z1.d, p0/m, z1.d
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: bswap_v4i64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldr q0, [x0, #16]
; NONEON-NOSVE-NEXT:    str q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr q0, [x0]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #31]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #9]
; NONEON-NOSVE-NEXT:    str q0, [sp, #32]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #30]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #10]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #29]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #11]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #28]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #12]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #27]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #13]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #26]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #14]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #25]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #15]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #24]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #23]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #1]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #22]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #2]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #21]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #3]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #20]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #4]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #19]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #5]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #18]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #6]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #17]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #7]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #16]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #40]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #16]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #63]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #41]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #62]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #42]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #61]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #43]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #60]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #44]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #59]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #45]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #58]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #46]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #57]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #47]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #56]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #32]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #55]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #33]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #54]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #34]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #53]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #35]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #52]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #36]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #51]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #37]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #50]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #38]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #49]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #39]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #48]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #48]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op = load <4 x i64>, ptr %a
  %res = call <4 x i64> @llvm.bswap.v4i64(<4 x i64> %op)
  store <4 x i64> %res, ptr %a
  ret void
}

declare <4 x i8> @llvm.bitreverse.v4i8(<4 x i8>)
declare <8 x i8> @llvm.bitreverse.v8i8(<8 x i8>)
declare <16 x i8> @llvm.bitreverse.v16i8(<16 x i8>)
declare <32 x i8> @llvm.bitreverse.v32i8(<32 x i8>)
declare <2 x i16> @llvm.bitreverse.v2i16(<2 x i16>)
declare <4 x i16> @llvm.bitreverse.v4i16(<4 x i16>)
declare <8 x i16> @llvm.bitreverse.v8i16(<8 x i16>)
declare <16 x i16> @llvm.bitreverse.v16i16(<16 x i16>)
declare <2 x i32> @llvm.bitreverse.v2i32(<2 x i32>)
declare <4 x i32> @llvm.bitreverse.v4i32(<4 x i32>)
declare <8 x i32> @llvm.bitreverse.v8i32(<8 x i32>)
declare <1 x i64> @llvm.bitreverse.v1i64(<1 x i64>)
declare <2 x i64> @llvm.bitreverse.v2i64(<2 x i64>)
declare <4 x i64> @llvm.bitreverse.v4i64(<4 x i64>)

declare <2 x i16> @llvm.bswap.v2i16(<2 x i16>)
declare <4 x i16> @llvm.bswap.v4i16(<4 x i16>)
declare <8 x i16> @llvm.bswap.v8i16(<8 x i16>)
declare <16 x i16> @llvm.bswap.v16i16(<16 x i16>)
declare <2 x i32> @llvm.bswap.v2i32(<2 x i32>)
declare <4 x i32> @llvm.bswap.v4i32(<4 x i32>)
declare <8 x i32> @llvm.bswap.v8i32(<8 x i32>)
declare <1 x i64> @llvm.bswap.v1i64(<1 x i64>)
declare <2 x i64> @llvm.bswap.v2i64(<2 x i64>)
declare <4 x i64> @llvm.bswap.v4i64(<4 x i64>)
