#ifndef AOQPLOT_WINDOW_H
#define AOQPLOT_WINDOW_H

#include <memory>
#include <string>
#include <vector>

#include <giomm/menu.h>

#include <gtkmm/application.h>
#include <gtkmm/applicationwindow.h>
#include <gtkmm/box.h>
#include <gtkmm/dialog.h>
#include <gtkmm/menubutton.h>
#include <gtkmm/notebook.h>
#include <gtkmm/statusbar.h>
#include <gtkmm/togglebutton.h>

#include "../quality/qualitytablesformatter.h"

#include "plotsheet.h"
#include "openoptionswindow.h"

#include "../structures/antennainfo.h"

#include "controllers/aoqpagecontroller.h"

class AOQPlotWindow : public Gtk::ApplicationWindow {
 public:
  explicit AOQPlotWindow(class AOQPlotController* controller);

  void Open(const std::vector<std::string>& files);
  void Open(const std::string& file) {
    std::vector<std::string> files(1);
    files[0] = file;
    Open(files);
  }
  void SetStatus(const std::string& newStatus) { onStatusChange(newStatus); }

  void ShowError(const std::string& message);

  void SetShowHistograms(bool show) { /*_histogramMI.set_sensitive(show);*/
  }

 private:
  void onOpenOptionsSelected(const std::vector<std::string>& files,
                             bool downsampleTime, bool downsampleFreq,
                             size_t timeSize, size_t freqSize,
                             bool correctHistograms);
  void close();
  void readDistributedObservation(const std::string& filename,
                                  bool correctHistograms);
  void readMetaInfoFromMS(const std::string& filename);
  void readAndCombine(const std::string& filename);

  void onStatusChange(const std::string& newStatus);

  void onChangeSheet(int new_sheet);

  class AOQPlotController* _controller;
  int _activeSheetIndex;
  Gtk::Box toolbar_;
  Gtk::MenuButton page_menu_button_;
  std::shared_ptr<Gio::SimpleAction> page_selection_;

  Gtk::Box _vBox{Gtk::Orientation::VERTICAL};
  Gtk::Statusbar _statusBar;

  std::unique_ptr<AOQPageController> _pageController;
  std::unique_ptr<PlotSheet> plot_page_;

  OpenOptionsWindow _openOptionsWindow;
  std::shared_ptr<Gtk::Dialog> dialog_;
};

#endif
