# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


@register_command(
    "network watcher test-ip-flow",
)
class TestIpFlow(AAZCommand):
    """Test IP flow to/from a VM given the currently configured network security group rules.

    Requires that Network Watcher is enabled for the region in which the VM is located. For more information visit https://learn.microsoft.com/en-us/azure/network-watcher/diagnose-vm-network-traffic-filtering-problem-cli.

    :example: Run test-ip-flow verify to test logical connectivity from a VM to the specified destination IPv4 address and port.
        az network watcher test-ip-flow -g MyResourceGroup --direction Outbound --protocol TCP --local 10.0.0.4:* --remote 10.1.0.4:80 --vm MyVm
    """

    _aaz_info = {
        "version": "2022-01-01",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.network/networkwatchers/{}/ipflowverify", "2022-01-01"],
        ]
    }

    AZ_SUPPORT_NO_WAIT = True

    def _handler(self, command_args):
        super()._handler(command_args)
        return self.build_lro_poller(self._execute_operations, self._output)

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.watcher_name = AAZStrArg(
            options=["--watcher-name"],
            help="Name of the network watcher.",
            required=True,
            id_part="name",
        )
        _args_schema.watcher_rg = AAZResourceGroupNameArg(
            options=["--watcher-rg"],
            help="Name of the resource group the watcher is in.",
            required=True,
        )
        _args_schema.direction = AAZStrArg(
            options=["--direction"],
            help="Direction of the packet relative to the VM.",
            required=True,
            enum={"Inbound": "Inbound", "Outbound": "Outbound"},
        )
        _args_schema.protocol = AAZStrArg(
            options=["--protocol"],
            help="Protocol to test.",
            required=True,
            enum={"TCP": "TCP", "UDP": "UDP"},
        )
        _args_schema.nic = AAZStrArg(
            options=["--nic"],
            help="Name or ID of the NIC resource to test. If the VM has multiple NICs and IP forwarding is enabled on any of them, this parameter is required.",
        )
        _args_schema.vm = AAZStrArg(
            options=["--vm"],
            help="Name or ID of the VM to target. If the name of the VM is provided, the `--resource-group` is required.",
            required=True,
        )

        # define Arg Group "Parameters"

        _args_schema = cls._args_schema
        _args_schema.local_ip_address = AAZStrArg(
            options=["--local-ip-address"],
            arg_group="Parameters",
            help="The local IP address. Acceptable values are valid IPv4 addresses.",
            required=True,
        )
        _args_schema.local_port = AAZStrArg(
            options=["--local-port"],
            arg_group="Parameters",
            help="The local port. Acceptable values are a single integer in the range (0-65535). Support for * for the source port, which depends on the direction.",
            required=True,
        )
        _args_schema.remote_ip_address = AAZStrArg(
            options=["--remote-ip-address"],
            arg_group="Parameters",
            help="The remote IP address. Acceptable values are valid IPv4 addresses.",
            required=True,
        )
        _args_schema.remote_port = AAZStrArg(
            options=["--remote-port"],
            arg_group="Parameters",
            help="The remote port. Acceptable values are a single integer in the range (0-65535). Support for * for the source port, which depends on the direction.",
            required=True,
        )
        return cls._args_schema

    def _execute_operations(self):
        self.pre_operations()
        yield self.NetworkWatchersVerifyIPFlow(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=True)
        return result

    class NetworkWatchersVerifyIPFlow(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [202]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200,
                    self.on_error,
                    lro_options={"final-state-via": "location"},
                    path_format_arguments=self.url_parameters,
                )
            if session.http_response.status_code in [200]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200,
                    self.on_error,
                    lro_options={"final-state-via": "location"},
                    path_format_arguments=self.url_parameters,
                )

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/ipFlowVerify",
                **self.url_parameters
            )

        @property
        def method(self):
            return "POST"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "networkWatcherName", self.ctx.args.watcher_name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.watcher_rg,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2022-01-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Content-Type", "application/json",
                ),
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        @property
        def content(self):
            _content_value, _builder = self.new_content_builder(
                self.ctx.args,
                typ=AAZObjectType,
                typ_kwargs={"flags": {"required": True, "client_flatten": True}}
            )
            _builder.set_prop("direction", AAZStrType, ".direction", typ_kwargs={"flags": {"required": True}})
            _builder.set_prop("localIPAddress", AAZStrType, ".local_ip_address", typ_kwargs={"flags": {"required": True}})
            _builder.set_prop("localPort", AAZStrType, ".local_port", typ_kwargs={"flags": {"required": True}})
            _builder.set_prop("protocol", AAZStrType, ".protocol", typ_kwargs={"flags": {"required": True}})
            _builder.set_prop("remoteIPAddress", AAZStrType, ".remote_ip_address", typ_kwargs={"flags": {"required": True}})
            _builder.set_prop("remotePort", AAZStrType, ".remote_port", typ_kwargs={"flags": {"required": True}})
            _builder.set_prop("targetNicResourceId", AAZStrType, ".nic")
            _builder.set_prop("targetResourceId", AAZStrType, ".vm", typ_kwargs={"flags": {"required": True}})

            return self.serialize_content(_content_value)

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()
            _TestIpFlowHelper._build_schema_verification_ip_flow_result_read(cls._schema_on_200)

            return cls._schema_on_200


class _TestIpFlowHelper:
    """Helper class for TestIpFlow"""

    _schema_verification_ip_flow_result_read = None

    @classmethod
    def _build_schema_verification_ip_flow_result_read(cls, _schema):
        if cls._schema_verification_ip_flow_result_read is not None:
            _schema.access = cls._schema_verification_ip_flow_result_read.access
            _schema.rule_name = cls._schema_verification_ip_flow_result_read.rule_name
            return

        cls._schema_verification_ip_flow_result_read = _schema_verification_ip_flow_result_read = AAZObjectType()

        verification_ip_flow_result_read = _schema_verification_ip_flow_result_read
        verification_ip_flow_result_read.access = AAZStrType()
        verification_ip_flow_result_read.rule_name = AAZStrType(
            serialized_name="ruleName",
        )

        _schema.access = cls._schema_verification_ip_flow_result_read.access
        _schema.rule_name = cls._schema_verification_ip_flow_result_read.rule_name


__all__ = ["TestIpFlow"]
