/*
 * Created on Oct 9, 2004
 * Created by Alon Rohter
 * Copyright (C) Azureus Software, Inc, All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

package com.biglybt.core.networkmanager;

/**
 * Allows for grouping of connections under a singular limit.
 */
public interface LimitedRateGroup {

  public String getName();

  /**
   * Get the current rate limit.
   * @return rate in bytes per second, 0 for unlimited, -1 for disabled (BUT it is better to use isDisabled as some
   * rate limiters implement logical disablement via other means (e.g. a download can implement it by disabling individual peers....)
   */

  public long getRateLimitBytesPerSecond();

  public void updateBytesUsed( long num );

  /**
   * Best way to check if rate limiter is effectively disabled
   * @return
   */

  public boolean isDisabled();
}
