import { Fragment, useState } from 'react';
import {
  Alert,
  AlertProps,
  AlertGroup,
  AlertActionCloseButton,
  AlertVariant,
  Flex,
  FlexItem
} from '@patternfly/react-core';
import buttonStyles from '@patternfly/react-styles/css/components/Button/button';

export const AlertGroupMultipleDynamic: React.FunctionComponent = () => {
  const [alerts, setAlerts] = useState<Partial<AlertProps>[]>([]);

  const addAlerts = (incomingAlerts: Partial<AlertProps>[]) => {
    setAlerts((prevAlerts) => [...incomingAlerts, ...prevAlerts]);
  };

  const removeAlert = (key: React.Key) => {
    setAlerts((prevAlerts) => [...prevAlerts.filter((alert) => alert.key !== key)]);
  };

  const btnClasses = [buttonStyles.button, buttonStyles.modifiers.secondary].join(' ');

  const getUniqueId = () => String.fromCharCode(65 + Math.floor(Math.random() * 26)) + Date.now();

  const addAlertCollection = () => {
    addAlerts([
      { title: 'First alert notification.', variant: 'success', key: getUniqueId() },
      { title: 'Second alert notification.', variant: 'warning', key: getUniqueId() },
      { title: 'Third alert notification.', variant: 'danger', key: getUniqueId() }
    ]);
  };

  return (
    <Fragment>
      <Flex gap={{ default: 'gapXs' }}>
        <FlexItem>
          <button onClick={addAlertCollection} type="button" className={btnClasses}>
            Add alert collection
          </button>
        </FlexItem>
      </Flex>
      <AlertGroup hasAnimations isToast isLiveRegion>
        {alerts.map(({ title, variant, key }) => (
          <Alert
            variant={AlertVariant[variant]}
            title={title}
            key={key}
            actionClose={
              <AlertActionCloseButton
                title={title as string}
                variantLabel={`${variant} alert`}
                onClose={() => removeAlert(key)}
              />
            }
          />
        ))}
      </AlertGroup>
    </Fragment>
  );
};
