PRAGMA foreign_keys=OFF;
BEGIN TRANSACTION;
CREATE TABLE suite_params(key TEXT, value TEXT, PRIMARY KEY(key));
INSERT INTO suite_params VALUES('uuid_str','0d0bf7e8-4543-4aeb-8bc6-397e3a03ee19');
INSERT INTO suite_params VALUES('run_mode','live');
INSERT INTO suite_params VALUES('cylc_version','7.9.9');
INSERT INTO suite_params VALUES('UTC_mode','0');
INSERT INTO suite_params VALUES('cycle_point_format','CCYY');
INSERT INTO suite_params VALUES('cycle_point_tz','+1200');
CREATE TABLE task_jobs(cycle TEXT, name TEXT, submit_num INTEGER, is_manual_submit INTEGER, try_num INTEGER, time_submit TEXT, time_submit_exit TEXT, submit_status INTEGER, time_run TEXT, time_run_exit TEXT, run_signal TEXT, run_status INTEGER, user_at_host TEXT, batch_sys_name TEXT, batch_sys_job_id TEXT, PRIMARY KEY(cycle, name, submit_num));
INSERT INTO task_jobs VALUES('2051','foo',1,0,1,'2024-05-30T14:11:40+12:00','2024-05-30T14:11:40+12:00',0,'2024-05-30T14:11:40+12:00','2024-05-30T14:11:40+12:00',NULL,0,'NIWA-1022450.niwa.local','background','12272');
INSERT INTO task_jobs VALUES('2051','bar',1,0,1,'2024-05-30T14:11:42+12:00','2024-05-30T14:11:42+12:00',0,'2024-05-30T14:11:42+12:00','2024-05-30T14:11:42+12:00',NULL,0,'NIWA-1022450.niwa.local','background','12327');
CREATE TABLE task_late_flags(cycle TEXT, name TEXT, value INTEGER, PRIMARY KEY(cycle, name));
CREATE TABLE broadcast_states_checkpoints(id INTEGER, point TEXT, namespace TEXT, key TEXT, value TEXT, PRIMARY KEY(id, point, namespace, key));
CREATE TABLE checkpoint_id(id INTEGER, time TEXT, event TEXT, PRIMARY KEY(id));
INSERT INTO checkpoint_id VALUES(0,'2024-05-30T14:11:43+12:00','latest');
CREATE TABLE inheritance(namespace TEXT, inheritance TEXT, PRIMARY KEY(namespace));
INSERT INTO inheritance VALUES('root','["root"]');
INSERT INTO inheritance VALUES('foo','["foo", "root"]');
INSERT INTO inheritance VALUES('bar','["bar", "root"]');
CREATE TABLE suite_params_checkpoints(id INTEGER, key TEXT, value TEXT, PRIMARY KEY(id, key));
CREATE TABLE task_pool_checkpoints(id INTEGER, cycle TEXT, name TEXT, spawned INTEGER, status TEXT, hold_swap TEXT, PRIMARY KEY(id, cycle, name));
CREATE TABLE task_outputs(cycle TEXT, name TEXT, outputs TEXT, PRIMARY KEY(cycle, name));
INSERT INTO task_outputs VALUES('2051','foo','{"x": "the quick brown fox"}');
CREATE TABLE broadcast_states(point TEXT, namespace TEXT, key TEXT, value TEXT, PRIMARY KEY(point, namespace, key));
CREATE TABLE task_timeout_timers(cycle TEXT, name TEXT, timeout REAL, PRIMARY KEY(cycle, name));
CREATE TABLE task_states(name TEXT, cycle TEXT, time_created TEXT, time_updated TEXT, submit_num INTEGER, status TEXT, PRIMARY KEY(name, cycle));
INSERT INTO task_states VALUES('foo','2051','2024-05-30T14:11:40+12:00','2024-05-30T14:11:41+12:00',1,'succeeded');
INSERT INTO task_states VALUES('bar','2051','2024-05-30T14:11:40+12:00','2024-05-30T14:11:43+12:00',1,NULL);
CREATE TABLE broadcast_events(time TEXT, change TEXT, point TEXT, namespace TEXT, key TEXT, value TEXT);
CREATE TABLE task_events(name TEXT, cycle TEXT, time TEXT, submit_num INTEGER, event TEXT, message TEXT);
INSERT INTO task_events VALUES('foo','2051','2024-05-30T14:11:41+12:00',1,'submitted','');
INSERT INTO task_events VALUES('foo','2051','2024-05-30T14:11:41+12:00',1,'started','');
INSERT INTO task_events VALUES('foo','2051','2024-05-30T14:11:41+12:00',1,'x','the quick brown fox');
INSERT INTO task_events VALUES('foo','2051','2024-05-30T14:11:41+12:00',1,'succeeded','');
INSERT INTO task_events VALUES('bar','2051','2024-05-30T14:11:43+12:00',1,'submitted','');
INSERT INTO task_events VALUES('bar','2051','2024-05-30T14:11:43+12:00',1,'started','');
INSERT INTO task_events VALUES('bar','2051','2024-05-30T14:11:43+12:00',1,'succeeded','');
CREATE TABLE suite_template_vars(key TEXT, value TEXT, PRIMARY KEY(key));
CREATE TABLE task_pool(cycle TEXT, name TEXT, spawned INTEGER, status TEXT, hold_swap TEXT, PRIMARY KEY(cycle, name));
INSERT INTO task_pool VALUES('2051','foo',1,'succeeded',NULL);
INSERT INTO task_pool VALUES('2051','bar',1,'succeeded',NULL);
CREATE TABLE xtriggers(signature TEXT, results TEXT, PRIMARY KEY(signature));
CREATE TABLE task_action_timers(cycle TEXT, name TEXT, ctx_key TEXT, ctx TEXT, delays TEXT, num INTEGER, delay TEXT, timeout TEXT, PRIMARY KEY(cycle, name, ctx_key));
INSERT INTO task_action_timers VALUES('2051','foo','["try_timers", "retrying"]','null','[]',0,NULL,NULL);
INSERT INTO task_action_timers VALUES('2051','foo','["try_timers", "submit-retrying"]','null','[]',0,NULL,NULL);
INSERT INTO task_action_timers VALUES('2051','bar','["try_timers", "retrying"]','null','[]',0,NULL,NULL);
INSERT INTO task_action_timers VALUES('2051','bar','["try_timers", "submit-retrying"]','null','[]',0,NULL,NULL);
COMMIT;
