"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.rectifyAvarTable = void 0;
const Ot = require("@ot-builder/ot");
function rectifyAvarTable(rec, avar) {
    const maps1 = new Map();
    for (const [dim, sgm] of avar.segmentMaps) {
        const mappedDim = rec.dim(dim);
        if (mappedDim)
            maps1.set(mappedDim, sgm);
    }
    for (const axis of rec.addedAxes) {
        maps1.set(axis.dim, [
            [-1, -1],
            [0, 0],
            [1, 1]
        ]);
    }
    return new Ot.Avar.Table(maps1);
}
exports.rectifyAvarTable = rectifyAvarTable;
//# sourceMappingURL=avar.js.map