import { OtVar } from "@ot-builder/variance";
import * as CffInterp from "../../interp/ir";
import { CffStackMachine } from "../../interp/stack-machine";
export interface CffCharStringInterpState {
    getRandom(): number;
    transient: OtVar.Value[];
    log: string;
}
export interface CffSubroutineSource {
    readonly global: Buffer[];
    readonly local: Buffer[];
    readonly defaultWidthX: OtVar.Value;
    readonly nominalWidthX: OtVar.Value;
}
export interface CffCharStringDataSink {
    stemQuantity: number;
    setWidth(x: OtVar.Value): void;
    addStemHint(isVertical: boolean, startEdge: OtVar.Value, endEdge: OtVar.Value): void;
    addHintMask(isCounterMask: boolean, flags: number[]): void;
    startContour(): void;
    lineTo(x: OtVar.Value, y: OtVar.Value): void;
    curveTo(x1: OtVar.Value, y1: OtVar.Value, x2: OtVar.Value, y2: OtVar.Value, x3: OtVar.Value, y3: OtVar.Value): void;
    endChar(): void;
}
export declare class CffCharStringInterpreter extends CffInterp.Interpreter {
    private readonly irSource;
    private readonly state;
    private readonly subroutines;
    private readonly sink;
    constructor(irSource: CffInterp.IrFlagPuller, state: CffStackMachine & CffCharStringInterpState, subroutines: CffSubroutineSource, sink: CffCharStringDataSink);
    doOperand(x: number): void;
    halt: boolean;
    end: boolean;
    protected doOperator(opCode: number): number | void | TypeError;
    private doStemHint;
    private doMove;
    private doRLineTo;
    private doVLineTo;
    private doHLineTo;
    private doRRCurveTo;
    private doRCurveLine;
    private doRLineCurve;
    private doVVCurveTo;
    private doHHCurveTo;
    private doVHCurveTo;
    private doHVCurveTo;
    private doFlex;
    private doHFlex;
    private doHFlex1;
    private doFlex1;
    private doAnd;
    private doOr;
    private doNot;
    private doEq;
    private doAbs;
    private doAdd;
    private doSub;
    private doNeg;
    private doMul;
    private doDiv;
    private doSqrt;
    private doRandom;
    private doDrop;
    private doDup;
    private doExch;
    private doIndex;
    private doRoll;
    private doGet;
    private doPut;
    private doConditional;
    private doEndChar;
    private doReturn;
    private getLocalSubroutine;
    private getGlobalSubroutine;
}
export declare function callCharString(buf: Buffer, st: CffStackMachine & CffCharStringInterpState, ss: CffSubroutineSource, ds: CffCharStringDataSink): boolean;
export declare function interpretCharString(buf: Buffer, st: CffStackMachine & CffCharStringInterpState, ss: CffSubroutineSource, ds: CffCharStringDataSink): void;
export declare function computeSubroutineBias(cnt: number): 107 | 1131 | 32768;
//# sourceMappingURL=interpreter.d.ts.map