---
date: 2026-02-19
section: 1
title: GO
header: Go programming tools and commands
footer: Go 1.26
---

# NAME

go - tool for managing Go source code

# SYNOPSIS

**go** *command* \[*arguments*\]

# DESCRIPTION

The Go distribution includes a command, named **go**, that automates the
downloading, building, installation, and testing of Go packages and
commands.

# COMMANDS

Each command is documented in its own manpage. For example, the
**build** command is documented in **go-build**(1).

**bug**

:   start a bug report

**build**

:   compile packages and dependencies

**clean**

:   remove object files and cached files

**doc**

:   show documentation for package or symbol

**env**

:   print Go environment information

**fix**

:   apply fixes suggested by static checkers

**fmt**

:   gofmt (reformat) package sources

**generate**

:   generate Go files by processing source

**get**

:   add dependencies to current module and install them

**install**

:   compile and install packages and dependencies

**list**

:   list packages or modules

**mod**

:   module maintenance

**work**

:   workspace maintenance

**run**

:   compile and run Go program

**telemetry**

:   manage telemetry data and settings

**test**

:   test packages

**tool**

:   run specified go tool

**version**

:   print Go version

**vet**

:   report likely mistakes in packages

Use "go help \<command\>" for more information about a command.

Additional help topics:

**buildconstraint**
:   build constraints

**buildjson**
:   build -json encoding

**buildmode**
:   build modes

**c**
:   calling between Go and C

**cache**
:   build and test caching

**environment**
:   environment variables

**filetype**
:   file types

**goauth**
:   GOAUTH environment variable

**go.mod**
:   the go.mod file

**gopath**
:   GOPATH environment variable

**goproxy**
:   module proxy protocol

**importpath**
:   import path syntax

**modules**
:   modules, module versions, and more

**module-auth**
:   module authentication using go.sum

**packages**
:   package lists and patterns

**private**
:   configuration for downloading non-public code

**testflag**
:   testing flags

**testfunc**
:   testing functions

**vcs**
:   controlling version control with GOVCS

Use "go help \<topic\>" for more information about that topic.

# AUTHOR

This manual page was created using help2man and afterwards updating the
output. It is maintained by the Debian Go Compiler Team
\<team+go-compiler@tracker.debian.org\> for the Debian project (and may
be used by others).
