//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armappplatform_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/appplatform/armappplatform/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1f22d4dbd99b0fe347ad79e79d4eb1ed44a87291/specification/appplatform/resource-manager/Microsoft.AppPlatform/preview/2023-01-01-preview/examples/RuntimeVersions_ListRuntimeVersions.json
func ExampleRuntimeVersionsClient_ListRuntimeVersions() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappplatform.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewRuntimeVersionsClient().ListRuntimeVersions(ctx, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AvailableRuntimeVersions = armappplatform.AvailableRuntimeVersions{
	// 	Value: []*armappplatform.SupportedRuntimeVersion{
	// 		{
	// 			Platform: to.Ptr(armappplatform.SupportedRuntimePlatformJava),
	// 			Value: to.Ptr(armappplatform.SupportedRuntimeValueJava8),
	// 			Version: to.Ptr("8"),
	// 		},
	// 		{
	// 			Platform: to.Ptr(armappplatform.SupportedRuntimePlatformJava),
	// 			Value: to.Ptr(armappplatform.SupportedRuntimeValueJava11),
	// 			Version: to.Ptr("11"),
	// 		},
	// 		{
	// 			Platform: to.Ptr(armappplatform.SupportedRuntimePlatformJava),
	// 			Value: to.Ptr(armappplatform.SupportedRuntimeValueJava17),
	// 			Version: to.Ptr("17"),
	// 		},
	// 		{
	// 			Platform: to.Ptr(armappplatform.SupportedRuntimePlatformNETCore),
	// 			Value: to.Ptr(armappplatform.SupportedRuntimeValueNetCore31),
	// 			Version: to.Ptr("3.1"),
	// 	}},
	// }
}
