//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/authorization/armauthorization/v3"
	"net/http"
	"regexp"
)

// ClassicAdministratorsServer is a fake server for instances of the armauthorization.ClassicAdministratorsClient type.
type ClassicAdministratorsServer struct {
	// NewListPager is the fake for method ClassicAdministratorsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(options *armauthorization.ClassicAdministratorsClientListOptions) (resp azfake.PagerResponder[armauthorization.ClassicAdministratorsClientListResponse])
}

// NewClassicAdministratorsServerTransport creates a new instance of ClassicAdministratorsServerTransport with the provided implementation.
// The returned ClassicAdministratorsServerTransport instance is connected to an instance of armauthorization.ClassicAdministratorsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewClassicAdministratorsServerTransport(srv *ClassicAdministratorsServer) *ClassicAdministratorsServerTransport {
	return &ClassicAdministratorsServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armauthorization.ClassicAdministratorsClientListResponse]](),
	}
}

// ClassicAdministratorsServerTransport connects instances of armauthorization.ClassicAdministratorsClient to instances of ClassicAdministratorsServer.
// Don't use this type directly, use NewClassicAdministratorsServerTransport instead.
type ClassicAdministratorsServerTransport struct {
	srv          *ClassicAdministratorsServer
	newListPager *tracker[azfake.PagerResponder[armauthorization.ClassicAdministratorsClientListResponse]]
}

// Do implements the policy.Transporter interface for ClassicAdministratorsServerTransport.
func (c *ClassicAdministratorsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ClassicAdministratorsClient.NewListPager":
		resp, err = c.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (c *ClassicAdministratorsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := c.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/classicAdministrators`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := c.srv.NewListPager(nil)
		newListPager = &resp
		c.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armauthorization.ClassicAdministratorsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		c.newListPager.remove(req)
	}
	return resp, nil
}
