package gen_test

import (
	"reflect"
	"testing"

	"github.com/leanovate/gopter/gen"
)

func TestComplex128Shrinker(t *testing.T) {
	zeroShrinks := gen.Complex128Shrinker(0 + 0i).All()
	if !reflect.DeepEqual(zeroShrinks, []interface{}{}) {
		t.Errorf("Invalid zeroShrinks: %#v", zeroShrinks)
	}

	oneShrink := gen.Complex128Shrinker(1 + 0i).All()
	if !reflect.DeepEqual(oneShrink, []interface{}{
		(0 + 0i), (0.5 + 0i), (-0.5 + 0i), (0.75 + 0i), (-0.75 + 0i), (0.875 + 0i), (-0.875 + 0i),
		(0.9375 + 0i), (-0.9375 + 0i), (0.96875 + 0i), (-0.96875 + 0i), (0.984375 + 0i),
		(-0.984375 + 0i), (0.9921875 + 0i), (-0.9921875 + 0i), (0.99609375 + 0i),
		(-0.99609375 + 0i), (0.998046875 + 0i), (-0.998046875 + 0i), (0.9990234375 + 0i),
		(-0.9990234375 + 0i), (0.99951171875 + 0i), (-0.99951171875 + 0i), (0.999755859375 + 0i),
		(-0.999755859375 + 0i), (0.9998779296875 + 0i), (-0.9998779296875 + 0i),
		(0.99993896484375 + 0i), (-0.99993896484375 + 0i), (0.999969482421875 + 0i),
		(-0.999969482421875 + 0i), (0.9999847412109375 + 0i), (-0.9999847412109375 + 0i),
	}) {
		t.Errorf("Invalid oneShrink: %#v", oneShrink)
	}

	iShrink := gen.Complex128Shrinker(1i).All()
	if !reflect.DeepEqual(iShrink, []interface{}{
		(0 + 0i), (0 + 0.5i), (0 - 0.5i), (0 + 0.75i), (0 - 0.75i), (0 + 0.875i), (0 - 0.875i),
		(0 + 0.9375i), (0 - 0.9375i), (0 + 0.96875i), (0 - 0.96875i), (0 + 0.984375i),
		(0 - 0.984375i), (0 + 0.9921875i), (0 - 0.9921875i), (0 + 0.99609375i), (0 - 0.99609375i),
		(0 + 0.998046875i), (0 - 0.998046875i), (0 + 0.9990234375i), (0 - 0.9990234375i),
		(0 + 0.99951171875i), (0 - 0.99951171875i), (0 + 0.999755859375i), (0 - 0.999755859375i),
		(0 + 0.9998779296875i), (0 - 0.9998779296875i), (0 + 0.99993896484375i),
		(0 - 0.99993896484375i), (0 + 0.999969482421875i), (0 - 0.999969482421875i),
		(0 + 0.9999847412109375i), (0 - 0.9999847412109375i),
	}) {
		t.Errorf("Invalid iShrink: %#v", iShrink)
	}

	teniShrink := gen.Complex128Shrinker(10 + 1i).All()
	if !reflect.DeepEqual(teniShrink, []interface{}{(0 + 1i), (10 + 0i), (5 + 1i), (10 + 0.5i),
		(-5 + 1i), (10 - 0.5i), (7.5 + 1i), (10 + 0.75i), (-7.5 + 1i), (10 - 0.75i), (8.75 + 1i),
		(10 + 0.875i), (-8.75 + 1i), (10 - 0.875i), (9.375 + 1i), (10 + 0.9375i), (-9.375 + 1i),
		(10 - 0.9375i), (9.6875 + 1i), (10 + 0.96875i), (-9.6875 + 1i), (10 - 0.96875i),
		(9.84375 + 1i), (10 + 0.984375i), (-9.84375 + 1i), (10 - 0.984375i), (9.921875 + 1i),
		(10 + 0.9921875i), (-9.921875 + 1i), (10 - 0.9921875i), (9.9609375 + 1i),
		(10 + 0.99609375i), (-9.9609375 + 1i), (10 - 0.99609375i), (9.98046875 + 1i),
		(10 + 0.998046875i), (-9.98046875 + 1i), (10 - 0.998046875i), (9.990234375 + 1i),
		(10 + 0.9990234375i), (-9.990234375 + 1i), (10 - 0.9990234375i), (9.9951171875 + 1i),
		(10 + 0.99951171875i), (-9.9951171875 + 1i), (10 - 0.99951171875i), (9.99755859375 + 1i),
		(10 + 0.999755859375i), (-9.99755859375 + 1i), (10 - 0.999755859375i),
		(9.998779296875 + 1i), (10 + 0.9998779296875i), (-9.998779296875 + 1i),
		(10 - 0.9998779296875i), (9.9993896484375 + 1i), (10 + 0.99993896484375i),
		(-9.9993896484375 + 1i), (10 - 0.99993896484375i), (9.99969482421875 + 1i),
		(10 + 0.999969482421875i), (-9.99969482421875 + 1i), (10 - 0.999969482421875i),
		(9.999847412109375 + 1i), (10 + 0.9999847412109375i), (-9.999847412109375 + 1i),
		(10 - 0.9999847412109375i), (9.999923706054688 + 1i), (-9.999923706054688 + 1i),
		(9.999961853027344 + 1i), (-9.999961853027344 + 1i), (9.999980926513672 + 1i),
		(-9.999980926513672 + 1i),
	}) {
		t.Errorf("Invalid teniShrink: %#v", teniShrink)
	}
}

func TestComplex64Shrinker(t *testing.T) {
	zeroShrinks := gen.Complex64Shrinker(complex64(0 + 0i)).All()
	if !reflect.DeepEqual(zeroShrinks, []interface{}{}) {
		t.Errorf("Invalid zeroShrinks: %#v", zeroShrinks)
	}

	oneShrink := gen.Complex64Shrinker(complex64(1 + 0i)).All()
	if !reflect.DeepEqual(oneShrink, []interface{}{
		complex64(0 + 0i), complex64(0.5 + 0i), complex64(-0.5 + 0i), complex64(0.75 + 0i),
		complex64(-0.75 + 0i), complex64(0.875 + 0i), complex64(-0.875 + 0i),
		complex64(0.9375 + 0i), complex64(-0.9375 + 0i), complex64(0.96875 + 0i),
		complex64(-0.96875 + 0i), complex64(0.984375 + 0i), complex64(-0.984375 + 0i),
		complex64(0.9921875 + 0i), complex64(-0.9921875 + 0i), complex64(0.99609375 + 0i),
		complex64(-0.99609375 + 0i), complex64(0.9980469 + 0i), complex64(-0.9980469 + 0i),
		complex64(0.99902344 + 0i), complex64(-0.99902344 + 0i), complex64(0.9995117 + 0i),
		complex64(-0.9995117 + 0i), complex64(0.99975586 + 0i), complex64(-0.99975586 + 0i),
		complex64(0.9998779 + 0i), complex64(-0.9998779 + 0i), complex64(0.99993896 + 0i),
		complex64(-0.99993896 + 0i), complex64(0.9999695 + 0i), complex64(-0.9999695 + 0i),
		complex64(0.99998474 + 0i), complex64(-0.99998474 + 0i),
	}) {
		t.Errorf("Invalid oneShrink: %#v", oneShrink)
	}
}
