// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.1
// 	protoc        v4.25.3
// source: google/shopping/merchant/quota/v1beta/quota.proto

package quotapb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The group information for methods in the Merchant API. The quota is shared
// between all methods in the group. Even if none of the methods within the
// group have usage the information for the group is returned.
type QuotaGroup struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. The resource name of the quota group.
	// Format: accounts/{account}/quotas/{group}
	// Note: There is no guarantee on the format of {group}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The current quota usage, meaning the number of calls already
	// made on a given day to the methods in the group. The daily quota limits
	// reset at at 12:00 PM midday UTC.
	QuotaUsage int64 `protobuf:"varint,2,opt,name=quota_usage,json=quotaUsage,proto3" json:"quota_usage,omitempty"`
	// Output only. The maximum number of calls allowed per day for the group.
	QuotaLimit int64 `protobuf:"varint,3,opt,name=quota_limit,json=quotaLimit,proto3" json:"quota_limit,omitempty"`
	// Output only. The maximum number of calls allowed per minute for the group.
	QuotaMinuteLimit int64 `protobuf:"varint,5,opt,name=quota_minute_limit,json=quotaMinuteLimit,proto3" json:"quota_minute_limit,omitempty"`
	// Output only. List of all methods group quota applies to.
	MethodDetails []*MethodDetails `protobuf:"bytes,4,rep,name=method_details,json=methodDetails,proto3" json:"method_details,omitempty"`
}

func (x *QuotaGroup) Reset() {
	*x = QuotaGroup{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_quota_v1beta_quota_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QuotaGroup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QuotaGroup) ProtoMessage() {}

func (x *QuotaGroup) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_quota_v1beta_quota_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QuotaGroup.ProtoReflect.Descriptor instead.
func (*QuotaGroup) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_quota_v1beta_quota_proto_rawDescGZIP(), []int{0}
}

func (x *QuotaGroup) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *QuotaGroup) GetQuotaUsage() int64 {
	if x != nil {
		return x.QuotaUsage
	}
	return 0
}

func (x *QuotaGroup) GetQuotaLimit() int64 {
	if x != nil {
		return x.QuotaLimit
	}
	return 0
}

func (x *QuotaGroup) GetQuotaMinuteLimit() int64 {
	if x != nil {
		return x.QuotaMinuteLimit
	}
	return 0
}

func (x *QuotaGroup) GetMethodDetails() []*MethodDetails {
	if x != nil {
		return x.MethodDetails
	}
	return nil
}

// The method details per method in the Merchant API.
type MethodDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The name of the method for example `products.list`.
	Method string `protobuf:"bytes,1,opt,name=method,proto3" json:"method,omitempty"`
	// Output only. The API version that the method belongs to.
	Version string `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
	// Output only. The sub-API that the method belongs to.
	Subapi string `protobuf:"bytes,3,opt,name=subapi,proto3" json:"subapi,omitempty"`
	// Output only. The path for the method such as
	// `products/v1/productInputs.insert`
	Path string `protobuf:"bytes,4,opt,name=path,proto3" json:"path,omitempty"`
}

func (x *MethodDetails) Reset() {
	*x = MethodDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_quota_v1beta_quota_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MethodDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MethodDetails) ProtoMessage() {}

func (x *MethodDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_quota_v1beta_quota_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MethodDetails.ProtoReflect.Descriptor instead.
func (*MethodDetails) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_quota_v1beta_quota_proto_rawDescGZIP(), []int{1}
}

func (x *MethodDetails) GetMethod() string {
	if x != nil {
		return x.Method
	}
	return ""
}

func (x *MethodDetails) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *MethodDetails) GetSubapi() string {
	if x != nil {
		return x.Subapi
	}
	return ""
}

func (x *MethodDetails) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

// Request message for the ListQuotaGroups method.
type ListQuotaGroupsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The merchant account who owns the collection of method quotas
	// Format: accounts/{account}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of quotas to return in the response, used
	// for paging. Defaults to 500; values above 1000 will be coerced to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. Token (if provided) to retrieve the subsequent page. All other
	// parameters must match the original call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListQuotaGroupsRequest) Reset() {
	*x = ListQuotaGroupsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_quota_v1beta_quota_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListQuotaGroupsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListQuotaGroupsRequest) ProtoMessage() {}

func (x *ListQuotaGroupsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_quota_v1beta_quota_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListQuotaGroupsRequest.ProtoReflect.Descriptor instead.
func (*ListQuotaGroupsRequest) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_quota_v1beta_quota_proto_rawDescGZIP(), []int{2}
}

func (x *ListQuotaGroupsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListQuotaGroupsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListQuotaGroupsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for the ListMethodGroups method.
type ListQuotaGroupsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The methods, current quota usage and limits per each group. The quota is
	// shared between all methods in the group. The groups are sorted in
	// descending order based on
	// [quotaUsage][google.shopping.merchant.quota.v1main.QuotaGroup.quota_usage].
	QuotaGroups []*QuotaGroup `protobuf:"bytes,1,rep,name=quota_groups,json=quotaGroups,proto3" json:"quota_groups,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListQuotaGroupsResponse) Reset() {
	*x = ListQuotaGroupsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_quota_v1beta_quota_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListQuotaGroupsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListQuotaGroupsResponse) ProtoMessage() {}

func (x *ListQuotaGroupsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_quota_v1beta_quota_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListQuotaGroupsResponse.ProtoReflect.Descriptor instead.
func (*ListQuotaGroupsResponse) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_quota_v1beta_quota_proto_rawDescGZIP(), []int{3}
}

func (x *ListQuotaGroupsResponse) GetQuotaGroups() []*QuotaGroup {
	if x != nil {
		return x.QuotaGroups
	}
	return nil
}

func (x *ListQuotaGroupsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

var File_google_shopping_merchant_quota_v1beta_quota_proto protoreflect.FileDescriptor

var file_google_shopping_merchant_quota_v1beta_quota_proto_rawDesc = []byte{
	0x0a, 0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x2f, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2f, 0x71, 0x75, 0x6f, 0x74, 0x61,
	0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x25, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x71, 0x75,
	0x6f, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xee, 0x02,
	0x0a, 0x0a, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x17, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x08, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x24, 0x0a, 0x0b, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x5f, 0x75,
	0x73, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0a, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x55, 0x73, 0x61, 0x67, 0x65, 0x12, 0x24, 0x0a, 0x0b, 0x71,
	0x75, 0x6f, 0x74, 0x61, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x4c, 0x69, 0x6d, 0x69,
	0x74, 0x12, 0x31, 0x0a, 0x12, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x5f, 0x6d, 0x69, 0x6e, 0x75, 0x74,
	0x65, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x10, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x4d, 0x69, 0x6e, 0x75, 0x74, 0x65, 0x4c,
	0x69, 0x6d, 0x69, 0x74, 0x12, 0x60, 0x0a, 0x0e, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x5f, 0x64,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d,
	0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x44, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x44,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x3a, 0x66, 0xea, 0x41, 0x63, 0x0a, 0x25, 0x6d, 0x65, 0x72,
	0x63, 0x68, 0x61, 0x6e, 0x74, 0x61, 0x70, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x12, 0x21, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x61, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x7d, 0x2f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x7b, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x7d, 0x2a, 0x0b, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x73, 0x32, 0x0a, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x22, 0x81,
	0x01, 0x0a, 0x0d, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x12, 0x1b, 0x0a, 0x06, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x12, 0x1d, 0x0a,
	0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1b, 0x0a, 0x06,
	0x73, 0x75, 0x62, 0x61, 0x70, 0x69, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x06, 0x73, 0x75, 0x62, 0x61, 0x70, 0x69, 0x12, 0x17, 0x0a, 0x04, 0x70, 0x61, 0x74,
	0x68, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x70, 0x61,
	0x74, 0x68, 0x22, 0xa5, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x51, 0x75, 0x6f, 0x74, 0x61,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x27, 0x12, 0x25, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x61,
	0x70, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61,
	0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x97, 0x01, 0x0a, 0x17, 0x4c,
	0x69, 0x73, 0x74, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x54, 0x0a, 0x0c, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x5f,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d,
	0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52,
	0x0b, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x12, 0x26, 0x0a, 0x0f,
	0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x32, 0xa5, 0x02, 0x0a, 0x0c, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xcb, 0x01, 0x0a, 0x0f, 0x4c, 0x69, 0x73, 0x74, 0x51, 0x75,
	0x6f, 0x74, 0x61, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63,
	0x68, 0x61, 0x6e, 0x74, 0x2e, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68,
	0x61, 0x6e, 0x74, 0x2e, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x39, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2a, 0x12, 0x28, 0x2f, 0x71, 0x75, 0x6f, 0x74,
	0x61, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x71, 0x75, 0x6f,
	0x74, 0x61, 0x73, 0x1a, 0x47, 0xca, 0x41, 0x1a, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74,
	0x61, 0x70, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0xd2, 0x41, 0x27, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x42, 0xbb, 0x01, 0xea,
	0x41, 0x38, 0x0a, 0x22, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x61, 0x70, 0x69, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x12, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73,
	0x2f, 0x7b, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x7d, 0x0a, 0x29, 0x63, 0x6f, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e,
	0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x42, 0x0a, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x50, 0x01, 0x5a, 0x45, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x2f, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2f, 0x71, 0x75, 0x6f, 0x74, 0x61,
	0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x71, 0x75, 0x6f, 0x74, 0x61,
	0x70, 0x62, 0x3b, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_google_shopping_merchant_quota_v1beta_quota_proto_rawDescOnce sync.Once
	file_google_shopping_merchant_quota_v1beta_quota_proto_rawDescData = file_google_shopping_merchant_quota_v1beta_quota_proto_rawDesc
)

func file_google_shopping_merchant_quota_v1beta_quota_proto_rawDescGZIP() []byte {
	file_google_shopping_merchant_quota_v1beta_quota_proto_rawDescOnce.Do(func() {
		file_google_shopping_merchant_quota_v1beta_quota_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_shopping_merchant_quota_v1beta_quota_proto_rawDescData)
	})
	return file_google_shopping_merchant_quota_v1beta_quota_proto_rawDescData
}

var file_google_shopping_merchant_quota_v1beta_quota_proto_msgTypes = make([]protoimpl.MessageInfo, 4)
var file_google_shopping_merchant_quota_v1beta_quota_proto_goTypes = []interface{}{
	(*QuotaGroup)(nil),              // 0: google.shopping.merchant.quota.v1beta.QuotaGroup
	(*MethodDetails)(nil),           // 1: google.shopping.merchant.quota.v1beta.MethodDetails
	(*ListQuotaGroupsRequest)(nil),  // 2: google.shopping.merchant.quota.v1beta.ListQuotaGroupsRequest
	(*ListQuotaGroupsResponse)(nil), // 3: google.shopping.merchant.quota.v1beta.ListQuotaGroupsResponse
}
var file_google_shopping_merchant_quota_v1beta_quota_proto_depIdxs = []int32{
	1, // 0: google.shopping.merchant.quota.v1beta.QuotaGroup.method_details:type_name -> google.shopping.merchant.quota.v1beta.MethodDetails
	0, // 1: google.shopping.merchant.quota.v1beta.ListQuotaGroupsResponse.quota_groups:type_name -> google.shopping.merchant.quota.v1beta.QuotaGroup
	2, // 2: google.shopping.merchant.quota.v1beta.QuotaService.ListQuotaGroups:input_type -> google.shopping.merchant.quota.v1beta.ListQuotaGroupsRequest
	3, // 3: google.shopping.merchant.quota.v1beta.QuotaService.ListQuotaGroups:output_type -> google.shopping.merchant.quota.v1beta.ListQuotaGroupsResponse
	3, // [3:4] is the sub-list for method output_type
	2, // [2:3] is the sub-list for method input_type
	2, // [2:2] is the sub-list for extension type_name
	2, // [2:2] is the sub-list for extension extendee
	0, // [0:2] is the sub-list for field type_name
}

func init() { file_google_shopping_merchant_quota_v1beta_quota_proto_init() }
func file_google_shopping_merchant_quota_v1beta_quota_proto_init() {
	if File_google_shopping_merchant_quota_v1beta_quota_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_shopping_merchant_quota_v1beta_quota_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QuotaGroup); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_quota_v1beta_quota_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MethodDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_quota_v1beta_quota_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListQuotaGroupsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_quota_v1beta_quota_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListQuotaGroupsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_shopping_merchant_quota_v1beta_quota_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   4,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_shopping_merchant_quota_v1beta_quota_proto_goTypes,
		DependencyIndexes: file_google_shopping_merchant_quota_v1beta_quota_proto_depIdxs,
		MessageInfos:      file_google_shopping_merchant_quota_v1beta_quota_proto_msgTypes,
	}.Build()
	File_google_shopping_merchant_quota_v1beta_quota_proto = out.File
	file_google_shopping_merchant_quota_v1beta_quota_proto_rawDesc = nil
	file_google_shopping_merchant_quota_v1beta_quota_proto_goTypes = nil
	file_google_shopping_merchant_quota_v1beta_quota_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// QuotaServiceClient is the client API for QuotaService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type QuotaServiceClient interface {
	// Lists the daily call quota and usage per group for your Merchant
	// Center account.
	ListQuotaGroups(ctx context.Context, in *ListQuotaGroupsRequest, opts ...grpc.CallOption) (*ListQuotaGroupsResponse, error)
}

type quotaServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewQuotaServiceClient(cc grpc.ClientConnInterface) QuotaServiceClient {
	return &quotaServiceClient{cc}
}

func (c *quotaServiceClient) ListQuotaGroups(ctx context.Context, in *ListQuotaGroupsRequest, opts ...grpc.CallOption) (*ListQuotaGroupsResponse, error) {
	out := new(ListQuotaGroupsResponse)
	err := c.cc.Invoke(ctx, "/google.shopping.merchant.quota.v1beta.QuotaService/ListQuotaGroups", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// QuotaServiceServer is the server API for QuotaService service.
type QuotaServiceServer interface {
	// Lists the daily call quota and usage per group for your Merchant
	// Center account.
	ListQuotaGroups(context.Context, *ListQuotaGroupsRequest) (*ListQuotaGroupsResponse, error)
}

// UnimplementedQuotaServiceServer can be embedded to have forward compatible implementations.
type UnimplementedQuotaServiceServer struct {
}

func (*UnimplementedQuotaServiceServer) ListQuotaGroups(context.Context, *ListQuotaGroupsRequest) (*ListQuotaGroupsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListQuotaGroups not implemented")
}

func RegisterQuotaServiceServer(s *grpc.Server, srv QuotaServiceServer) {
	s.RegisterService(&_QuotaService_serviceDesc, srv)
}

func _QuotaService_ListQuotaGroups_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListQuotaGroupsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(QuotaServiceServer).ListQuotaGroups(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.shopping.merchant.quota.v1beta.QuotaService/ListQuotaGroups",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(QuotaServiceServer).ListQuotaGroups(ctx, req.(*ListQuotaGroupsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _QuotaService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.shopping.merchant.quota.v1beta.QuotaService",
	HandlerType: (*QuotaServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListQuotaGroups",
			Handler:    _QuotaService_ListQuotaGroups_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/shopping/merchant/quota/v1beta/quota.proto",
}
