// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.1
// 	protoc        v4.25.3
// source: google/shopping/merchant/reports/v1beta/reports.proto

package reportspb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	typepb "cloud.google.com/go/shopping/type/typepb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	date "google.golang.org/genproto/googleapis/type/date"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Status of the product aggregated for all reporting contexts.
//
// Here's an example of how the aggregated status is computed:
//
// Free listings | Shopping ads | Status
// --------------|--------------|------------------------------
// Approved      | Approved     | ELIGIBLE
// Approved      | Pending      | ELIGIBLE
// Approved      | Disapproved  | ELIGIBLE_LIMITED
// Pending       | Pending      | PENDING
// Disapproved   | Disapproved  | NOT_ELIGIBLE_OR_DISAPPROVED
type ProductView_AggregatedReportingContextStatus int32

const (
	// Not specified.
	ProductView_AGGREGATED_REPORTING_CONTEXT_STATUS_UNSPECIFIED ProductView_AggregatedReportingContextStatus = 0
	// Product is not eligible or is disapproved for all reporting contexts.
	ProductView_NOT_ELIGIBLE_OR_DISAPPROVED ProductView_AggregatedReportingContextStatus = 1
	// Product's status is pending in all reporting contexts.
	ProductView_PENDING ProductView_AggregatedReportingContextStatus = 2
	// Product is eligible for some (but not all) reporting contexts.
	ProductView_ELIGIBLE_LIMITED ProductView_AggregatedReportingContextStatus = 3
	// Product is eligible for all reporting contexts.
	ProductView_ELIGIBLE ProductView_AggregatedReportingContextStatus = 4
)

// Enum value maps for ProductView_AggregatedReportingContextStatus.
var (
	ProductView_AggregatedReportingContextStatus_name = map[int32]string{
		0: "AGGREGATED_REPORTING_CONTEXT_STATUS_UNSPECIFIED",
		1: "NOT_ELIGIBLE_OR_DISAPPROVED",
		2: "PENDING",
		3: "ELIGIBLE_LIMITED",
		4: "ELIGIBLE",
	}
	ProductView_AggregatedReportingContextStatus_value = map[string]int32{
		"AGGREGATED_REPORTING_CONTEXT_STATUS_UNSPECIFIED": 0,
		"NOT_ELIGIBLE_OR_DISAPPROVED":                     1,
		"PENDING":                                         2,
		"ELIGIBLE_LIMITED":                                3,
		"ELIGIBLE":                                        4,
	}
)

func (x ProductView_AggregatedReportingContextStatus) Enum() *ProductView_AggregatedReportingContextStatus {
	p := new(ProductView_AggregatedReportingContextStatus)
	*p = x
	return p
}

func (x ProductView_AggregatedReportingContextStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ProductView_AggregatedReportingContextStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_shopping_merchant_reports_v1beta_reports_proto_enumTypes[0].Descriptor()
}

func (ProductView_AggregatedReportingContextStatus) Type() protoreflect.EnumType {
	return &file_google_shopping_merchant_reports_v1beta_reports_proto_enumTypes[0]
}

func (x ProductView_AggregatedReportingContextStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ProductView_AggregatedReportingContextStatus.Descriptor instead.
func (ProductView_AggregatedReportingContextStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_shopping_merchant_reports_v1beta_reports_proto_rawDescGZIP(), []int{4, 0}
}

// A product's [click
// potential](https://support.google.com/merchants/answer/188488) estimates
// its performance potential compared to highest performing products of the
// merchant. Click potential of a product helps merchants to prioritize which
// products to fix and helps them understand how products are performing
// against their potential.
type ProductView_ClickPotential int32

const (
	// Unknown predicted clicks impact.
	ProductView_CLICK_POTENTIAL_UNSPECIFIED ProductView_ClickPotential = 0
	// Potential to receive a low number of clicks compared to the highest
	// performing products of the merchant.
	ProductView_LOW ProductView_ClickPotential = 1
	// Potential to receive a moderate number of clicks compared to the highest
	// performing products of the merchant.
	ProductView_MEDIUM ProductView_ClickPotential = 2
	// Potential to receive a similar number of clicks as the highest performing
	// products of the merchant.
	ProductView_HIGH ProductView_ClickPotential = 3
)

// Enum value maps for ProductView_ClickPotential.
var (
	ProductView_ClickPotential_name = map[int32]string{
		0: "CLICK_POTENTIAL_UNSPECIFIED",
		1: "LOW",
		2: "MEDIUM",
		3: "HIGH",
	}
	ProductView_ClickPotential_value = map[string]int32{
		"CLICK_POTENTIAL_UNSPECIFIED": 0,
		"LOW":                         1,
		"MEDIUM":                      2,
		"HIGH":                        3,
	}
)

func (x ProductView_ClickPotential) Enum() *ProductView_ClickPotential {
	p := new(ProductView_ClickPotential)
	*p = x
	return p
}

func (x ProductView_ClickPotential) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ProductView_ClickPotential) Descriptor() protoreflect.EnumDescriptor {
	return file_google_shopping_merchant_reports_v1beta_reports_proto_enumTypes[1].Descriptor()
}

func (ProductView_ClickPotential) Type() protoreflect.EnumType {
	return &file_google_shopping_merchant_reports_v1beta_reports_proto_enumTypes[1]
}

func (x ProductView_ClickPotential) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ProductView_ClickPotential.Descriptor instead.
func (ProductView_ClickPotential) EnumDescriptor() ([]byte, []int) {
	return file_google_shopping_merchant_reports_v1beta_reports_proto_rawDescGZIP(), []int{4, 1}
}

// How to resolve the issue.
type ProductView_ItemIssue_ItemIssueResolution int32

const (
	// Not specified.
	ProductView_ItemIssue_ITEM_ISSUE_RESOLUTION_UNSPECIFIED ProductView_ItemIssue_ItemIssueResolution = 0
	// The merchant has to fix the issue.
	ProductView_ItemIssue_MERCHANT_ACTION ProductView_ItemIssue_ItemIssueResolution = 1
	// The issue will be resolved automatically (for example, image crawl) or
	// through a Google review. No merchant action is required now. Resolution
	// might lead to another issue (for example, if crawl fails).
	ProductView_ItemIssue_PENDING_PROCESSING ProductView_ItemIssue_ItemIssueResolution = 2
)

// Enum value maps for ProductView_ItemIssue_ItemIssueResolution.
var (
	ProductView_ItemIssue_ItemIssueResolution_name = map[int32]string{
		0: "ITEM_ISSUE_RESOLUTION_UNSPECIFIED",
		1: "MERCHANT_ACTION",
		2: "PENDING_PROCESSING",
	}
	ProductView_ItemIssue_ItemIssueResolution_value = map[string]int32{
		"ITEM_ISSUE_RESOLUTION_UNSPECIFIED": 0,
		"MERCHANT_ACTION":                   1,
		"PENDING_PROCESSING":                2,
	}
)

func (x ProductView_ItemIssue_ItemIssueResolution) Enum() *ProductView_ItemIssue_ItemIssueResolution {
	p := new(ProductView_ItemIssue_ItemIssueResolution)
	*p = x
	return p
}

func (x ProductView_ItemIssue_ItemIssueResolution) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ProductView_ItemIssue_ItemIssueResolution) Descriptor() protoreflect.EnumDescriptor {
	return file_google_shopping_merchant_reports_v1beta_reports_proto_enumTypes[2].Descriptor()
}

func (ProductView_ItemIssue_ItemIssueResolution) Type() protoreflect.EnumType {
	return &file_google_shopping_merchant_reports_v1beta_reports_proto_enumTypes[2]
}

func (x ProductView_ItemIssue_ItemIssueResolution) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ProductView_ItemIssue_ItemIssueResolution.Descriptor instead.
func (ProductView_ItemIssue_ItemIssueResolution) EnumDescriptor() ([]byte, []int) {
	return file_google_shopping_merchant_reports_v1beta_reports_proto_rawDescGZIP(), []int{4, 0, 0}
}

// Issue severity aggregated for all reporting contexts.
type ProductView_ItemIssue_ItemIssueSeverity_AggregatedIssueSeverity int32

const (
	// Not specified.
	ProductView_ItemIssue_ItemIssueSeverity_AGGREGATED_ISSUE_SEVERITY_UNSPECIFIED ProductView_ItemIssue_ItemIssueSeverity_AggregatedIssueSeverity = 0
	// Issue disapproves the product in at least one reporting context.
	ProductView_ItemIssue_ItemIssueSeverity_DISAPPROVED ProductView_ItemIssue_ItemIssueSeverity_AggregatedIssueSeverity = 1
	// Issue demotes the product in all reporting contexts it affects.
	ProductView_ItemIssue_ItemIssueSeverity_DEMOTED ProductView_ItemIssue_ItemIssueSeverity_AggregatedIssueSeverity = 2
	// Issue resolution is `PENDING_PROCESSING`.
	ProductView_ItemIssue_ItemIssueSeverity_PENDING ProductView_ItemIssue_ItemIssueSeverity_AggregatedIssueSeverity = 3
)

// Enum value maps for ProductView_ItemIssue_ItemIssueSeverity_AggregatedIssueSeverity.
var (
	ProductView_ItemIssue_ItemIssueSeverity_AggregatedIssueSeverity_name = map[int32]string{
		0: "AGGREGATED_ISSUE_SEVERITY_UNSPECIFIED",
		1: "DISAPPROVED",
		2: "DEMOTED",
		3: "PENDING",
	}
	ProductView_ItemIssue_ItemIssueSeverity_AggregatedIssueSeverity_value = map[string]int32{
		"AGGREGATED_ISSUE_SEVERITY_UNSPECIFIED": 0,
		"DISAPPROVED":                           1,
		"DEMOTED":                               2,
		"PENDING":                               3,
	}
)

func (x ProductView_ItemIssue_ItemIssueSeverity_AggregatedIssueSeverity) Enum() *ProductView_ItemIssue_ItemIssueSeverity_AggregatedIssueSeverity {
	p := new(ProductView_ItemIssue_ItemIssueSeverity_AggregatedIssueSeverity)
	*p = x
	return p
}

func (x ProductView_ItemIssue_ItemIssueSeverity_AggregatedIssueSeverity) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ProductView_ItemIssue_ItemIssueSeverity_AggregatedIssueSeverity) Descriptor() protoreflect.EnumDescriptor {
	return file_google_shopping_merchant_reports_v1beta_reports_proto_enumTypes[3].Descriptor()
}

func (ProductView_ItemIssue_ItemIssueSeverity_AggregatedIssueSeverity) Type() protoreflect.EnumType {
	return &file_google_shopping_merchant_reports_v1beta_reports_proto_enumTypes[3]
}

func (x ProductView_ItemIssue_ItemIssueSeverity_AggregatedIssueSeverity) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ProductView_ItemIssue_ItemIssueSeverity_AggregatedIssueSeverity.Descriptor instead.
func (ProductView_ItemIssue_ItemIssueSeverity_AggregatedIssueSeverity) EnumDescriptor() ([]byte, []int) {
	return file_google_shopping_merchant_reports_v1beta_reports_proto_rawDescGZIP(), []int{4, 0, 1, 0}
}

// Predicted effectiveness bucket.
//
// Effectiveness indicates which products would benefit most from price
// changes. This rating takes into consideration the performance boost
// predicted by adjusting the sale price and the difference between your
// current price and the suggested price. Price suggestions with `HIGH`
// effectiveness are predicted to drive the largest increase in performance.
type PriceInsightsProductView_Effectiveness int32

const (
	// Effectiveness is unknown.
	PriceInsightsProductView_EFFECTIVENESS_UNSPECIFIED PriceInsightsProductView_Effectiveness = 0
	// Effectiveness is low.
	PriceInsightsProductView_LOW PriceInsightsProductView_Effectiveness = 1
	// Effectiveness is medium.
	PriceInsightsProductView_MEDIUM PriceInsightsProductView_Effectiveness = 2
	// Effectiveness is high.
	PriceInsightsProductView_HIGH PriceInsightsProductView_Effectiveness = 3
)

// Enum value maps for PriceInsightsProductView_Effectiveness.
var (
	PriceInsightsProductView_Effectiveness_name = map[int32]string{
		0: "EFFECTIVENESS_UNSPECIFIED",
		1: "LOW",
		2: "MEDIUM",
		3: "HIGH",
	}
	PriceInsightsProductView_Effectiveness_value = map[string]int32{
		"EFFECTIVENESS_UNSPECIFIED": 0,
		"LOW":                       1,
		"MEDIUM":                    2,
		"HIGH":                      3,
	}
)

func (x PriceInsightsProductView_Effectiveness) Enum() *PriceInsightsProductView_Effectiveness {
	p := new(PriceInsightsProductView_Effectiveness)
	*p = x
	return p
}

func (x PriceInsightsProductView_Effectiveness) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PriceInsightsProductView_Effectiveness) Descriptor() protoreflect.EnumDescriptor {
	return file_google_shopping_merchant_reports_v1beta_reports_proto_enumTypes[4].Descriptor()
}

func (PriceInsightsProductView_Effectiveness) Type() protoreflect.EnumType {
	return &file_google_shopping_merchant_reports_v1beta_reports_proto_enumTypes[4]
}

func (x PriceInsightsProductView_Effectiveness) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PriceInsightsProductView_Effectiveness.Descriptor instead.
func (PriceInsightsProductView_Effectiveness) EnumDescriptor() ([]byte, []int) {
	return file_google_shopping_merchant_reports_v1beta_reports_proto_rawDescGZIP(), []int{6, 0}
}

// Status of the product cluster or brand in your inventory.
type BestSellersProductClusterView_InventoryStatus int32

const (
	// Not specified.
	BestSellersProductClusterView_INVENTORY_STATUS_UNSPECIFIED BestSellersProductClusterView_InventoryStatus = 0
	// You have a product for this product cluster or brand in stock.
	BestSellersProductClusterView_IN_STOCK BestSellersProductClusterView_InventoryStatus = 1
	// You have a product for this product cluster or brand in inventory but it
	// is currently out of stock.
	BestSellersProductClusterView_OUT_OF_STOCK BestSellersProductClusterView_InventoryStatus = 2
	// You do not have a product for this product cluster or brand in inventory.
	BestSellersProductClusterView_NOT_IN_INVENTORY BestSellersProductClusterView_InventoryStatus = 3
)

// Enum value maps for BestSellersProductClusterView_InventoryStatus.
var (
	BestSellersProductClusterView_InventoryStatus_name = map[int32]string{
		0: "INVENTORY_STATUS_UNSPECIFIED",
		1: "IN_STOCK",
		2: "OUT_OF_STOCK",
		3: "NOT_IN_INVENTORY",
	}
	BestSellersProductClusterView_InventoryStatus_value = map[string]int32{
		"INVENTORY_STATUS_UNSPECIFIED": 0,
		"IN_STOCK":                     1,
		"OUT_OF_STOCK":                 2,
		"NOT_IN_INVENTORY":             3,
	}
)

func (x BestSellersProductClusterView_InventoryStatus) Enum() *BestSellersProductClusterView_InventoryStatus {
	p := new(BestSellersProductClusterView_InventoryStatus)
	*p = x
	return p
}

func (x BestSellersProductClusterView_InventoryStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BestSellersProductClusterView_InventoryStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_shopping_merchant_reports_v1beta_reports_proto_enumTypes[5].Descriptor()
}

func (BestSellersProductClusterView_InventoryStatus) Type() protoreflect.EnumType {
	return &file_google_shopping_merchant_reports_v1beta_reports_proto_enumTypes[5]
}

func (x BestSellersProductClusterView_InventoryStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BestSellersProductClusterView_InventoryStatus.Descriptor instead.
func (BestSellersProductClusterView_InventoryStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_shopping_merchant_reports_v1beta_reports_proto_rawDescGZIP(), []int{7, 0}
}

// Marketing method values.
type MarketingMethod_MarketingMethodEnum int32

const (
	// Not specified.
	MarketingMethod_MARKETING_METHOD_ENUM_UNSPECIFIED MarketingMethod_MarketingMethodEnum = 0
	// Organic marketing.
	MarketingMethod_ORGANIC MarketingMethod_MarketingMethodEnum = 1
	// Ads-based marketing.
	MarketingMethod_ADS MarketingMethod_MarketingMethodEnum = 2
)

// Enum value maps for MarketingMethod_MarketingMethodEnum.
var (
	MarketingMethod_MarketingMethodEnum_name = map[int32]string{
		0: "MARKETING_METHOD_ENUM_UNSPECIFIED",
		1: "ORGANIC",
		2: "ADS",
	}
	MarketingMethod_MarketingMethodEnum_value = map[string]int32{
		"MARKETING_METHOD_ENUM_UNSPECIFIED": 0,
		"ORGANIC":                           1,
		"ADS":                               2,
	}
)

func (x MarketingMethod_MarketingMethodEnum) Enum() *MarketingMethod_MarketingMethodEnum {
	p := new(MarketingMethod_MarketingMethodEnum)
	*p = x
	return p
}

func (x MarketingMethod_MarketingMethodEnum) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MarketingMethod_MarketingMethodEnum) Descriptor() protoreflect.EnumDescriptor {
	return file_google_shopping_merchant_reports_v1beta_reports_proto_enumTypes[6].Descriptor()
}

func (MarketingMethod_MarketingMethodEnum) Type() protoreflect.EnumType {
	return &file_google_shopping_merchant_reports_v1beta_reports_proto_enumTypes[6]
}

func (x MarketingMethod_MarketingMethodEnum) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MarketingMethod_MarketingMethodEnum.Descriptor instead.
func (MarketingMethod_MarketingMethodEnum) EnumDescriptor() ([]byte, []int) {
	return file_google_shopping_merchant_reports_v1beta_reports_proto_rawDescGZIP(), []int{13, 0}
}

// Report granularity values.
type ReportGranularity_ReportGranularityEnum int32

const (
	// Not specified.
	ReportGranularity_REPORT_GRANULARITY_ENUM_UNSPECIFIED ReportGranularity_ReportGranularityEnum = 0
	// Report is computed over a week timeframe.
	ReportGranularity_WEEKLY ReportGranularity_ReportGranularityEnum = 1
	// Report is computed over a month timeframe.
	ReportGranularity_MONTHLY ReportGranularity_ReportGranularityEnum = 2
)

// Enum value maps for ReportGranularity_ReportGranularityEnum.
var (
	ReportGranularity_ReportGranularityEnum_name = map[int32]string{
		0: "REPORT_GRANULARITY_ENUM_UNSPECIFIED",
		1: "WEEKLY",
		2: "MONTHLY",
	}
	ReportGranularity_ReportGranularityEnum_value = map[string]int32{
		"REPORT_GRANULARITY_ENUM_UNSPECIFIED": 0,
		"WEEKLY":                              1,
		"MONTHLY":                             2,
	}
)

func (x ReportGranularity_ReportGranularityEnum) Enum() *ReportGranularity_ReportGranularityEnum {
	p := new(ReportGranularity_ReportGranularityEnum)
	*p = x
	return p
}

func (x ReportGranularity_ReportGranularityEnum) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ReportGranularity_ReportGranularityEnum) Descriptor() protoreflect.EnumDescriptor {
	return file_google_shopping_merchant_reports_v1beta_reports_proto_enumTypes[7].Descriptor()
}

func (ReportGranularity_ReportGranularityEnum) Type() protoreflect.EnumType {
	return &file_google_shopping_merchant_reports_v1beta_reports_proto_enumTypes[7]
}

func (x ReportGranularity_ReportGranularityEnum) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ReportGranularity_ReportGranularityEnum.Descriptor instead.
func (ReportGranularity_ReportGranularityEnum) EnumDescriptor() ([]byte, []int) {
	return file_google_shopping_merchant_reports_v1beta_reports_proto_rawDescGZIP(), []int{14, 0}
}

// Relative demand values.
type RelativeDemand_RelativeDemandEnum int32

const (
	// Not specified.
	RelativeDemand_RELATIVE_DEMAND_ENUM_UNSPECIFIED RelativeDemand_RelativeDemandEnum = 0
	// Demand is 0-5% of the demand of the highest ranked product cluster or
	// brand.
	RelativeDemand_VERY_LOW RelativeDemand_RelativeDemandEnum = 10
	// Demand is 6-10% of the demand of the highest ranked product cluster or
	// brand.
	RelativeDemand_LOW RelativeDemand_RelativeDemandEnum = 20
	// Demand is 11-20% of the demand of the highest ranked product cluster or
	// brand.
	RelativeDemand_MEDIUM RelativeDemand_RelativeDemandEnum = 30
	// Demand is 21-50% of the demand of the highest ranked product cluster or
	// brand.
	RelativeDemand_HIGH RelativeDemand_RelativeDemandEnum = 40
	// Demand is 51-100% of the demand of the highest ranked product cluster or
	// brand.
	RelativeDemand_VERY_HIGH RelativeDemand_RelativeDemandEnum = 50
)

// Enum value maps for RelativeDemand_RelativeDemandEnum.
var (
	RelativeDemand_RelativeDemandEnum_name = map[int32]string{
		0:  "RELATIVE_DEMAND_ENUM_UNSPECIFIED",
		10: "VERY_LOW",
		20: "LOW",
		30: "MEDIUM",
		40: "HIGH",
		50: "VERY_HIGH",
	}
	RelativeDemand_RelativeDemandEnum_value = map[string]int32{
		"RELATIVE_DEMAND_ENUM_UNSPECIFIED": 0,
		"VERY_LOW":                         10,
		"LOW":                              20,
		"MEDIUM":                           30,
		"HIGH":                             40,
		"VERY_HIGH":                        50,
	}
)

func (x RelativeDemand_RelativeDemandEnum) Enum() *RelativeDemand_RelativeDemandEnum {
	p := new(RelativeDemand_RelativeDemandEnum)
	*p = x
	return p
}

func (x RelativeDemand_RelativeDemandEnum) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RelativeDemand_RelativeDemandEnum) Descriptor() protoreflect.EnumDescriptor {
	return file_google_shopping_merchant_reports_v1beta_reports_proto_enumTypes[8].Descriptor()
}

func (RelativeDemand_RelativeDemandEnum) Type() protoreflect.EnumType {
	return &file_google_shopping_merchant_reports_v1beta_reports_proto_enumTypes[8]
}

func (x RelativeDemand_RelativeDemandEnum) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RelativeDemand_RelativeDemandEnum.Descriptor instead.
func (RelativeDemand_RelativeDemandEnum) EnumDescriptor() ([]byte, []int) {
	return file_google_shopping_merchant_reports_v1beta_reports_proto_rawDescGZIP(), []int{15, 0}
}

// Relative demand change type values.
type RelativeDemandChangeType_RelativeDemandChangeTypeEnum int32

const (
	// Not specified.
	RelativeDemandChangeType_RELATIVE_DEMAND_CHANGE_TYPE_ENUM_UNSPECIFIED RelativeDemandChangeType_RelativeDemandChangeTypeEnum = 0
	// Relative demand is lower than the previous time period.
	RelativeDemandChangeType_SINKER RelativeDemandChangeType_RelativeDemandChangeTypeEnum = 1
	// Relative demand is equal to the previous time period.
	RelativeDemandChangeType_FLAT RelativeDemandChangeType_RelativeDemandChangeTypeEnum = 2
	// Relative demand is higher than the previous time period.
	RelativeDemandChangeType_RISER RelativeDemandChangeType_RelativeDemandChangeTypeEnum = 3
)

// Enum value maps for RelativeDemandChangeType_RelativeDemandChangeTypeEnum.
var (
	RelativeDemandChangeType_RelativeDemandChangeTypeEnum_name = map[int32]string{
		0: "RELATIVE_DEMAND_CHANGE_TYPE_ENUM_UNSPECIFIED",
		1: "SINKER",
		2: "FLAT",
		3: "RISER",
	}
	RelativeDemandChangeType_RelativeDemandChangeTypeEnum_value = map[string]int32{
		"RELATIVE_DEMAND_CHANGE_TYPE_ENUM_UNSPECIFIED": 0,
		"SINKER": 1,
		"FLAT":   2,
		"RISER":  3,
	}
)

func (x RelativeDemandChangeType_RelativeDemandChangeTypeEnum) Enum() *RelativeDemandChangeType_RelativeDemandChangeTypeEnum {
	p := new(RelativeDemandChangeType_RelativeDemandChangeTypeEnum)
	*p = x
	return p
}

func (x RelativeDemandChangeType_RelativeDemandChangeTypeEnum) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RelativeDemandChangeType_RelativeDemandChangeTypeEnum) Descriptor() protoreflect.EnumDescriptor {
	return file_google_shopping_merchant_reports_v1beta_reports_proto_enumTypes[9].Descriptor()
}

func (RelativeDemandChangeType_RelativeDemandChangeTypeEnum) Type() protoreflect.EnumType {
	return &file_google_shopping_merchant_reports_v1beta_reports_proto_enumTypes[9]
}

func (x RelativeDemandChangeType_RelativeDemandChangeTypeEnum) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RelativeDemandChangeType_RelativeDemandChangeTypeEnum.Descriptor instead.
func (RelativeDemandChangeType_RelativeDemandChangeTypeEnum) EnumDescriptor() ([]byte, []int) {
	return file_google_shopping_merchant_reports_v1beta_reports_proto_rawDescGZIP(), []int{16, 0}
}

// Traffic source values.
type TrafficSource_TrafficSourceEnum int32

const (
	// Not specified.
	TrafficSource_TRAFFIC_SOURCE_ENUM_UNSPECIFIED TrafficSource_TrafficSourceEnum = 0
	// Organic traffic.
	TrafficSource_ORGANIC TrafficSource_TrafficSourceEnum = 1
	// Traffic from ads.
	TrafficSource_ADS TrafficSource_TrafficSourceEnum = 2
	// Organic and ads traffic.
	TrafficSource_ALL TrafficSource_TrafficSourceEnum = 3
)

// Enum value maps for TrafficSource_TrafficSourceEnum.
var (
	TrafficSource_TrafficSourceEnum_name = map[int32]string{
		0: "TRAFFIC_SOURCE_ENUM_UNSPECIFIED",
		1: "ORGANIC",
		2: "ADS",
		3: "ALL",
	}
	TrafficSource_TrafficSourceEnum_value = map[string]int32{
		"TRAFFIC_SOURCE_ENUM_UNSPECIFIED": 0,
		"ORGANIC":                         1,
		"ADS":                             2,
		"ALL":                             3,
	}
)

func (x TrafficSource_TrafficSourceEnum) Enum() *TrafficSource_TrafficSourceEnum {
	p := new(TrafficSource_TrafficSourceEnum)
	*p = x
	return p
}

func (x TrafficSource_TrafficSourceEnum) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TrafficSource_TrafficSourceEnum) Descriptor() protoreflect.EnumDescriptor {
	return file_google_shopping_merchant_reports_v1beta_reports_proto_enumTypes[10].Descriptor()
}

func (TrafficSource_TrafficSourceEnum) Type() protoreflect.EnumType {
	return &file_google_shopping_merchant_reports_v1beta_reports_proto_enumTypes[10]
}

func (x TrafficSource_TrafficSourceEnum) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TrafficSource_TrafficSourceEnum.Descriptor instead.
func (TrafficSource_TrafficSourceEnum) EnumDescriptor() ([]byte, []int) {
	return file_google_shopping_merchant_reports_v1beta_reports_proto_rawDescGZIP(), []int{17, 0}
}

// Request message for the `ReportService.Search` method.
type SearchRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Id of the account making the call. Must be a standalone account
	// or an MCA subaccount. Format: accounts/{account}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Query that defines a report to be retrieved.
	//
	// For details on how to construct your query, see the Query Language
	// guide. For the full list of available tables and fields, see the Available
	// fields.
	Query string `protobuf:"bytes,2,opt,name=query,proto3" json:"query,omitempty"`
	// Optional. Number of `ReportRows` to retrieve in a single page. Defaults to
	// 1000. Values above 5000 are coerced to 5000.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. Token of the page to retrieve. If not specified, the first page
	// of results is returned. In order to request the next page of results, the
	// value obtained from `next_page_token` in the previous response should be
	// used.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *SearchRequest) Reset() {
	*x = SearchRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchRequest) ProtoMessage() {}

func (x *SearchRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchRequest.ProtoReflect.Descriptor instead.
func (*SearchRequest) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_reports_v1beta_reports_proto_rawDescGZIP(), []int{0}
}

func (x *SearchRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *SearchRequest) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

func (x *SearchRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *SearchRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for the `ReportService.Search` method.
type SearchResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Rows that matched the search query.
	Results []*ReportRow `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
	// Token which can be sent as `page_token` to retrieve the next page. If
	// omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *SearchResponse) Reset() {
	*x = SearchResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchResponse) ProtoMessage() {}

func (x *SearchResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchResponse.ProtoReflect.Descriptor instead.
func (*SearchResponse) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_reports_v1beta_reports_proto_rawDescGZIP(), []int{1}
}

func (x *SearchResponse) GetResults() []*ReportRow {
	if x != nil {
		return x.Results
	}
	return nil
}

func (x *SearchResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Result row returned from the search query.
//
// Only the message corresponding to the queried table is populated in the
// response. Within the populated message, only the fields requested explicitly
// in the query are populated.
type ReportRow struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Fields available for query in `product_performance_view` table.
	ProductPerformanceView *ProductPerformanceView `protobuf:"bytes,1,opt,name=product_performance_view,json=productPerformanceView,proto3" json:"product_performance_view,omitempty"`
	// Fields available for query in `non_product_performance_view` table.
	NonProductPerformanceView *NonProductPerformanceView `protobuf:"bytes,7,opt,name=non_product_performance_view,json=nonProductPerformanceView,proto3" json:"non_product_performance_view,omitempty"`
	// Fields available for query in `product_view` table.
	ProductView *ProductView `protobuf:"bytes,2,opt,name=product_view,json=productView,proto3" json:"product_view,omitempty"`
	// Fields available for query in `price_competitiveness_product_view` table.
	PriceCompetitivenessProductView *PriceCompetitivenessProductView `protobuf:"bytes,3,opt,name=price_competitiveness_product_view,json=priceCompetitivenessProductView,proto3" json:"price_competitiveness_product_view,omitempty"`
	// Fields available for query in `price_insights_product_view` table.
	PriceInsightsProductView *PriceInsightsProductView `protobuf:"bytes,4,opt,name=price_insights_product_view,json=priceInsightsProductView,proto3" json:"price_insights_product_view,omitempty"`
	// Fields available for query in `best_sellers_product_cluster_view` table.
	BestSellersProductClusterView *BestSellersProductClusterView `protobuf:"bytes,5,opt,name=best_sellers_product_cluster_view,json=bestSellersProductClusterView,proto3" json:"best_sellers_product_cluster_view,omitempty"`
	// Fields available for query in `best_sellers_brand_view` table.
	BestSellersBrandView *BestSellersBrandView `protobuf:"bytes,6,opt,name=best_sellers_brand_view,json=bestSellersBrandView,proto3" json:"best_sellers_brand_view,omitempty"`
	// Fields available for query in `competitive_visibility_competitor_view`
	// table.
	CompetitiveVisibilityCompetitorView *CompetitiveVisibilityCompetitorView `protobuf:"bytes,8,opt,name=competitive_visibility_competitor_view,json=competitiveVisibilityCompetitorView,proto3" json:"competitive_visibility_competitor_view,omitempty"`
	// Fields available for query in `competitive_visibility_top_merchant_view`
	// table.
	CompetitiveVisibilityTopMerchantView *CompetitiveVisibilityTopMerchantView `protobuf:"bytes,9,opt,name=competitive_visibility_top_merchant_view,json=competitiveVisibilityTopMerchantView,proto3" json:"competitive_visibility_top_merchant_view,omitempty"`
	// Fields available for query in `competitive_visibility_benchmark_view`
	// table.
	CompetitiveVisibilityBenchmarkView *CompetitiveVisibilityBenchmarkView `protobuf:"bytes,10,opt,name=competitive_visibility_benchmark_view,json=competitiveVisibilityBenchmarkView,proto3" json:"competitive_visibility_benchmark_view,omitempty"`
}

func (x *ReportRow) Reset() {
	*x = ReportRow{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReportRow) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportRow) ProtoMessage() {}

func (x *ReportRow) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportRow.ProtoReflect.Descriptor instead.
func (*ReportRow) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_reports_v1beta_reports_proto_rawDescGZIP(), []int{2}
}

func (x *ReportRow) GetProductPerformanceView() *ProductPerformanceView {
	if x != nil {
		return x.ProductPerformanceView
	}
	return nil
}

func (x *ReportRow) GetNonProductPerformanceView() *NonProductPerformanceView {
	if x != nil {
		return x.NonProductPerformanceView
	}
	return nil
}

func (x *ReportRow) GetProductView() *ProductView {
	if x != nil {
		return x.ProductView
	}
	return nil
}

func (x *ReportRow) GetPriceCompetitivenessProductView() *PriceCompetitivenessProductView {
	if x != nil {
		return x.PriceCompetitivenessProductView
	}
	return nil
}

func (x *ReportRow) GetPriceInsightsProductView() *PriceInsightsProductView {
	if x != nil {
		return x.PriceInsightsProductView
	}
	return nil
}

func (x *ReportRow) GetBestSellersProductClusterView() *BestSellersProductClusterView {
	if x != nil {
		return x.BestSellersProductClusterView
	}
	return nil
}

func (x *ReportRow) GetBestSellersBrandView() *BestSellersBrandView {
	if x != nil {
		return x.BestSellersBrandView
	}
	return nil
}

func (x *ReportRow) GetCompetitiveVisibilityCompetitorView() *CompetitiveVisibilityCompetitorView {
	if x != nil {
		return x.CompetitiveVisibilityCompetitorView
	}
	return nil
}

func (x *ReportRow) GetCompetitiveVisibilityTopMerchantView() *CompetitiveVisibilityTopMerchantView {
	if x != nil {
		return x.CompetitiveVisibilityTopMerchantView
	}
	return nil
}

func (x *ReportRow) GetCompetitiveVisibilityBenchmarkView() *CompetitiveVisibilityBenchmarkView {
	if x != nil {
		return x.CompetitiveVisibilityBenchmarkView
	}
	return nil
}

// Fields available for query in `product_performance_view` table.
//
// Product performance data for your account, including performance metrics (for
// example, `clicks`) and dimensions according to which performance metrics are
// segmented (for example, `offer_id`). Values of product dimensions, such as
// `offer_id`, reflect the state of a product at the time of the impression.
//
// Segment fields cannot be selected in queries without also selecting at least
// one metric field.
//
// Values are only set for fields requested explicitly in the request's search
// query.
type ProductPerformanceView struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Marketing method to which metrics apply. Segment.
	MarketingMethod *MarketingMethod_MarketingMethodEnum `protobuf:"varint,1,opt,name=marketing_method,json=marketingMethod,proto3,enum=google.shopping.merchant.reports.v1beta.MarketingMethod_MarketingMethodEnum,oneof" json:"marketing_method,omitempty"`
	// Date in the merchant timezone to which metrics apply. Segment.
	//
	// Condition on `date` is required in the `WHERE` clause.
	Date *date.Date `protobuf:"bytes,2,opt,name=date,proto3" json:"date,omitempty"`
	// First day of the week (Monday) of the metrics date in the merchant
	// timezone. Segment.
	Week *date.Date `protobuf:"bytes,3,opt,name=week,proto3" json:"week,omitempty"`
	// Code of the country where the customer is located at the time of the event.
	// Represented in the ISO 3166 format. Segment.
	//
	// If the customer country cannot be determined, a special 'ZZ' code is
	// returned.
	CustomerCountryCode *string `protobuf:"bytes,4,opt,name=customer_country_code,json=customerCountryCode,proto3,oneof" json:"customer_country_code,omitempty"`
	// Merchant-provided id of the product. Segment.
	OfferId *string `protobuf:"bytes,5,opt,name=offer_id,json=offerId,proto3,oneof" json:"offer_id,omitempty"`
	// Title of the product. Segment.
	Title *string `protobuf:"bytes,6,opt,name=title,proto3,oneof" json:"title,omitempty"`
	// Brand of the product. Segment.
	Brand *string `protobuf:"bytes,7,opt,name=brand,proto3,oneof" json:"brand,omitempty"`
	// [Product category (1st
	// level)](https://developers.google.com/shopping-content/guides/reports/segmentation#category_and_product_type)
	// in Google's product taxonomy. Segment.
	CategoryL1 *string `protobuf:"bytes,8,opt,name=category_l1,json=categoryL1,proto3,oneof" json:"category_l1,omitempty"`
	// [Product category (2nd
	// level)](https://developers.google.com/shopping-content/guides/reports/segmentation#category_and_product_type)
	// in Google's product taxonomy. Segment.
	CategoryL2 *string `protobuf:"bytes,9,opt,name=category_l2,json=categoryL2,proto3,oneof" json:"category_l2,omitempty"`
	// [Product category (3rd
	// level)](https://developers.google.com/shopping-content/guides/reports/segmentation#category_and_product_type)
	// in Google's product taxonomy. Segment.
	CategoryL3 *string `protobuf:"bytes,10,opt,name=category_l3,json=categoryL3,proto3,oneof" json:"category_l3,omitempty"`
	// [Product category (4th
	// level)](https://developers.google.com/shopping-content/guides/reports/segmentation#category_and_product_type)
	// in Google's product taxonomy. Segment.
	CategoryL4 *string `protobuf:"bytes,11,opt,name=category_l4,json=categoryL4,proto3,oneof" json:"category_l4,omitempty"`
	// [Product category (5th
	// level)](https://developers.google.com/shopping-content/guides/reports/segmentation#category_and_product_type)
	// in Google's product taxonomy. Segment.
	CategoryL5 *string `protobuf:"bytes,12,opt,name=category_l5,json=categoryL5,proto3,oneof" json:"category_l5,omitempty"`
	// [Product type (1st
	// level)](https://developers.google.com/shopping-content/guides/reports/segmentation#category_and_product_type)
	// in merchant's own product taxonomy. Segment.
	ProductTypeL1 *string `protobuf:"bytes,13,opt,name=product_type_l1,json=productTypeL1,proto3,oneof" json:"product_type_l1,omitempty"`
	// [Product type (2nd
	// level)](https://developers.google.com/shopping-content/guides/reports/segmentation#category_and_product_type)
	// in merchant's own product taxonomy. Segment.
	ProductTypeL2 *string `protobuf:"bytes,14,opt,name=product_type_l2,json=productTypeL2,proto3,oneof" json:"product_type_l2,omitempty"`
	// [Product type (3rd
	// level)](https://developers.google.com/shopping-content/guides/reports/segmentation#category_and_product_type)
	// in merchant's own product taxonomy. Segment.
	ProductTypeL3 *string `protobuf:"bytes,15,opt,name=product_type_l3,json=productTypeL3,proto3,oneof" json:"product_type_l3,omitempty"`
	// [Product type (4th
	// level)](https://developers.google.com/shopping-content/guides/reports/segmentation#category_and_product_type)
	// in merchant's own product taxonomy. Segment.
	ProductTypeL4 *string `protobuf:"bytes,16,opt,name=product_type_l4,json=productTypeL4,proto3,oneof" json:"product_type_l4,omitempty"`
	// [Product type (5th
	// level)](https://developers.google.com/shopping-content/guides/reports/segmentation#category_and_product_type)
	// in merchant's own product taxonomy. Segment.
	ProductTypeL5 *string `protobuf:"bytes,17,opt,name=product_type_l5,json=productTypeL5,proto3,oneof" json:"product_type_l5,omitempty"`
	// Custom label 0 for custom grouping of products. Segment.
	CustomLabel0 *string `protobuf:"bytes,18,opt,name=custom_label0,json=customLabel0,proto3,oneof" json:"custom_label0,omitempty"`
	// Custom label 1 for custom grouping of products. Segment.
	CustomLabel1 *string `protobuf:"bytes,19,opt,name=custom_label1,json=customLabel1,proto3,oneof" json:"custom_label1,omitempty"`
	// Custom label 2 for custom grouping of products. Segment.
	CustomLabel2 *string `protobuf:"bytes,20,opt,name=custom_label2,json=customLabel2,proto3,oneof" json:"custom_label2,omitempty"`
	// Custom label 3 for custom grouping of products. Segment.
	CustomLabel3 *string `protobuf:"bytes,21,opt,name=custom_label3,json=customLabel3,proto3,oneof" json:"custom_label3,omitempty"`
	// Custom label 4 for custom grouping of products. Segment.
	CustomLabel4 *string `protobuf:"bytes,22,opt,name=custom_label4,json=customLabel4,proto3,oneof" json:"custom_label4,omitempty"`
	// Number of clicks. Metric.
	Clicks *int64 `protobuf:"varint,23,opt,name=clicks,proto3,oneof" json:"clicks,omitempty"`
	// Number of times merchant's products are shown. Metric.
	Impressions *int64 `protobuf:"varint,24,opt,name=impressions,proto3,oneof" json:"impressions,omitempty"`
	// Click-through rate - the number of clicks merchant's products receive
	// (clicks) divided by the number of times the products are shown
	// (impressions). Metric.
	ClickThroughRate *float64 `protobuf:"fixed64,25,opt,name=click_through_rate,json=clickThroughRate,proto3,oneof" json:"click_through_rate,omitempty"`
	// Number of conversions attributed to the product, reported on the conversion
	// date. Depending on the attribution model, a conversion might be distributed
	// across multiple clicks, where each click gets its own credit assigned. This
	// metric is a sum of all such credits. Metric.
	//
	// Available only for the `FREE` traffic source.
	Conversions *float64 `protobuf:"fixed64,26,opt,name=conversions,proto3,oneof" json:"conversions,omitempty"`
	// Value of conversions attributed to the product, reported on the conversion
	// date. Metric.
	//
	// Available only for the `FREE` traffic source.
	ConversionValue *typepb.Price `protobuf:"bytes,27,opt,name=conversion_value,json=conversionValue,proto3" json:"conversion_value,omitempty"`
	// Number of conversions divided by the number of clicks, reported on the
	// impression date. Metric.
	//
	// Available only for the `FREE` traffic source.
	ConversionRate *float64 `protobuf:"fixed64,28,opt,name=conversion_rate,json=conversionRate,proto3,oneof" json:"conversion_rate,omitempty"`
}

func (x *ProductPerformanceView) Reset() {
	*x = ProductPerformanceView{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProductPerformanceView) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProductPerformanceView) ProtoMessage() {}

func (x *ProductPerformanceView) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProductPerformanceView.ProtoReflect.Descriptor instead.
func (*ProductPerformanceView) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_reports_v1beta_reports_proto_rawDescGZIP(), []int{3}
}

func (x *ProductPerformanceView) GetMarketingMethod() MarketingMethod_MarketingMethodEnum {
	if x != nil && x.MarketingMethod != nil {
		return *x.MarketingMethod
	}
	return MarketingMethod_MARKETING_METHOD_ENUM_UNSPECIFIED
}

func (x *ProductPerformanceView) GetDate() *date.Date {
	if x != nil {
		return x.Date
	}
	return nil
}

func (x *ProductPerformanceView) GetWeek() *date.Date {
	if x != nil {
		return x.Week
	}
	return nil
}

func (x *ProductPerformanceView) GetCustomerCountryCode() string {
	if x != nil && x.CustomerCountryCode != nil {
		return *x.CustomerCountryCode
	}
	return ""
}

func (x *ProductPerformanceView) GetOfferId() string {
	if x != nil && x.OfferId != nil {
		return *x.OfferId
	}
	return ""
}

func (x *ProductPerformanceView) GetTitle() string {
	if x != nil && x.Title != nil {
		return *x.Title
	}
	return ""
}

func (x *ProductPerformanceView) GetBrand() string {
	if x != nil && x.Brand != nil {
		return *x.Brand
	}
	return ""
}

func (x *ProductPerformanceView) GetCategoryL1() string {
	if x != nil && x.CategoryL1 != nil {
		return *x.CategoryL1
	}
	return ""
}

func (x *ProductPerformanceView) GetCategoryL2() string {
	if x != nil && x.CategoryL2 != nil {
		return *x.CategoryL2
	}
	return ""
}

func (x *ProductPerformanceView) GetCategoryL3() string {
	if x != nil && x.CategoryL3 != nil {
		return *x.CategoryL3
	}
	return ""
}

func (x *ProductPerformanceView) GetCategoryL4() string {
	if x != nil && x.CategoryL4 != nil {
		return *x.CategoryL4
	}
	return ""
}

func (x *ProductPerformanceView) GetCategoryL5() string {
	if x != nil && x.CategoryL5 != nil {
		return *x.CategoryL5
	}
	return ""
}

func (x *ProductPerformanceView) GetProductTypeL1() string {
	if x != nil && x.ProductTypeL1 != nil {
		return *x.ProductTypeL1
	}
	return ""
}

func (x *ProductPerformanceView) GetProductTypeL2() string {
	if x != nil && x.ProductTypeL2 != nil {
		return *x.ProductTypeL2
	}
	return ""
}

func (x *ProductPerformanceView) GetProductTypeL3() string {
	if x != nil && x.ProductTypeL3 != nil {
		return *x.ProductTypeL3
	}
	return ""
}

func (x *ProductPerformanceView) GetProductTypeL4() string {
	if x != nil && x.ProductTypeL4 != nil {
		return *x.ProductTypeL4
	}
	return ""
}

func (x *ProductPerformanceView) GetProductTypeL5() string {
	if x != nil && x.ProductTypeL5 != nil {
		return *x.ProductTypeL5
	}
	return ""
}

func (x *ProductPerformanceView) GetCustomLabel0() string {
	if x != nil && x.CustomLabel0 != nil {
		return *x.CustomLabel0
	}
	return ""
}

func (x *ProductPerformanceView) GetCustomLabel1() string {
	if x != nil && x.CustomLabel1 != nil {
		return *x.CustomLabel1
	}
	return ""
}

func (x *ProductPerformanceView) GetCustomLabel2() string {
	if x != nil && x.CustomLabel2 != nil {
		return *x.CustomLabel2
	}
	return ""
}

func (x *ProductPerformanceView) GetCustomLabel3() string {
	if x != nil && x.CustomLabel3 != nil {
		return *x.CustomLabel3
	}
	return ""
}

func (x *ProductPerformanceView) GetCustomLabel4() string {
	if x != nil && x.CustomLabel4 != nil {
		return *x.CustomLabel4
	}
	return ""
}

func (x *ProductPerformanceView) GetClicks() int64 {
	if x != nil && x.Clicks != nil {
		return *x.Clicks
	}
	return 0
}

func (x *ProductPerformanceView) GetImpressions() int64 {
	if x != nil && x.Impressions != nil {
		return *x.Impressions
	}
	return 0
}

func (x *ProductPerformanceView) GetClickThroughRate() float64 {
	if x != nil && x.ClickThroughRate != nil {
		return *x.ClickThroughRate
	}
	return 0
}

func (x *ProductPerformanceView) GetConversions() float64 {
	if x != nil && x.Conversions != nil {
		return *x.Conversions
	}
	return 0
}

func (x *ProductPerformanceView) GetConversionValue() *typepb.Price {
	if x != nil {
		return x.ConversionValue
	}
	return nil
}

func (x *ProductPerformanceView) GetConversionRate() float64 {
	if x != nil && x.ConversionRate != nil {
		return *x.ConversionRate
	}
	return 0
}

// Fields available for query in `product_view` table.
//
// Products in the current inventory. Products in this table are the same as in
// Products sub-API but not all product attributes from Products sub-API are
// available for query in this table. In contrast to Products sub-API, this
// table allows to filter the returned list of products by product attributes.
// To retrieve a single product by `id` or list all products, Products sub-API
// should be used.
//
// Values are only set for fields requested explicitly in the request's search
// query.
type ProductView struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// REST ID of the product, in the form of
	// `channel~languageCode~feedLabel~offerId`. Merchant API methods that operate
	// on products take this as their `name` parameter.
	//
	// Required in the `SELECT` clause.
	Id *string `protobuf:"bytes,1,opt,name=id,proto3,oneof" json:"id,omitempty"`
	// Channel of the product. Can be `ONLINE` or `LOCAL`.
	Channel *typepb.Channel_ChannelEnum `protobuf:"varint,28,opt,name=channel,proto3,enum=google.shopping.type.Channel_ChannelEnum,oneof" json:"channel,omitempty"`
	// Language code of the product in BCP 47 format.
	LanguageCode *string `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3,oneof" json:"language_code,omitempty"`
	// Feed label of the product.
	FeedLabel *string `protobuf:"bytes,3,opt,name=feed_label,json=feedLabel,proto3,oneof" json:"feed_label,omitempty"`
	// Merchant-provided id of the product.
	OfferId *string `protobuf:"bytes,4,opt,name=offer_id,json=offerId,proto3,oneof" json:"offer_id,omitempty"`
	// Title of the product.
	Title *string `protobuf:"bytes,5,opt,name=title,proto3,oneof" json:"title,omitempty"`
	// Brand of the product.
	Brand *string `protobuf:"bytes,6,opt,name=brand,proto3,oneof" json:"brand,omitempty"`
	// Product category (1st level) in [Google's product
	// taxonomy](https://support.google.com/merchants/answer/6324436).
	CategoryL1 *string `protobuf:"bytes,7,opt,name=category_l1,json=categoryL1,proto3,oneof" json:"category_l1,omitempty"`
	// Product category (2nd level) in [Google's product
	// taxonomy](https://support.google.com/merchants/answer/6324436).
	CategoryL2 *string `protobuf:"bytes,8,opt,name=category_l2,json=categoryL2,proto3,oneof" json:"category_l2,omitempty"`
	// Product category (3rd level) in [Google's product
	// taxonomy](https://support.google.com/merchants/answer/6324436).
	CategoryL3 *string `protobuf:"bytes,9,opt,name=category_l3,json=categoryL3,proto3,oneof" json:"category_l3,omitempty"`
	// Product category (4th level) in [Google's product
	// taxonomy](https://support.google.com/merchants/answer/6324436).
	CategoryL4 *string `protobuf:"bytes,10,opt,name=category_l4,json=categoryL4,proto3,oneof" json:"category_l4,omitempty"`
	// Product category (5th level) in [Google's product
	// taxonomy](https://support.google.com/merchants/answer/6324436).
	CategoryL5 *string `protobuf:"bytes,11,opt,name=category_l5,json=categoryL5,proto3,oneof" json:"category_l5,omitempty"`
	// Product type (1st level) in merchant's own [product
	// taxonomy](https://support.google.com/merchants/answer/6324406).
	ProductTypeL1 *string `protobuf:"bytes,12,opt,name=product_type_l1,json=productTypeL1,proto3,oneof" json:"product_type_l1,omitempty"`
	// Product type (2nd level) in merchant's own [product
	// taxonomy](https://support.google.com/merchants/answer/6324406).
	ProductTypeL2 *string `protobuf:"bytes,13,opt,name=product_type_l2,json=productTypeL2,proto3,oneof" json:"product_type_l2,omitempty"`
	// Product type (3rd level) in merchant's own [product
	// taxonomy](https://support.google.com/merchants/answer/6324406).
	ProductTypeL3 *string `protobuf:"bytes,14,opt,name=product_type_l3,json=productTypeL3,proto3,oneof" json:"product_type_l3,omitempty"`
	// Product type (4th level) in merchant's own [product
	// taxonomy](https://support.google.com/merchants/answer/6324406).
	ProductTypeL4 *string `protobuf:"bytes,15,opt,name=product_type_l4,json=productTypeL4,proto3,oneof" json:"product_type_l4,omitempty"`
	// Product type (5th level) in merchant's own [product
	// taxonomy](https://support.google.com/merchants/answer/6324406).
	ProductTypeL5 *string `protobuf:"bytes,16,opt,name=product_type_l5,json=productTypeL5,proto3,oneof" json:"product_type_l5,omitempty"`
	// Product price. Absent if the information about the price of the product is
	// not available.
	Price *typepb.Price `protobuf:"bytes,17,opt,name=price,proto3" json:"price,omitempty"`
	// [Condition](https://support.google.com/merchants/answer/6324469) of the
	// product.
	Condition *string `protobuf:"bytes,18,opt,name=condition,proto3,oneof" json:"condition,omitempty"`
	// [Availability](https://support.google.com/merchants/answer/6324448) of the
	// product.
	Availability *string `protobuf:"bytes,19,opt,name=availability,proto3,oneof" json:"availability,omitempty"`
	// Normalized [shipping
	// label](https://support.google.com/merchants/answer/6324504) specified in
	// the data source.
	ShippingLabel *string `protobuf:"bytes,20,opt,name=shipping_label,json=shippingLabel,proto3,oneof" json:"shipping_label,omitempty"`
	// List of Global Trade Item Numbers (GTINs) of the product.
	Gtin []string `protobuf:"bytes,21,rep,name=gtin,proto3" json:"gtin,omitempty"`
	// Item group id provided by the merchant for grouping variants together.
	ItemGroupId *string `protobuf:"bytes,22,opt,name=item_group_id,json=itemGroupId,proto3,oneof" json:"item_group_id,omitempty"`
	// Link to the processed image of the product, hosted on the Google
	// infrastructure.
	ThumbnailLink *string `protobuf:"bytes,23,opt,name=thumbnail_link,json=thumbnailLink,proto3,oneof" json:"thumbnail_link,omitempty"`
	// The time the merchant created the product in timestamp seconds.
	CreationTime *timestamppb.Timestamp `protobuf:"bytes,24,opt,name=creation_time,json=creationTime,proto3" json:"creation_time,omitempty"`
	// Expiration date for the product, specified on insertion.
	ExpirationDate *date.Date `protobuf:"bytes,25,opt,name=expiration_date,json=expirationDate,proto3" json:"expiration_date,omitempty"`
	// Aggregated status.
	AggregatedReportingContextStatus *ProductView_AggregatedReportingContextStatus `protobuf:"varint,26,opt,name=aggregated_reporting_context_status,json=aggregatedReportingContextStatus,proto3,enum=google.shopping.merchant.reports.v1beta.ProductView_AggregatedReportingContextStatus,oneof" json:"aggregated_reporting_context_status,omitempty"`
	// List of item issues for the product.
	//
	// **This field cannot be used for sorting the results.**
	//
	// **Only selected attributes of this field (for example,
	// `item_issues.severity.aggregated_severity`) can be used for filtering the
	// results.**
	ItemIssues []*ProductView_ItemIssue `protobuf:"bytes,27,rep,name=item_issues,json=itemIssues,proto3" json:"item_issues,omitempty"`
	// Estimated performance potential compared to highest performing products of
	// the merchant.
	ClickPotential ProductView_ClickPotential `protobuf:"varint,29,opt,name=click_potential,json=clickPotential,proto3,enum=google.shopping.merchant.reports.v1beta.ProductView_ClickPotential" json:"click_potential,omitempty"`
	// Rank of the product based on its click potential. A product with
	// `click_potential_rank` 1 has the highest click potential among the
	// merchant's products that fulfill the search query conditions.
	ClickPotentialRank *int64 `protobuf:"varint,30,opt,name=click_potential_rank,json=clickPotentialRank,proto3,oneof" json:"click_potential_rank,omitempty"`
}

func (x *ProductView) Reset() {
	*x = ProductView{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProductView) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProductView) ProtoMessage() {}

func (x *ProductView) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProductView.ProtoReflect.Descriptor instead.
func (*ProductView) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_reports_v1beta_reports_proto_rawDescGZIP(), []int{4}
}

func (x *ProductView) GetId() string {
	if x != nil && x.Id != nil {
		return *x.Id
	}
	return ""
}

func (x *ProductView) GetChannel() typepb.Channel_ChannelEnum {
	if x != nil && x.Channel != nil {
		return *x.Channel
	}
	return typepb.Channel_ChannelEnum(0)
}

func (x *ProductView) GetLanguageCode() string {
	if x != nil && x.LanguageCode != nil {
		return *x.LanguageCode
	}
	return ""
}

func (x *ProductView) GetFeedLabel() string {
	if x != nil && x.FeedLabel != nil {
		return *x.FeedLabel
	}
	return ""
}

func (x *ProductView) GetOfferId() string {
	if x != nil && x.OfferId != nil {
		return *x.OfferId
	}
	return ""
}

func (x *ProductView) GetTitle() string {
	if x != nil && x.Title != nil {
		return *x.Title
	}
	return ""
}

func (x *ProductView) GetBrand() string {
	if x != nil && x.Brand != nil {
		return *x.Brand
	}
	return ""
}

func (x *ProductView) GetCategoryL1() string {
	if x != nil && x.CategoryL1 != nil {
		return *x.CategoryL1
	}
	return ""
}

func (x *ProductView) GetCategoryL2() string {
	if x != nil && x.CategoryL2 != nil {
		return *x.CategoryL2
	}
	return ""
}

func (x *ProductView) GetCategoryL3() string {
	if x != nil && x.CategoryL3 != nil {
		return *x.CategoryL3
	}
	return ""
}

func (x *ProductView) GetCategoryL4() string {
	if x != nil && x.CategoryL4 != nil {
		return *x.CategoryL4
	}
	return ""
}

func (x *ProductView) GetCategoryL5() string {
	if x != nil && x.CategoryL5 != nil {
		return *x.CategoryL5
	}
	return ""
}

func (x *ProductView) GetProductTypeL1() string {
	if x != nil && x.ProductTypeL1 != nil {
		return *x.ProductTypeL1
	}
	return ""
}

func (x *ProductView) GetProductTypeL2() string {
	if x != nil && x.ProductTypeL2 != nil {
		return *x.ProductTypeL2
	}
	return ""
}

func (x *ProductView) GetProductTypeL3() string {
	if x != nil && x.ProductTypeL3 != nil {
		return *x.ProductTypeL3
	}
	return ""
}

func (x *ProductView) GetProductTypeL4() string {
	if x != nil && x.ProductTypeL4 != nil {
		return *x.ProductTypeL4
	}
	return ""
}

func (x *ProductView) GetProductTypeL5() string {
	if x != nil && x.ProductTypeL5 != nil {
		return *x.ProductTypeL5
	}
	return ""
}

func (x *ProductView) GetPrice() *typepb.Price {
	if x != nil {
		return x.Price
	}
	return nil
}

func (x *ProductView) GetCondition() string {
	if x != nil && x.Condition != nil {
		return *x.Condition
	}
	return ""
}

func (x *ProductView) GetAvailability() string {
	if x != nil && x.Availability != nil {
		return *x.Availability
	}
	return ""
}

func (x *ProductView) GetShippingLabel() string {
	if x != nil && x.ShippingLabel != nil {
		return *x.ShippingLabel
	}
	return ""
}

func (x *ProductView) GetGtin() []string {
	if x != nil {
		return x.Gtin
	}
	return nil
}

func (x *ProductView) GetItemGroupId() string {
	if x != nil && x.ItemGroupId != nil {
		return *x.ItemGroupId
	}
	return ""
}

func (x *ProductView) GetThumbnailLink() string {
	if x != nil && x.ThumbnailLink != nil {
		return *x.ThumbnailLink
	}
	return ""
}

func (x *ProductView) GetCreationTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreationTime
	}
	return nil
}

func (x *ProductView) GetExpirationDate() *date.Date {
	if x != nil {
		return x.ExpirationDate
	}
	return nil
}

func (x *ProductView) GetAggregatedReportingContextStatus() ProductView_AggregatedReportingContextStatus {
	if x != nil && x.AggregatedReportingContextStatus != nil {
		return *x.AggregatedReportingContextStatus
	}
	return ProductView_AGGREGATED_REPORTING_CONTEXT_STATUS_UNSPECIFIED
}

func (x *ProductView) GetItemIssues() []*ProductView_ItemIssue {
	if x != nil {
		return x.ItemIssues
	}
	return nil
}

func (x *ProductView) GetClickPotential() ProductView_ClickPotential {
	if x != nil {
		return x.ClickPotential
	}
	return ProductView_CLICK_POTENTIAL_UNSPECIFIED
}

func (x *ProductView) GetClickPotentialRank() int64 {
	if x != nil && x.ClickPotentialRank != nil {
		return *x.ClickPotentialRank
	}
	return 0
}

// Fields available for query in `price_competitiveness_product_view` table.
//
// [Price competitiveness](https://support.google.com/merchants/answer/9626903)
// report.
//
// Values are only set for fields requested explicitly in the request's search
// query.
type PriceCompetitivenessProductView struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Country of the price benchmark. Represented in the ISO 3166 format.
	//
	// Required in the `SELECT` clause.
	ReportCountryCode *string `protobuf:"bytes,1,opt,name=report_country_code,json=reportCountryCode,proto3,oneof" json:"report_country_code,omitempty"`
	// REST ID of the product, in the form of
	// `channel~languageCode~feedLabel~offerId`. Can be used to join data with the
	// `product_view` table.
	//
	// Required in the `SELECT` clause.
	Id *string `protobuf:"bytes,2,opt,name=id,proto3,oneof" json:"id,omitempty"`
	// Merchant-provided id of the product.
	OfferId *string `protobuf:"bytes,3,opt,name=offer_id,json=offerId,proto3,oneof" json:"offer_id,omitempty"`
	// Title of the product.
	Title *string `protobuf:"bytes,4,opt,name=title,proto3,oneof" json:"title,omitempty"`
	// Brand of the product.
	Brand *string `protobuf:"bytes,5,opt,name=brand,proto3,oneof" json:"brand,omitempty"`
	// Product category (1st level) in [Google's product
	// taxonomy](https://support.google.com/merchants/answer/6324436).
	CategoryL1 *string `protobuf:"bytes,6,opt,name=category_l1,json=categoryL1,proto3,oneof" json:"category_l1,omitempty"`
	// Product category (2nd level) in [Google's product
	// taxonomy](https://support.google.com/merchants/answer/6324436).
	CategoryL2 *string `protobuf:"bytes,7,opt,name=category_l2,json=categoryL2,proto3,oneof" json:"category_l2,omitempty"`
	// Product category (3rd level) in [Google's product
	// taxonomy](https://support.google.com/merchants/answer/6324436).
	CategoryL3 *string `protobuf:"bytes,8,opt,name=category_l3,json=categoryL3,proto3,oneof" json:"category_l3,omitempty"`
	// Product category (4th level) in [Google's product
	// taxonomy](https://support.google.com/merchants/answer/6324436).
	CategoryL4 *string `protobuf:"bytes,9,opt,name=category_l4,json=categoryL4,proto3,oneof" json:"category_l4,omitempty"`
	// Product category (5th level) in [Google's product
	// taxonomy](https://support.google.com/merchants/answer/6324436).
	CategoryL5 *string `protobuf:"bytes,10,opt,name=category_l5,json=categoryL5,proto3,oneof" json:"category_l5,omitempty"`
	// Product type (1st level) in merchant's own [product
	// taxonomy](https://support.google.com/merchants/answer/6324406).
	ProductTypeL1 *string `protobuf:"bytes,11,opt,name=product_type_l1,json=productTypeL1,proto3,oneof" json:"product_type_l1,omitempty"`
	// Product type (2nd level) in merchant's own [product
	// taxonomy](https://support.google.com/merchants/answer/6324406).
	ProductTypeL2 *string `protobuf:"bytes,12,opt,name=product_type_l2,json=productTypeL2,proto3,oneof" json:"product_type_l2,omitempty"`
	// Product type (3rd level) in merchant's own [product
	// taxonomy](https://support.google.com/merchants/answer/6324406).
	ProductTypeL3 *string `protobuf:"bytes,13,opt,name=product_type_l3,json=productTypeL3,proto3,oneof" json:"product_type_l3,omitempty"`
	// Product type (4th level) in merchant's own [product
	// taxonomy](https://support.google.com/merchants/answer/6324406).
	ProductTypeL4 *string `protobuf:"bytes,14,opt,name=product_type_l4,json=productTypeL4,proto3,oneof" json:"product_type_l4,omitempty"`
	// Product type (5th level) in merchant's own [product
	// taxonomy](https://support.google.com/merchants/answer/6324406).
	ProductTypeL5 *string `protobuf:"bytes,15,opt,name=product_type_l5,json=productTypeL5,proto3,oneof" json:"product_type_l5,omitempty"`
	// Current price of the product.
	Price *typepb.Price `protobuf:"bytes,16,opt,name=price,proto3" json:"price,omitempty"`
	// Latest available price benchmark for the product's catalog in the benchmark
	// country.
	BenchmarkPrice *typepb.Price `protobuf:"bytes,17,opt,name=benchmark_price,json=benchmarkPrice,proto3" json:"benchmark_price,omitempty"`
}

func (x *PriceCompetitivenessProductView) Reset() {
	*x = PriceCompetitivenessProductView{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PriceCompetitivenessProductView) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PriceCompetitivenessProductView) ProtoMessage() {}

func (x *PriceCompetitivenessProductView) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PriceCompetitivenessProductView.ProtoReflect.Descriptor instead.
func (*PriceCompetitivenessProductView) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_reports_v1beta_reports_proto_rawDescGZIP(), []int{5}
}

func (x *PriceCompetitivenessProductView) GetReportCountryCode() string {
	if x != nil && x.ReportCountryCode != nil {
		return *x.ReportCountryCode
	}
	return ""
}

func (x *PriceCompetitivenessProductView) GetId() string {
	if x != nil && x.Id != nil {
		return *x.Id
	}
	return ""
}

func (x *PriceCompetitivenessProductView) GetOfferId() string {
	if x != nil && x.OfferId != nil {
		return *x.OfferId
	}
	return ""
}

func (x *PriceCompetitivenessProductView) GetTitle() string {
	if x != nil && x.Title != nil {
		return *x.Title
	}
	return ""
}

func (x *PriceCompetitivenessProductView) GetBrand() string {
	if x != nil && x.Brand != nil {
		return *x.Brand
	}
	return ""
}

func (x *PriceCompetitivenessProductView) GetCategoryL1() string {
	if x != nil && x.CategoryL1 != nil {
		return *x.CategoryL1
	}
	return ""
}

func (x *PriceCompetitivenessProductView) GetCategoryL2() string {
	if x != nil && x.CategoryL2 != nil {
		return *x.CategoryL2
	}
	return ""
}

func (x *PriceCompetitivenessProductView) GetCategoryL3() string {
	if x != nil && x.CategoryL3 != nil {
		return *x.CategoryL3
	}
	return ""
}

func (x *PriceCompetitivenessProductView) GetCategoryL4() string {
	if x != nil && x.CategoryL4 != nil {
		return *x.CategoryL4
	}
	return ""
}

func (x *PriceCompetitivenessProductView) GetCategoryL5() string {
	if x != nil && x.CategoryL5 != nil {
		return *x.CategoryL5
	}
	return ""
}

func (x *PriceCompetitivenessProductView) GetProductTypeL1() string {
	if x != nil && x.ProductTypeL1 != nil {
		return *x.ProductTypeL1
	}
	return ""
}

func (x *PriceCompetitivenessProductView) GetProductTypeL2() string {
	if x != nil && x.ProductTypeL2 != nil {
		return *x.ProductTypeL2
	}
	return ""
}

func (x *PriceCompetitivenessProductView) GetProductTypeL3() string {
	if x != nil && x.ProductTypeL3 != nil {
		return *x.ProductTypeL3
	}
	return ""
}

func (x *PriceCompetitivenessProductView) GetProductTypeL4() string {
	if x != nil && x.ProductTypeL4 != nil {
		return *x.ProductTypeL4
	}
	return ""
}

func (x *PriceCompetitivenessProductView) GetProductTypeL5() string {
	if x != nil && x.ProductTypeL5 != nil {
		return *x.ProductTypeL5
	}
	return ""
}

func (x *PriceCompetitivenessProductView) GetPrice() *typepb.Price {
	if x != nil {
		return x.Price
	}
	return nil
}

func (x *PriceCompetitivenessProductView) GetBenchmarkPrice() *typepb.Price {
	if x != nil {
		return x.BenchmarkPrice
	}
	return nil
}

// Fields available for query in `price_insights_product_view` table.
//
// [Price insights](https://support.google.com/merchants/answer/11916926)
// report.
//
// Values are only set for fields requested explicitly in the request's search
// query.
type PriceInsightsProductView struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// REST ID of the product, in the form of
	// `channel~languageCode~feedLabel~offerId`. Can be used to join data with the
	// `product_view` table.
	//
	// Required in the `SELECT` clause.
	Id *string `protobuf:"bytes,1,opt,name=id,proto3,oneof" json:"id,omitempty"`
	// Merchant-provided id of the product.
	OfferId *string `protobuf:"bytes,2,opt,name=offer_id,json=offerId,proto3,oneof" json:"offer_id,omitempty"`
	// Title of the product.
	Title *string `protobuf:"bytes,3,opt,name=title,proto3,oneof" json:"title,omitempty"`
	// Brand of the product.
	Brand *string `protobuf:"bytes,4,opt,name=brand,proto3,oneof" json:"brand,omitempty"`
	// Product category (1st level) in [Google's product
	// taxonomy](https://support.google.com/merchants/answer/6324436).
	CategoryL1 *string `protobuf:"bytes,5,opt,name=category_l1,json=categoryL1,proto3,oneof" json:"category_l1,omitempty"`
	// Product category (2nd level) in [Google's product
	// taxonomy](https://support.google.com/merchants/answer/6324436).
	CategoryL2 *string `protobuf:"bytes,6,opt,name=category_l2,json=categoryL2,proto3,oneof" json:"category_l2,omitempty"`
	// Product category (3rd level) in [Google's product
	// taxonomy](https://support.google.com/merchants/answer/6324436).
	CategoryL3 *string `protobuf:"bytes,7,opt,name=category_l3,json=categoryL3,proto3,oneof" json:"category_l3,omitempty"`
	// Product category (4th level) in [Google's product
	// taxonomy](https://support.google.com/merchants/answer/6324436).
	CategoryL4 *string `protobuf:"bytes,8,opt,name=category_l4,json=categoryL4,proto3,oneof" json:"category_l4,omitempty"`
	// Product category (5th level) in [Google's product
	// taxonomy](https://support.google.com/merchants/answer/6324436).
	CategoryL5 *string `protobuf:"bytes,9,opt,name=category_l5,json=categoryL5,proto3,oneof" json:"category_l5,omitempty"`
	// Product type (1st level) in merchant's own [product
	// taxonomy](https://support.google.com/merchants/answer/6324406).
	ProductTypeL1 *string `protobuf:"bytes,10,opt,name=product_type_l1,json=productTypeL1,proto3,oneof" json:"product_type_l1,omitempty"`
	// Product type (2nd level) in merchant's own [product
	// taxonomy](https://support.google.com/merchants/answer/6324406).
	ProductTypeL2 *string `protobuf:"bytes,11,opt,name=product_type_l2,json=productTypeL2,proto3,oneof" json:"product_type_l2,omitempty"`
	// Product type (3rd level) in merchant's own [product
	// taxonomy](https://support.google.com/merchants/answer/6324406).
	ProductTypeL3 *string `protobuf:"bytes,12,opt,name=product_type_l3,json=productTypeL3,proto3,oneof" json:"product_type_l3,omitempty"`
	// Product type (4th level) in merchant's own [product
	// taxonomy](https://support.google.com/merchants/answer/6324406).
	ProductTypeL4 *string `protobuf:"bytes,13,opt,name=product_type_l4,json=productTypeL4,proto3,oneof" json:"product_type_l4,omitempty"`
	// Product type (5th level) in merchant's own [product
	// taxonomy](https://support.google.com/merchants/answer/6324406).
	ProductTypeL5 *string `protobuf:"bytes,14,opt,name=product_type_l5,json=productTypeL5,proto3,oneof" json:"product_type_l5,omitempty"`
	// Current price of the product.
	Price *typepb.Price `protobuf:"bytes,15,opt,name=price,proto3" json:"price,omitempty"`
	// Latest suggested price for the product.
	SuggestedPrice *typepb.Price `protobuf:"bytes,16,opt,name=suggested_price,json=suggestedPrice,proto3" json:"suggested_price,omitempty"`
	// Predicted change in impressions as a fraction after introducing the
	// suggested price compared to current active price. For example, 0.05 is a 5%
	// predicted increase in impressions.
	PredictedImpressionsChangeFraction *float64 `protobuf:"fixed64,17,opt,name=predicted_impressions_change_fraction,json=predictedImpressionsChangeFraction,proto3,oneof" json:"predicted_impressions_change_fraction,omitempty"`
	// Predicted change in clicks as a fraction after introducing the
	// suggested price compared to current active price. For example, 0.05 is a 5%
	// predicted increase in clicks.
	PredictedClicksChangeFraction *float64 `protobuf:"fixed64,18,opt,name=predicted_clicks_change_fraction,json=predictedClicksChangeFraction,proto3,oneof" json:"predicted_clicks_change_fraction,omitempty"`
	// Predicted change in conversions as a fraction after introducing the
	// suggested price compared to current active price. For example, 0.05 is a 5%
	// predicted increase in conversions).
	PredictedConversionsChangeFraction *float64 `protobuf:"fixed64,19,opt,name=predicted_conversions_change_fraction,json=predictedConversionsChangeFraction,proto3,oneof" json:"predicted_conversions_change_fraction,omitempty"`
	// The predicted effectiveness of applying the price suggestion, bucketed.
	Effectiveness PriceInsightsProductView_Effectiveness `protobuf:"varint,22,opt,name=effectiveness,proto3,enum=google.shopping.merchant.reports.v1beta.PriceInsightsProductView_Effectiveness" json:"effectiveness,omitempty"`
}

func (x *PriceInsightsProductView) Reset() {
	*x = PriceInsightsProductView{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PriceInsightsProductView) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PriceInsightsProductView) ProtoMessage() {}

func (x *PriceInsightsProductView) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PriceInsightsProductView.ProtoReflect.Descriptor instead.
func (*PriceInsightsProductView) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_reports_v1beta_reports_proto_rawDescGZIP(), []int{6}
}

func (x *PriceInsightsProductView) GetId() string {
	if x != nil && x.Id != nil {
		return *x.Id
	}
	return ""
}

func (x *PriceInsightsProductView) GetOfferId() string {
	if x != nil && x.OfferId != nil {
		return *x.OfferId
	}
	return ""
}

func (x *PriceInsightsProductView) GetTitle() string {
	if x != nil && x.Title != nil {
		return *x.Title
	}
	return ""
}

func (x *PriceInsightsProductView) GetBrand() string {
	if x != nil && x.Brand != nil {
		return *x.Brand
	}
	return ""
}

func (x *PriceInsightsProductView) GetCategoryL1() string {
	if x != nil && x.CategoryL1 != nil {
		return *x.CategoryL1
	}
	return ""
}

func (x *PriceInsightsProductView) GetCategoryL2() string {
	if x != nil && x.CategoryL2 != nil {
		return *x.CategoryL2
	}
	return ""
}

func (x *PriceInsightsProductView) GetCategoryL3() string {
	if x != nil && x.CategoryL3 != nil {
		return *x.CategoryL3
	}
	return ""
}

func (x *PriceInsightsProductView) GetCategoryL4() string {
	if x != nil && x.CategoryL4 != nil {
		return *x.CategoryL4
	}
	return ""
}

func (x *PriceInsightsProductView) GetCategoryL5() string {
	if x != nil && x.CategoryL5 != nil {
		return *x.CategoryL5
	}
	return ""
}

func (x *PriceInsightsProductView) GetProductTypeL1() string {
	if x != nil && x.ProductTypeL1 != nil {
		return *x.ProductTypeL1
	}
	return ""
}

func (x *PriceInsightsProductView) GetProductTypeL2() string {
	if x != nil && x.ProductTypeL2 != nil {
		return *x.ProductTypeL2
	}
	return ""
}

func (x *PriceInsightsProductView) GetProductTypeL3() string {
	if x != nil && x.ProductTypeL3 != nil {
		return *x.ProductTypeL3
	}
	return ""
}

func (x *PriceInsightsProductView) GetProductTypeL4() string {
	if x != nil && x.ProductTypeL4 != nil {
		return *x.ProductTypeL4
	}
	return ""
}

func (x *PriceInsightsProductView) GetProductTypeL5() string {
	if x != nil && x.ProductTypeL5 != nil {
		return *x.ProductTypeL5
	}
	return ""
}

func (x *PriceInsightsProductView) GetPrice() *typepb.Price {
	if x != nil {
		return x.Price
	}
	return nil
}

func (x *PriceInsightsProductView) GetSuggestedPrice() *typepb.Price {
	if x != nil {
		return x.SuggestedPrice
	}
	return nil
}

func (x *PriceInsightsProductView) GetPredictedImpressionsChangeFraction() float64 {
	if x != nil && x.PredictedImpressionsChangeFraction != nil {
		return *x.PredictedImpressionsChangeFraction
	}
	return 0
}

func (x *PriceInsightsProductView) GetPredictedClicksChangeFraction() float64 {
	if x != nil && x.PredictedClicksChangeFraction != nil {
		return *x.PredictedClicksChangeFraction
	}
	return 0
}

func (x *PriceInsightsProductView) GetPredictedConversionsChangeFraction() float64 {
	if x != nil && x.PredictedConversionsChangeFraction != nil {
		return *x.PredictedConversionsChangeFraction
	}
	return 0
}

func (x *PriceInsightsProductView) GetEffectiveness() PriceInsightsProductView_Effectiveness {
	if x != nil {
		return x.Effectiveness
	}
	return PriceInsightsProductView_EFFECTIVENESS_UNSPECIFIED
}

// Fields available for query in `best_sellers_product_cluster_view` table.
//
// [Best sellers](https://support.google.com/merchants/answer/9488679) report
// with top product clusters. A product cluster is a grouping for different
// offers and variants that represent the same product, for example, Google
// Pixel 7.
//
// Values are only set for fields requested explicitly in the request's search
// query.
type BestSellersProductClusterView struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Report date. The value of this field can only be one of the following:
	//
	// *   The first day of the week (Monday) for weekly reports,
	// *   The first day of the month for monthly reports.
	//
	// Required in the `SELECT` clause. If a `WHERE` condition on `report_date` is
	// not specified in the query, the latest available weekly or monthly report
	// is returned.
	ReportDate *date.Date `protobuf:"bytes,1,opt,name=report_date,json=reportDate,proto3" json:"report_date,omitempty"`
	// Granularity of the report. The ranking can be done over a week or a month
	// timeframe.
	//
	// Required in the `SELECT` clause. Condition on `report_granularity` is
	// required in the `WHERE` clause.
	ReportGranularity *ReportGranularity_ReportGranularityEnum `protobuf:"varint,2,opt,name=report_granularity,json=reportGranularity,proto3,enum=google.shopping.merchant.reports.v1beta.ReportGranularity_ReportGranularityEnum,oneof" json:"report_granularity,omitempty"`
	// Country where the ranking is calculated. Represented in the ISO 3166
	// format.
	//
	// Required in the `SELECT` clause. Condition on `report_country_code` is
	// required in the `WHERE` clause.
	ReportCountryCode *string `protobuf:"bytes,3,opt,name=report_country_code,json=reportCountryCode,proto3,oneof" json:"report_country_code,omitempty"`
	// Google product category ID to calculate the ranking for, represented in
	// [Google's product
	// taxonomy](https://support.google.com/merchants/answer/6324436).
	//
	// Required in the `SELECT` clause. If a `WHERE` condition on
	// `report_category_id` is not specified in the query, rankings for all
	// top-level categories are returned.
	ReportCategoryId *int64 `protobuf:"varint,4,opt,name=report_category_id,json=reportCategoryId,proto3,oneof" json:"report_category_id,omitempty"`
	// Title of the product cluster.
	Title *string `protobuf:"bytes,6,opt,name=title,proto3,oneof" json:"title,omitempty"`
	// Brand of the product cluster.
	Brand *string `protobuf:"bytes,7,opt,name=brand,proto3,oneof" json:"brand,omitempty"`
	// Product category (1st level) of the product cluster, represented in
	// [Google's product
	// taxonomy](https://support.google.com/merchants/answer/6324436).
	CategoryL1 *string `protobuf:"bytes,8,opt,name=category_l1,json=categoryL1,proto3,oneof" json:"category_l1,omitempty"`
	// Product category (2nd level) of the product cluster, represented in
	// [Google's product
	// taxonomy](https://support.google.com/merchants/answer/6324436).
	CategoryL2 *string `protobuf:"bytes,9,opt,name=category_l2,json=categoryL2,proto3,oneof" json:"category_l2,omitempty"`
	// Product category (3rd level) of the product cluster, represented in
	// [Google's product
	// taxonomy](https://support.google.com/merchants/answer/6324436).
	CategoryL3 *string `protobuf:"bytes,10,opt,name=category_l3,json=categoryL3,proto3,oneof" json:"category_l3,omitempty"`
	// Product category (4th level) of the product cluster, represented in
	// [Google's product
	// taxonomy](https://support.google.com/merchants/answer/6324436).
	CategoryL4 *string `protobuf:"bytes,11,opt,name=category_l4,json=categoryL4,proto3,oneof" json:"category_l4,omitempty"`
	// Product category (5th level) of the product cluster, represented in
	// [Google's product
	// taxonomy](https://support.google.com/merchants/answer/6324436).
	CategoryL5 *string `protobuf:"bytes,12,opt,name=category_l5,json=categoryL5,proto3,oneof" json:"category_l5,omitempty"`
	// GTINs of example variants of the product cluster.
	VariantGtins []string `protobuf:"bytes,13,rep,name=variant_gtins,json=variantGtins,proto3" json:"variant_gtins,omitempty"`
	// Whether the product cluster is `IN_STOCK` in your product data source in at
	// least one of the countries, `OUT_OF_STOCK` in your product data source in
	// all countries, or `NOT_IN_INVENTORY` at all.
	//
	// The field doesn't take the Best sellers report country filter into account.
	InventoryStatus *BestSellersProductClusterView_InventoryStatus `protobuf:"varint,14,opt,name=inventory_status,json=inventoryStatus,proto3,enum=google.shopping.merchant.reports.v1beta.BestSellersProductClusterView_InventoryStatus,oneof" json:"inventory_status,omitempty"`
	// Whether there is at least one product of the brand currently `IN_STOCK` in
	// your product data source in at least one of the countries, all products are
	// `OUT_OF_STOCK` in your product data source in all countries, or
	// `NOT_IN_INVENTORY`.
	//
	// The field doesn't take the Best sellers report country filter into account.
	BrandInventoryStatus *BestSellersProductClusterView_InventoryStatus `protobuf:"varint,15,opt,name=brand_inventory_status,json=brandInventoryStatus,proto3,enum=google.shopping.merchant.reports.v1beta.BestSellersProductClusterView_InventoryStatus,oneof" json:"brand_inventory_status,omitempty"`
	// Popularity of the product cluster on Ads and organic surfaces, in the
	// selected category and country, based on the estimated number of units sold.
	Rank *int64 `protobuf:"varint,16,opt,name=rank,proto3,oneof" json:"rank,omitempty"`
	// Popularity rank in the previous week or month.
	PreviousRank *int64 `protobuf:"varint,17,opt,name=previous_rank,json=previousRank,proto3,oneof" json:"previous_rank,omitempty"`
	// Estimated demand in relation to the product cluster with the highest
	// popularity rank in the same category and country.
	RelativeDemand *RelativeDemand_RelativeDemandEnum `protobuf:"varint,18,opt,name=relative_demand,json=relativeDemand,proto3,enum=google.shopping.merchant.reports.v1beta.RelativeDemand_RelativeDemandEnum,oneof" json:"relative_demand,omitempty"`
	// Estimated demand in relation to the product cluster with the highest
	// popularity rank in the same category and country in the previous week or
	// month.
	PreviousRelativeDemand *RelativeDemand_RelativeDemandEnum `protobuf:"varint,19,opt,name=previous_relative_demand,json=previousRelativeDemand,proto3,enum=google.shopping.merchant.reports.v1beta.RelativeDemand_RelativeDemandEnum,oneof" json:"previous_relative_demand,omitempty"`
	// Change in the estimated demand. Whether it rose, sank or remained flat.
	RelativeDemandChange *RelativeDemandChangeType_RelativeDemandChangeTypeEnum `protobuf:"varint,20,opt,name=relative_demand_change,json=relativeDemandChange,proto3,enum=google.shopping.merchant.reports.v1beta.RelativeDemandChangeType_RelativeDemandChangeTypeEnum,oneof" json:"relative_demand_change,omitempty"`
}

func (x *BestSellersProductClusterView) Reset() {
	*x = BestSellersProductClusterView{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BestSellersProductClusterView) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BestSellersProductClusterView) ProtoMessage() {}

func (x *BestSellersProductClusterView) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BestSellersProductClusterView.ProtoReflect.Descriptor instead.
func (*BestSellersProductClusterView) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_reports_v1beta_reports_proto_rawDescGZIP(), []int{7}
}

func (x *BestSellersProductClusterView) GetReportDate() *date.Date {
	if x != nil {
		return x.ReportDate
	}
	return nil
}

func (x *BestSellersProductClusterView) GetReportGranularity() ReportGranularity_ReportGranularityEnum {
	if x != nil && x.ReportGranularity != nil {
		return *x.ReportGranularity
	}
	return ReportGranularity_REPORT_GRANULARITY_ENUM_UNSPECIFIED
}

func (x *BestSellersProductClusterView) GetReportCountryCode() string {
	if x != nil && x.ReportCountryCode != nil {
		return *x.ReportCountryCode
	}
	return ""
}

func (x *BestSellersProductClusterView) GetReportCategoryId() int64 {
	if x != nil && x.ReportCategoryId != nil {
		return *x.ReportCategoryId
	}
	return 0
}

func (x *BestSellersProductClusterView) GetTitle() string {
	if x != nil && x.Title != nil {
		return *x.Title
	}
	return ""
}

func (x *BestSellersProductClusterView) GetBrand() string {
	if x != nil && x.Brand != nil {
		return *x.Brand
	}
	return ""
}

func (x *BestSellersProductClusterView) GetCategoryL1() string {
	if x != nil && x.CategoryL1 != nil {
		return *x.CategoryL1
	}
	return ""
}

func (x *BestSellersProductClusterView) GetCategoryL2() string {
	if x != nil && x.CategoryL2 != nil {
		return *x.CategoryL2
	}
	return ""
}

func (x *BestSellersProductClusterView) GetCategoryL3() string {
	if x != nil && x.CategoryL3 != nil {
		return *x.CategoryL3
	}
	return ""
}

func (x *BestSellersProductClusterView) GetCategoryL4() string {
	if x != nil && x.CategoryL4 != nil {
		return *x.CategoryL4
	}
	return ""
}

func (x *BestSellersProductClusterView) GetCategoryL5() string {
	if x != nil && x.CategoryL5 != nil {
		return *x.CategoryL5
	}
	return ""
}

func (x *BestSellersProductClusterView) GetVariantGtins() []string {
	if x != nil {
		return x.VariantGtins
	}
	return nil
}

func (x *BestSellersProductClusterView) GetInventoryStatus() BestSellersProductClusterView_InventoryStatus {
	if x != nil && x.InventoryStatus != nil {
		return *x.InventoryStatus
	}
	return BestSellersProductClusterView_INVENTORY_STATUS_UNSPECIFIED
}

func (x *BestSellersProductClusterView) GetBrandInventoryStatus() BestSellersProductClusterView_InventoryStatus {
	if x != nil && x.BrandInventoryStatus != nil {
		return *x.BrandInventoryStatus
	}
	return BestSellersProductClusterView_INVENTORY_STATUS_UNSPECIFIED
}

func (x *BestSellersProductClusterView) GetRank() int64 {
	if x != nil && x.Rank != nil {
		return *x.Rank
	}
	return 0
}

func (x *BestSellersProductClusterView) GetPreviousRank() int64 {
	if x != nil && x.PreviousRank != nil {
		return *x.PreviousRank
	}
	return 0
}

func (x *BestSellersProductClusterView) GetRelativeDemand() RelativeDemand_RelativeDemandEnum {
	if x != nil && x.RelativeDemand != nil {
		return *x.RelativeDemand
	}
	return RelativeDemand_RELATIVE_DEMAND_ENUM_UNSPECIFIED
}

func (x *BestSellersProductClusterView) GetPreviousRelativeDemand() RelativeDemand_RelativeDemandEnum {
	if x != nil && x.PreviousRelativeDemand != nil {
		return *x.PreviousRelativeDemand
	}
	return RelativeDemand_RELATIVE_DEMAND_ENUM_UNSPECIFIED
}

func (x *BestSellersProductClusterView) GetRelativeDemandChange() RelativeDemandChangeType_RelativeDemandChangeTypeEnum {
	if x != nil && x.RelativeDemandChange != nil {
		return *x.RelativeDemandChange
	}
	return RelativeDemandChangeType_RELATIVE_DEMAND_CHANGE_TYPE_ENUM_UNSPECIFIED
}

// Fields available for query in `best_sellers_brand_view` table.
//
// [Best sellers](https://support.google.com/merchants/answer/9488679) report
// with top brands.
//
// Values are only set for fields requested explicitly in the request's search
// query.
type BestSellersBrandView struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Report date. The value of this field can only be one of the following:
	//
	// *   The first day of the week (Monday) for weekly reports,
	// *   The first day of the month for monthly reports.
	//
	// Required in the `SELECT` clause. If a `WHERE` condition on `report_date` is
	// not specified in the query, the latest available weekly or monthly report
	// is returned.
	ReportDate *date.Date `protobuf:"bytes,1,opt,name=report_date,json=reportDate,proto3" json:"report_date,omitempty"`
	// Granularity of the report. The ranking can be done over a week or a month
	// timeframe.
	//
	// Required in the `SELECT` clause. Condition on `report_granularity` is
	// required in the `WHERE` clause.
	ReportGranularity *ReportGranularity_ReportGranularityEnum `protobuf:"varint,2,opt,name=report_granularity,json=reportGranularity,proto3,enum=google.shopping.merchant.reports.v1beta.ReportGranularity_ReportGranularityEnum,oneof" json:"report_granularity,omitempty"`
	// Country where the ranking is calculated. Represented in the ISO 3166
	// format.
	//
	// Required in the `SELECT` clause. Condition on `report_country_code` is
	// required in the `WHERE` clause.
	ReportCountryCode *string `protobuf:"bytes,3,opt,name=report_country_code,json=reportCountryCode,proto3,oneof" json:"report_country_code,omitempty"`
	// Google product category ID to calculate the ranking for, represented in
	// [Google's product
	// taxonomy](https://support.google.com/merchants/answer/6324436).
	//
	// Required in the `SELECT` clause. If a `WHERE` condition on
	// `report_category_id` is not specified in the query, rankings for all
	// top-level categories are returned.
	ReportCategoryId *int64 `protobuf:"varint,4,opt,name=report_category_id,json=reportCategoryId,proto3,oneof" json:"report_category_id,omitempty"`
	// Name of the brand.
	Brand *string `protobuf:"bytes,6,opt,name=brand,proto3,oneof" json:"brand,omitempty"`
	// Popularity of the brand on Ads and organic surfaces, in the selected
	// category and country, based on the estimated number of units sold.
	Rank *int64 `protobuf:"varint,7,opt,name=rank,proto3,oneof" json:"rank,omitempty"`
	// Popularity rank in the previous week or month.
	PreviousRank *int64 `protobuf:"varint,8,opt,name=previous_rank,json=previousRank,proto3,oneof" json:"previous_rank,omitempty"`
	// Estimated demand in relation to the brand with the highest popularity rank
	// in the same category and country.
	RelativeDemand *RelativeDemand_RelativeDemandEnum `protobuf:"varint,9,opt,name=relative_demand,json=relativeDemand,proto3,enum=google.shopping.merchant.reports.v1beta.RelativeDemand_RelativeDemandEnum,oneof" json:"relative_demand,omitempty"`
	// Estimated demand in relation to the brand with the highest popularity rank
	// in the same category and country in the previous week or month.
	PreviousRelativeDemand *RelativeDemand_RelativeDemandEnum `protobuf:"varint,10,opt,name=previous_relative_demand,json=previousRelativeDemand,proto3,enum=google.shopping.merchant.reports.v1beta.RelativeDemand_RelativeDemandEnum,oneof" json:"previous_relative_demand,omitempty"`
	// Change in the estimated demand. Whether it rose, sank or remained flat.
	RelativeDemandChange *RelativeDemandChangeType_RelativeDemandChangeTypeEnum `protobuf:"varint,11,opt,name=relative_demand_change,json=relativeDemandChange,proto3,enum=google.shopping.merchant.reports.v1beta.RelativeDemandChangeType_RelativeDemandChangeTypeEnum,oneof" json:"relative_demand_change,omitempty"`
}

func (x *BestSellersBrandView) Reset() {
	*x = BestSellersBrandView{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BestSellersBrandView) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BestSellersBrandView) ProtoMessage() {}

func (x *BestSellersBrandView) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BestSellersBrandView.ProtoReflect.Descriptor instead.
func (*BestSellersBrandView) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_reports_v1beta_reports_proto_rawDescGZIP(), []int{8}
}

func (x *BestSellersBrandView) GetReportDate() *date.Date {
	if x != nil {
		return x.ReportDate
	}
	return nil
}

func (x *BestSellersBrandView) GetReportGranularity() ReportGranularity_ReportGranularityEnum {
	if x != nil && x.ReportGranularity != nil {
		return *x.ReportGranularity
	}
	return ReportGranularity_REPORT_GRANULARITY_ENUM_UNSPECIFIED
}

func (x *BestSellersBrandView) GetReportCountryCode() string {
	if x != nil && x.ReportCountryCode != nil {
		return *x.ReportCountryCode
	}
	return ""
}

func (x *BestSellersBrandView) GetReportCategoryId() int64 {
	if x != nil && x.ReportCategoryId != nil {
		return *x.ReportCategoryId
	}
	return 0
}

func (x *BestSellersBrandView) GetBrand() string {
	if x != nil && x.Brand != nil {
		return *x.Brand
	}
	return ""
}

func (x *BestSellersBrandView) GetRank() int64 {
	if x != nil && x.Rank != nil {
		return *x.Rank
	}
	return 0
}

func (x *BestSellersBrandView) GetPreviousRank() int64 {
	if x != nil && x.PreviousRank != nil {
		return *x.PreviousRank
	}
	return 0
}

func (x *BestSellersBrandView) GetRelativeDemand() RelativeDemand_RelativeDemandEnum {
	if x != nil && x.RelativeDemand != nil {
		return *x.RelativeDemand
	}
	return RelativeDemand_RELATIVE_DEMAND_ENUM_UNSPECIFIED
}

func (x *BestSellersBrandView) GetPreviousRelativeDemand() RelativeDemand_RelativeDemandEnum {
	if x != nil && x.PreviousRelativeDemand != nil {
		return *x.PreviousRelativeDemand
	}
	return RelativeDemand_RELATIVE_DEMAND_ENUM_UNSPECIFIED
}

func (x *BestSellersBrandView) GetRelativeDemandChange() RelativeDemandChangeType_RelativeDemandChangeTypeEnum {
	if x != nil && x.RelativeDemandChange != nil {
		return *x.RelativeDemandChange
	}
	return RelativeDemandChangeType_RELATIVE_DEMAND_CHANGE_TYPE_ENUM_UNSPECIFIED
}

// Fields available for query in `non_product_performance_view` table.
//
// Performance data on images and online store links leading to your non-product
// pages. This includes performance metrics (for example, `clicks`)
// and dimensions according to which performance metrics are segmented (for
// example, `date`).
//
// Segment fields cannot be selected in queries without also selecting at least
// one metric field.
//
// Values are only set for fields requested explicitly in the request's search
// query.
type NonProductPerformanceView struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Date in the merchant timezone to which metrics apply. Segment.
	//
	// Condition on `date` is required in the `WHERE` clause.
	Date *date.Date `protobuf:"bytes,1,opt,name=date,proto3" json:"date,omitempty"`
	// First day of the week (Monday) of the metrics date in the merchant
	// timezone. Segment.
	Week *date.Date `protobuf:"bytes,2,opt,name=week,proto3" json:"week,omitempty"`
	// Number of clicks on images and online store links leading to your
	// non-product pages. Metric.
	Clicks *int64 `protobuf:"varint,3,opt,name=clicks,proto3,oneof" json:"clicks,omitempty"`
	// Number of times images and online store links leading to your non-product
	// pages were shown. Metric.
	Impressions *int64 `protobuf:"varint,4,opt,name=impressions,proto3,oneof" json:"impressions,omitempty"`
	// Click-through rate - the number of clicks (`clicks`) divided by the number
	// of impressions (`impressions`) of images and online store links leading to
	// your non-product pages. Metric.
	ClickThroughRate *float64 `protobuf:"fixed64,5,opt,name=click_through_rate,json=clickThroughRate,proto3,oneof" json:"click_through_rate,omitempty"`
}

func (x *NonProductPerformanceView) Reset() {
	*x = NonProductPerformanceView{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NonProductPerformanceView) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NonProductPerformanceView) ProtoMessage() {}

func (x *NonProductPerformanceView) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NonProductPerformanceView.ProtoReflect.Descriptor instead.
func (*NonProductPerformanceView) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_reports_v1beta_reports_proto_rawDescGZIP(), []int{9}
}

func (x *NonProductPerformanceView) GetDate() *date.Date {
	if x != nil {
		return x.Date
	}
	return nil
}

func (x *NonProductPerformanceView) GetWeek() *date.Date {
	if x != nil {
		return x.Week
	}
	return nil
}

func (x *NonProductPerformanceView) GetClicks() int64 {
	if x != nil && x.Clicks != nil {
		return *x.Clicks
	}
	return 0
}

func (x *NonProductPerformanceView) GetImpressions() int64 {
	if x != nil && x.Impressions != nil {
		return *x.Impressions
	}
	return 0
}

func (x *NonProductPerformanceView) GetClickThroughRate() float64 {
	if x != nil && x.ClickThroughRate != nil {
		return *x.ClickThroughRate
	}
	return 0
}

// Fields available for query in `competitive_visibility_competitor_view` table.
//
// [Competitive
// visibility](https://support.google.com/merchants/answer/11366442) report with
// businesses with similar visibility.
//
// Values are only set for fields requested explicitly in the request's search
// query.
type CompetitiveVisibilityCompetitorView struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Date of this row.
	//
	// A condition on `date` is required in the `WHERE` clause.
	Date *date.Date `protobuf:"bytes,1,opt,name=date,proto3" json:"date,omitempty"`
	// Domain of your competitor or your domain, if 'is_your_domain' is true.
	//
	// Required in the `SELECT` clause. Cannot be filtered on in the 'WHERE'
	// clause.
	Domain *string `protobuf:"bytes,2,opt,name=domain,proto3,oneof" json:"domain,omitempty"`
	// True if this row contains data for your domain.
	//
	// Cannot be filtered on in the 'WHERE' clause.
	IsYourDomain *bool `protobuf:"varint,3,opt,name=is_your_domain,json=isYourDomain,proto3,oneof" json:"is_your_domain,omitempty"`
	// Country where impressions appeared.
	//
	// Required in the `SELECT` clause. A condition on `report_country_code` is
	// required in the `WHERE` clause.
	ReportCountryCode *string `protobuf:"bytes,4,opt,name=report_country_code,json=reportCountryCode,proto3,oneof" json:"report_country_code,omitempty"`
	// Google product category ID to calculate the report for, represented in
	// [Google's product
	// taxonomy](https://support.google.com/merchants/answer/6324436).
	//
	// Required in the `SELECT` clause. A condition on `report_category_id` is
	// required in the `WHERE` clause.
	ReportCategoryId *int64 `protobuf:"varint,5,opt,name=report_category_id,json=reportCategoryId,proto3,oneof" json:"report_category_id,omitempty"`
	// Traffic source of impressions.
	//
	// Required in the `SELECT` clause.
	TrafficSource *TrafficSource_TrafficSourceEnum `protobuf:"varint,6,opt,name=traffic_source,json=trafficSource,proto3,enum=google.shopping.merchant.reports.v1beta.TrafficSource_TrafficSourceEnum,oneof" json:"traffic_source,omitempty"`
	// Position of the domain in the similar businesses ranking for the selected
	// keys (`date`, `report_category_id`, `report_country_code`,
	// `traffic_source`) based on impressions. 1 is the highest.
	//
	// Cannot be filtered on in the 'WHERE' clause.
	Rank *int64 `protobuf:"varint,7,opt,name=rank,proto3,oneof" json:"rank,omitempty"`
	// [Ads / organic ratio]
	// (https://support.google.com/merchants/answer/11366442#zippy=%2Cads-free-ratio)
	// shows how often the domain receives impressions from Shopping ads compared
	// to organic traffic. The number is rounded and bucketed.
	//
	// Cannot be filtered on in the 'WHERE' clause.
	AdsOrganicRatio *float64 `protobuf:"fixed64,8,opt,name=ads_organic_ratio,json=adsOrganicRatio,proto3,oneof" json:"ads_organic_ratio,omitempty"`
	// [Page overlap rate]
	// (https://support.google.com/merchants/answer/11366442#zippy=%2Cpage-overlap-rate)
	// shows how frequently competing retailers’ offers are shown together with
	// your offers on the same page.
	//
	// Cannot be filtered on in the 'WHERE' clause.
	PageOverlapRate *float64 `protobuf:"fixed64,9,opt,name=page_overlap_rate,json=pageOverlapRate,proto3,oneof" json:"page_overlap_rate,omitempty"`
	// [Higher position rate]
	// (https://support.google.com/merchants/answer/11366442#zippy=%2Chigher-position-rate)
	// shows how often a competitor’s offer got placed in a higher position on the
	// page than your offer.
	//
	// Cannot be filtered on in the 'WHERE' clause.
	HigherPositionRate *float64 `protobuf:"fixed64,10,opt,name=higher_position_rate,json=higherPositionRate,proto3,oneof" json:"higher_position_rate,omitempty"`
	// [Relative visibility]
	// (https://support.google.com/merchants/answer/11366442#zippy=%2Crelative-visibility)
	// shows how often your competitors’ offers are shown compared to your offers.
	// In other words, this is the number of displayed impressions of a competitor
	// retailer divided by the number of your displayed impressions during a
	// selected time range for a selected product category and country.
	//
	// Cannot be filtered on in the 'WHERE' clause.
	RelativeVisibility *float64 `protobuf:"fixed64,11,opt,name=relative_visibility,json=relativeVisibility,proto3,oneof" json:"relative_visibility,omitempty"`
}

func (x *CompetitiveVisibilityCompetitorView) Reset() {
	*x = CompetitiveVisibilityCompetitorView{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CompetitiveVisibilityCompetitorView) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CompetitiveVisibilityCompetitorView) ProtoMessage() {}

func (x *CompetitiveVisibilityCompetitorView) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CompetitiveVisibilityCompetitorView.ProtoReflect.Descriptor instead.
func (*CompetitiveVisibilityCompetitorView) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_reports_v1beta_reports_proto_rawDescGZIP(), []int{10}
}

func (x *CompetitiveVisibilityCompetitorView) GetDate() *date.Date {
	if x != nil {
		return x.Date
	}
	return nil
}

func (x *CompetitiveVisibilityCompetitorView) GetDomain() string {
	if x != nil && x.Domain != nil {
		return *x.Domain
	}
	return ""
}

func (x *CompetitiveVisibilityCompetitorView) GetIsYourDomain() bool {
	if x != nil && x.IsYourDomain != nil {
		return *x.IsYourDomain
	}
	return false
}

func (x *CompetitiveVisibilityCompetitorView) GetReportCountryCode() string {
	if x != nil && x.ReportCountryCode != nil {
		return *x.ReportCountryCode
	}
	return ""
}

func (x *CompetitiveVisibilityCompetitorView) GetReportCategoryId() int64 {
	if x != nil && x.ReportCategoryId != nil {
		return *x.ReportCategoryId
	}
	return 0
}

func (x *CompetitiveVisibilityCompetitorView) GetTrafficSource() TrafficSource_TrafficSourceEnum {
	if x != nil && x.TrafficSource != nil {
		return *x.TrafficSource
	}
	return TrafficSource_TRAFFIC_SOURCE_ENUM_UNSPECIFIED
}

func (x *CompetitiveVisibilityCompetitorView) GetRank() int64 {
	if x != nil && x.Rank != nil {
		return *x.Rank
	}
	return 0
}

func (x *CompetitiveVisibilityCompetitorView) GetAdsOrganicRatio() float64 {
	if x != nil && x.AdsOrganicRatio != nil {
		return *x.AdsOrganicRatio
	}
	return 0
}

func (x *CompetitiveVisibilityCompetitorView) GetPageOverlapRate() float64 {
	if x != nil && x.PageOverlapRate != nil {
		return *x.PageOverlapRate
	}
	return 0
}

func (x *CompetitiveVisibilityCompetitorView) GetHigherPositionRate() float64 {
	if x != nil && x.HigherPositionRate != nil {
		return *x.HigherPositionRate
	}
	return 0
}

func (x *CompetitiveVisibilityCompetitorView) GetRelativeVisibility() float64 {
	if x != nil && x.RelativeVisibility != nil {
		return *x.RelativeVisibility
	}
	return 0
}

// Fields available for query in `competitive_visibility_top_merchant_view`
// table.
//
// [Competitive
// visibility](https://support.google.com/merchants/answer/11366442) report with
// business with highest visibility.
//
// Values are only set for fields requested explicitly in the request's search
// query.
type CompetitiveVisibilityTopMerchantView struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Date of this row.
	//
	// Cannot be selected in the `SELECT` clause. A condition on `date` is
	// required in the `WHERE` clause.
	Date *date.Date `protobuf:"bytes,1,opt,name=date,proto3" json:"date,omitempty"`
	// Domain of your competitor or your domain, if 'is_your_domain' is true.
	//
	// Required in the `SELECT` clause. Cannot be filtered on in the 'WHERE'
	// clause.
	Domain *string `protobuf:"bytes,2,opt,name=domain,proto3,oneof" json:"domain,omitempty"`
	// True if this row contains data for your domain.
	//
	// Cannot be filtered on in the 'WHERE' clause.
	IsYourDomain *bool `protobuf:"varint,3,opt,name=is_your_domain,json=isYourDomain,proto3,oneof" json:"is_your_domain,omitempty"`
	// Country where impressions appeared.
	//
	// Required in the `SELECT` clause. A condition on `report_country_code` is
	// required in the `WHERE` clause.
	ReportCountryCode *string `protobuf:"bytes,4,opt,name=report_country_code,json=reportCountryCode,proto3,oneof" json:"report_country_code,omitempty"`
	// Google product category ID to calculate the report for, represented in
	// [Google's product
	// taxonomy](https://support.google.com/merchants/answer/6324436).
	//
	// Required in the `SELECT` clause. A condition on `report_category_id` is
	// required in the `WHERE` clause.
	ReportCategoryId *int64 `protobuf:"varint,5,opt,name=report_category_id,json=reportCategoryId,proto3,oneof" json:"report_category_id,omitempty"`
	// Traffic source of impressions.
	//
	// Required in the `SELECT` clause.
	TrafficSource *TrafficSource_TrafficSourceEnum `protobuf:"varint,6,opt,name=traffic_source,json=trafficSource,proto3,enum=google.shopping.merchant.reports.v1beta.TrafficSource_TrafficSourceEnum,oneof" json:"traffic_source,omitempty"`
	// Position of the domain in the top merchants ranking for the selected keys
	// (`date`, `report_category_id`, `report_country_code`, `traffic_source`)
	// based on impressions. 1 is the highest.
	//
	// Cannot be filtered on in the 'WHERE' clause.
	Rank *int64 `protobuf:"varint,7,opt,name=rank,proto3,oneof" json:"rank,omitempty"`
	// [Ads / organic ratio]
	// (https://support.google.com/merchants/answer/11366442#zippy=%2Cads-free-ratio)
	// shows how often the domain receives impressions from Shopping ads compared
	// to organic traffic. The number is rounded and bucketed.
	//
	// Cannot be filtered on in the 'WHERE' clause.
	AdsOrganicRatio *float64 `protobuf:"fixed64,8,opt,name=ads_organic_ratio,json=adsOrganicRatio,proto3,oneof" json:"ads_organic_ratio,omitempty"`
	// [Page overlap rate]
	// (https://support.google.com/merchants/answer/11366442#zippy=%2Cpage-overlap-rate)
	// shows how frequently competing retailers’ offers are shown together with
	// your offers on the same page.
	//
	// Cannot be filtered on in the 'WHERE' clause.
	PageOverlapRate *float64 `protobuf:"fixed64,9,opt,name=page_overlap_rate,json=pageOverlapRate,proto3,oneof" json:"page_overlap_rate,omitempty"`
	// [Higher position rate]
	// (https://support.google.com/merchants/answer/11366442#zippy=%2Chigher-position-rate)
	// shows how often a competitor’s offer got placed in a higher position on the
	// page than your offer.
	//
	// Cannot be filtered on in the 'WHERE' clause.
	HigherPositionRate *float64 `protobuf:"fixed64,10,opt,name=higher_position_rate,json=higherPositionRate,proto3,oneof" json:"higher_position_rate,omitempty"`
}

func (x *CompetitiveVisibilityTopMerchantView) Reset() {
	*x = CompetitiveVisibilityTopMerchantView{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CompetitiveVisibilityTopMerchantView) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CompetitiveVisibilityTopMerchantView) ProtoMessage() {}

func (x *CompetitiveVisibilityTopMerchantView) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CompetitiveVisibilityTopMerchantView.ProtoReflect.Descriptor instead.
func (*CompetitiveVisibilityTopMerchantView) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_reports_v1beta_reports_proto_rawDescGZIP(), []int{11}
}

func (x *CompetitiveVisibilityTopMerchantView) GetDate() *date.Date {
	if x != nil {
		return x.Date
	}
	return nil
}

func (x *CompetitiveVisibilityTopMerchantView) GetDomain() string {
	if x != nil && x.Domain != nil {
		return *x.Domain
	}
	return ""
}

func (x *CompetitiveVisibilityTopMerchantView) GetIsYourDomain() bool {
	if x != nil && x.IsYourDomain != nil {
		return *x.IsYourDomain
	}
	return false
}

func (x *CompetitiveVisibilityTopMerchantView) GetReportCountryCode() string {
	if x != nil && x.ReportCountryCode != nil {
		return *x.ReportCountryCode
	}
	return ""
}

func (x *CompetitiveVisibilityTopMerchantView) GetReportCategoryId() int64 {
	if x != nil && x.ReportCategoryId != nil {
		return *x.ReportCategoryId
	}
	return 0
}

func (x *CompetitiveVisibilityTopMerchantView) GetTrafficSource() TrafficSource_TrafficSourceEnum {
	if x != nil && x.TrafficSource != nil {
		return *x.TrafficSource
	}
	return TrafficSource_TRAFFIC_SOURCE_ENUM_UNSPECIFIED
}

func (x *CompetitiveVisibilityTopMerchantView) GetRank() int64 {
	if x != nil && x.Rank != nil {
		return *x.Rank
	}
	return 0
}

func (x *CompetitiveVisibilityTopMerchantView) GetAdsOrganicRatio() float64 {
	if x != nil && x.AdsOrganicRatio != nil {
		return *x.AdsOrganicRatio
	}
	return 0
}

func (x *CompetitiveVisibilityTopMerchantView) GetPageOverlapRate() float64 {
	if x != nil && x.PageOverlapRate != nil {
		return *x.PageOverlapRate
	}
	return 0
}

func (x *CompetitiveVisibilityTopMerchantView) GetHigherPositionRate() float64 {
	if x != nil && x.HigherPositionRate != nil {
		return *x.HigherPositionRate
	}
	return 0
}

// Fields available for query in `competitive_visibility_benchmark_view` table.
//
// [Competitive
// visibility](https://support.google.com/merchants/answer/11366442) report with
// the category benchmark.
//
// Values are only set for fields requested explicitly in the request's search
// query.
type CompetitiveVisibilityBenchmarkView struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Date of this row.
	//
	// Required in the `SELECT` clause. A condition on `date` is required in the
	// `WHERE` clause.
	Date *date.Date `protobuf:"bytes,1,opt,name=date,proto3" json:"date,omitempty"`
	// Country where impressions appeared.
	//
	// Required in the `SELECT` clause. A condition on `report_country_code` is
	// required in the `WHERE` clause.
	ReportCountryCode *string `protobuf:"bytes,2,opt,name=report_country_code,json=reportCountryCode,proto3,oneof" json:"report_country_code,omitempty"`
	// Google product category ID to calculate the report for, represented in
	// [Google's product
	// taxonomy](https://support.google.com/merchants/answer/6324436).
	//
	// Required in the `SELECT` clause. A condition on `report_category_id` is
	// required in the `WHERE` clause.
	ReportCategoryId *int64 `protobuf:"varint,3,opt,name=report_category_id,json=reportCategoryId,proto3,oneof" json:"report_category_id,omitempty"`
	// Traffic source of impressions.
	//
	// Required in the `SELECT` clause.
	TrafficSource *TrafficSource_TrafficSourceEnum `protobuf:"varint,4,opt,name=traffic_source,json=trafficSource,proto3,enum=google.shopping.merchant.reports.v1beta.TrafficSource_TrafficSourceEnum,oneof" json:"traffic_source,omitempty"`
	// Change in visibility based on impressions for your domain with respect to
	// the start of the selected time range (or first day with non-zero
	// impressions).
	//
	// Cannot be filtered on in the 'WHERE' clause.
	YourDomainVisibilityTrend *float64 `protobuf:"fixed64,5,opt,name=your_domain_visibility_trend,json=yourDomainVisibilityTrend,proto3,oneof" json:"your_domain_visibility_trend,omitempty"`
	// Change in visibility based on impressions with respect to the start of the
	// selected time range (or first day with non-zero impressions) for a
	// combined set of merchants with highest visibility approximating the
	// market.
	//
	// Cannot be filtered on in the 'WHERE' clause.
	CategoryBenchmarkVisibilityTrend *float64 `protobuf:"fixed64,6,opt,name=category_benchmark_visibility_trend,json=categoryBenchmarkVisibilityTrend,proto3,oneof" json:"category_benchmark_visibility_trend,omitempty"`
}

func (x *CompetitiveVisibilityBenchmarkView) Reset() {
	*x = CompetitiveVisibilityBenchmarkView{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CompetitiveVisibilityBenchmarkView) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CompetitiveVisibilityBenchmarkView) ProtoMessage() {}

func (x *CompetitiveVisibilityBenchmarkView) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CompetitiveVisibilityBenchmarkView.ProtoReflect.Descriptor instead.
func (*CompetitiveVisibilityBenchmarkView) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_reports_v1beta_reports_proto_rawDescGZIP(), []int{12}
}

func (x *CompetitiveVisibilityBenchmarkView) GetDate() *date.Date {
	if x != nil {
		return x.Date
	}
	return nil
}

func (x *CompetitiveVisibilityBenchmarkView) GetReportCountryCode() string {
	if x != nil && x.ReportCountryCode != nil {
		return *x.ReportCountryCode
	}
	return ""
}

func (x *CompetitiveVisibilityBenchmarkView) GetReportCategoryId() int64 {
	if x != nil && x.ReportCategoryId != nil {
		return *x.ReportCategoryId
	}
	return 0
}

func (x *CompetitiveVisibilityBenchmarkView) GetTrafficSource() TrafficSource_TrafficSourceEnum {
	if x != nil && x.TrafficSource != nil {
		return *x.TrafficSource
	}
	return TrafficSource_TRAFFIC_SOURCE_ENUM_UNSPECIFIED
}

func (x *CompetitiveVisibilityBenchmarkView) GetYourDomainVisibilityTrend() float64 {
	if x != nil && x.YourDomainVisibilityTrend != nil {
		return *x.YourDomainVisibilityTrend
	}
	return 0
}

func (x *CompetitiveVisibilityBenchmarkView) GetCategoryBenchmarkVisibilityTrend() float64 {
	if x != nil && x.CategoryBenchmarkVisibilityTrend != nil {
		return *x.CategoryBenchmarkVisibilityTrend
	}
	return 0
}

// Marketing method used to promote your products on Google (organic versus
// ads).
type MarketingMethod struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *MarketingMethod) Reset() {
	*x = MarketingMethod{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MarketingMethod) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MarketingMethod) ProtoMessage() {}

func (x *MarketingMethod) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MarketingMethod.ProtoReflect.Descriptor instead.
func (*MarketingMethod) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_reports_v1beta_reports_proto_rawDescGZIP(), []int{13}
}

// Granularity of the Best sellers report. Best sellers reports are computed
// over a week and a month timeframe.
type ReportGranularity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ReportGranularity) Reset() {
	*x = ReportGranularity{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReportGranularity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportGranularity) ProtoMessage() {}

func (x *ReportGranularity) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportGranularity.ProtoReflect.Descriptor instead.
func (*ReportGranularity) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_reports_v1beta_reports_proto_rawDescGZIP(), []int{14}
}

// Relative demand of a product cluster or brand in the Best sellers report.
type RelativeDemand struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *RelativeDemand) Reset() {
	*x = RelativeDemand{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RelativeDemand) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RelativeDemand) ProtoMessage() {}

func (x *RelativeDemand) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RelativeDemand.ProtoReflect.Descriptor instead.
func (*RelativeDemand) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_reports_v1beta_reports_proto_rawDescGZIP(), []int{15}
}

// Relative demand of a product cluster or brand in the Best sellers report
// compared to the previous time period.
type RelativeDemandChangeType struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *RelativeDemandChangeType) Reset() {
	*x = RelativeDemandChangeType{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RelativeDemandChangeType) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RelativeDemandChangeType) ProtoMessage() {}

func (x *RelativeDemandChangeType) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RelativeDemandChangeType.ProtoReflect.Descriptor instead.
func (*RelativeDemandChangeType) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_reports_v1beta_reports_proto_rawDescGZIP(), []int{16}
}

// Traffic source of impressions in the Competitive visibility report.
type TrafficSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *TrafficSource) Reset() {
	*x = TrafficSource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TrafficSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrafficSource) ProtoMessage() {}

func (x *TrafficSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrafficSource.ProtoReflect.Descriptor instead.
func (*TrafficSource) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_reports_v1beta_reports_proto_rawDescGZIP(), []int{17}
}

// Item issue associated with the product.
type ProductView_ItemIssue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Item issue type.
	Type *ProductView_ItemIssue_ItemIssueType `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	// Item issue severity.
	Severity *ProductView_ItemIssue_ItemIssueSeverity `protobuf:"bytes,2,opt,name=severity,proto3" json:"severity,omitempty"`
	// Item issue resolution.
	Resolution *ProductView_ItemIssue_ItemIssueResolution `protobuf:"varint,3,opt,name=resolution,proto3,enum=google.shopping.merchant.reports.v1beta.ProductView_ItemIssue_ItemIssueResolution,oneof" json:"resolution,omitempty"`
}

func (x *ProductView_ItemIssue) Reset() {
	*x = ProductView_ItemIssue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProductView_ItemIssue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProductView_ItemIssue) ProtoMessage() {}

func (x *ProductView_ItemIssue) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProductView_ItemIssue.ProtoReflect.Descriptor instead.
func (*ProductView_ItemIssue) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_reports_v1beta_reports_proto_rawDescGZIP(), []int{4, 0}
}

func (x *ProductView_ItemIssue) GetType() *ProductView_ItemIssue_ItemIssueType {
	if x != nil {
		return x.Type
	}
	return nil
}

func (x *ProductView_ItemIssue) GetSeverity() *ProductView_ItemIssue_ItemIssueSeverity {
	if x != nil {
		return x.Severity
	}
	return nil
}

func (x *ProductView_ItemIssue) GetResolution() ProductView_ItemIssue_ItemIssueResolution {
	if x != nil && x.Resolution != nil {
		return *x.Resolution
	}
	return ProductView_ItemIssue_ITEM_ISSUE_RESOLUTION_UNSPECIFIED
}

// Issue type.
type ProductView_ItemIssue_ItemIssueType struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Error code of the issue, equivalent to the `code` of [Product
	// issues](https://developers.google.com/shopping-content/guides/product-issues).
	Code *string `protobuf:"bytes,1,opt,name=code,proto3,oneof" json:"code,omitempty"`
	// Canonical attribute name for attribute-specific issues.
	CanonicalAttribute *string `protobuf:"bytes,2,opt,name=canonical_attribute,json=canonicalAttribute,proto3,oneof" json:"canonical_attribute,omitempty"`
}

func (x *ProductView_ItemIssue_ItemIssueType) Reset() {
	*x = ProductView_ItemIssue_ItemIssueType{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProductView_ItemIssue_ItemIssueType) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProductView_ItemIssue_ItemIssueType) ProtoMessage() {}

func (x *ProductView_ItemIssue_ItemIssueType) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProductView_ItemIssue_ItemIssueType.ProtoReflect.Descriptor instead.
func (*ProductView_ItemIssue_ItemIssueType) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_reports_v1beta_reports_proto_rawDescGZIP(), []int{4, 0, 0}
}

func (x *ProductView_ItemIssue_ItemIssueType) GetCode() string {
	if x != nil && x.Code != nil {
		return *x.Code
	}
	return ""
}

func (x *ProductView_ItemIssue_ItemIssueType) GetCanonicalAttribute() string {
	if x != nil && x.CanonicalAttribute != nil {
		return *x.CanonicalAttribute
	}
	return ""
}

// How the issue affects the serving of the product.
type ProductView_ItemIssue_ItemIssueSeverity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Issue severity per reporting context.
	SeverityPerReportingContext []*ProductView_ItemIssue_ItemIssueSeverity_IssueSeverityPerReportingContext `protobuf:"bytes,1,rep,name=severity_per_reporting_context,json=severityPerReportingContext,proto3" json:"severity_per_reporting_context,omitempty"`
	// Aggregated severity of the issue for all reporting contexts it affects.
	//
	// **This field can be used for filtering the results.**
	AggregatedSeverity *ProductView_ItemIssue_ItemIssueSeverity_AggregatedIssueSeverity `protobuf:"varint,2,opt,name=aggregated_severity,json=aggregatedSeverity,proto3,enum=google.shopping.merchant.reports.v1beta.ProductView_ItemIssue_ItemIssueSeverity_AggregatedIssueSeverity,oneof" json:"aggregated_severity,omitempty"`
}

func (x *ProductView_ItemIssue_ItemIssueSeverity) Reset() {
	*x = ProductView_ItemIssue_ItemIssueSeverity{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProductView_ItemIssue_ItemIssueSeverity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProductView_ItemIssue_ItemIssueSeverity) ProtoMessage() {}

func (x *ProductView_ItemIssue_ItemIssueSeverity) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProductView_ItemIssue_ItemIssueSeverity.ProtoReflect.Descriptor instead.
func (*ProductView_ItemIssue_ItemIssueSeverity) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_reports_v1beta_reports_proto_rawDescGZIP(), []int{4, 0, 1}
}

func (x *ProductView_ItemIssue_ItemIssueSeverity) GetSeverityPerReportingContext() []*ProductView_ItemIssue_ItemIssueSeverity_IssueSeverityPerReportingContext {
	if x != nil {
		return x.SeverityPerReportingContext
	}
	return nil
}

func (x *ProductView_ItemIssue_ItemIssueSeverity) GetAggregatedSeverity() ProductView_ItemIssue_ItemIssueSeverity_AggregatedIssueSeverity {
	if x != nil && x.AggregatedSeverity != nil {
		return *x.AggregatedSeverity
	}
	return ProductView_ItemIssue_ItemIssueSeverity_AGGREGATED_ISSUE_SEVERITY_UNSPECIFIED
}

// Issue severity per reporting context.
type ProductView_ItemIssue_ItemIssueSeverity_IssueSeverityPerReportingContext struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Reporting context the issue applies to.
	ReportingContext *typepb.ReportingContext_ReportingContextEnum `protobuf:"varint,1,opt,name=reporting_context,json=reportingContext,proto3,enum=google.shopping.type.ReportingContext_ReportingContextEnum,oneof" json:"reporting_context,omitempty"`
	// List of disapproved countries in the reporting context, represented
	// in ISO 3166 format.
	DisapprovedCountries []string `protobuf:"bytes,2,rep,name=disapproved_countries,json=disapprovedCountries,proto3" json:"disapproved_countries,omitempty"`
	// List of demoted countries in the reporting context, represented in
	// ISO 3166 format.
	DemotedCountries []string `protobuf:"bytes,3,rep,name=demoted_countries,json=demotedCountries,proto3" json:"demoted_countries,omitempty"`
}

func (x *ProductView_ItemIssue_ItemIssueSeverity_IssueSeverityPerReportingContext) Reset() {
	*x = ProductView_ItemIssue_ItemIssueSeverity_IssueSeverityPerReportingContext{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProductView_ItemIssue_ItemIssueSeverity_IssueSeverityPerReportingContext) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProductView_ItemIssue_ItemIssueSeverity_IssueSeverityPerReportingContext) ProtoMessage() {}

func (x *ProductView_ItemIssue_ItemIssueSeverity_IssueSeverityPerReportingContext) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProductView_ItemIssue_ItemIssueSeverity_IssueSeverityPerReportingContext.ProtoReflect.Descriptor instead.
func (*ProductView_ItemIssue_ItemIssueSeverity_IssueSeverityPerReportingContext) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_reports_v1beta_reports_proto_rawDescGZIP(), []int{4, 0, 1, 0}
}

func (x *ProductView_ItemIssue_ItemIssueSeverity_IssueSeverityPerReportingContext) GetReportingContext() typepb.ReportingContext_ReportingContextEnum {
	if x != nil && x.ReportingContext != nil {
		return *x.ReportingContext
	}
	return typepb.ReportingContext_ReportingContextEnum(0)
}

func (x *ProductView_ItemIssue_ItemIssueSeverity_IssueSeverityPerReportingContext) GetDisapprovedCountries() []string {
	if x != nil {
		return x.DisapprovedCountries
	}
	return nil
}

func (x *ProductView_ItemIssue_ItemIssueSeverity_IssueSeverityPerReportingContext) GetDemotedCountries() []string {
	if x != nil {
		return x.DemotedCountries
	}
	return nil
}

var File_google_shopping_merchant_reports_v1beta_reports_proto protoreflect.FileDescriptor

var file_google_shopping_merchant_reports_v1beta_reports_proto_rawDesc = []byte{
	0x0a, 0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x2f, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x72,
	0x74, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x27, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e,
	0x74, 0x2e, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69,
	0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f,
	0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x16, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0x8d, 0x01, 0x0a, 0x0d, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x19, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12, 0x20, 0x0a,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0x86, 0x01, 0x0a, 0x0e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4c, 0x0a, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61,
	0x6e, 0x74, 0x2e, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x6f, 0x77, 0x52, 0x07, 0x72, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e,
	0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xf6, 0x0a, 0x0a,
	0x09, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x6f, 0x77, 0x12, 0x79, 0x0a, 0x18, 0x70, 0x72,
	0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x70, 0x65, 0x72, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63,
	0x65, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d,
	0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x50, 0x65,
	0x72, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x56, 0x69, 0x65, 0x77, 0x52, 0x16, 0x70,
	0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x50, 0x65, 0x72, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63,
	0x65, 0x56, 0x69, 0x65, 0x77, 0x12, 0x83, 0x01, 0x0a, 0x1c, 0x6e, 0x6f, 0x6e, 0x5f, 0x70, 0x72,
	0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x70, 0x65, 0x72, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63,
	0x65, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d,
	0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4e, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x74, 0x50, 0x65, 0x72, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x56, 0x69, 0x65, 0x77,
	0x52, 0x19, 0x6e, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x50, 0x65, 0x72, 0x66,
	0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x56, 0x69, 0x65, 0x77, 0x12, 0x57, 0x0a, 0x0c, 0x70,
	0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70,
	0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x72, 0x65, 0x70,
	0x6f, 0x72, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x56, 0x69, 0x65, 0x77, 0x52, 0x0b, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74,
	0x56, 0x69, 0x65, 0x77, 0x12, 0x95, 0x01, 0x0a, 0x22, 0x70, 0x72, 0x69, 0x63, 0x65, 0x5f, 0x63,
	0x6f, 0x6d, 0x70, 0x65, 0x74, 0x69, 0x74, 0x69, 0x76, 0x65, 0x6e, 0x65, 0x73, 0x73, 0x5f, 0x70,
	0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70,
	0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x72, 0x65, 0x70,
	0x6f, 0x72, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x72, 0x69, 0x63,
	0x65, 0x43, 0x6f, 0x6d, 0x70, 0x65, 0x74, 0x69, 0x74, 0x69, 0x76, 0x65, 0x6e, 0x65, 0x73, 0x73,
	0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x56, 0x69, 0x65, 0x77, 0x52, 0x1f, 0x70, 0x72, 0x69,
	0x63, 0x65, 0x43, 0x6f, 0x6d, 0x70, 0x65, 0x74, 0x69, 0x74, 0x69, 0x76, 0x65, 0x6e, 0x65, 0x73,
	0x73, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x56, 0x69, 0x65, 0x77, 0x12, 0x80, 0x01, 0x0a,
	0x1b, 0x70, 0x72, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x5f,
	0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x72, 0x65,
	0x70, 0x6f, 0x72, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x72, 0x69,
	0x63, 0x65, 0x49, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x74, 0x56, 0x69, 0x65, 0x77, 0x52, 0x18, 0x70, 0x72, 0x69, 0x63, 0x65, 0x49, 0x6e, 0x73, 0x69,
	0x67, 0x68, 0x74, 0x73, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x56, 0x69, 0x65, 0x77, 0x12,
	0x90, 0x01, 0x0a, 0x21, 0x62, 0x65, 0x73, 0x74, 0x5f, 0x73, 0x65, 0x6c, 0x6c, 0x65, 0x72, 0x73,
	0x5f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x5f, 0x76, 0x69, 0x65, 0x77, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65,
	0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x42, 0x65, 0x73, 0x74, 0x53, 0x65, 0x6c, 0x6c, 0x65, 0x72,
	0x73, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x56,
	0x69, 0x65, 0x77, 0x52, 0x1d, 0x62, 0x65, 0x73, 0x74, 0x53, 0x65, 0x6c, 0x6c, 0x65, 0x72, 0x73,
	0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x56, 0x69,
	0x65, 0x77, 0x12, 0x74, 0x0a, 0x17, 0x62, 0x65, 0x73, 0x74, 0x5f, 0x73, 0x65, 0x6c, 0x6c, 0x65,
	0x72, 0x73, 0x5f, 0x62, 0x72, 0x61, 0x6e, 0x64, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f,
	0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x72,
	0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x42, 0x65,
	0x73, 0x74, 0x53, 0x65, 0x6c, 0x6c, 0x65, 0x72, 0x73, 0x42, 0x72, 0x61, 0x6e, 0x64, 0x56, 0x69,
	0x65, 0x77, 0x52, 0x14, 0x62, 0x65, 0x73, 0x74, 0x53, 0x65, 0x6c, 0x6c, 0x65, 0x72, 0x73, 0x42,
	0x72, 0x61, 0x6e, 0x64, 0x56, 0x69, 0x65, 0x77, 0x12, 0xa1, 0x01, 0x0a, 0x26, 0x63, 0x6f, 0x6d,
	0x70, 0x65, 0x74, 0x69, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x76, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6c,
	0x69, 0x74, 0x79, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x65, 0x74, 0x69, 0x74, 0x6f, 0x72, 0x5f, 0x76,
	0x69, 0x65, 0x77, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63,
	0x68, 0x61, 0x6e, 0x74, 0x2e, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x65, 0x74, 0x69, 0x74, 0x69, 0x76, 0x65, 0x56,
	0x69, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d, 0x70, 0x65, 0x74, 0x69,
	0x74, 0x6f, 0x72, 0x56, 0x69, 0x65, 0x77, 0x52, 0x23, 0x63, 0x6f, 0x6d, 0x70, 0x65, 0x74, 0x69,
	0x74, 0x69, 0x76, 0x65, 0x56, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x43, 0x6f,
	0x6d, 0x70, 0x65, 0x74, 0x69, 0x74, 0x6f, 0x72, 0x56, 0x69, 0x65, 0x77, 0x12, 0xa5, 0x01, 0x0a,
	0x28, 0x63, 0x6f, 0x6d, 0x70, 0x65, 0x74, 0x69, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x76, 0x69, 0x73,
	0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x74, 0x6f, 0x70, 0x5f, 0x6d, 0x65, 0x72, 0x63,
	0x68, 0x61, 0x6e, 0x74, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x72, 0x65, 0x70, 0x6f, 0x72,
	0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x65, 0x74,
	0x69, 0x74, 0x69, 0x76, 0x65, 0x56, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x54,
	0x6f, 0x70, 0x4d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x56, 0x69, 0x65, 0x77, 0x52, 0x24,
	0x63, 0x6f, 0x6d, 0x70, 0x65, 0x74, 0x69, 0x74, 0x69, 0x76, 0x65, 0x56, 0x69, 0x73, 0x69, 0x62,
	0x69, 0x6c, 0x69, 0x74, 0x79, 0x54, 0x6f, 0x70, 0x4d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74,
	0x56, 0x69, 0x65, 0x77, 0x12, 0x9e, 0x01, 0x0a, 0x25, 0x63, 0x6f, 0x6d, 0x70, 0x65, 0x74, 0x69,
	0x74, 0x69, 0x76, 0x65, 0x5f, 0x76, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x5f,
	0x62, 0x65, 0x6e, 0x63, 0x68, 0x6d, 0x61, 0x72, 0x6b, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x4b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68,
	0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e,
	0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43,
	0x6f, 0x6d, 0x70, 0x65, 0x74, 0x69, 0x74, 0x69, 0x76, 0x65, 0x56, 0x69, 0x73, 0x69, 0x62, 0x69,
	0x6c, 0x69, 0x74, 0x79, 0x42, 0x65, 0x6e, 0x63, 0x68, 0x6d, 0x61, 0x72, 0x6b, 0x56, 0x69, 0x65,
	0x77, 0x52, 0x22, 0x63, 0x6f, 0x6d, 0x70, 0x65, 0x74, 0x69, 0x74, 0x69, 0x76, 0x65, 0x56, 0x69,
	0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x42, 0x65, 0x6e, 0x63, 0x68, 0x6d, 0x61, 0x72,
	0x6b, 0x56, 0x69, 0x65, 0x77, 0x22, 0xac, 0x0d, 0x0a, 0x16, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x74, 0x50, 0x65, 0x72, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x56, 0x69, 0x65, 0x77,
	0x12, 0x7c, 0x0a, 0x10, 0x6d, 0x61, 0x72, 0x6b, 0x65, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x6d, 0x65,
	0x74, 0x68, 0x6f, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72,
	0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x4d, 0x61, 0x72, 0x6b, 0x65, 0x74, 0x69, 0x6e, 0x67, 0x4d, 0x65,
	0x74, 0x68, 0x6f, 0x64, 0x2e, 0x4d, 0x61, 0x72, 0x6b, 0x65, 0x74, 0x69, 0x6e, 0x67, 0x4d, 0x65,
	0x74, 0x68, 0x6f, 0x64, 0x45, 0x6e, 0x75, 0x6d, 0x48, 0x00, 0x52, 0x0f, 0x6d, 0x61, 0x72, 0x6b,
	0x65, 0x74, 0x69, 0x6e, 0x67, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x88, 0x01, 0x01, 0x12, 0x25,
	0x0a, 0x04, 0x64, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x52,
	0x04, 0x64, 0x61, 0x74, 0x65, 0x12, 0x25, 0x0a, 0x04, 0x77, 0x65, 0x65, 0x6b, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70,
	0x65, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x52, 0x04, 0x77, 0x65, 0x65, 0x6b, 0x12, 0x37, 0x0a, 0x15,
	0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79,
	0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x48, 0x01, 0x52, 0x13, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79, 0x43, 0x6f,
	0x64, 0x65, 0x88, 0x01, 0x01, 0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x66, 0x66, 0x65, 0x72, 0x5f, 0x69,
	0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x48, 0x02, 0x52, 0x07, 0x6f, 0x66, 0x66, 0x65, 0x72,
	0x49, 0x64, 0x88, 0x01, 0x01, 0x12, 0x19, 0x0a, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x09, 0x48, 0x03, 0x52, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x88, 0x01, 0x01,
	0x12, 0x19, 0x0a, 0x05, 0x62, 0x72, 0x61, 0x6e, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x48,
	0x04, 0x52, 0x05, 0x62, 0x72, 0x61, 0x6e, 0x64, 0x88, 0x01, 0x01, 0x12, 0x24, 0x0a, 0x0b, 0x63,
	0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x5f, 0x6c, 0x31, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09,
	0x48, 0x05, 0x52, 0x0a, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x4c, 0x31, 0x88, 0x01,
	0x01, 0x12, 0x24, 0x0a, 0x0b, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x5f, 0x6c, 0x32,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x48, 0x06, 0x52, 0x0a, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f,
	0x72, 0x79, 0x4c, 0x32, 0x88, 0x01, 0x01, 0x12, 0x24, 0x0a, 0x0b, 0x63, 0x61, 0x74, 0x65, 0x67,
	0x6f, 0x72, 0x79, 0x5f, 0x6c, 0x33, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x48, 0x07, 0x52, 0x0a,
	0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x4c, 0x33, 0x88, 0x01, 0x01, 0x12, 0x24, 0x0a,
	0x0b, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x5f, 0x6c, 0x34, 0x18, 0x0b, 0x20, 0x01,
	0x28, 0x09, 0x48, 0x08, 0x52, 0x0a, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x4c, 0x34,
	0x88, 0x01, 0x01, 0x12, 0x24, 0x0a, 0x0b, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x5f,
	0x6c, 0x35, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x48, 0x09, 0x52, 0x0a, 0x63, 0x61, 0x74, 0x65,
	0x67, 0x6f, 0x72, 0x79, 0x4c, 0x35, 0x88, 0x01, 0x01, 0x12, 0x2b, 0x0a, 0x0f, 0x70, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x6c, 0x31, 0x18, 0x0d, 0x20, 0x01,
	0x28, 0x09, 0x48, 0x0a, 0x52, 0x0d, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x54, 0x79, 0x70,
	0x65, 0x4c, 0x31, 0x88, 0x01, 0x01, 0x12, 0x2b, 0x0a, 0x0f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x6c, 0x32, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x48,
	0x0b, 0x52, 0x0d, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x4c, 0x32,
	0x88, 0x01, 0x01, 0x12, 0x2b, 0x0a, 0x0f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x5f, 0x6c, 0x33, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x09, 0x48, 0x0c, 0x52, 0x0d,
	0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x4c, 0x33, 0x88, 0x01, 0x01,
	0x12, 0x2b, 0x0a, 0x0f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x5f, 0x6c, 0x34, 0x18, 0x10, 0x20, 0x01, 0x28, 0x09, 0x48, 0x0d, 0x52, 0x0d, 0x70, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x4c, 0x34, 0x88, 0x01, 0x01, 0x12, 0x2b, 0x0a,
	0x0f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x6c, 0x35,
	0x18, 0x11, 0x20, 0x01, 0x28, 0x09, 0x48, 0x0e, 0x52, 0x0d, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x74, 0x54, 0x79, 0x70, 0x65, 0x4c, 0x35, 0x88, 0x01, 0x01, 0x12, 0x28, 0x0a, 0x0d, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x30, 0x18, 0x12, 0x20, 0x01, 0x28,
	0x09, 0x48, 0x0f, 0x52, 0x0c, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x30, 0x88, 0x01, 0x01, 0x12, 0x28, 0x0a, 0x0d, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x31, 0x18, 0x13, 0x20, 0x01, 0x28, 0x09, 0x48, 0x10, 0x52, 0x0c, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x31, 0x88, 0x01, 0x01, 0x12, 0x28,
	0x0a, 0x0d, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x32, 0x18,
	0x14, 0x20, 0x01, 0x28, 0x09, 0x48, 0x11, 0x52, 0x0c, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x32, 0x88, 0x01, 0x01, 0x12, 0x28, 0x0a, 0x0d, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x33, 0x18, 0x15, 0x20, 0x01, 0x28, 0x09, 0x48,
	0x12, 0x52, 0x0c, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x33, 0x88,
	0x01, 0x01, 0x12, 0x28, 0x0a, 0x0d, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x34, 0x18, 0x16, 0x20, 0x01, 0x28, 0x09, 0x48, 0x13, 0x52, 0x0c, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x34, 0x88, 0x01, 0x01, 0x12, 0x1b, 0x0a, 0x06,
	0x63, 0x6c, 0x69, 0x63, 0x6b, 0x73, 0x18, 0x17, 0x20, 0x01, 0x28, 0x03, 0x48, 0x14, 0x52, 0x06,
	0x63, 0x6c, 0x69, 0x63, 0x6b, 0x73, 0x88, 0x01, 0x01, 0x12, 0x25, 0x0a, 0x0b, 0x69, 0x6d, 0x70,
	0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x18, 0x20, 0x01, 0x28, 0x03, 0x48, 0x15,
	0x52, 0x0b, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x88, 0x01, 0x01,
	0x12, 0x31, 0x0a, 0x12, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x5f, 0x74, 0x68, 0x72, 0x6f, 0x75, 0x67,
	0x68, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x18, 0x19, 0x20, 0x01, 0x28, 0x01, 0x48, 0x16, 0x52, 0x10,
	0x63, 0x6c, 0x69, 0x63, 0x6b, 0x54, 0x68, 0x72, 0x6f, 0x75, 0x67, 0x68, 0x52, 0x61, 0x74, 0x65,
	0x88, 0x01, 0x01, 0x12, 0x25, 0x0a, 0x0b, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x1a, 0x20, 0x01, 0x28, 0x01, 0x48, 0x17, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x88, 0x01, 0x01, 0x12, 0x46, 0x0a, 0x10, 0x63, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x1b,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68,
	0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x50, 0x72, 0x69, 0x63,
	0x65, 0x52, 0x0f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x12, 0x2c, 0x0a, 0x0f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x5f, 0x72, 0x61, 0x74, 0x65, 0x18, 0x1c, 0x20, 0x01, 0x28, 0x01, 0x48, 0x18, 0x52, 0x0e, 0x63,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x61, 0x74, 0x65, 0x88, 0x01, 0x01,
	0x42, 0x13, 0x0a, 0x11, 0x5f, 0x6d, 0x61, 0x72, 0x6b, 0x65, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x6d,
	0x65, 0x74, 0x68, 0x6f, 0x64, 0x42, 0x18, 0x0a, 0x16, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x65, 0x72, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x42,
	0x0b, 0x0a, 0x09, 0x5f, 0x6f, 0x66, 0x66, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x42, 0x08, 0x0a, 0x06,
	0x5f, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x62, 0x72, 0x61, 0x6e, 0x64,
	0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x5f, 0x6c, 0x31,
	0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x5f, 0x6c, 0x32,
	0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x5f, 0x6c, 0x33,
	0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x5f, 0x6c, 0x34,
	0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x5f, 0x6c, 0x35,
	0x42, 0x12, 0x0a, 0x10, 0x5f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x5f, 0x6c, 0x31, 0x42, 0x12, 0x0a, 0x10, 0x5f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x6c, 0x32, 0x42, 0x12, 0x0a, 0x10, 0x5f, 0x70, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x6c, 0x33, 0x42, 0x12, 0x0a, 0x10,
	0x5f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x6c, 0x34,
	0x42, 0x12, 0x0a, 0x10, 0x5f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x5f, 0x6c, 0x35, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x30, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x31, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x32, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x33, 0x42, 0x10, 0x0a, 0x0e,
	0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x34, 0x42, 0x09,
	0x0a, 0x07, 0x5f, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x73, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x69, 0x6d,
	0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x15, 0x0a, 0x13, 0x5f, 0x63, 0x6c,
	0x69, 0x63, 0x6b, 0x5f, 0x74, 0x68, 0x72, 0x6f, 0x75, 0x67, 0x68, 0x5f, 0x72, 0x61, 0x74, 0x65,
	0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x42, 0x12, 0x0a, 0x10, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f,
	0x72, 0x61, 0x74, 0x65, 0x22, 0xe8, 0x1b, 0x0a, 0x0b, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74,
	0x56, 0x69, 0x65, 0x77, 0x12, 0x13, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x48, 0x00, 0x52, 0x02, 0x69, 0x64, 0x88, 0x01, 0x01, 0x12, 0x48, 0x0a, 0x07, 0x63, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x18, 0x1c, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x74, 0x79, 0x70,
	0x65, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x45, 0x6e, 0x75, 0x6d, 0x48, 0x01, 0x52, 0x07, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x88, 0x01, 0x01, 0x12, 0x28, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f,
	0x63, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x02, 0x52, 0x0c, 0x6c, 0x61,
	0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x88, 0x01, 0x01, 0x12, 0x22, 0x0a,
	0x0a, 0x66, 0x65, 0x65, 0x64, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x48, 0x03, 0x52, 0x09, 0x66, 0x65, 0x65, 0x64, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x88, 0x01,
	0x01, 0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x66, 0x66, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x48, 0x04, 0x52, 0x07, 0x6f, 0x66, 0x66, 0x65, 0x72, 0x49, 0x64, 0x88, 0x01,
	0x01, 0x12, 0x19, 0x0a, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x48, 0x05, 0x52, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x88, 0x01, 0x01, 0x12, 0x19, 0x0a, 0x05,
	0x62, 0x72, 0x61, 0x6e, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x48, 0x06, 0x52, 0x05, 0x62,
	0x72, 0x61, 0x6e, 0x64, 0x88, 0x01, 0x01, 0x12, 0x24, 0x0a, 0x0b, 0x63, 0x61, 0x74, 0x65, 0x67,
	0x6f, 0x72, 0x79, 0x5f, 0x6c, 0x31, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x48, 0x07, 0x52, 0x0a,
	0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x4c, 0x31, 0x88, 0x01, 0x01, 0x12, 0x24, 0x0a,
	0x0b, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x5f, 0x6c, 0x32, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x09, 0x48, 0x08, 0x52, 0x0a, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x4c, 0x32,
	0x88, 0x01, 0x01, 0x12, 0x24, 0x0a, 0x0b, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x5f,
	0x6c, 0x33, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x48, 0x09, 0x52, 0x0a, 0x63, 0x61, 0x74, 0x65,
	0x67, 0x6f, 0x72, 0x79, 0x4c, 0x33, 0x88, 0x01, 0x01, 0x12, 0x24, 0x0a, 0x0b, 0x63, 0x61, 0x74,
	0x65, 0x67, 0x6f, 0x72, 0x79, 0x5f, 0x6c, 0x34, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x48, 0x0a,
	0x52, 0x0a, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x4c, 0x34, 0x88, 0x01, 0x01, 0x12,
	0x24, 0x0a, 0x0b, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x5f, 0x6c, 0x35, 0x18, 0x0b,
	0x20, 0x01, 0x28, 0x09, 0x48, 0x0b, 0x52, 0x0a, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79,
	0x4c, 0x35, 0x88, 0x01, 0x01, 0x12, 0x2b, 0x0a, 0x0f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x6c, 0x31, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x48, 0x0c,
	0x52, 0x0d, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x4c, 0x31, 0x88,
	0x01, 0x01, 0x12, 0x2b, 0x0a, 0x0f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x5f, 0x6c, 0x32, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x48, 0x0d, 0x52, 0x0d, 0x70,
	0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x4c, 0x32, 0x88, 0x01, 0x01, 0x12,
	0x2b, 0x0a, 0x0f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f,
	0x6c, 0x33, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x48, 0x0e, 0x52, 0x0d, 0x70, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x4c, 0x33, 0x88, 0x01, 0x01, 0x12, 0x2b, 0x0a, 0x0f,
	0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x6c, 0x34, 0x18,
	0x0f, 0x20, 0x01, 0x28, 0x09, 0x48, 0x0f, 0x52, 0x0d, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74,
	0x54, 0x79, 0x70, 0x65, 0x4c, 0x34, 0x88, 0x01, 0x01, 0x12, 0x2b, 0x0a, 0x0f, 0x70, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x6c, 0x35, 0x18, 0x10, 0x20, 0x01,
	0x28, 0x09, 0x48, 0x10, 0x52, 0x0d, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x54, 0x79, 0x70,
	0x65, 0x4c, 0x35, 0x88, 0x01, 0x01, 0x12, 0x31, 0x0a, 0x05, 0x70, 0x72, 0x69, 0x63, 0x65, 0x18,
	0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x50, 0x72, 0x69,
	0x63, 0x65, 0x52, 0x05, 0x70, 0x72, 0x69, 0x63, 0x65, 0x12, 0x21, 0x0a, 0x09, 0x63, 0x6f, 0x6e,
	0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x12, 0x20, 0x01, 0x28, 0x09, 0x48, 0x11, 0x52, 0x09,
	0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x27, 0x0a, 0x0c,
	0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x13, 0x20, 0x01,
	0x28, 0x09, 0x48, 0x12, 0x52, 0x0c, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x69, 0x6c, 0x69,
	0x74, 0x79, 0x88, 0x01, 0x01, 0x12, 0x2a, 0x0a, 0x0e, 0x73, 0x68, 0x69, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x14, 0x20, 0x01, 0x28, 0x09, 0x48, 0x13, 0x52,
	0x0d, 0x73, 0x68, 0x69, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x88, 0x01,
	0x01, 0x12, 0x12, 0x0a, 0x04, 0x67, 0x74, 0x69, 0x6e, 0x18, 0x15, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x04, 0x67, 0x74, 0x69, 0x6e, 0x12, 0x27, 0x0a, 0x0d, 0x69, 0x74, 0x65, 0x6d, 0x5f, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x5f, 0x69, 0x64, 0x18, 0x16, 0x20, 0x01, 0x28, 0x09, 0x48, 0x14, 0x52, 0x0b,
	0x69, 0x74, 0x65, 0x6d, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x64, 0x88, 0x01, 0x01, 0x12, 0x2a,
	0x0a, 0x0e, 0x74, 0x68, 0x75, 0x6d, 0x62, 0x6e, 0x61, 0x69, 0x6c, 0x5f, 0x6c, 0x69, 0x6e, 0x6b,
	0x18, 0x17, 0x20, 0x01, 0x28, 0x09, 0x48, 0x15, 0x52, 0x0d, 0x74, 0x68, 0x75, 0x6d, 0x62, 0x6e,
	0x61, 0x69, 0x6c, 0x4c, 0x69, 0x6e, 0x6b, 0x88, 0x01, 0x01, 0x12, 0x3f, 0x0a, 0x0d, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x18, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0c, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x0f, 0x65,
	0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0x19,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79,
	0x70, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x52, 0x0e, 0x65, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x65, 0x12, 0xa9, 0x01, 0x0a, 0x23, 0x61, 0x67, 0x67, 0x72,
	0x65, 0x67, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67,
	0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18,
	0x1a, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x55, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74,
	0x2e, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x56, 0x69, 0x65, 0x77, 0x2e, 0x41, 0x67, 0x67, 0x72,
	0x65, 0x67, 0x61, 0x74, 0x65, 0x64, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x43,
	0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x48, 0x16, 0x52, 0x20,
	0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x65, 0x64, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74,
	0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x88, 0x01, 0x01, 0x12, 0x5f, 0x0a, 0x0b, 0x69, 0x74, 0x65, 0x6d, 0x5f, 0x69, 0x73, 0x73, 0x75,
	0x65, 0x73, 0x18, 0x1b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68,
	0x61, 0x6e, 0x74, 0x2e, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x56, 0x69, 0x65, 0x77, 0x2e, 0x49,
	0x74, 0x65, 0x6d, 0x49, 0x73, 0x73, 0x75, 0x65, 0x52, 0x0a, 0x69, 0x74, 0x65, 0x6d, 0x49, 0x73,
	0x73, 0x75, 0x65, 0x73, 0x12, 0x6c, 0x0a, 0x0f, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x5f, 0x70, 0x6f,
	0x74, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x18, 0x1d, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x43, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e,
	0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x56,
	0x69, 0x65, 0x77, 0x2e, 0x43, 0x6c, 0x69, 0x63, 0x6b, 0x50, 0x6f, 0x74, 0x65, 0x6e, 0x74, 0x69,
	0x61, 0x6c, 0x52, 0x0e, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x50, 0x6f, 0x74, 0x65, 0x6e, 0x74, 0x69,
	0x61, 0x6c, 0x12, 0x35, 0x0a, 0x14, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x5f, 0x70, 0x6f, 0x74, 0x65,
	0x6e, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x72, 0x61, 0x6e, 0x6b, 0x18, 0x1e, 0x20, 0x01, 0x28, 0x03,
	0x48, 0x17, 0x52, 0x12, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x50, 0x6f, 0x74, 0x65, 0x6e, 0x74, 0x69,
	0x61, 0x6c, 0x52, 0x61, 0x6e, 0x6b, 0x88, 0x01, 0x01, 0x1a, 0xd4, 0x0a, 0x0a, 0x09, 0x49, 0x74,
	0x65, 0x6d, 0x49, 0x73, 0x73, 0x75, 0x65, 0x12, 0x60, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74,
	0x2e, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x56, 0x69, 0x65, 0x77, 0x2e, 0x49, 0x74, 0x65, 0x6d,
	0x49, 0x73, 0x73, 0x75, 0x65, 0x2e, 0x49, 0x74, 0x65, 0x6d, 0x49, 0x73, 0x73, 0x75, 0x65, 0x54,
	0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x6c, 0x0a, 0x08, 0x73, 0x65, 0x76,
	0x65, 0x72, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x50, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65,
	0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x56, 0x69, 0x65,
	0x77, 0x2e, 0x49, 0x74, 0x65, 0x6d, 0x49, 0x73, 0x73, 0x75, 0x65, 0x2e, 0x49, 0x74, 0x65, 0x6d,
	0x49, 0x73, 0x73, 0x75, 0x65, 0x53, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x52, 0x08, 0x73,
	0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x12, 0x77, 0x0a, 0x0a, 0x72, 0x65, 0x73, 0x6f, 0x6c,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x52, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65,
	0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x56, 0x69, 0x65,
	0x77, 0x2e, 0x49, 0x74, 0x65, 0x6d, 0x49, 0x73, 0x73, 0x75, 0x65, 0x2e, 0x49, 0x74, 0x65, 0x6d,
	0x49, 0x73, 0x73, 0x75, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x48,
	0x00, 0x52, 0x0a, 0x72, 0x65, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01,
	0x1a, 0x7f, 0x0a, 0x0d, 0x49, 0x74, 0x65, 0x6d, 0x49, 0x73, 0x73, 0x75, 0x65, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x17, 0x0a, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48,
	0x00, 0x52, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x88, 0x01, 0x01, 0x12, 0x34, 0x0a, 0x13, 0x63, 0x61,
	0x6e, 0x6f, 0x6e, 0x69, 0x63, 0x61, 0x6c, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x01, 0x52, 0x12, 0x63, 0x61, 0x6e, 0x6f, 0x6e,
	0x69, 0x63, 0x61, 0x6c, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x88, 0x01, 0x01,
	0x42, 0x07, 0x0a, 0x05, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x42, 0x16, 0x0a, 0x14, 0x5f, 0x63, 0x61,
	0x6e, 0x6f, 0x6e, 0x69, 0x63, 0x61, 0x6c, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x65, 0x1a, 0x82, 0x06, 0x0a, 0x11, 0x49, 0x74, 0x65, 0x6d, 0x49, 0x73, 0x73, 0x75, 0x65, 0x53,
	0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x12, 0xb6, 0x01, 0x0a, 0x1e, 0x73, 0x65, 0x76, 0x65,
	0x72, 0x69, 0x74, 0x79, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x69,
	0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x71, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69,
	0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x72, 0x65, 0x70, 0x6f,
	0x72, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75,
	0x63, 0x74, 0x56, 0x69, 0x65, 0x77, 0x2e, 0x49, 0x74, 0x65, 0x6d, 0x49, 0x73, 0x73, 0x75, 0x65,
	0x2e, 0x49, 0x74, 0x65, 0x6d, 0x49, 0x73, 0x73, 0x75, 0x65, 0x53, 0x65, 0x76, 0x65, 0x72, 0x69,
	0x74, 0x79, 0x2e, 0x49, 0x73, 0x73, 0x75, 0x65, 0x53, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79,
	0x50, 0x65, 0x72, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x74,
	0x65, 0x78, 0x74, 0x52, 0x1b, 0x73, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x50, 0x65, 0x72,
	0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74,
	0x12, 0x9e, 0x01, 0x0a, 0x13, 0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x65, 0x64, 0x5f,
	0x73, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x68,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67,
	0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74,
	0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74,
	0x56, 0x69, 0x65, 0x77, 0x2e, 0x49, 0x74, 0x65, 0x6d, 0x49, 0x73, 0x73, 0x75, 0x65, 0x2e, 0x49,
	0x74, 0x65, 0x6d, 0x49, 0x73, 0x73, 0x75, 0x65, 0x53, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79,
	0x2e, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x65, 0x64, 0x49, 0x73, 0x73, 0x75, 0x65,
	0x53, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x48, 0x00, 0x52, 0x12, 0x61, 0x67, 0x67, 0x72,
	0x65, 0x67, 0x61, 0x74, 0x65, 0x64, 0x53, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x88, 0x01,
	0x01, 0x1a, 0x89, 0x02, 0x0a, 0x20, 0x49, 0x73, 0x73, 0x75, 0x65, 0x53, 0x65, 0x76, 0x65, 0x72,
	0x69, 0x74, 0x79, 0x50, 0x65, 0x72, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x43,
	0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x6d, 0x0a, 0x11, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74,
	0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70,
	0x69, 0x6e, 0x67, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x69,
	0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74,
	0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x45, 0x6e, 0x75, 0x6d, 0x48, 0x00,
	0x52, 0x10, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x74, 0x65,
	0x78, 0x74, 0x88, 0x01, 0x01, 0x12, 0x33, 0x0a, 0x15, 0x64, 0x69, 0x73, 0x61, 0x70, 0x70, 0x72,
	0x6f, 0x76, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x14, 0x64, 0x69, 0x73, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65,
	0x64, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x12, 0x2b, 0x0a, 0x11, 0x64, 0x65,
	0x6d, 0x6f, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x10, 0x64, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x64, 0x43, 0x6f,
	0x75, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x42, 0x14, 0x0a, 0x12, 0x5f, 0x72, 0x65, 0x70, 0x6f,
	0x72, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x22, 0x6f, 0x0a,
	0x17, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x65, 0x64, 0x49, 0x73, 0x73, 0x75, 0x65,
	0x53, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x12, 0x29, 0x0a, 0x25, 0x41, 0x47, 0x47, 0x52,
	0x45, 0x47, 0x41, 0x54, 0x45, 0x44, 0x5f, 0x49, 0x53, 0x53, 0x55, 0x45, 0x5f, 0x53, 0x45, 0x56,
	0x45, 0x52, 0x49, 0x54, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x44, 0x49, 0x53, 0x41, 0x50, 0x50, 0x52, 0x4f, 0x56,
	0x45, 0x44, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x45, 0x4d, 0x4f, 0x54, 0x45, 0x44, 0x10,
	0x02, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x42, 0x16,
	0x0a, 0x14, 0x5f, 0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x73, 0x65,
	0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x22, 0x69, 0x0a, 0x13, 0x49, 0x74, 0x65, 0x6d, 0x49, 0x73,
	0x73, 0x75, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x25, 0x0a,
	0x21, 0x49, 0x54, 0x45, 0x4d, 0x5f, 0x49, 0x53, 0x53, 0x55, 0x45, 0x5f, 0x52, 0x45, 0x53, 0x4f,
	0x4c, 0x55, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x13, 0x0a, 0x0f, 0x4d, 0x45, 0x52, 0x43, 0x48, 0x41, 0x4e, 0x54,
	0x5f, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x01, 0x12, 0x16, 0x0a, 0x12, 0x50, 0x45, 0x4e,
	0x44, 0x49, 0x4e, 0x47, 0x5f, 0x50, 0x52, 0x4f, 0x43, 0x45, 0x53, 0x53, 0x49, 0x4e, 0x47, 0x10,
	0x02, 0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0xa9, 0x01, 0x0a, 0x20, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x65, 0x64, 0x52,
	0x65, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x33, 0x0a, 0x2f, 0x41, 0x47, 0x47, 0x52, 0x45, 0x47, 0x41,
	0x54, 0x45, 0x44, 0x5f, 0x52, 0x45, 0x50, 0x4f, 0x52, 0x54, 0x49, 0x4e, 0x47, 0x5f, 0x43, 0x4f,
	0x4e, 0x54, 0x45, 0x58, 0x54, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1f, 0x0a, 0x1b, 0x4e, 0x4f,
	0x54, 0x5f, 0x45, 0x4c, 0x49, 0x47, 0x49, 0x42, 0x4c, 0x45, 0x5f, 0x4f, 0x52, 0x5f, 0x44, 0x49,
	0x53, 0x41, 0x50, 0x50, 0x52, 0x4f, 0x56, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x50,
	0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x14, 0x0a, 0x10, 0x45, 0x4c, 0x49, 0x47,
	0x49, 0x42, 0x4c, 0x45, 0x5f, 0x4c, 0x49, 0x4d, 0x49, 0x54, 0x45, 0x44, 0x10, 0x03, 0x12, 0x0c,
	0x0a, 0x08, 0x45, 0x4c, 0x49, 0x47, 0x49, 0x42, 0x4c, 0x45, 0x10, 0x04, 0x22, 0x50, 0x0a, 0x0e,
	0x43, 0x6c, 0x69, 0x63, 0x6b, 0x50, 0x6f, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x12, 0x1f,
	0x0a, 0x1b, 0x43, 0x4c, 0x49, 0x43, 0x4b, 0x5f, 0x50, 0x4f, 0x54, 0x45, 0x4e, 0x54, 0x49, 0x41,
	0x4c, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x07, 0x0a, 0x03, 0x4c, 0x4f, 0x57, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x4d, 0x45, 0x44, 0x49,
	0x55, 0x4d, 0x10, 0x02, 0x12, 0x08, 0x0a, 0x04, 0x48, 0x49, 0x47, 0x48, 0x10, 0x03, 0x42, 0x05,
	0x0a, 0x03, 0x5f, 0x69, 0x64, 0x42, 0x0a, 0x0a, 0x08, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63,
	0x6f, 0x64, 0x65, 0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x66, 0x65, 0x65, 0x64, 0x5f, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x42, 0x0b, 0x0a, 0x09, 0x5f, 0x6f, 0x66, 0x66, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x42,
	0x08, 0x0a, 0x06, 0x5f, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x62, 0x72,
	0x61, 0x6e, 0x64, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79,
	0x5f, 0x6c, 0x31, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79,
	0x5f, 0x6c, 0x32, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79,
	0x5f, 0x6c, 0x33, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79,
	0x5f, 0x6c, 0x34, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79,
	0x5f, 0x6c, 0x35, 0x42, 0x12, 0x0a, 0x10, 0x5f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x5f, 0x6c, 0x31, 0x42, 0x12, 0x0a, 0x10, 0x5f, 0x70, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x6c, 0x32, 0x42, 0x12, 0x0a, 0x10, 0x5f,
	0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x6c, 0x33, 0x42,
	0x12, 0x0a, 0x10, 0x5f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x5f, 0x6c, 0x34, 0x42, 0x12, 0x0a, 0x10, 0x5f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x5f, 0x6c, 0x35, 0x42, 0x0c, 0x0a, 0x0a, 0x5f, 0x63, 0x6f, 0x6e, 0x64,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x0f, 0x0a, 0x0d, 0x5f, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61,
	0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x42, 0x11, 0x0a, 0x0f, 0x5f, 0x73, 0x68, 0x69, 0x70, 0x70,
	0x69, 0x6e, 0x67, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x69, 0x74,
	0x65, 0x6d, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x69, 0x64, 0x42, 0x11, 0x0a, 0x0f, 0x5f,
	0x74, 0x68, 0x75, 0x6d, 0x62, 0x6e, 0x61, 0x69, 0x6c, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x42, 0x26,
	0x0a, 0x24, 0x5f, 0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x72, 0x65,
	0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x5f,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x17, 0x0a, 0x15, 0x5f, 0x63, 0x6c, 0x69, 0x63, 0x6b,
	0x5f, 0x70, 0x6f, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x72, 0x61, 0x6e, 0x6b, 0x22,
	0xcd, 0x07, 0x0a, 0x1f, 0x50, 0x72, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6d, 0x70, 0x65, 0x74, 0x69,
	0x74, 0x69, 0x76, 0x65, 0x6e, 0x65, 0x73, 0x73, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x56,
	0x69, 0x65, 0x77, 0x12, 0x33, 0x0a, 0x13, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x48, 0x00, 0x52, 0x11, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x72,
	0x79, 0x43, 0x6f, 0x64, 0x65, 0x88, 0x01, 0x01, 0x12, 0x13, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x48, 0x01, 0x52, 0x02, 0x69, 0x64, 0x88, 0x01, 0x01, 0x12, 0x1e, 0x0a,
	0x08, 0x6f, 0x66, 0x66, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x48,
	0x02, 0x52, 0x07, 0x6f, 0x66, 0x66, 0x65, 0x72, 0x49, 0x64, 0x88, 0x01, 0x01, 0x12, 0x19, 0x0a,
	0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x48, 0x03, 0x52, 0x05,
	0x74, 0x69, 0x74, 0x6c, 0x65, 0x88, 0x01, 0x01, 0x12, 0x19, 0x0a, 0x05, 0x62, 0x72, 0x61, 0x6e,
	0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x48, 0x04, 0x52, 0x05, 0x62, 0x72, 0x61, 0x6e, 0x64,
	0x88, 0x01, 0x01, 0x12, 0x24, 0x0a, 0x0b, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x5f,
	0x6c, 0x31, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x48, 0x05, 0x52, 0x0a, 0x63, 0x61, 0x74, 0x65,
	0x67, 0x6f, 0x72, 0x79, 0x4c, 0x31, 0x88, 0x01, 0x01, 0x12, 0x24, 0x0a, 0x0b, 0x63, 0x61, 0x74,
	0x65, 0x67, 0x6f, 0x72, 0x79, 0x5f, 0x6c, 0x32, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x48, 0x06,
	0x52, 0x0a, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x4c, 0x32, 0x88, 0x01, 0x01, 0x12,
	0x24, 0x0a, 0x0b, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x5f, 0x6c, 0x33, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x09, 0x48, 0x07, 0x52, 0x0a, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79,
	0x4c, 0x33, 0x88, 0x01, 0x01, 0x12, 0x24, 0x0a, 0x0b, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72,
	0x79, 0x5f, 0x6c, 0x34, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x48, 0x08, 0x52, 0x0a, 0x63, 0x61,
	0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x4c, 0x34, 0x88, 0x01, 0x01, 0x12, 0x24, 0x0a, 0x0b, 0x63,
	0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x5f, 0x6c, 0x35, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09,
	0x48, 0x09, 0x52, 0x0a, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x4c, 0x35, 0x88, 0x01,
	0x01, 0x12, 0x2b, 0x0a, 0x0f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x5f, 0x6c, 0x31, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x48, 0x0a, 0x52, 0x0d, 0x70, 0x72,
	0x6f, 0x64, 0x75, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x4c, 0x31, 0x88, 0x01, 0x01, 0x12, 0x2b,
	0x0a, 0x0f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x6c,
	0x32, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x48, 0x0b, 0x52, 0x0d, 0x70, 0x72, 0x6f, 0x64, 0x75,
	0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x4c, 0x32, 0x88, 0x01, 0x01, 0x12, 0x2b, 0x0a, 0x0f, 0x70,
	0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x6c, 0x33, 0x18, 0x0d,
	0x20, 0x01, 0x28, 0x09, 0x48, 0x0c, 0x52, 0x0d, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x54,
	0x79, 0x70, 0x65, 0x4c, 0x33, 0x88, 0x01, 0x01, 0x12, 0x2b, 0x0a, 0x0f, 0x70, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x6c, 0x34, 0x18, 0x0e, 0x20, 0x01, 0x28,
	0x09, 0x48, 0x0d, 0x52, 0x0d, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65,
	0x4c, 0x34, 0x88, 0x01, 0x01, 0x12, 0x2b, 0x0a, 0x0f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x6c, 0x35, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x09, 0x48, 0x0e,
	0x52, 0x0d, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x4c, 0x35, 0x88,
	0x01, 0x01, 0x12, 0x31, 0x0a, 0x05, 0x70, 0x72, 0x69, 0x63, 0x65, 0x18, 0x10, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70,
	0x69, 0x6e, 0x67, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x50, 0x72, 0x69, 0x63, 0x65, 0x52, 0x05,
	0x70, 0x72, 0x69, 0x63, 0x65, 0x12, 0x44, 0x0a, 0x0f, 0x62, 0x65, 0x6e, 0x63, 0x68, 0x6d, 0x61,
	0x72, 0x6b, 0x5f, 0x70, 0x72, 0x69, 0x63, 0x65, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67,
	0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x50, 0x72, 0x69, 0x63, 0x65, 0x52, 0x0e, 0x62, 0x65, 0x6e,
	0x63, 0x68, 0x6d, 0x61, 0x72, 0x6b, 0x50, 0x72, 0x69, 0x63, 0x65, 0x42, 0x16, 0x0a, 0x14, 0x5f,
	0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x63,
	0x6f, 0x64, 0x65, 0x42, 0x05, 0x0a, 0x03, 0x5f, 0x69, 0x64, 0x42, 0x0b, 0x0a, 0x09, 0x5f, 0x6f,
	0x66, 0x66, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x74, 0x69, 0x74, 0x6c,
	0x65, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x62, 0x72, 0x61, 0x6e, 0x64, 0x42, 0x0e, 0x0a, 0x0c, 0x5f,
	0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x5f, 0x6c, 0x31, 0x42, 0x0e, 0x0a, 0x0c, 0x5f,
	0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x5f, 0x6c, 0x32, 0x42, 0x0e, 0x0a, 0x0c, 0x5f,
	0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x5f, 0x6c, 0x33, 0x42, 0x0e, 0x0a, 0x0c, 0x5f,
	0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x5f, 0x6c, 0x34, 0x42, 0x0e, 0x0a, 0x0c, 0x5f,
	0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x5f, 0x6c, 0x35, 0x42, 0x12, 0x0a, 0x10, 0x5f,
	0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x6c, 0x31, 0x42,
	0x12, 0x0a, 0x10, 0x5f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x5f, 0x6c, 0x32, 0x42, 0x12, 0x0a, 0x10, 0x5f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x5f, 0x6c, 0x33, 0x42, 0x12, 0x0a, 0x10, 0x5f, 0x70, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x6c, 0x34, 0x42, 0x12, 0x0a, 0x10, 0x5f,
	0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x6c, 0x35, 0x22,
	0xb6, 0x0b, 0x0a, 0x18, 0x50, 0x72, 0x69, 0x63, 0x65, 0x49, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74,
	0x73, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x56, 0x69, 0x65, 0x77, 0x12, 0x13, 0x0a, 0x02,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x02, 0x69, 0x64, 0x88, 0x01,
	0x01, 0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x66, 0x66, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x48, 0x01, 0x52, 0x07, 0x6f, 0x66, 0x66, 0x65, 0x72, 0x49, 0x64, 0x88, 0x01,
	0x01, 0x12, 0x19, 0x0a, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x48, 0x02, 0x52, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x88, 0x01, 0x01, 0x12, 0x19, 0x0a, 0x05,
	0x62, 0x72, 0x61, 0x6e, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x48, 0x03, 0x52, 0x05, 0x62,
	0x72, 0x61, 0x6e, 0x64, 0x88, 0x01, 0x01, 0x12, 0x24, 0x0a, 0x0b, 0x63, 0x61, 0x74, 0x65, 0x67,
	0x6f, 0x72, 0x79, 0x5f, 0x6c, 0x31, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x48, 0x04, 0x52, 0x0a,
	0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x4c, 0x31, 0x88, 0x01, 0x01, 0x12, 0x24, 0x0a,
	0x0b, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x5f, 0x6c, 0x32, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x09, 0x48, 0x05, 0x52, 0x0a, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x4c, 0x32,
	0x88, 0x01, 0x01, 0x12, 0x24, 0x0a, 0x0b, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x5f,
	0x6c, 0x33, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x48, 0x06, 0x52, 0x0a, 0x63, 0x61, 0x74, 0x65,
	0x67, 0x6f, 0x72, 0x79, 0x4c, 0x33, 0x88, 0x01, 0x01, 0x12, 0x24, 0x0a, 0x0b, 0x63, 0x61, 0x74,
	0x65, 0x67, 0x6f, 0x72, 0x79, 0x5f, 0x6c, 0x34, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x48, 0x07,
	0x52, 0x0a, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x4c, 0x34, 0x88, 0x01, 0x01, 0x12,
	0x24, 0x0a, 0x0b, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x5f, 0x6c, 0x35, 0x18, 0x09,
	0x20, 0x01, 0x28, 0x09, 0x48, 0x08, 0x52, 0x0a, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79,
	0x4c, 0x35, 0x88, 0x01, 0x01, 0x12, 0x2b, 0x0a, 0x0f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x6c, 0x31, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x48, 0x09,
	0x52, 0x0d, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x4c, 0x31, 0x88,
	0x01, 0x01, 0x12, 0x2b, 0x0a, 0x0f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x5f, 0x6c, 0x32, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x48, 0x0a, 0x52, 0x0d, 0x70,
	0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x4c, 0x32, 0x88, 0x01, 0x01, 0x12,
	0x2b, 0x0a, 0x0f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f,
	0x6c, 0x33, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x48, 0x0b, 0x52, 0x0d, 0x70, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x4c, 0x33, 0x88, 0x01, 0x01, 0x12, 0x2b, 0x0a, 0x0f,
	0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x6c, 0x34, 0x18,
	0x0d, 0x20, 0x01, 0x28, 0x09, 0x48, 0x0c, 0x52, 0x0d, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74,
	0x54, 0x79, 0x70, 0x65, 0x4c, 0x34, 0x88, 0x01, 0x01, 0x12, 0x2b, 0x0a, 0x0f, 0x70, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x6c, 0x35, 0x18, 0x0e, 0x20, 0x01,
	0x28, 0x09, 0x48, 0x0d, 0x52, 0x0d, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x54, 0x79, 0x70,
	0x65, 0x4c, 0x35, 0x88, 0x01, 0x01, 0x12, 0x31, 0x0a, 0x05, 0x70, 0x72, 0x69, 0x63, 0x65, 0x18,
	0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x50, 0x72, 0x69,
	0x63, 0x65, 0x52, 0x05, 0x70, 0x72, 0x69, 0x63, 0x65, 0x12, 0x44, 0x0a, 0x0f, 0x73, 0x75, 0x67,
	0x67, 0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x70, 0x72, 0x69, 0x63, 0x65, 0x18, 0x10, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x50, 0x72, 0x69, 0x63, 0x65, 0x52,
	0x0e, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x65, 0x64, 0x50, 0x72, 0x69, 0x63, 0x65, 0x12,
	0x56, 0x0a, 0x25, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x69, 0x6d, 0x70,
	0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x5f,
	0x66, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x11, 0x20, 0x01, 0x28, 0x01, 0x48, 0x0e,
	0x52, 0x22, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x65, 0x64, 0x49, 0x6d, 0x70, 0x72, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x46, 0x72, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x4c, 0x0a, 0x20, 0x70, 0x72, 0x65, 0x64, 0x69,
	0x63, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x73, 0x5f, 0x63, 0x68, 0x61, 0x6e,
	0x67, 0x65, 0x5f, 0x66, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x12, 0x20, 0x01, 0x28,
	0x01, 0x48, 0x0f, 0x52, 0x1d, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x65, 0x64, 0x43, 0x6c,
	0x69, 0x63, 0x6b, 0x73, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x46, 0x72, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x56, 0x0a, 0x25, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74,
	0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x63,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x66, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x13,
	0x20, 0x01, 0x28, 0x01, 0x48, 0x10, 0x52, 0x22, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x65,
	0x64, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x43, 0x68, 0x61, 0x6e,
	0x67, 0x65, 0x46, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x75, 0x0a,
	0x0d, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x6e, 0x65, 0x73, 0x73, 0x18, 0x16,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x4f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68,
	0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e,
	0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50,
	0x72, 0x69, 0x63, 0x65, 0x49, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x50, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x56, 0x69, 0x65, 0x77, 0x2e, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76,
	0x65, 0x6e, 0x65, 0x73, 0x73, 0x52, 0x0d, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65,
	0x6e, 0x65, 0x73, 0x73, 0x22, 0x4d, 0x0a, 0x0d, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76,
	0x65, 0x6e, 0x65, 0x73, 0x73, 0x12, 0x1d, 0x0a, 0x19, 0x45, 0x46, 0x46, 0x45, 0x43, 0x54, 0x49,
	0x56, 0x45, 0x4e, 0x45, 0x53, 0x53, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x07, 0x0a, 0x03, 0x4c, 0x4f, 0x57, 0x10, 0x01, 0x12, 0x0a, 0x0a,
	0x06, 0x4d, 0x45, 0x44, 0x49, 0x55, 0x4d, 0x10, 0x02, 0x12, 0x08, 0x0a, 0x04, 0x48, 0x49, 0x47,
	0x48, 0x10, 0x03, 0x42, 0x05, 0x0a, 0x03, 0x5f, 0x69, 0x64, 0x42, 0x0b, 0x0a, 0x09, 0x5f, 0x6f,
	0x66, 0x66, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x74, 0x69, 0x74, 0x6c,
	0x65, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x62, 0x72, 0x61, 0x6e, 0x64, 0x42, 0x0e, 0x0a, 0x0c, 0x5f,
	0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x5f, 0x6c, 0x31, 0x42, 0x0e, 0x0a, 0x0c, 0x5f,
	0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x5f, 0x6c, 0x32, 0x42, 0x0e, 0x0a, 0x0c, 0x5f,
	0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x5f, 0x6c, 0x33, 0x42, 0x0e, 0x0a, 0x0c, 0x5f,
	0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x5f, 0x6c, 0x34, 0x42, 0x0e, 0x0a, 0x0c, 0x5f,
	0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x5f, 0x6c, 0x35, 0x42, 0x12, 0x0a, 0x10, 0x5f,
	0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x6c, 0x31, 0x42,
	0x12, 0x0a, 0x10, 0x5f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x5f, 0x6c, 0x32, 0x42, 0x12, 0x0a, 0x10, 0x5f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x5f, 0x6c, 0x33, 0x42, 0x12, 0x0a, 0x10, 0x5f, 0x70, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x6c, 0x34, 0x42, 0x12, 0x0a, 0x10, 0x5f,
	0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x6c, 0x35, 0x42,
	0x28, 0x0a, 0x26, 0x5f, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x69, 0x6d,
	0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65,
	0x5f, 0x66, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x23, 0x0a, 0x21, 0x5f, 0x70, 0x72,
	0x65, 0x64, 0x69, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x73, 0x5f, 0x63,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x66, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x28,
	0x0a, 0x26, 0x5f, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x5f,
	0x66, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x89, 0x0e, 0x0a, 0x1d, 0x42, 0x65, 0x73,
	0x74, 0x53, 0x65, 0x6c, 0x6c, 0x65, 0x72, 0x73, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x56, 0x69, 0x65, 0x77, 0x12, 0x32, 0x0a, 0x0b, 0x72, 0x65,
	0x70, 0x6f, 0x72, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x11, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61,
	0x74, 0x65, 0x52, 0x0a, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x61, 0x74, 0x65, 0x12, 0x84,
	0x01, 0x0a, 0x12, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x67, 0x72, 0x61, 0x6e, 0x75, 0x6c,
	0x61, 0x72, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x50, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65,
	0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x47, 0x72, 0x61, 0x6e,
	0x75, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x47, 0x72,
	0x61, 0x6e, 0x75, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79, 0x45, 0x6e, 0x75, 0x6d, 0x48, 0x00, 0x52,
	0x11, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x47, 0x72, 0x61, 0x6e, 0x75, 0x6c, 0x61, 0x72, 0x69,
	0x74, 0x79, 0x88, 0x01, 0x01, 0x12, 0x33, 0x0a, 0x13, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x5f,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x48, 0x01, 0x52, 0x11, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x75, 0x6e,
	0x74, 0x72, 0x79, 0x43, 0x6f, 0x64, 0x65, 0x88, 0x01, 0x01, 0x12, 0x31, 0x0a, 0x12, 0x72, 0x65,
	0x70, 0x6f, 0x72, 0x74, 0x5f, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x5f, 0x69, 0x64,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x48, 0x02, 0x52, 0x10, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74,
	0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x49, 0x64, 0x88, 0x01, 0x01, 0x12, 0x19, 0x0a,
	0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x48, 0x03, 0x52, 0x05,
	0x74, 0x69, 0x74, 0x6c, 0x65, 0x88, 0x01, 0x01, 0x12, 0x19, 0x0a, 0x05, 0x62, 0x72, 0x61, 0x6e,
	0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x48, 0x04, 0x52, 0x05, 0x62, 0x72, 0x61, 0x6e, 0x64,
	0x88, 0x01, 0x01, 0x12, 0x24, 0x0a, 0x0b, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x5f,
	0x6c, 0x31, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x48, 0x05, 0x52, 0x0a, 0x63, 0x61, 0x74, 0x65,
	0x67, 0x6f, 0x72, 0x79, 0x4c, 0x31, 0x88, 0x01, 0x01, 0x12, 0x24, 0x0a, 0x0b, 0x63, 0x61, 0x74,
	0x65, 0x67, 0x6f, 0x72, 0x79, 0x5f, 0x6c, 0x32, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x48, 0x06,
	0x52, 0x0a, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x4c, 0x32, 0x88, 0x01, 0x01, 0x12,
	0x24, 0x0a, 0x0b, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x5f, 0x6c, 0x33, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x09, 0x48, 0x07, 0x52, 0x0a, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79,
	0x4c, 0x33, 0x88, 0x01, 0x01, 0x12, 0x24, 0x0a, 0x0b, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72,
	0x79, 0x5f, 0x6c, 0x34, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x48, 0x08, 0x52, 0x0a, 0x63, 0x61,
	0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x4c, 0x34, 0x88, 0x01, 0x01, 0x12, 0x24, 0x0a, 0x0b, 0x63,
	0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x5f, 0x6c, 0x35, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09,
	0x48, 0x09, 0x52, 0x0a, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x4c, 0x35, 0x88, 0x01,
	0x01, 0x12, 0x23, 0x0a, 0x0d, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x5f, 0x67, 0x74, 0x69,
	0x6e, 0x73, 0x18, 0x0d, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e,
	0x74, 0x47, 0x74, 0x69, 0x6e, 0x73, 0x12, 0x86, 0x01, 0x0a, 0x10, 0x69, 0x6e, 0x76, 0x65, 0x6e,
	0x74, 0x6f, 0x72, 0x79, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x0e, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x56, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70,
	0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x72, 0x65, 0x70,
	0x6f, 0x72, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x42, 0x65, 0x73, 0x74,
	0x53, 0x65, 0x6c, 0x6c, 0x65, 0x72, 0x73, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x56, 0x69, 0x65, 0x77, 0x2e, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74,
	0x6f, 0x72, 0x79, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x48, 0x0a, 0x52, 0x0f, 0x69, 0x6e, 0x76,
	0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x88, 0x01, 0x01, 0x12,
	0x91, 0x01, 0x0a, 0x16, 0x62, 0x72, 0x61, 0x6e, 0x64, 0x5f, 0x69, 0x6e, 0x76, 0x65, 0x6e, 0x74,
	0x6f, 0x72, 0x79, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x56, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69,
	0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x72, 0x65, 0x70, 0x6f,
	0x72, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x42, 0x65, 0x73, 0x74, 0x53,
	0x65, 0x6c, 0x6c, 0x65, 0x72, 0x73, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x43, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x56, 0x69, 0x65, 0x77, 0x2e, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f,
	0x72, 0x79, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x48, 0x0b, 0x52, 0x14, 0x62, 0x72, 0x61, 0x6e,
	0x64, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x88, 0x01, 0x01, 0x12, 0x17, 0x0a, 0x04, 0x72, 0x61, 0x6e, 0x6b, 0x18, 0x10, 0x20, 0x01, 0x28,
	0x03, 0x48, 0x0c, 0x52, 0x04, 0x72, 0x61, 0x6e, 0x6b, 0x88, 0x01, 0x01, 0x12, 0x28, 0x0a, 0x0d,
	0x70, 0x72, 0x65, 0x76, 0x69, 0x6f, 0x75, 0x73, 0x5f, 0x72, 0x61, 0x6e, 0x6b, 0x18, 0x11, 0x20,
	0x01, 0x28, 0x03, 0x48, 0x0d, 0x52, 0x0c, 0x70, 0x72, 0x65, 0x76, 0x69, 0x6f, 0x75, 0x73, 0x52,
	0x61, 0x6e, 0x6b, 0x88, 0x01, 0x01, 0x12, 0x78, 0x0a, 0x0f, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69,
	0x76, 0x65, 0x5f, 0x64, 0x65, 0x6d, 0x61, 0x6e, 0x64, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x72, 0x65, 0x70, 0x6f, 0x72,
	0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x69,
	0x76, 0x65, 0x44, 0x65, 0x6d, 0x61, 0x6e, 0x64, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x76,
	0x65, 0x44, 0x65, 0x6d, 0x61, 0x6e, 0x64, 0x45, 0x6e, 0x75, 0x6d, 0x48, 0x0e, 0x52, 0x0e, 0x72,
	0x65, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x44, 0x65, 0x6d, 0x61, 0x6e, 0x64, 0x88, 0x01, 0x01,
	0x12, 0x89, 0x01, 0x0a, 0x18, 0x70, 0x72, 0x65, 0x76, 0x69, 0x6f, 0x75, 0x73, 0x5f, 0x72, 0x65,
	0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x64, 0x65, 0x6d, 0x61, 0x6e, 0x64, 0x18, 0x13, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f,
	0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x72,
	0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x52, 0x65,
	0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x44, 0x65, 0x6d, 0x61, 0x6e, 0x64, 0x2e, 0x52, 0x65, 0x6c,
	0x61, 0x74, 0x69, 0x76, 0x65, 0x44, 0x65, 0x6d, 0x61, 0x6e, 0x64, 0x45, 0x6e, 0x75, 0x6d, 0x48,
	0x0f, 0x52, 0x16, 0x70, 0x72, 0x65, 0x76, 0x69, 0x6f, 0x75, 0x73, 0x52, 0x65, 0x6c, 0x61, 0x74,
	0x69, 0x76, 0x65, 0x44, 0x65, 0x6d, 0x61, 0x6e, 0x64, 0x88, 0x01, 0x01, 0x12, 0x99, 0x01, 0x0a,
	0x16, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x64, 0x65, 0x6d, 0x61, 0x6e, 0x64,
	0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x5e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e,
	0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65,
	0x44, 0x65, 0x6d, 0x61, 0x6e, 0x64, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65,
	0x2e, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x44, 0x65, 0x6d, 0x61, 0x6e, 0x64, 0x43,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x45, 0x6e, 0x75, 0x6d, 0x48, 0x10, 0x52,
	0x14, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x44, 0x65, 0x6d, 0x61, 0x6e, 0x64, 0x43,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x88, 0x01, 0x01, 0x22, 0x69, 0x0a, 0x0f, 0x49, 0x6e, 0x76, 0x65,
	0x6e, 0x74, 0x6f, 0x72, 0x79, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x20, 0x0a, 0x1c, 0x49,
	0x4e, 0x56, 0x45, 0x4e, 0x54, 0x4f, 0x52, 0x59, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a,
	0x08, 0x49, 0x4e, 0x5f, 0x53, 0x54, 0x4f, 0x43, 0x4b, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x4f,
	0x55, 0x54, 0x5f, 0x4f, 0x46, 0x5f, 0x53, 0x54, 0x4f, 0x43, 0x4b, 0x10, 0x02, 0x12, 0x14, 0x0a,
	0x10, 0x4e, 0x4f, 0x54, 0x5f, 0x49, 0x4e, 0x5f, 0x49, 0x4e, 0x56, 0x45, 0x4e, 0x54, 0x4f, 0x52,
	0x59, 0x10, 0x03, 0x42, 0x15, 0x0a, 0x13, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x67,
	0x72, 0x61, 0x6e, 0x75, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79, 0x42, 0x16, 0x0a, 0x14, 0x5f, 0x72,
	0x65, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x63, 0x6f,
	0x64, 0x65, 0x42, 0x15, 0x0a, 0x13, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x63, 0x61,
	0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x5f, 0x69, 0x64, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x74, 0x69,
	0x74, 0x6c, 0x65, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x62, 0x72, 0x61, 0x6e, 0x64, 0x42, 0x0e, 0x0a,
	0x0c, 0x5f, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x5f, 0x6c, 0x31, 0x42, 0x0e, 0x0a,
	0x0c, 0x5f, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x5f, 0x6c, 0x32, 0x42, 0x0e, 0x0a,
	0x0c, 0x5f, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x5f, 0x6c, 0x33, 0x42, 0x0e, 0x0a,
	0x0c, 0x5f, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x5f, 0x6c, 0x34, 0x42, 0x0e, 0x0a,
	0x0c, 0x5f, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x5f, 0x6c, 0x35, 0x42, 0x13, 0x0a,
	0x11, 0x5f, 0x69, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x73, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x42, 0x19, 0x0a, 0x17, 0x5f, 0x62, 0x72, 0x61, 0x6e, 0x64, 0x5f, 0x69, 0x6e, 0x76,
	0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x07, 0x0a,
	0x05, 0x5f, 0x72, 0x61, 0x6e, 0x6b, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x70, 0x72, 0x65, 0x76, 0x69,
	0x6f, 0x75, 0x73, 0x5f, 0x72, 0x61, 0x6e, 0x6b, 0x42, 0x12, 0x0a, 0x10, 0x5f, 0x72, 0x65, 0x6c,
	0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x64, 0x65, 0x6d, 0x61, 0x6e, 0x64, 0x42, 0x1b, 0x0a, 0x19,
	0x5f, 0x70, 0x72, 0x65, 0x76, 0x69, 0x6f, 0x75, 0x73, 0x5f, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69,
	0x76, 0x65, 0x5f, 0x64, 0x65, 0x6d, 0x61, 0x6e, 0x64, 0x42, 0x19, 0x0a, 0x17, 0x5f, 0x72, 0x65,
	0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x64, 0x65, 0x6d, 0x61, 0x6e, 0x64, 0x5f, 0x63, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x22, 0xf0, 0x07, 0x0a, 0x14, 0x42, 0x65, 0x73, 0x74, 0x53, 0x65, 0x6c,
	0x6c, 0x65, 0x72, 0x73, 0x42, 0x72, 0x61, 0x6e, 0x64, 0x56, 0x69, 0x65, 0x77, 0x12, 0x32, 0x0a,
	0x0b, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65,
	0x2e, 0x44, 0x61, 0x74, 0x65, 0x52, 0x0a, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x61, 0x74,
	0x65, 0x12, 0x84, 0x01, 0x0a, 0x12, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x67, 0x72, 0x61,
	0x6e, 0x75, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x50,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67,
	0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74,
	0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x47,
	0x72, 0x61, 0x6e, 0x75, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72,
	0x74, 0x47, 0x72, 0x61, 0x6e, 0x75, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79, 0x45, 0x6e, 0x75, 0x6d,
	0x48, 0x00, 0x52, 0x11, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x47, 0x72, 0x61, 0x6e, 0x75, 0x6c,
	0x61, 0x72, 0x69, 0x74, 0x79, 0x88, 0x01, 0x01, 0x12, 0x33, 0x0a, 0x13, 0x72, 0x65, 0x70, 0x6f,
	0x72, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x48, 0x01, 0x52, 0x11, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79, 0x43, 0x6f, 0x64, 0x65, 0x88, 0x01, 0x01, 0x12, 0x31, 0x0a,
	0x12, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79,
	0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x48, 0x02, 0x52, 0x10, 0x72, 0x65, 0x70,
	0x6f, 0x72, 0x74, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x49, 0x64, 0x88, 0x01, 0x01,
	0x12, 0x19, 0x0a, 0x05, 0x62, 0x72, 0x61, 0x6e, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x48,
	0x03, 0x52, 0x05, 0x62, 0x72, 0x61, 0x6e, 0x64, 0x88, 0x01, 0x01, 0x12, 0x17, 0x0a, 0x04, 0x72,
	0x61, 0x6e, 0x6b, 0x18, 0x07, 0x20, 0x01, 0x28, 0x03, 0x48, 0x04, 0x52, 0x04, 0x72, 0x61, 0x6e,
	0x6b, 0x88, 0x01, 0x01, 0x12, 0x28, 0x0a, 0x0d, 0x70, 0x72, 0x65, 0x76, 0x69, 0x6f, 0x75, 0x73,
	0x5f, 0x72, 0x61, 0x6e, 0x6b, 0x18, 0x08, 0x20, 0x01, 0x28, 0x03, 0x48, 0x05, 0x52, 0x0c, 0x70,
	0x72, 0x65, 0x76, 0x69, 0x6f, 0x75, 0x73, 0x52, 0x61, 0x6e, 0x6b, 0x88, 0x01, 0x01, 0x12, 0x78,
	0x0a, 0x0f, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x64, 0x65, 0x6d, 0x61, 0x6e,
	0x64, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61,
	0x6e, 0x74, 0x2e, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x44, 0x65, 0x6d, 0x61, 0x6e, 0x64,
	0x2e, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x44, 0x65, 0x6d, 0x61, 0x6e, 0x64, 0x45,
	0x6e, 0x75, 0x6d, 0x48, 0x06, 0x52, 0x0e, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x44,
	0x65, 0x6d, 0x61, 0x6e, 0x64, 0x88, 0x01, 0x01, 0x12, 0x89, 0x01, 0x0a, 0x18, 0x70, 0x72, 0x65,
	0x76, 0x69, 0x6f, 0x75, 0x73, 0x5f, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x64,
	0x65, 0x6d, 0x61, 0x6e, 0x64, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65,
	0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x44, 0x65,
	0x6d, 0x61, 0x6e, 0x64, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x44, 0x65, 0x6d,
	0x61, 0x6e, 0x64, 0x45, 0x6e, 0x75, 0x6d, 0x48, 0x07, 0x52, 0x16, 0x70, 0x72, 0x65, 0x76, 0x69,
	0x6f, 0x75, 0x73, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x44, 0x65, 0x6d, 0x61, 0x6e,
	0x64, 0x88, 0x01, 0x01, 0x12, 0x99, 0x01, 0x0a, 0x16, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x76,
	0x65, 0x5f, 0x64, 0x65, 0x6d, 0x61, 0x6e, 0x64, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x18,
	0x0b, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x5e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74,
	0x2e, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x52, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x44, 0x65, 0x6d, 0x61, 0x6e, 0x64, 0x43, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x76,
	0x65, 0x44, 0x65, 0x6d, 0x61, 0x6e, 0x64, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x54, 0x79, 0x70,
	0x65, 0x45, 0x6e, 0x75, 0x6d, 0x48, 0x08, 0x52, 0x14, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x76,
	0x65, 0x44, 0x65, 0x6d, 0x61, 0x6e, 0x64, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x88, 0x01, 0x01,
	0x42, 0x15, 0x0a, 0x13, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x67, 0x72, 0x61, 0x6e,
	0x75, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79, 0x42, 0x16, 0x0a, 0x14, 0x5f, 0x72, 0x65, 0x70, 0x6f,
	0x72, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x42,
	0x15, 0x0a, 0x13, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x63, 0x61, 0x74, 0x65, 0x67,
	0x6f, 0x72, 0x79, 0x5f, 0x69, 0x64, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x62, 0x72, 0x61, 0x6e, 0x64,
	0x42, 0x07, 0x0a, 0x05, 0x5f, 0x72, 0x61, 0x6e, 0x6b, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x70, 0x72,
	0x65, 0x76, 0x69, 0x6f, 0x75, 0x73, 0x5f, 0x72, 0x61, 0x6e, 0x6b, 0x42, 0x12, 0x0a, 0x10, 0x5f,
	0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x64, 0x65, 0x6d, 0x61, 0x6e, 0x64, 0x42,
	0x1b, 0x0a, 0x19, 0x5f, 0x70, 0x72, 0x65, 0x76, 0x69, 0x6f, 0x75, 0x73, 0x5f, 0x72, 0x65, 0x6c,
	0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x64, 0x65, 0x6d, 0x61, 0x6e, 0x64, 0x42, 0x19, 0x0a, 0x17,
	0x5f, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x64, 0x65, 0x6d, 0x61, 0x6e, 0x64,
	0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x22, 0x92, 0x02, 0x0a, 0x19, 0x4e, 0x6f, 0x6e, 0x50,
	0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x50, 0x65, 0x72, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63,
	0x65, 0x56, 0x69, 0x65, 0x77, 0x12, 0x25, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70,
	0x65, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x52, 0x04, 0x64, 0x61, 0x74, 0x65, 0x12, 0x25, 0x0a, 0x04,
	0x77, 0x65, 0x65, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x52, 0x04, 0x77,
	0x65, 0x65, 0x6b, 0x12, 0x1b, 0x0a, 0x06, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x73, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x03, 0x48, 0x00, 0x52, 0x06, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x73, 0x88, 0x01, 0x01,
	0x12, 0x25, 0x0a, 0x0b, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x03, 0x48, 0x01, 0x52, 0x0b, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x88, 0x01, 0x01, 0x12, 0x31, 0x0a, 0x12, 0x63, 0x6c, 0x69, 0x63, 0x6b,
	0x5f, 0x74, 0x68, 0x72, 0x6f, 0x75, 0x67, 0x68, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x01, 0x48, 0x02, 0x52, 0x10, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x54, 0x68, 0x72, 0x6f,
	0x75, 0x67, 0x68, 0x52, 0x61, 0x74, 0x65, 0x88, 0x01, 0x01, 0x42, 0x09, 0x0a, 0x07, 0x5f, 0x63,
	0x6c, 0x69, 0x63, 0x6b, 0x73, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x15, 0x0a, 0x13, 0x5f, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x5f,
	0x74, 0x68, 0x72, 0x6f, 0x75, 0x67, 0x68, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x22, 0xa0, 0x06, 0x0a,
	0x23, 0x43, 0x6f, 0x6d, 0x70, 0x65, 0x74, 0x69, 0x74, 0x69, 0x76, 0x65, 0x56, 0x69, 0x73, 0x69,
	0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d, 0x70, 0x65, 0x74, 0x69, 0x74, 0x6f, 0x72,
	0x56, 0x69, 0x65, 0x77, 0x12, 0x25, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65,
	0x2e, 0x44, 0x61, 0x74, 0x65, 0x52, 0x04, 0x64, 0x61, 0x74, 0x65, 0x12, 0x1b, 0x0a, 0x06, 0x64,
	0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x06, 0x64,
	0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x29, 0x0a, 0x0e, 0x69, 0x73, 0x5f, 0x79,
	0x6f, 0x75, 0x72, 0x5f, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08,
	0x48, 0x01, 0x52, 0x0c, 0x69, 0x73, 0x59, 0x6f, 0x75, 0x72, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e,
	0x88, 0x01, 0x01, 0x12, 0x33, 0x0a, 0x13, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x48, 0x02, 0x52, 0x11, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x72,
	0x79, 0x43, 0x6f, 0x64, 0x65, 0x88, 0x01, 0x01, 0x12, 0x31, 0x0a, 0x12, 0x72, 0x65, 0x70, 0x6f,
	0x72, 0x74, 0x5f, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x03, 0x48, 0x03, 0x52, 0x10, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x61,
	0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x49, 0x64, 0x88, 0x01, 0x01, 0x12, 0x74, 0x0a, 0x0e, 0x74,
	0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f,
	0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x72,
	0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x54, 0x72,
	0x61, 0x66, 0x66, 0x69, 0x63, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x54, 0x72, 0x61, 0x66,
	0x66, 0x69, 0x63, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x45, 0x6e, 0x75, 0x6d, 0x48, 0x04, 0x52,
	0x0d, 0x74, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x88, 0x01,
	0x01, 0x12, 0x17, 0x0a, 0x04, 0x72, 0x61, 0x6e, 0x6b, 0x18, 0x07, 0x20, 0x01, 0x28, 0x03, 0x48,
	0x05, 0x52, 0x04, 0x72, 0x61, 0x6e, 0x6b, 0x88, 0x01, 0x01, 0x12, 0x2f, 0x0a, 0x11, 0x61, 0x64,
	0x73, 0x5f, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x63, 0x5f, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x01, 0x48, 0x06, 0x52, 0x0f, 0x61, 0x64, 0x73, 0x4f, 0x72, 0x67, 0x61,
	0x6e, 0x69, 0x63, 0x52, 0x61, 0x74, 0x69, 0x6f, 0x88, 0x01, 0x01, 0x12, 0x2f, 0x0a, 0x11, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x6f, 0x76, 0x65, 0x72, 0x6c, 0x61, 0x70, 0x5f, 0x72, 0x61, 0x74, 0x65,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x01, 0x48, 0x07, 0x52, 0x0f, 0x70, 0x61, 0x67, 0x65, 0x4f, 0x76,
	0x65, 0x72, 0x6c, 0x61, 0x70, 0x52, 0x61, 0x74, 0x65, 0x88, 0x01, 0x01, 0x12, 0x35, 0x0a, 0x14,
	0x68, 0x69, 0x67, 0x68, 0x65, 0x72, 0x5f, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x72, 0x61, 0x74, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x01, 0x48, 0x08, 0x52, 0x12, 0x68, 0x69,
	0x67, 0x68, 0x65, 0x72, 0x50, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x61, 0x74, 0x65,
	0x88, 0x01, 0x01, 0x12, 0x34, 0x0a, 0x13, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f,
	0x76, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x01,
	0x48, 0x09, 0x52, 0x12, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x56, 0x69, 0x73, 0x69,
	0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x88, 0x01, 0x01, 0x42, 0x09, 0x0a, 0x07, 0x5f, 0x64, 0x6f,
	0x6d, 0x61, 0x69, 0x6e, 0x42, 0x11, 0x0a, 0x0f, 0x5f, 0x69, 0x73, 0x5f, 0x79, 0x6f, 0x75, 0x72,
	0x5f, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x42, 0x16, 0x0a, 0x14, 0x5f, 0x72, 0x65, 0x70, 0x6f,
	0x72, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x42,
	0x15, 0x0a, 0x13, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x63, 0x61, 0x74, 0x65, 0x67,
	0x6f, 0x72, 0x79, 0x5f, 0x69, 0x64, 0x42, 0x11, 0x0a, 0x0f, 0x5f, 0x74, 0x72, 0x61, 0x66, 0x66,
	0x69, 0x63, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x07, 0x0a, 0x05, 0x5f, 0x72, 0x61,
	0x6e, 0x6b, 0x42, 0x14, 0x0a, 0x12, 0x5f, 0x61, 0x64, 0x73, 0x5f, 0x6f, 0x72, 0x67, 0x61, 0x6e,
	0x69, 0x63, 0x5f, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x42, 0x14, 0x0a, 0x12, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x6f, 0x76, 0x65, 0x72, 0x6c, 0x61, 0x70, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x42, 0x17,
	0x0a, 0x15, 0x5f, 0x68, 0x69, 0x67, 0x68, 0x65, 0x72, 0x5f, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x42, 0x16, 0x0a, 0x14, 0x5f, 0x72, 0x65, 0x6c, 0x61,
	0x74, 0x69, 0x76, 0x65, 0x5f, 0x76, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x22,
	0xd3, 0x05, 0x0a, 0x24, 0x43, 0x6f, 0x6d, 0x70, 0x65, 0x74, 0x69, 0x74, 0x69, 0x76, 0x65, 0x56,
	0x69, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x54, 0x6f, 0x70, 0x4d, 0x65, 0x72, 0x63,
	0x68, 0x61, 0x6e, 0x74, 0x56, 0x69, 0x65, 0x77, 0x12, 0x25, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x52, 0x04, 0x64, 0x61, 0x74, 0x65, 0x12,
	0x1b, 0x0a, 0x06, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48,
	0x00, 0x52, 0x06, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x29, 0x0a, 0x0e,
	0x69, 0x73, 0x5f, 0x79, 0x6f, 0x75, 0x72, 0x5f, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x08, 0x48, 0x01, 0x52, 0x0c, 0x69, 0x73, 0x59, 0x6f, 0x75, 0x72, 0x44, 0x6f,
	0x6d, 0x61, 0x69, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x33, 0x0a, 0x13, 0x72, 0x65, 0x70, 0x6f, 0x72,
	0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x48, 0x02, 0x52, 0x11, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f,
	0x75, 0x6e, 0x74, 0x72, 0x79, 0x43, 0x6f, 0x64, 0x65, 0x88, 0x01, 0x01, 0x12, 0x31, 0x0a, 0x12,
	0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x5f,
	0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x48, 0x03, 0x52, 0x10, 0x72, 0x65, 0x70, 0x6f,
	0x72, 0x74, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x49, 0x64, 0x88, 0x01, 0x01, 0x12,
	0x74, 0x0a, 0x0e, 0x74, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61,
	0x6e, 0x74, 0x2e, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x54, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e,
	0x54, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x45, 0x6e, 0x75,
	0x6d, 0x48, 0x04, 0x52, 0x0d, 0x74, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x88, 0x01, 0x01, 0x12, 0x17, 0x0a, 0x04, 0x72, 0x61, 0x6e, 0x6b, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x03, 0x48, 0x05, 0x52, 0x04, 0x72, 0x61, 0x6e, 0x6b, 0x88, 0x01, 0x01, 0x12, 0x2f,
	0x0a, 0x11, 0x61, 0x64, 0x73, 0x5f, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x63, 0x5f, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x18, 0x08, 0x20, 0x01, 0x28, 0x01, 0x48, 0x06, 0x52, 0x0f, 0x61, 0x64, 0x73,
	0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x63, 0x52, 0x61, 0x74, 0x69, 0x6f, 0x88, 0x01, 0x01, 0x12,
	0x2f, 0x0a, 0x11, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x6f, 0x76, 0x65, 0x72, 0x6c, 0x61, 0x70, 0x5f,
	0x72, 0x61, 0x74, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x01, 0x48, 0x07, 0x52, 0x0f, 0x70, 0x61,
	0x67, 0x65, 0x4f, 0x76, 0x65, 0x72, 0x6c, 0x61, 0x70, 0x52, 0x61, 0x74, 0x65, 0x88, 0x01, 0x01,
	0x12, 0x35, 0x0a, 0x14, 0x68, 0x69, 0x67, 0x68, 0x65, 0x72, 0x5f, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x01, 0x48, 0x08,
	0x52, 0x12, 0x68, 0x69, 0x67, 0x68, 0x65, 0x72, 0x50, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x61, 0x74, 0x65, 0x88, 0x01, 0x01, 0x42, 0x09, 0x0a, 0x07, 0x5f, 0x64, 0x6f, 0x6d, 0x61,
	0x69, 0x6e, 0x42, 0x11, 0x0a, 0x0f, 0x5f, 0x69, 0x73, 0x5f, 0x79, 0x6f, 0x75, 0x72, 0x5f, 0x64,
	0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x42, 0x16, 0x0a, 0x14, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74,
	0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x42, 0x15, 0x0a,
	0x13, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72,
	0x79, 0x5f, 0x69, 0x64, 0x42, 0x11, 0x0a, 0x0f, 0x5f, 0x74, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63,
	0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x07, 0x0a, 0x05, 0x5f, 0x72, 0x61, 0x6e, 0x6b,
	0x42, 0x14, 0x0a, 0x12, 0x5f, 0x61, 0x64, 0x73, 0x5f, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x63,
	0x5f, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x42, 0x14, 0x0a, 0x12, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x6f, 0x76, 0x65, 0x72, 0x6c, 0x61, 0x70, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x42, 0x17, 0x0a, 0x15,
	0x5f, 0x68, 0x69, 0x67, 0x68, 0x65, 0x72, 0x5f, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x72, 0x61, 0x74, 0x65, 0x22, 0xce, 0x04, 0x0a, 0x22, 0x43, 0x6f, 0x6d, 0x70, 0x65, 0x74,
	0x69, 0x74, 0x69, 0x76, 0x65, 0x56, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x42,
	0x65, 0x6e, 0x63, 0x68, 0x6d, 0x61, 0x72, 0x6b, 0x56, 0x69, 0x65, 0x77, 0x12, 0x25, 0x0a, 0x04,
	0x64, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x52, 0x04, 0x64,
	0x61, 0x74, 0x65, 0x12, 0x33, 0x0a, 0x13, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x48, 0x00, 0x52, 0x11, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x72,
	0x79, 0x43, 0x6f, 0x64, 0x65, 0x88, 0x01, 0x01, 0x12, 0x31, 0x0a, 0x12, 0x72, 0x65, 0x70, 0x6f,
	0x72, 0x74, 0x5f, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x03, 0x48, 0x01, 0x52, 0x10, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x61,
	0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x49, 0x64, 0x88, 0x01, 0x01, 0x12, 0x74, 0x0a, 0x0e, 0x74,
	0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f,
	0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x72,
	0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x54, 0x72,
	0x61, 0x66, 0x66, 0x69, 0x63, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x54, 0x72, 0x61, 0x66,
	0x66, 0x69, 0x63, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x45, 0x6e, 0x75, 0x6d, 0x48, 0x02, 0x52,
	0x0d, 0x74, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x88, 0x01,
	0x01, 0x12, 0x44, 0x0a, 0x1c, 0x79, 0x6f, 0x75, 0x72, 0x5f, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e,
	0x5f, 0x76, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x74, 0x72, 0x65, 0x6e,
	0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x01, 0x48, 0x03, 0x52, 0x19, 0x79, 0x6f, 0x75, 0x72, 0x44,
	0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x56, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x54,
	0x72, 0x65, 0x6e, 0x64, 0x88, 0x01, 0x01, 0x12, 0x52, 0x0a, 0x23, 0x63, 0x61, 0x74, 0x65, 0x67,
	0x6f, 0x72, 0x79, 0x5f, 0x62, 0x65, 0x6e, 0x63, 0x68, 0x6d, 0x61, 0x72, 0x6b, 0x5f, 0x76, 0x69,
	0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x74, 0x72, 0x65, 0x6e, 0x64, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x01, 0x48, 0x04, 0x52, 0x20, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79,
	0x42, 0x65, 0x6e, 0x63, 0x68, 0x6d, 0x61, 0x72, 0x6b, 0x56, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6c,
	0x69, 0x74, 0x79, 0x54, 0x72, 0x65, 0x6e, 0x64, 0x88, 0x01, 0x01, 0x42, 0x16, 0x0a, 0x14, 0x5f,
	0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x63,
	0x6f, 0x64, 0x65, 0x42, 0x15, 0x0a, 0x13, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x63,
	0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x5f, 0x69, 0x64, 0x42, 0x11, 0x0a, 0x0f, 0x5f, 0x74,
	0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x1f, 0x0a,
	0x1d, 0x5f, 0x79, 0x6f, 0x75, 0x72, 0x5f, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x5f, 0x76, 0x69,
	0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x74, 0x72, 0x65, 0x6e, 0x64, 0x42, 0x26,
	0x0a, 0x24, 0x5f, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x5f, 0x62, 0x65, 0x6e, 0x63,
	0x68, 0x6d, 0x61, 0x72, 0x6b, 0x5f, 0x76, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79,
	0x5f, 0x74, 0x72, 0x65, 0x6e, 0x64, 0x22, 0x65, 0x0a, 0x0f, 0x4d, 0x61, 0x72, 0x6b, 0x65, 0x74,
	0x69, 0x6e, 0x67, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x22, 0x52, 0x0a, 0x13, 0x4d, 0x61, 0x72,
	0x6b, 0x65, 0x74, 0x69, 0x6e, 0x67, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x45, 0x6e, 0x75, 0x6d,
	0x12, 0x25, 0x0a, 0x21, 0x4d, 0x41, 0x52, 0x4b, 0x45, 0x54, 0x49, 0x4e, 0x47, 0x5f, 0x4d, 0x45,
	0x54, 0x48, 0x4f, 0x44, 0x5f, 0x45, 0x4e, 0x55, 0x4d, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x4f, 0x52, 0x47, 0x41, 0x4e,
	0x49, 0x43, 0x10, 0x01, 0x12, 0x07, 0x0a, 0x03, 0x41, 0x44, 0x53, 0x10, 0x02, 0x22, 0x6e, 0x0a,
	0x11, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x47, 0x72, 0x61, 0x6e, 0x75, 0x6c, 0x61, 0x72, 0x69,
	0x74, 0x79, 0x22, 0x59, 0x0a, 0x15, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x47, 0x72, 0x61, 0x6e,
	0x75, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79, 0x45, 0x6e, 0x75, 0x6d, 0x12, 0x27, 0x0a, 0x23, 0x52,
	0x45, 0x50, 0x4f, 0x52, 0x54, 0x5f, 0x47, 0x52, 0x41, 0x4e, 0x55, 0x4c, 0x41, 0x52, 0x49, 0x54,
	0x59, 0x5f, 0x45, 0x4e, 0x55, 0x4d, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x57, 0x45, 0x45, 0x4b, 0x4c, 0x59, 0x10, 0x01,
	0x12, 0x0b, 0x0a, 0x07, 0x4d, 0x4f, 0x4e, 0x54, 0x48, 0x4c, 0x59, 0x10, 0x02, 0x22, 0x88, 0x01,
	0x0a, 0x0e, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x44, 0x65, 0x6d, 0x61, 0x6e, 0x64,
	0x22, 0x76, 0x0a, 0x12, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x44, 0x65, 0x6d, 0x61,
	0x6e, 0x64, 0x45, 0x6e, 0x75, 0x6d, 0x12, 0x24, 0x0a, 0x20, 0x52, 0x45, 0x4c, 0x41, 0x54, 0x49,
	0x56, 0x45, 0x5f, 0x44, 0x45, 0x4d, 0x41, 0x4e, 0x44, 0x5f, 0x45, 0x4e, 0x55, 0x4d, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08,
	0x56, 0x45, 0x52, 0x59, 0x5f, 0x4c, 0x4f, 0x57, 0x10, 0x0a, 0x12, 0x07, 0x0a, 0x03, 0x4c, 0x4f,
	0x57, 0x10, 0x14, 0x12, 0x0a, 0x0a, 0x06, 0x4d, 0x45, 0x44, 0x49, 0x55, 0x4d, 0x10, 0x1e, 0x12,
	0x08, 0x0a, 0x04, 0x48, 0x49, 0x47, 0x48, 0x10, 0x28, 0x12, 0x0d, 0x0a, 0x09, 0x56, 0x45, 0x52,
	0x59, 0x5f, 0x48, 0x49, 0x47, 0x48, 0x10, 0x32, 0x22, 0x8d, 0x01, 0x0a, 0x18, 0x52, 0x65, 0x6c,
	0x61, 0x74, 0x69, 0x76, 0x65, 0x44, 0x65, 0x6d, 0x61, 0x6e, 0x64, 0x43, 0x68, 0x61, 0x6e, 0x67,
	0x65, 0x54, 0x79, 0x70, 0x65, 0x22, 0x71, 0x0a, 0x1c, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x76,
	0x65, 0x44, 0x65, 0x6d, 0x61, 0x6e, 0x64, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x54, 0x79, 0x70,
	0x65, 0x45, 0x6e, 0x75, 0x6d, 0x12, 0x30, 0x0a, 0x2c, 0x52, 0x45, 0x4c, 0x41, 0x54, 0x49, 0x56,
	0x45, 0x5f, 0x44, 0x45, 0x4d, 0x41, 0x4e, 0x44, 0x5f, 0x43, 0x48, 0x41, 0x4e, 0x47, 0x45, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x45, 0x4e, 0x55, 0x4d, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x49, 0x4e, 0x4b, 0x45,
	0x52, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x46, 0x4c, 0x41, 0x54, 0x10, 0x02, 0x12, 0x09, 0x0a,
	0x05, 0x52, 0x49, 0x53, 0x45, 0x52, 0x10, 0x03, 0x22, 0x68, 0x0a, 0x0d, 0x54, 0x72, 0x61, 0x66,
	0x66, 0x69, 0x63, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0x57, 0x0a, 0x11, 0x54, 0x72, 0x61,
	0x66, 0x66, 0x69, 0x63, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x45, 0x6e, 0x75, 0x6d, 0x12, 0x23,
	0x0a, 0x1f, 0x54, 0x52, 0x41, 0x46, 0x46, 0x49, 0x43, 0x5f, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45,
	0x5f, 0x45, 0x4e, 0x55, 0x4d, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x4f, 0x52, 0x47, 0x41, 0x4e, 0x49, 0x43, 0x10, 0x01,
	0x12, 0x07, 0x0a, 0x03, 0x41, 0x44, 0x53, 0x10, 0x02, 0x12, 0x07, 0x0a, 0x03, 0x41, 0x4c, 0x4c,
	0x10, 0x03, 0x32, 0x9c, 0x02, 0x0a, 0x0d, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x12, 0xc1, 0x01, 0x0a, 0x06, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x12,
	0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x72, 0x65, 0x70, 0x6f, 0x72,
	0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61,
	0x6e, 0x74, 0x2e, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x46, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x37, 0x3a, 0x01, 0x2a, 0x22, 0x32, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x61, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74,
	0x73, 0x3a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x1a, 0x47, 0xca, 0x41, 0x1a, 0x6d, 0x65, 0x72,
	0x63, 0x68, 0x61, 0x6e, 0x74, 0x61, 0x70, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x27, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a,
	0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x42, 0x8a, 0x01, 0x0a, 0x2b, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61,
	0x6e, 0x74, 0x2e, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x42, 0x0c, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50,
	0x01, 0x5a, 0x4b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2f,
	0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73,
	0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x72,
	0x74, 0x73, 0x70, 0x62, 0x3b, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x70, 0x62, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_shopping_merchant_reports_v1beta_reports_proto_rawDescOnce sync.Once
	file_google_shopping_merchant_reports_v1beta_reports_proto_rawDescData = file_google_shopping_merchant_reports_v1beta_reports_proto_rawDesc
)

func file_google_shopping_merchant_reports_v1beta_reports_proto_rawDescGZIP() []byte {
	file_google_shopping_merchant_reports_v1beta_reports_proto_rawDescOnce.Do(func() {
		file_google_shopping_merchant_reports_v1beta_reports_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_shopping_merchant_reports_v1beta_reports_proto_rawDescData)
	})
	return file_google_shopping_merchant_reports_v1beta_reports_proto_rawDescData
}

var file_google_shopping_merchant_reports_v1beta_reports_proto_enumTypes = make([]protoimpl.EnumInfo, 11)
var file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes = make([]protoimpl.MessageInfo, 22)
var file_google_shopping_merchant_reports_v1beta_reports_proto_goTypes = []interface{}{
	(ProductView_AggregatedReportingContextStatus)(0),                                // 0: google.shopping.merchant.reports.v1beta.ProductView.AggregatedReportingContextStatus
	(ProductView_ClickPotential)(0),                                                  // 1: google.shopping.merchant.reports.v1beta.ProductView.ClickPotential
	(ProductView_ItemIssue_ItemIssueResolution)(0),                                   // 2: google.shopping.merchant.reports.v1beta.ProductView.ItemIssue.ItemIssueResolution
	(ProductView_ItemIssue_ItemIssueSeverity_AggregatedIssueSeverity)(0),             // 3: google.shopping.merchant.reports.v1beta.ProductView.ItemIssue.ItemIssueSeverity.AggregatedIssueSeverity
	(PriceInsightsProductView_Effectiveness)(0),                                      // 4: google.shopping.merchant.reports.v1beta.PriceInsightsProductView.Effectiveness
	(BestSellersProductClusterView_InventoryStatus)(0),                               // 5: google.shopping.merchant.reports.v1beta.BestSellersProductClusterView.InventoryStatus
	(MarketingMethod_MarketingMethodEnum)(0),                                         // 6: google.shopping.merchant.reports.v1beta.MarketingMethod.MarketingMethodEnum
	(ReportGranularity_ReportGranularityEnum)(0),                                     // 7: google.shopping.merchant.reports.v1beta.ReportGranularity.ReportGranularityEnum
	(RelativeDemand_RelativeDemandEnum)(0),                                           // 8: google.shopping.merchant.reports.v1beta.RelativeDemand.RelativeDemandEnum
	(RelativeDemandChangeType_RelativeDemandChangeTypeEnum)(0),                       // 9: google.shopping.merchant.reports.v1beta.RelativeDemandChangeType.RelativeDemandChangeTypeEnum
	(TrafficSource_TrafficSourceEnum)(0),                                             // 10: google.shopping.merchant.reports.v1beta.TrafficSource.TrafficSourceEnum
	(*SearchRequest)(nil),                                                            // 11: google.shopping.merchant.reports.v1beta.SearchRequest
	(*SearchResponse)(nil),                                                           // 12: google.shopping.merchant.reports.v1beta.SearchResponse
	(*ReportRow)(nil),                                                                // 13: google.shopping.merchant.reports.v1beta.ReportRow
	(*ProductPerformanceView)(nil),                                                   // 14: google.shopping.merchant.reports.v1beta.ProductPerformanceView
	(*ProductView)(nil),                                                              // 15: google.shopping.merchant.reports.v1beta.ProductView
	(*PriceCompetitivenessProductView)(nil),                                          // 16: google.shopping.merchant.reports.v1beta.PriceCompetitivenessProductView
	(*PriceInsightsProductView)(nil),                                                 // 17: google.shopping.merchant.reports.v1beta.PriceInsightsProductView
	(*BestSellersProductClusterView)(nil),                                            // 18: google.shopping.merchant.reports.v1beta.BestSellersProductClusterView
	(*BestSellersBrandView)(nil),                                                     // 19: google.shopping.merchant.reports.v1beta.BestSellersBrandView
	(*NonProductPerformanceView)(nil),                                                // 20: google.shopping.merchant.reports.v1beta.NonProductPerformanceView
	(*CompetitiveVisibilityCompetitorView)(nil),                                      // 21: google.shopping.merchant.reports.v1beta.CompetitiveVisibilityCompetitorView
	(*CompetitiveVisibilityTopMerchantView)(nil),                                     // 22: google.shopping.merchant.reports.v1beta.CompetitiveVisibilityTopMerchantView
	(*CompetitiveVisibilityBenchmarkView)(nil),                                       // 23: google.shopping.merchant.reports.v1beta.CompetitiveVisibilityBenchmarkView
	(*MarketingMethod)(nil),                                                          // 24: google.shopping.merchant.reports.v1beta.MarketingMethod
	(*ReportGranularity)(nil),                                                        // 25: google.shopping.merchant.reports.v1beta.ReportGranularity
	(*RelativeDemand)(nil),                                                           // 26: google.shopping.merchant.reports.v1beta.RelativeDemand
	(*RelativeDemandChangeType)(nil),                                                 // 27: google.shopping.merchant.reports.v1beta.RelativeDemandChangeType
	(*TrafficSource)(nil),                                                            // 28: google.shopping.merchant.reports.v1beta.TrafficSource
	(*ProductView_ItemIssue)(nil),                                                    // 29: google.shopping.merchant.reports.v1beta.ProductView.ItemIssue
	(*ProductView_ItemIssue_ItemIssueType)(nil),                                      // 30: google.shopping.merchant.reports.v1beta.ProductView.ItemIssue.ItemIssueType
	(*ProductView_ItemIssue_ItemIssueSeverity)(nil),                                  // 31: google.shopping.merchant.reports.v1beta.ProductView.ItemIssue.ItemIssueSeverity
	(*ProductView_ItemIssue_ItemIssueSeverity_IssueSeverityPerReportingContext)(nil), // 32: google.shopping.merchant.reports.v1beta.ProductView.ItemIssue.ItemIssueSeverity.IssueSeverityPerReportingContext
	(*date.Date)(nil),                                                                // 33: google.type.Date
	(*typepb.Price)(nil),                                                             // 34: google.shopping.type.Price
	(typepb.Channel_ChannelEnum)(0),                                                  // 35: google.shopping.type.Channel.ChannelEnum
	(*timestamppb.Timestamp)(nil),                                                    // 36: google.protobuf.Timestamp
	(typepb.ReportingContext_ReportingContextEnum)(0),                                // 37: google.shopping.type.ReportingContext.ReportingContextEnum
}
var file_google_shopping_merchant_reports_v1beta_reports_proto_depIdxs = []int32{
	13, // 0: google.shopping.merchant.reports.v1beta.SearchResponse.results:type_name -> google.shopping.merchant.reports.v1beta.ReportRow
	14, // 1: google.shopping.merchant.reports.v1beta.ReportRow.product_performance_view:type_name -> google.shopping.merchant.reports.v1beta.ProductPerformanceView
	20, // 2: google.shopping.merchant.reports.v1beta.ReportRow.non_product_performance_view:type_name -> google.shopping.merchant.reports.v1beta.NonProductPerformanceView
	15, // 3: google.shopping.merchant.reports.v1beta.ReportRow.product_view:type_name -> google.shopping.merchant.reports.v1beta.ProductView
	16, // 4: google.shopping.merchant.reports.v1beta.ReportRow.price_competitiveness_product_view:type_name -> google.shopping.merchant.reports.v1beta.PriceCompetitivenessProductView
	17, // 5: google.shopping.merchant.reports.v1beta.ReportRow.price_insights_product_view:type_name -> google.shopping.merchant.reports.v1beta.PriceInsightsProductView
	18, // 6: google.shopping.merchant.reports.v1beta.ReportRow.best_sellers_product_cluster_view:type_name -> google.shopping.merchant.reports.v1beta.BestSellersProductClusterView
	19, // 7: google.shopping.merchant.reports.v1beta.ReportRow.best_sellers_brand_view:type_name -> google.shopping.merchant.reports.v1beta.BestSellersBrandView
	21, // 8: google.shopping.merchant.reports.v1beta.ReportRow.competitive_visibility_competitor_view:type_name -> google.shopping.merchant.reports.v1beta.CompetitiveVisibilityCompetitorView
	22, // 9: google.shopping.merchant.reports.v1beta.ReportRow.competitive_visibility_top_merchant_view:type_name -> google.shopping.merchant.reports.v1beta.CompetitiveVisibilityTopMerchantView
	23, // 10: google.shopping.merchant.reports.v1beta.ReportRow.competitive_visibility_benchmark_view:type_name -> google.shopping.merchant.reports.v1beta.CompetitiveVisibilityBenchmarkView
	6,  // 11: google.shopping.merchant.reports.v1beta.ProductPerformanceView.marketing_method:type_name -> google.shopping.merchant.reports.v1beta.MarketingMethod.MarketingMethodEnum
	33, // 12: google.shopping.merchant.reports.v1beta.ProductPerformanceView.date:type_name -> google.type.Date
	33, // 13: google.shopping.merchant.reports.v1beta.ProductPerformanceView.week:type_name -> google.type.Date
	34, // 14: google.shopping.merchant.reports.v1beta.ProductPerformanceView.conversion_value:type_name -> google.shopping.type.Price
	35, // 15: google.shopping.merchant.reports.v1beta.ProductView.channel:type_name -> google.shopping.type.Channel.ChannelEnum
	34, // 16: google.shopping.merchant.reports.v1beta.ProductView.price:type_name -> google.shopping.type.Price
	36, // 17: google.shopping.merchant.reports.v1beta.ProductView.creation_time:type_name -> google.protobuf.Timestamp
	33, // 18: google.shopping.merchant.reports.v1beta.ProductView.expiration_date:type_name -> google.type.Date
	0,  // 19: google.shopping.merchant.reports.v1beta.ProductView.aggregated_reporting_context_status:type_name -> google.shopping.merchant.reports.v1beta.ProductView.AggregatedReportingContextStatus
	29, // 20: google.shopping.merchant.reports.v1beta.ProductView.item_issues:type_name -> google.shopping.merchant.reports.v1beta.ProductView.ItemIssue
	1,  // 21: google.shopping.merchant.reports.v1beta.ProductView.click_potential:type_name -> google.shopping.merchant.reports.v1beta.ProductView.ClickPotential
	34, // 22: google.shopping.merchant.reports.v1beta.PriceCompetitivenessProductView.price:type_name -> google.shopping.type.Price
	34, // 23: google.shopping.merchant.reports.v1beta.PriceCompetitivenessProductView.benchmark_price:type_name -> google.shopping.type.Price
	34, // 24: google.shopping.merchant.reports.v1beta.PriceInsightsProductView.price:type_name -> google.shopping.type.Price
	34, // 25: google.shopping.merchant.reports.v1beta.PriceInsightsProductView.suggested_price:type_name -> google.shopping.type.Price
	4,  // 26: google.shopping.merchant.reports.v1beta.PriceInsightsProductView.effectiveness:type_name -> google.shopping.merchant.reports.v1beta.PriceInsightsProductView.Effectiveness
	33, // 27: google.shopping.merchant.reports.v1beta.BestSellersProductClusterView.report_date:type_name -> google.type.Date
	7,  // 28: google.shopping.merchant.reports.v1beta.BestSellersProductClusterView.report_granularity:type_name -> google.shopping.merchant.reports.v1beta.ReportGranularity.ReportGranularityEnum
	5,  // 29: google.shopping.merchant.reports.v1beta.BestSellersProductClusterView.inventory_status:type_name -> google.shopping.merchant.reports.v1beta.BestSellersProductClusterView.InventoryStatus
	5,  // 30: google.shopping.merchant.reports.v1beta.BestSellersProductClusterView.brand_inventory_status:type_name -> google.shopping.merchant.reports.v1beta.BestSellersProductClusterView.InventoryStatus
	8,  // 31: google.shopping.merchant.reports.v1beta.BestSellersProductClusterView.relative_demand:type_name -> google.shopping.merchant.reports.v1beta.RelativeDemand.RelativeDemandEnum
	8,  // 32: google.shopping.merchant.reports.v1beta.BestSellersProductClusterView.previous_relative_demand:type_name -> google.shopping.merchant.reports.v1beta.RelativeDemand.RelativeDemandEnum
	9,  // 33: google.shopping.merchant.reports.v1beta.BestSellersProductClusterView.relative_demand_change:type_name -> google.shopping.merchant.reports.v1beta.RelativeDemandChangeType.RelativeDemandChangeTypeEnum
	33, // 34: google.shopping.merchant.reports.v1beta.BestSellersBrandView.report_date:type_name -> google.type.Date
	7,  // 35: google.shopping.merchant.reports.v1beta.BestSellersBrandView.report_granularity:type_name -> google.shopping.merchant.reports.v1beta.ReportGranularity.ReportGranularityEnum
	8,  // 36: google.shopping.merchant.reports.v1beta.BestSellersBrandView.relative_demand:type_name -> google.shopping.merchant.reports.v1beta.RelativeDemand.RelativeDemandEnum
	8,  // 37: google.shopping.merchant.reports.v1beta.BestSellersBrandView.previous_relative_demand:type_name -> google.shopping.merchant.reports.v1beta.RelativeDemand.RelativeDemandEnum
	9,  // 38: google.shopping.merchant.reports.v1beta.BestSellersBrandView.relative_demand_change:type_name -> google.shopping.merchant.reports.v1beta.RelativeDemandChangeType.RelativeDemandChangeTypeEnum
	33, // 39: google.shopping.merchant.reports.v1beta.NonProductPerformanceView.date:type_name -> google.type.Date
	33, // 40: google.shopping.merchant.reports.v1beta.NonProductPerformanceView.week:type_name -> google.type.Date
	33, // 41: google.shopping.merchant.reports.v1beta.CompetitiveVisibilityCompetitorView.date:type_name -> google.type.Date
	10, // 42: google.shopping.merchant.reports.v1beta.CompetitiveVisibilityCompetitorView.traffic_source:type_name -> google.shopping.merchant.reports.v1beta.TrafficSource.TrafficSourceEnum
	33, // 43: google.shopping.merchant.reports.v1beta.CompetitiveVisibilityTopMerchantView.date:type_name -> google.type.Date
	10, // 44: google.shopping.merchant.reports.v1beta.CompetitiveVisibilityTopMerchantView.traffic_source:type_name -> google.shopping.merchant.reports.v1beta.TrafficSource.TrafficSourceEnum
	33, // 45: google.shopping.merchant.reports.v1beta.CompetitiveVisibilityBenchmarkView.date:type_name -> google.type.Date
	10, // 46: google.shopping.merchant.reports.v1beta.CompetitiveVisibilityBenchmarkView.traffic_source:type_name -> google.shopping.merchant.reports.v1beta.TrafficSource.TrafficSourceEnum
	30, // 47: google.shopping.merchant.reports.v1beta.ProductView.ItemIssue.type:type_name -> google.shopping.merchant.reports.v1beta.ProductView.ItemIssue.ItemIssueType
	31, // 48: google.shopping.merchant.reports.v1beta.ProductView.ItemIssue.severity:type_name -> google.shopping.merchant.reports.v1beta.ProductView.ItemIssue.ItemIssueSeverity
	2,  // 49: google.shopping.merchant.reports.v1beta.ProductView.ItemIssue.resolution:type_name -> google.shopping.merchant.reports.v1beta.ProductView.ItemIssue.ItemIssueResolution
	32, // 50: google.shopping.merchant.reports.v1beta.ProductView.ItemIssue.ItemIssueSeverity.severity_per_reporting_context:type_name -> google.shopping.merchant.reports.v1beta.ProductView.ItemIssue.ItemIssueSeverity.IssueSeverityPerReportingContext
	3,  // 51: google.shopping.merchant.reports.v1beta.ProductView.ItemIssue.ItemIssueSeverity.aggregated_severity:type_name -> google.shopping.merchant.reports.v1beta.ProductView.ItemIssue.ItemIssueSeverity.AggregatedIssueSeverity
	37, // 52: google.shopping.merchant.reports.v1beta.ProductView.ItemIssue.ItemIssueSeverity.IssueSeverityPerReportingContext.reporting_context:type_name -> google.shopping.type.ReportingContext.ReportingContextEnum
	11, // 53: google.shopping.merchant.reports.v1beta.ReportService.Search:input_type -> google.shopping.merchant.reports.v1beta.SearchRequest
	12, // 54: google.shopping.merchant.reports.v1beta.ReportService.Search:output_type -> google.shopping.merchant.reports.v1beta.SearchResponse
	54, // [54:55] is the sub-list for method output_type
	53, // [53:54] is the sub-list for method input_type
	53, // [53:53] is the sub-list for extension type_name
	53, // [53:53] is the sub-list for extension extendee
	0,  // [0:53] is the sub-list for field type_name
}

func init() { file_google_shopping_merchant_reports_v1beta_reports_proto_init() }
func file_google_shopping_merchant_reports_v1beta_reports_proto_init() {
	if File_google_shopping_merchant_reports_v1beta_reports_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReportRow); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProductPerformanceView); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProductView); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PriceCompetitivenessProductView); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PriceInsightsProductView); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BestSellersProductClusterView); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BestSellersBrandView); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NonProductPerformanceView); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CompetitiveVisibilityCompetitorView); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CompetitiveVisibilityTopMerchantView); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CompetitiveVisibilityBenchmarkView); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MarketingMethod); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReportGranularity); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RelativeDemand); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RelativeDemandChangeType); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TrafficSource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProductView_ItemIssue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProductView_ItemIssue_ItemIssueType); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProductView_ItemIssue_ItemIssueSeverity); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProductView_ItemIssue_ItemIssueSeverity_IssueSeverityPerReportingContext); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[3].OneofWrappers = []interface{}{}
	file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[4].OneofWrappers = []interface{}{}
	file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[5].OneofWrappers = []interface{}{}
	file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[6].OneofWrappers = []interface{}{}
	file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[7].OneofWrappers = []interface{}{}
	file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[8].OneofWrappers = []interface{}{}
	file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[9].OneofWrappers = []interface{}{}
	file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[10].OneofWrappers = []interface{}{}
	file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[11].OneofWrappers = []interface{}{}
	file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[12].OneofWrappers = []interface{}{}
	file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[18].OneofWrappers = []interface{}{}
	file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[19].OneofWrappers = []interface{}{}
	file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[20].OneofWrappers = []interface{}{}
	file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes[21].OneofWrappers = []interface{}{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_shopping_merchant_reports_v1beta_reports_proto_rawDesc,
			NumEnums:      11,
			NumMessages:   22,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_shopping_merchant_reports_v1beta_reports_proto_goTypes,
		DependencyIndexes: file_google_shopping_merchant_reports_v1beta_reports_proto_depIdxs,
		EnumInfos:         file_google_shopping_merchant_reports_v1beta_reports_proto_enumTypes,
		MessageInfos:      file_google_shopping_merchant_reports_v1beta_reports_proto_msgTypes,
	}.Build()
	File_google_shopping_merchant_reports_v1beta_reports_proto = out.File
	file_google_shopping_merchant_reports_v1beta_reports_proto_rawDesc = nil
	file_google_shopping_merchant_reports_v1beta_reports_proto_goTypes = nil
	file_google_shopping_merchant_reports_v1beta_reports_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ReportServiceClient is the client API for ReportService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ReportServiceClient interface {
	// Retrieves a report defined by a search query. The response might contain
	// fewer rows than specified by `page_size`. Rely on `next_page_token` to
	// determine if there are more rows to be requested.
	Search(ctx context.Context, in *SearchRequest, opts ...grpc.CallOption) (*SearchResponse, error)
}

type reportServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewReportServiceClient(cc grpc.ClientConnInterface) ReportServiceClient {
	return &reportServiceClient{cc}
}

func (c *reportServiceClient) Search(ctx context.Context, in *SearchRequest, opts ...grpc.CallOption) (*SearchResponse, error) {
	out := new(SearchResponse)
	err := c.cc.Invoke(ctx, "/google.shopping.merchant.reports.v1beta.ReportService/Search", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ReportServiceServer is the server API for ReportService service.
type ReportServiceServer interface {
	// Retrieves a report defined by a search query. The response might contain
	// fewer rows than specified by `page_size`. Rely on `next_page_token` to
	// determine if there are more rows to be requested.
	Search(context.Context, *SearchRequest) (*SearchResponse, error)
}

// UnimplementedReportServiceServer can be embedded to have forward compatible implementations.
type UnimplementedReportServiceServer struct {
}

func (*UnimplementedReportServiceServer) Search(context.Context, *SearchRequest) (*SearchResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Search not implemented")
}

func RegisterReportServiceServer(s *grpc.Server, srv ReportServiceServer) {
	s.RegisterService(&_ReportService_serviceDesc, srv)
}

func _ReportService_Search_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReportServiceServer).Search(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.shopping.merchant.reports.v1beta.ReportService/Search",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReportServiceServer).Search(ctx, req.(*SearchRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ReportService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.shopping.merchant.reports.v1beta.ReportService",
	HandlerType: (*ReportServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Search",
			Handler:    _ReportService_Search_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/shopping/merchant/reports/v1beta/reports.proto",
}
