
/*** DO NOT EDIT THIS FILE DIRECTLY (use ../config/gen_code.sh to generate) ***/

#ifndef hypre_UTILITIES_MUP_HEADER
#define hypre_UTILITIES_MUP_HEADER

#ifdef __cplusplus
extern "C" {
#endif

#if defined (HYPRE_MIXED_PRECISION)

/*** DO NOT EDIT THIS FILE DIRECTLY (use ../config/gen_code.sh to generate) ***/

/******************************************************************************
 * Copyright (c) 1998 Lawrence Livermore National Security, LLC and other
 * HYPRE Project Developers. See the top-level COPYRIGHT file for details.
 *
 * SPDX-License-Identifier: (Apache-2.0 OR MIT)
 ******************************************************************************/


HYPRE_Int
hypre_BeginTiming_fcn_flt( HYPRE_Int time_index );
HYPRE_Int
hypre_BeginTiming_fcn_dbl( HYPRE_Int time_index );
HYPRE_Int
hypre_BeginTiming_fcn_long_dbl( HYPRE_Int time_index );

HYPRE_Int
hypre_BigBinarySearch_flt( HYPRE_BigInt *list, HYPRE_BigInt value, HYPRE_Int list_length );
HYPRE_Int
hypre_BigBinarySearch_dbl( HYPRE_BigInt *list, HYPRE_BigInt value, HYPRE_Int list_length );
HYPRE_Int
hypre_BigBinarySearch_long_dbl( HYPRE_BigInt *list, HYPRE_BigInt value, HYPRE_Int list_length );

HYPRE_BigInt *
hypre_BigLowerBound_flt( HYPRE_BigInt *first, HYPRE_BigInt *last, HYPRE_BigInt value );
HYPRE_BigInt *
hypre_BigLowerBound_dbl( HYPRE_BigInt *first, HYPRE_BigInt *last, HYPRE_BigInt value );
HYPRE_BigInt *
hypre_BigLowerBound_long_dbl( HYPRE_BigInt *first, HYPRE_BigInt *last, HYPRE_BigInt value );

void
hypre_BigQsort0_flt( HYPRE_BigInt *v, HYPRE_Int left, HYPRE_Int right );
void
hypre_BigQsort0_dbl( HYPRE_BigInt *v, HYPRE_Int left, HYPRE_Int right );
void
hypre_BigQsort0_long_dbl( HYPRE_BigInt *v, HYPRE_Int left, HYPRE_Int right );

void
hypre_BigQsort1_flt( HYPRE_BigInt *v, hypre_float *w, HYPRE_Int left, HYPRE_Int right );
void
hypre_BigQsort1_dbl( HYPRE_BigInt *v, hypre_double *w, HYPRE_Int left, HYPRE_Int right );
void
hypre_BigQsort1_long_dbl( HYPRE_BigInt *v, hypre_long_double *w, HYPRE_Int left, HYPRE_Int right );

void
hypre_BigQsort2i_flt( HYPRE_BigInt *v, HYPRE_Int *w, HYPRE_Int left, HYPRE_Int right );
void
hypre_BigQsort2i_dbl( HYPRE_BigInt *v, HYPRE_Int *w, HYPRE_Int left, HYPRE_Int right );
void
hypre_BigQsort2i_long_dbl( HYPRE_BigInt *v, HYPRE_Int *w, HYPRE_Int left, HYPRE_Int right );

void
hypre_BigQsort4_abs_flt( hypre_float *v, HYPRE_BigInt *w, HYPRE_Int *z, HYPRE_Int *y, HYPRE_Int left, HYPRE_Int right );
void
hypre_BigQsort4_abs_dbl( hypre_double *v, HYPRE_BigInt *w, HYPRE_Int *z, HYPRE_Int *y, HYPRE_Int left, HYPRE_Int right );
void
hypre_BigQsort4_abs_long_dbl( hypre_long_double *v, HYPRE_BigInt *w, HYPRE_Int *z, HYPRE_Int *y, HYPRE_Int left, HYPRE_Int right );

void
hypre_BigQsortb2i_flt( HYPRE_BigInt *v, HYPRE_Int *w, HYPRE_Int *z, HYPRE_Int left, HYPRE_Int right );
void
hypre_BigQsortb2i_dbl( HYPRE_BigInt *v, HYPRE_Int *w, HYPRE_Int *z, HYPRE_Int left, HYPRE_Int right );
void
hypre_BigQsortb2i_long_dbl( HYPRE_BigInt *v, HYPRE_Int *w, HYPRE_Int *z, HYPRE_Int left, HYPRE_Int right );

void
hypre_BigQsortbLoc_flt( HYPRE_BigInt *v, HYPRE_Int *w, HYPRE_Int left, HYPRE_Int right );
void
hypre_BigQsortbLoc_dbl( HYPRE_BigInt *v, HYPRE_Int *w, HYPRE_Int left, HYPRE_Int right );
void
hypre_BigQsortbLoc_long_dbl( HYPRE_BigInt *v, HYPRE_Int *w, HYPRE_Int left, HYPRE_Int right );

void
hypre_BigQsortbi_flt( HYPRE_BigInt *v, HYPRE_Int *w, HYPRE_Int left, HYPRE_Int right );
void
hypre_BigQsortbi_dbl( HYPRE_BigInt *v, HYPRE_Int *w, HYPRE_Int left, HYPRE_Int right );
void
hypre_BigQsortbi_long_dbl( HYPRE_BigInt *v, HYPRE_Int *w, HYPRE_Int left, HYPRE_Int right );

void
hypre_BigSwap_flt( HYPRE_BigInt *v, HYPRE_Int i, HYPRE_Int j );
void
hypre_BigSwap_dbl( HYPRE_BigInt *v, HYPRE_Int i, HYPRE_Int j );
void
hypre_BigSwap_long_dbl( HYPRE_BigInt *v, HYPRE_Int i, HYPRE_Int j );

void
hypre_BigSwap2_flt( HYPRE_BigInt *v, hypre_float *w, HYPRE_Int i, HYPRE_Int j );
void
hypre_BigSwap2_dbl( HYPRE_BigInt *v, hypre_double *w, HYPRE_Int i, HYPRE_Int j );
void
hypre_BigSwap2_long_dbl( HYPRE_BigInt *v, hypre_long_double *w, HYPRE_Int i, HYPRE_Int j );

void
hypre_BigSwap2i_flt( HYPRE_BigInt *v, HYPRE_Int *w, HYPRE_Int i, HYPRE_Int j );
void
hypre_BigSwap2i_dbl( HYPRE_BigInt *v, HYPRE_Int *w, HYPRE_Int i, HYPRE_Int j );
void
hypre_BigSwap2i_long_dbl( HYPRE_BigInt *v, HYPRE_Int *w, HYPRE_Int i, HYPRE_Int j );

void
hypre_BigSwap4_d_flt( hypre_float *v, HYPRE_BigInt *w, HYPRE_Int *z, HYPRE_Int *y, HYPRE_Int i, HYPRE_Int j );
void
hypre_BigSwap4_d_dbl( hypre_double *v, HYPRE_BigInt *w, HYPRE_Int *z, HYPRE_Int *y, HYPRE_Int i, HYPRE_Int j );
void
hypre_BigSwap4_d_long_dbl( hypre_long_double *v, HYPRE_BigInt *w, HYPRE_Int *z, HYPRE_Int *y, HYPRE_Int i, HYPRE_Int j );

void
hypre_BigSwapLoc_flt( HYPRE_BigInt *v, HYPRE_Int *w, HYPRE_Int i, HYPRE_Int j );
void
hypre_BigSwapLoc_dbl( HYPRE_BigInt *v, HYPRE_Int *w, HYPRE_Int i, HYPRE_Int j );
void
hypre_BigSwapLoc_long_dbl( HYPRE_BigInt *v, HYPRE_Int *w, HYPRE_Int i, HYPRE_Int j );

void
hypre_BigSwapb2i_flt( HYPRE_BigInt *v, HYPRE_Int *w, HYPRE_Int *z, HYPRE_Int i, HYPRE_Int j );
void
hypre_BigSwapb2i_dbl( HYPRE_BigInt *v, HYPRE_Int *w, HYPRE_Int *z, HYPRE_Int i, HYPRE_Int j );
void
hypre_BigSwapb2i_long_dbl( HYPRE_BigInt *v, HYPRE_Int *w, HYPRE_Int *z, HYPRE_Int i, HYPRE_Int j );

void
hypre_BigSwapbi_flt( HYPRE_BigInt *v, HYPRE_Int *w, HYPRE_Int i, HYPRE_Int j );
void
hypre_BigSwapbi_dbl( HYPRE_BigInt *v, HYPRE_Int *w, HYPRE_Int i, HYPRE_Int j );
void
hypre_BigSwapbi_long_dbl( HYPRE_BigInt *v, HYPRE_Int *w, HYPRE_Int i, HYPRE_Int j );

HYPRE_Int
hypre_BinarySearch_flt( HYPRE_Int *list, HYPRE_Int value, HYPRE_Int list_length );
HYPRE_Int
hypre_BinarySearch_dbl( HYPRE_Int *list, HYPRE_Int value, HYPRE_Int list_length );
HYPRE_Int
hypre_BinarySearch_long_dbl( HYPRE_Int *list, HYPRE_Int value, HYPRE_Int list_length );

HYPRE_Int
hypre_BinarySearch2_flt( HYPRE_Int *list, HYPRE_Int value, HYPRE_Int low, HYPRE_Int high, HYPRE_Int *spot );
HYPRE_Int
hypre_BinarySearch2_dbl( HYPRE_Int *list, HYPRE_Int value, HYPRE_Int low, HYPRE_Int high, HYPRE_Int *spot );
HYPRE_Int
hypre_BinarySearch2_long_dbl( HYPRE_Int *list, HYPRE_Int value, HYPRE_Int low, HYPRE_Int high, HYPRE_Int *spot );

void *
hypre_CAlloc_flt( size_t count, size_t elt_size, HYPRE_MemoryLocation location );
void *
hypre_CAlloc_dbl( size_t count, size_t elt_size, HYPRE_MemoryLocation location );
void *
hypre_CAlloc_long_dbl( size_t count, size_t elt_size, HYPRE_MemoryLocation location );

HYPRE_Int
hypre_CheckDirExists_flt( const char *path );
HYPRE_Int
hypre_CheckDirExists_dbl( const char *path );
HYPRE_Int
hypre_CheckDirExists_long_dbl( const char *path );

void
hypre_CheckMemoryLocation_flt( void *ptr, hypre_MemoryLocation location );
void
hypre_CheckMemoryLocation_dbl( void *ptr, hypre_MemoryLocation location );
void
hypre_CheckMemoryLocation_long_dbl( void *ptr, hypre_MemoryLocation location );

HYPRE_Int
hypre_ClearTiming_fcn_flt( void );
HYPRE_Int
hypre_ClearTiming_fcn_dbl( void );
HYPRE_Int
hypre_ClearTiming_fcn_long_dbl( void );

char*
hypre_ConvertIndicesToString_flt( HYPRE_Int size, HYPRE_Int *indices );
char*
hypre_ConvertIndicesToString_dbl( HYPRE_Int size, HYPRE_Int *indices );
char*
hypre_ConvertIndicesToString_long_dbl( HYPRE_Int size, HYPRE_Int *indices );

HYPRE_Int
hypre_CreateBinaryTree_flt( HYPRE_Int myid, HYPRE_Int num_procs, hypre_BinaryTree **tree_ptr );
HYPRE_Int
hypre_CreateBinaryTree_dbl( HYPRE_Int myid, HYPRE_Int num_procs, hypre_BinaryTree **tree_ptr );
HYPRE_Int
hypre_CreateBinaryTree_long_dbl( HYPRE_Int myid, HYPRE_Int num_procs, hypre_BinaryTree **tree_ptr );

HYPRE_Int
hypre_CreateDir_flt( const char *path );
HYPRE_Int
hypre_CreateDir_dbl( const char *path );
HYPRE_Int
hypre_CreateDir_long_dbl( const char *path );

HYPRE_Int
hypre_CreateNextDirOfSequence_flt( const char *basepath, const char *prefix, char **fullpath_ptr );
HYPRE_Int
hypre_CreateNextDirOfSequence_dbl( const char *basepath, const char *prefix, char **fullpath_ptr );
HYPRE_Int
hypre_CreateNextDirOfSequence_long_dbl( const char *basepath, const char *prefix, char **fullpath_ptr );

HYPRE_Int
hypre_DataExchangeList_flt( HYPRE_Int num_contacts, HYPRE_Int *contact_proc_list, void *contact_send_buf, HYPRE_Int *contact_send_buf_starts, HYPRE_Int contact_obj_size, HYPRE_Int response_obj_size, hypre_DataExchangeResponse *response_obj, HYPRE_Int max_response_size, HYPRE_Int rnum, MPI_Comm comm, void **p_response_recv_buf, HYPRE_Int **p_response_recv_buf_starts );
HYPRE_Int
hypre_DataExchangeList_dbl( HYPRE_Int num_contacts, HYPRE_Int *contact_proc_list, void *contact_send_buf, HYPRE_Int *contact_send_buf_starts, HYPRE_Int contact_obj_size, HYPRE_Int response_obj_size, hypre_DataExchangeResponse *response_obj, HYPRE_Int max_response_size, HYPRE_Int rnum, MPI_Comm comm, void **p_response_recv_buf, HYPRE_Int **p_response_recv_buf_starts );
HYPRE_Int
hypre_DataExchangeList_long_dbl( HYPRE_Int num_contacts, HYPRE_Int *contact_proc_list, void *contact_send_buf, HYPRE_Int *contact_send_buf_starts, HYPRE_Int contact_obj_size, HYPRE_Int response_obj_size, hypre_DataExchangeResponse *response_obj, HYPRE_Int max_response_size, HYPRE_Int rnum, MPI_Comm comm, void **p_response_recv_buf, HYPRE_Int **p_response_recv_buf_starts );

HYPRE_Int
hypre_DestroyBinaryTree_flt( hypre_BinaryTree *tree );
HYPRE_Int
hypre_DestroyBinaryTree_dbl( hypre_BinaryTree *tree );
HYPRE_Int
hypre_DestroyBinaryTree_long_dbl( hypre_BinaryTree *tree );

HYPRE_Int
hypre_DoubleQuickSplit_flt( hypre_float *values, HYPRE_Int *indices, HYPRE_Int list_length, HYPRE_Int NumberKept );
HYPRE_Int
hypre_DoubleQuickSplit_dbl( hypre_double *values, HYPRE_Int *indices, HYPRE_Int list_length, HYPRE_Int NumberKept );
HYPRE_Int
hypre_DoubleQuickSplit_long_dbl( hypre_long_double *values, HYPRE_Int *indices, HYPRE_Int list_length, HYPRE_Int NumberKept );

HYPRE_Int
hypre_EndTiming_fcn_flt( HYPRE_Int time_index );
HYPRE_Int
hypre_EndTiming_fcn_dbl( HYPRE_Int time_index );
HYPRE_Int
hypre_EndTiming_fcn_long_dbl( HYPRE_Int time_index );

HYPRE_Int
hypre_FinalizeAllTimings_fcn_flt( void );
HYPRE_Int
hypre_FinalizeAllTimings_fcn_dbl( void );
HYPRE_Int
hypre_FinalizeAllTimings_fcn_long_dbl( void );

HYPRE_Int
hypre_FinalizeTiming_fcn_flt( HYPRE_Int time_index );
HYPRE_Int
hypre_FinalizeTiming_fcn_dbl( HYPRE_Int time_index );
HYPRE_Int
hypre_FinalizeTiming_fcn_long_dbl( HYPRE_Int time_index );

HYPRE_Int
hypre_Finalized_flt( void );
HYPRE_Int
hypre_Finalized_dbl( void );
HYPRE_Int
hypre_Finalized_long_dbl( void );

void
hypre_Free_flt( void *ptr, HYPRE_MemoryLocation location );
void
hypre_Free_dbl( void *ptr, HYPRE_MemoryLocation location );
void
hypre_Free_long_dbl( void *ptr, HYPRE_MemoryLocation location );

HYPRE_Int
hypre_GetDevice_flt( hypre_int *device_id );
HYPRE_Int
hypre_GetDevice_dbl( hypre_int *device_id );
HYPRE_Int
hypre_GetDevice_long_dbl( hypre_int *device_id );

HYPRE_Int
hypre_GetDeviceCount_flt( hypre_int *device_count );
HYPRE_Int
hypre_GetDeviceCount_dbl( hypre_int *device_count );
HYPRE_Int
hypre_GetDeviceCount_long_dbl( hypre_int *device_count );

HYPRE_Int
hypre_GetDeviceGSMethod_flt( void );
HYPRE_Int
hypre_GetDeviceGSMethod_dbl( void );
HYPRE_Int
hypre_GetDeviceGSMethod_long_dbl( void );

HYPRE_Int
hypre_GetDeviceLastError_flt( void );
HYPRE_Int
hypre_GetDeviceLastError_dbl( void );
HYPRE_Int
hypre_GetDeviceLastError_long_dbl( void );

HYPRE_Int
hypre_GetDeviceMaxShmemSize_flt( hypre_int device_id, hypre_int *max_size_ptr, hypre_int *max_size_optin_ptr );
HYPRE_Int
hypre_GetDeviceMaxShmemSize_dbl( hypre_int device_id, hypre_int *max_size_ptr, hypre_int *max_size_optin_ptr );
HYPRE_Int
hypre_GetDeviceMaxShmemSize_long_dbl( hypre_int device_id, hypre_int *max_size_ptr, hypre_int *max_size_optin_ptr );

HYPRE_ExecutionPolicy
hypre_GetExecPolicy1_flt( HYPRE_MemoryLocation location );
HYPRE_ExecutionPolicy
hypre_GetExecPolicy1_dbl( HYPRE_MemoryLocation location );
HYPRE_ExecutionPolicy
hypre_GetExecPolicy1_long_dbl( HYPRE_MemoryLocation location );

HYPRE_ExecutionPolicy
hypre_GetExecPolicy2_flt( HYPRE_MemoryLocation location1, HYPRE_MemoryLocation location2 );
HYPRE_ExecutionPolicy
hypre_GetExecPolicy2_dbl( HYPRE_MemoryLocation location1, HYPRE_MemoryLocation location2 );
HYPRE_ExecutionPolicy
hypre_GetExecPolicy2_long_dbl( HYPRE_MemoryLocation location1, HYPRE_MemoryLocation location2 );

HYPRE_Int
hypre_GetGpuAwareMPI_flt( void );
HYPRE_Int
hypre_GetGpuAwareMPI_dbl( void );
HYPRE_Int
hypre_GetGpuAwareMPI_long_dbl( void );

HYPRE_Int
hypre_GetMemoryLocationName_flt( hypre_MemoryLocation memory_location, char *memory_location_name );
HYPRE_Int
hypre_GetMemoryLocationName_dbl( hypre_MemoryLocation memory_location, char *memory_location_name );
HYPRE_Int
hypre_GetMemoryLocationName_long_dbl( hypre_MemoryLocation memory_location, char *memory_location_name );

HYPRE_Int
hypre_GetPointerLocation_flt( const void *ptr, hypre_MemoryLocation *memory_location );
HYPRE_Int
hypre_GetPointerLocation_dbl( const void *ptr, hypre_MemoryLocation *memory_location );
HYPRE_Int
hypre_GetPointerLocation_long_dbl( const void *ptr, hypre_MemoryLocation *memory_location );

void
hypre_GetSimpleThreadPartition_flt( HYPRE_Int *begin, HYPRE_Int *end, HYPRE_Int n );
void
hypre_GetSimpleThreadPartition_dbl( HYPRE_Int *begin, HYPRE_Int *end, HYPRE_Int n );
void
hypre_GetSimpleThreadPartition_long_dbl( HYPRE_Int *begin, HYPRE_Int *end, HYPRE_Int n );

HYPRE_Int
hypre_GetTiming_fcn_flt( const char *heading, hypre_float *wall_time_ptr, MPI_Comm comm );
HYPRE_Int
hypre_GetTiming_fcn_dbl( const char *heading, hypre_double *wall_time_ptr, MPI_Comm comm );
HYPRE_Int
hypre_GetTiming_fcn_long_dbl( const char *heading, hypre_long_double *wall_time_ptr, MPI_Comm comm );

void
hypre_GpuProfilingPopRange_flt( void );
void
hypre_GpuProfilingPopRange_dbl( void );
void
hypre_GpuProfilingPopRange_long_dbl( void );

void
hypre_GpuProfilingPushRange_flt( const char *name );
void
hypre_GpuProfilingPushRange_dbl( const char *name );
void
hypre_GpuProfilingPushRange_long_dbl( const char *name );

void
hypre_GpuProfilingPushRangeColor_flt( const char *name, HYPRE_Int cid );
void
hypre_GpuProfilingPushRangeColor_dbl( const char *name, HYPRE_Int cid );
void
hypre_GpuProfilingPushRangeColor_long_dbl( const char *name, HYPRE_Int cid );

hypre_Handle*
hypre_HandleCreate_flt( void );
hypre_Handle*
hypre_HandleCreate_dbl( void );
hypre_Handle*
hypre_HandleCreate_long_dbl( void );

HYPRE_Int
hypre_HandleDestroy_flt( hypre_Handle *hypre_handle_ );
HYPRE_Int
hypre_HandleDestroy_dbl( hypre_Handle *hypre_handle_ );
HYPRE_Int
hypre_HandleDestroy_long_dbl( hypre_Handle *hypre_handle_ );

HYPRE_Int
hypre_HostMemoryGetUsage_flt( hypre_float *mem );
HYPRE_Int
hypre_HostMemoryGetUsage_dbl( hypre_double *mem );
HYPRE_Int
hypre_HostMemoryGetUsage_long_dbl( hypre_long_double *mem );

HYPRE_Int
hypre_IncFLOPCount_fcn_flt( HYPRE_BigInt inc );
HYPRE_Int
hypre_IncFLOPCount_fcn_dbl( HYPRE_BigInt inc );
HYPRE_Int
hypre_IncFLOPCount_fcn_long_dbl( HYPRE_BigInt inc );

HYPRE_Int
hypre_InitializeTiming_fcn_flt( const char *name );
HYPRE_Int
hypre_InitializeTiming_fcn_dbl( const char *name );
HYPRE_Int
hypre_InitializeTiming_fcn_long_dbl( const char *name );

HYPRE_Int
hypre_Initialized_flt( void );
HYPRE_Int
hypre_Initialized_dbl( void );
HYPRE_Int
hypre_Initialized_long_dbl( void );

hypre_IntArrayArray*
hypre_IntArrayArrayCreate_flt( HYPRE_Int num_entries, HYPRE_Int *sizes );
hypre_IntArrayArray*
hypre_IntArrayArrayCreate_dbl( HYPRE_Int num_entries, HYPRE_Int *sizes );
hypre_IntArrayArray*
hypre_IntArrayArrayCreate_long_dbl( HYPRE_Int num_entries, HYPRE_Int *sizes );

HYPRE_Int
hypre_IntArrayArrayDestroy_flt( hypre_IntArrayArray *w );
HYPRE_Int
hypre_IntArrayArrayDestroy_dbl( hypre_IntArrayArray *w );
HYPRE_Int
hypre_IntArrayArrayDestroy_long_dbl( hypre_IntArrayArray *w );

HYPRE_Int
hypre_IntArrayArrayInitialize_flt( hypre_IntArrayArray *w );
HYPRE_Int
hypre_IntArrayArrayInitialize_dbl( hypre_IntArrayArray *w );
HYPRE_Int
hypre_IntArrayArrayInitialize_long_dbl( hypre_IntArrayArray *w );

HYPRE_Int
hypre_IntArrayArrayInitializeIn_flt( hypre_IntArrayArray *w, HYPRE_MemoryLocation memory_location );
HYPRE_Int
hypre_IntArrayArrayInitializeIn_dbl( hypre_IntArrayArray *w, HYPRE_MemoryLocation memory_location );
HYPRE_Int
hypre_IntArrayArrayInitializeIn_long_dbl( hypre_IntArrayArray *w, HYPRE_MemoryLocation memory_location );

HYPRE_Int
hypre_IntArrayArrayMigrate_flt( hypre_IntArrayArray *w, HYPRE_MemoryLocation memory_location );
HYPRE_Int
hypre_IntArrayArrayMigrate_dbl( hypre_IntArrayArray *w, HYPRE_MemoryLocation memory_location );
HYPRE_Int
hypre_IntArrayArrayMigrate_long_dbl( hypre_IntArrayArray *w, HYPRE_MemoryLocation memory_location );

hypre_IntArray*
hypre_IntArrayCloneDeep_flt( hypre_IntArray *x );
hypre_IntArray*
hypre_IntArrayCloneDeep_dbl( hypre_IntArray *x );
hypre_IntArray*
hypre_IntArrayCloneDeep_long_dbl( hypre_IntArray *x );

hypre_IntArray*
hypre_IntArrayCloneDeep_v2_flt( hypre_IntArray *x, HYPRE_MemoryLocation memory_location );
hypre_IntArray*
hypre_IntArrayCloneDeep_v2_dbl( hypre_IntArray *x, HYPRE_MemoryLocation memory_location );
hypre_IntArray*
hypre_IntArrayCloneDeep_v2_long_dbl( hypre_IntArray *x, HYPRE_MemoryLocation memory_location );

HYPRE_Int
hypre_IntArrayCopy_flt( hypre_IntArray *x, hypre_IntArray *y );
HYPRE_Int
hypre_IntArrayCopy_dbl( hypre_IntArray *x, hypre_IntArray *y );
HYPRE_Int
hypre_IntArrayCopy_long_dbl( hypre_IntArray *x, hypre_IntArray *y );

HYPRE_Int
hypre_IntArrayCount_flt( hypre_IntArray *v, HYPRE_Int value, HYPRE_Int *num_values_ptr );
HYPRE_Int
hypre_IntArrayCount_dbl( hypre_IntArray *v, HYPRE_Int value, HYPRE_Int *num_values_ptr );
HYPRE_Int
hypre_IntArrayCount_long_dbl( hypre_IntArray *v, HYPRE_Int value, HYPRE_Int *num_values_ptr );

HYPRE_Int
hypre_IntArrayCountHost_flt( hypre_IntArray *v, HYPRE_Int value, HYPRE_Int *num_values_ptr );
HYPRE_Int
hypre_IntArrayCountHost_dbl( hypre_IntArray *v, HYPRE_Int value, HYPRE_Int *num_values_ptr );
HYPRE_Int
hypre_IntArrayCountHost_long_dbl( hypre_IntArray *v, HYPRE_Int value, HYPRE_Int *num_values_ptr );

hypre_IntArray*
hypre_IntArrayCreate_flt( HYPRE_Int size );
hypre_IntArray*
hypre_IntArrayCreate_dbl( HYPRE_Int size );
hypre_IntArray*
hypre_IntArrayCreate_long_dbl( HYPRE_Int size );

HYPRE_Int
hypre_IntArrayDestroy_flt( hypre_IntArray *array );
HYPRE_Int
hypre_IntArrayDestroy_dbl( hypre_IntArray *array );
HYPRE_Int
hypre_IntArrayDestroy_long_dbl( hypre_IntArray *array );

HYPRE_Int
hypre_IntArrayInitialize_flt( hypre_IntArray *array );
HYPRE_Int
hypre_IntArrayInitialize_dbl( hypre_IntArray *array );
HYPRE_Int
hypre_IntArrayInitialize_long_dbl( hypre_IntArray *array );

HYPRE_Int
hypre_IntArrayInitialize_v2_flt( hypre_IntArray *array, HYPRE_MemoryLocation memory_location );
HYPRE_Int
hypre_IntArrayInitialize_v2_dbl( hypre_IntArray *array, HYPRE_MemoryLocation memory_location );
HYPRE_Int
hypre_IntArrayInitialize_v2_long_dbl( hypre_IntArray *array, HYPRE_MemoryLocation memory_location );

HYPRE_Int
hypre_IntArrayInverseMapping_flt( hypre_IntArray *v, hypre_IntArray **w_ptr );
HYPRE_Int
hypre_IntArrayInverseMapping_dbl( hypre_IntArray *v, hypre_IntArray **w_ptr );
HYPRE_Int
hypre_IntArrayInverseMapping_long_dbl( hypre_IntArray *v, hypre_IntArray **w_ptr );

HYPRE_Int
hypre_IntArrayMergeOrdered_flt( hypre_IntArray *array1, hypre_IntArray *array2, hypre_IntArray *array3 );
HYPRE_Int
hypre_IntArrayMergeOrdered_dbl( hypre_IntArray *array1, hypre_IntArray *array2, hypre_IntArray *array3 );
HYPRE_Int
hypre_IntArrayMergeOrdered_long_dbl( hypre_IntArray *array1, hypre_IntArray *array2, hypre_IntArray *array3 );

HYPRE_Int
hypre_IntArrayMigrate_flt( hypre_IntArray *v, HYPRE_MemoryLocation memory_location );
HYPRE_Int
hypre_IntArrayMigrate_dbl( hypre_IntArray *v, HYPRE_MemoryLocation memory_location );
HYPRE_Int
hypre_IntArrayMigrate_long_dbl( hypre_IntArray *v, HYPRE_MemoryLocation memory_location );

HYPRE_Int
hypre_IntArrayNegate_flt( hypre_IntArray *v );
HYPRE_Int
hypre_IntArrayNegate_dbl( hypre_IntArray *v );
HYPRE_Int
hypre_IntArrayNegate_long_dbl( hypre_IntArray *v );

HYPRE_Int
hypre_IntArrayPrint_flt( MPI_Comm comm, hypre_IntArray *array, const char *filename );
HYPRE_Int
hypre_IntArrayPrint_dbl( MPI_Comm comm, hypre_IntArray *array, const char *filename );
HYPRE_Int
hypre_IntArrayPrint_long_dbl( MPI_Comm comm, hypre_IntArray *array, const char *filename );

HYPRE_Int
hypre_IntArrayRead_flt( MPI_Comm comm, const char *filename, hypre_IntArray **array_ptr );
HYPRE_Int
hypre_IntArrayRead_dbl( MPI_Comm comm, const char *filename, hypre_IntArray **array_ptr );
HYPRE_Int
hypre_IntArrayRead_long_dbl( MPI_Comm comm, const char *filename, hypre_IntArray **array_ptr );

HYPRE_Int
hypre_IntArraySeparateByValue_flt( HYPRE_Int num_values, HYPRE_Int *values, HYPRE_Int *sizes, hypre_IntArray *v, hypre_IntArrayArray **w_ptr );
HYPRE_Int
hypre_IntArraySeparateByValue_dbl( HYPRE_Int num_values, HYPRE_Int *values, HYPRE_Int *sizes, hypre_IntArray *v, hypre_IntArrayArray **w_ptr );
HYPRE_Int
hypre_IntArraySeparateByValue_long_dbl( HYPRE_Int num_values, HYPRE_Int *values, HYPRE_Int *sizes, hypre_IntArray *v, hypre_IntArrayArray **w_ptr );

HYPRE_Int
hypre_IntArraySetConstantValues_flt( hypre_IntArray *v, HYPRE_Int value );
HYPRE_Int
hypre_IntArraySetConstantValues_dbl( hypre_IntArray *v, HYPRE_Int value );
HYPRE_Int
hypre_IntArraySetConstantValues_long_dbl( hypre_IntArray *v, HYPRE_Int value );

HYPRE_Int
hypre_IntArraySetConstantValuesHost_flt( hypre_IntArray *v, HYPRE_Int value );
HYPRE_Int
hypre_IntArraySetConstantValuesHost_dbl( hypre_IntArray *v, HYPRE_Int value );
HYPRE_Int
hypre_IntArraySetConstantValuesHost_long_dbl( hypre_IntArray *v, HYPRE_Int value );

HYPRE_Int
hypre_IntArraySetInterleavedValues_flt( hypre_IntArray *v, HYPRE_Int cycle );
HYPRE_Int
hypre_IntArraySetInterleavedValues_dbl( hypre_IntArray *v, HYPRE_Int cycle );
HYPRE_Int
hypre_IntArraySetInterleavedValues_long_dbl( hypre_IntArray *v, HYPRE_Int cycle );

HYPRE_Int
hypre_IntSequence_flt( HYPRE_MemoryLocation memory_location, HYPRE_Int size, HYPRE_Int *data );
HYPRE_Int
hypre_IntSequence_dbl( HYPRE_MemoryLocation memory_location, HYPRE_Int size, HYPRE_Int *data );
HYPRE_Int
hypre_IntSequence_long_dbl( HYPRE_MemoryLocation memory_location, HYPRE_Int size, HYPRE_Int *data );

HYPRE_Int
hypre_Log2_flt( HYPRE_Int p );
HYPRE_Int
hypre_Log2_dbl( HYPRE_Int p );
HYPRE_Int
hypre_Log2_long_dbl( HYPRE_Int p );

HYPRE_Int *
hypre_LowerBound_flt( HYPRE_Int *first, HYPRE_Int *last, HYPRE_Int value );
HYPRE_Int *
hypre_LowerBound_dbl( HYPRE_Int *first, HYPRE_Int *last, HYPRE_Int value );
HYPRE_Int *
hypre_LowerBound_long_dbl( HYPRE_Int *first, HYPRE_Int *last, HYPRE_Int value );

void *
hypre_MAlloc_flt( size_t size, HYPRE_MemoryLocation location );
void *
hypre_MAlloc_dbl( size_t size, HYPRE_MemoryLocation location );
void *
hypre_MAlloc_long_dbl( size_t size, HYPRE_MemoryLocation location );

HYPRE_Int
hypre_MPI_Abort_flt( hypre_MPI_Comm comm, HYPRE_Int errorcode );
HYPRE_Int
hypre_MPI_Abort_dbl( hypre_MPI_Comm comm, HYPRE_Int errorcode );
HYPRE_Int
hypre_MPI_Abort_long_dbl( hypre_MPI_Comm comm, HYPRE_Int errorcode );

HYPRE_Int
hypre_MPI_Address_flt( void *location, hypre_MPI_Aint *address );
HYPRE_Int
hypre_MPI_Address_dbl( void *location, hypre_MPI_Aint *address );
HYPRE_Int
hypre_MPI_Address_long_dbl( void *location, hypre_MPI_Aint *address );

HYPRE_Int
hypre_MPI_Allgather_flt( void *sendbuf, HYPRE_Int sendcount, hypre_MPI_Datatype sendtype, void *recvbuf, HYPRE_Int recvcount, hypre_MPI_Datatype recvtype, hypre_MPI_Comm comm );
HYPRE_Int
hypre_MPI_Allgather_dbl( void *sendbuf, HYPRE_Int sendcount, hypre_MPI_Datatype sendtype, void *recvbuf, HYPRE_Int recvcount, hypre_MPI_Datatype recvtype, hypre_MPI_Comm comm );
HYPRE_Int
hypre_MPI_Allgather_long_dbl( void *sendbuf, HYPRE_Int sendcount, hypre_MPI_Datatype sendtype, void *recvbuf, HYPRE_Int recvcount, hypre_MPI_Datatype recvtype, hypre_MPI_Comm comm );

HYPRE_Int
hypre_MPI_Allgatherv_flt( void *sendbuf, HYPRE_Int sendcount, hypre_MPI_Datatype sendtype, void *recvbuf, HYPRE_Int *recvcounts, HYPRE_Int *displs, hypre_MPI_Datatype recvtype, hypre_MPI_Comm comm );
HYPRE_Int
hypre_MPI_Allgatherv_dbl( void *sendbuf, HYPRE_Int sendcount, hypre_MPI_Datatype sendtype, void *recvbuf, HYPRE_Int *recvcounts, HYPRE_Int *displs, hypre_MPI_Datatype recvtype, hypre_MPI_Comm comm );
HYPRE_Int
hypre_MPI_Allgatherv_long_dbl( void *sendbuf, HYPRE_Int sendcount, hypre_MPI_Datatype sendtype, void *recvbuf, HYPRE_Int *recvcounts, HYPRE_Int *displs, hypre_MPI_Datatype recvtype, hypre_MPI_Comm comm );

HYPRE_Int
hypre_MPI_Allreduce_flt( void *sendbuf, void *recvbuf, HYPRE_Int count, hypre_MPI_Datatype datatype, hypre_MPI_Op op, hypre_MPI_Comm comm );
HYPRE_Int
hypre_MPI_Allreduce_dbl( void *sendbuf, void *recvbuf, HYPRE_Int count, hypre_MPI_Datatype datatype, hypre_MPI_Op op, hypre_MPI_Comm comm );
HYPRE_Int
hypre_MPI_Allreduce_long_dbl( void *sendbuf, void *recvbuf, HYPRE_Int count, hypre_MPI_Datatype datatype, hypre_MPI_Op op, hypre_MPI_Comm comm );

HYPRE_Int
hypre_MPI_Alltoall_flt( void *sendbuf, HYPRE_Int sendcount, hypre_MPI_Datatype sendtype, void *recvbuf, HYPRE_Int recvcount, hypre_MPI_Datatype recvtype, hypre_MPI_Comm comm );
HYPRE_Int
hypre_MPI_Alltoall_dbl( void *sendbuf, HYPRE_Int sendcount, hypre_MPI_Datatype sendtype, void *recvbuf, HYPRE_Int recvcount, hypre_MPI_Datatype recvtype, hypre_MPI_Comm comm );
HYPRE_Int
hypre_MPI_Alltoall_long_dbl( void *sendbuf, HYPRE_Int sendcount, hypre_MPI_Datatype sendtype, void *recvbuf, HYPRE_Int recvcount, hypre_MPI_Datatype recvtype, hypre_MPI_Comm comm );

HYPRE_Int
hypre_MPI_Barrier_flt( hypre_MPI_Comm comm );
HYPRE_Int
hypre_MPI_Barrier_dbl( hypre_MPI_Comm comm );
HYPRE_Int
hypre_MPI_Barrier_long_dbl( hypre_MPI_Comm comm );

HYPRE_Int
hypre_MPI_Bcast_flt( void *buffer, HYPRE_Int count, hypre_MPI_Datatype datatype, HYPRE_Int root, hypre_MPI_Comm comm );
HYPRE_Int
hypre_MPI_Bcast_dbl( void *buffer, HYPRE_Int count, hypre_MPI_Datatype datatype, HYPRE_Int root, hypre_MPI_Comm comm );
HYPRE_Int
hypre_MPI_Bcast_long_dbl( void *buffer, HYPRE_Int count, hypre_MPI_Datatype datatype, HYPRE_Int root, hypre_MPI_Comm comm );

HYPRE_Int
hypre_MPI_CheckCommMatrix_flt( hypre_MPI_Comm comm, HYPRE_Int num_recvs, HYPRE_Int *recvs, HYPRE_Int num_sends, HYPRE_Int *sends );
HYPRE_Int
hypre_MPI_CheckCommMatrix_dbl( hypre_MPI_Comm comm, HYPRE_Int num_recvs, HYPRE_Int *recvs, HYPRE_Int num_sends, HYPRE_Int *sends );
HYPRE_Int
hypre_MPI_CheckCommMatrix_long_dbl( hypre_MPI_Comm comm, HYPRE_Int num_recvs, HYPRE_Int *recvs, HYPRE_Int num_sends, HYPRE_Int *sends );

HYPRE_Int
hypre_MPI_Comm_create_flt( hypre_MPI_Comm comm, hypre_MPI_Group group, hypre_MPI_Comm *newcomm );
HYPRE_Int
hypre_MPI_Comm_create_dbl( hypre_MPI_Comm comm, hypre_MPI_Group group, hypre_MPI_Comm *newcomm );
HYPRE_Int
hypre_MPI_Comm_create_long_dbl( hypre_MPI_Comm comm, hypre_MPI_Group group, hypre_MPI_Comm *newcomm );

HYPRE_Int
hypre_MPI_Comm_dup_flt( hypre_MPI_Comm comm, hypre_MPI_Comm *newcomm );
HYPRE_Int
hypre_MPI_Comm_dup_dbl( hypre_MPI_Comm comm, hypre_MPI_Comm *newcomm );
HYPRE_Int
hypre_MPI_Comm_dup_long_dbl( hypre_MPI_Comm comm, hypre_MPI_Comm *newcomm );

hypre_MPI_Comm
hypre_MPI_Comm_f2c_flt( hypre_int comm );
hypre_MPI_Comm
hypre_MPI_Comm_f2c_dbl( hypre_int comm );
hypre_MPI_Comm
hypre_MPI_Comm_f2c_long_dbl( hypre_int comm );

HYPRE_Int
hypre_MPI_Comm_free_flt( hypre_MPI_Comm *comm );
HYPRE_Int
hypre_MPI_Comm_free_dbl( hypre_MPI_Comm *comm );
HYPRE_Int
hypre_MPI_Comm_free_long_dbl( hypre_MPI_Comm *comm );

HYPRE_Int
hypre_MPI_Comm_group_flt( hypre_MPI_Comm comm, hypre_MPI_Group *group );
HYPRE_Int
hypre_MPI_Comm_group_dbl( hypre_MPI_Comm comm, hypre_MPI_Group *group );
HYPRE_Int
hypre_MPI_Comm_group_long_dbl( hypre_MPI_Comm comm, hypre_MPI_Group *group );

HYPRE_Int
hypre_MPI_Comm_rank_flt( hypre_MPI_Comm comm, HYPRE_Int *rank );
HYPRE_Int
hypre_MPI_Comm_rank_dbl( hypre_MPI_Comm comm, HYPRE_Int *rank );
HYPRE_Int
hypre_MPI_Comm_rank_long_dbl( hypre_MPI_Comm comm, HYPRE_Int *rank );

HYPRE_Int
hypre_MPI_Comm_size_flt( hypre_MPI_Comm comm, HYPRE_Int *size );
HYPRE_Int
hypre_MPI_Comm_size_dbl( hypre_MPI_Comm comm, HYPRE_Int *size );
HYPRE_Int
hypre_MPI_Comm_size_long_dbl( hypre_MPI_Comm comm, HYPRE_Int *size );

HYPRE_Int
hypre_MPI_Comm_split_flt( hypre_MPI_Comm comm, HYPRE_Int n, HYPRE_Int m, hypre_MPI_Comm * comms );
HYPRE_Int
hypre_MPI_Comm_split_dbl( hypre_MPI_Comm comm, HYPRE_Int n, HYPRE_Int m, hypre_MPI_Comm * comms );
HYPRE_Int
hypre_MPI_Comm_split_long_dbl( hypre_MPI_Comm comm, HYPRE_Int n, HYPRE_Int m, hypre_MPI_Comm * comms );

HYPRE_Int
hypre_MPI_Finalize_flt( void );
HYPRE_Int
hypre_MPI_Finalize_dbl( void );
HYPRE_Int
hypre_MPI_Finalize_long_dbl( void );

HYPRE_Int
hypre_MPI_Gather_flt( void *sendbuf, HYPRE_Int sendcount, hypre_MPI_Datatype sendtype, void *recvbuf, HYPRE_Int recvcount, hypre_MPI_Datatype recvtype, HYPRE_Int root, hypre_MPI_Comm comm );
HYPRE_Int
hypre_MPI_Gather_dbl( void *sendbuf, HYPRE_Int sendcount, hypre_MPI_Datatype sendtype, void *recvbuf, HYPRE_Int recvcount, hypre_MPI_Datatype recvtype, HYPRE_Int root, hypre_MPI_Comm comm );
HYPRE_Int
hypre_MPI_Gather_long_dbl( void *sendbuf, HYPRE_Int sendcount, hypre_MPI_Datatype sendtype, void *recvbuf, HYPRE_Int recvcount, hypre_MPI_Datatype recvtype, HYPRE_Int root, hypre_MPI_Comm comm );

HYPRE_Int
hypre_MPI_Gatherv_flt( void *sendbuf, HYPRE_Int sendcount, hypre_MPI_Datatype sendtype, void *recvbuf, HYPRE_Int *recvcounts, HYPRE_Int *displs, hypre_MPI_Datatype recvtype, HYPRE_Int root, hypre_MPI_Comm comm );
HYPRE_Int
hypre_MPI_Gatherv_dbl( void *sendbuf, HYPRE_Int sendcount, hypre_MPI_Datatype sendtype, void *recvbuf, HYPRE_Int *recvcounts, HYPRE_Int *displs, hypre_MPI_Datatype recvtype, HYPRE_Int root, hypre_MPI_Comm comm );
HYPRE_Int
hypre_MPI_Gatherv_long_dbl( void *sendbuf, HYPRE_Int sendcount, hypre_MPI_Datatype sendtype, void *recvbuf, HYPRE_Int *recvcounts, HYPRE_Int *displs, hypre_MPI_Datatype recvtype, HYPRE_Int root, hypre_MPI_Comm comm );

HYPRE_Int
hypre_MPI_Get_count_flt( hypre_MPI_Status *status, hypre_MPI_Datatype datatype, HYPRE_Int *count );
HYPRE_Int
hypre_MPI_Get_count_dbl( hypre_MPI_Status *status, hypre_MPI_Datatype datatype, HYPRE_Int *count );
HYPRE_Int
hypre_MPI_Get_count_long_dbl( hypre_MPI_Status *status, hypre_MPI_Datatype datatype, HYPRE_Int *count );

HYPRE_Int
hypre_MPI_Group_free_flt( hypre_MPI_Group *group );
HYPRE_Int
hypre_MPI_Group_free_dbl( hypre_MPI_Group *group );
HYPRE_Int
hypre_MPI_Group_free_long_dbl( hypre_MPI_Group *group );

HYPRE_Int
hypre_MPI_Group_incl_flt( hypre_MPI_Group group, HYPRE_Int n, HYPRE_Int *ranks, hypre_MPI_Group *newgroup );
HYPRE_Int
hypre_MPI_Group_incl_dbl( hypre_MPI_Group group, HYPRE_Int n, HYPRE_Int *ranks, hypre_MPI_Group *newgroup );
HYPRE_Int
hypre_MPI_Group_incl_long_dbl( hypre_MPI_Group group, HYPRE_Int n, HYPRE_Int *ranks, hypre_MPI_Group *newgroup );

HYPRE_Int
hypre_MPI_Init_flt( hypre_int *argc, char ***argv );
HYPRE_Int
hypre_MPI_Init_dbl( hypre_int *argc, char ***argv );
HYPRE_Int
hypre_MPI_Init_long_dbl( hypre_int *argc, char ***argv );

HYPRE_Int
hypre_MPI_Iprobe_flt( HYPRE_Int source, HYPRE_Int tag, hypre_MPI_Comm comm, HYPRE_Int *flag, hypre_MPI_Status *status );
HYPRE_Int
hypre_MPI_Iprobe_dbl( HYPRE_Int source, HYPRE_Int tag, hypre_MPI_Comm comm, HYPRE_Int *flag, hypre_MPI_Status *status );
HYPRE_Int
hypre_MPI_Iprobe_long_dbl( HYPRE_Int source, HYPRE_Int tag, hypre_MPI_Comm comm, HYPRE_Int *flag, hypre_MPI_Status *status );

HYPRE_Int
hypre_MPI_Irecv_flt( void *buf, HYPRE_Int count, hypre_MPI_Datatype datatype, HYPRE_Int source, HYPRE_Int tag, hypre_MPI_Comm comm, hypre_MPI_Request *request );
HYPRE_Int
hypre_MPI_Irecv_dbl( void *buf, HYPRE_Int count, hypre_MPI_Datatype datatype, HYPRE_Int source, HYPRE_Int tag, hypre_MPI_Comm comm, hypre_MPI_Request *request );
HYPRE_Int
hypre_MPI_Irecv_long_dbl( void *buf, HYPRE_Int count, hypre_MPI_Datatype datatype, HYPRE_Int source, HYPRE_Int tag, hypre_MPI_Comm comm, hypre_MPI_Request *request );

HYPRE_Int
hypre_MPI_Irsend_flt( void *buf, HYPRE_Int count, hypre_MPI_Datatype datatype, HYPRE_Int dest, HYPRE_Int tag, hypre_MPI_Comm comm, hypre_MPI_Request *request );
HYPRE_Int
hypre_MPI_Irsend_dbl( void *buf, HYPRE_Int count, hypre_MPI_Datatype datatype, HYPRE_Int dest, HYPRE_Int tag, hypre_MPI_Comm comm, hypre_MPI_Request *request );
HYPRE_Int
hypre_MPI_Irsend_long_dbl( void *buf, HYPRE_Int count, hypre_MPI_Datatype datatype, HYPRE_Int dest, HYPRE_Int tag, hypre_MPI_Comm comm, hypre_MPI_Request *request );

HYPRE_Int
hypre_MPI_Isend_flt( void *buf, HYPRE_Int count, hypre_MPI_Datatype datatype, HYPRE_Int dest, HYPRE_Int tag, hypre_MPI_Comm comm, hypre_MPI_Request *request );
HYPRE_Int
hypre_MPI_Isend_dbl( void *buf, HYPRE_Int count, hypre_MPI_Datatype datatype, HYPRE_Int dest, HYPRE_Int tag, hypre_MPI_Comm comm, hypre_MPI_Request *request );
HYPRE_Int
hypre_MPI_Isend_long_dbl( void *buf, HYPRE_Int count, hypre_MPI_Datatype datatype, HYPRE_Int dest, HYPRE_Int tag, hypre_MPI_Comm comm, hypre_MPI_Request *request );

HYPRE_Int
hypre_MPI_Op_create_flt( hypre_MPI_User_function *function, hypre_int commute, hypre_MPI_Op *op );
HYPRE_Int
hypre_MPI_Op_create_dbl( hypre_MPI_User_function *function, hypre_int commute, hypre_MPI_Op *op );
HYPRE_Int
hypre_MPI_Op_create_long_dbl( hypre_MPI_User_function *function, hypre_int commute, hypre_MPI_Op *op );

HYPRE_Int
hypre_MPI_Op_free_flt( hypre_MPI_Op *op );
HYPRE_Int
hypre_MPI_Op_free_dbl( hypre_MPI_Op *op );
HYPRE_Int
hypre_MPI_Op_free_long_dbl( hypre_MPI_Op *op );

HYPRE_Int
hypre_MPI_Probe_flt( HYPRE_Int source, HYPRE_Int tag, hypre_MPI_Comm comm, hypre_MPI_Status *status );
HYPRE_Int
hypre_MPI_Probe_dbl( HYPRE_Int source, HYPRE_Int tag, hypre_MPI_Comm comm, hypre_MPI_Status *status );
HYPRE_Int
hypre_MPI_Probe_long_dbl( HYPRE_Int source, HYPRE_Int tag, hypre_MPI_Comm comm, hypre_MPI_Status *status );

HYPRE_Int
hypre_MPI_Recv_flt( void *buf, HYPRE_Int count, hypre_MPI_Datatype datatype, HYPRE_Int source, HYPRE_Int tag, hypre_MPI_Comm comm, hypre_MPI_Status *status );
HYPRE_Int
hypre_MPI_Recv_dbl( void *buf, HYPRE_Int count, hypre_MPI_Datatype datatype, HYPRE_Int source, HYPRE_Int tag, hypre_MPI_Comm comm, hypre_MPI_Status *status );
HYPRE_Int
hypre_MPI_Recv_long_dbl( void *buf, HYPRE_Int count, hypre_MPI_Datatype datatype, HYPRE_Int source, HYPRE_Int tag, hypre_MPI_Comm comm, hypre_MPI_Status *status );

HYPRE_Int
hypre_MPI_Recv_init_flt( void *buf, HYPRE_Int count, hypre_MPI_Datatype datatype, HYPRE_Int dest, HYPRE_Int tag, hypre_MPI_Comm comm, hypre_MPI_Request *request );
HYPRE_Int
hypre_MPI_Recv_init_dbl( void *buf, HYPRE_Int count, hypre_MPI_Datatype datatype, HYPRE_Int dest, HYPRE_Int tag, hypre_MPI_Comm comm, hypre_MPI_Request *request );
HYPRE_Int
hypre_MPI_Recv_init_long_dbl( void *buf, HYPRE_Int count, hypre_MPI_Datatype datatype, HYPRE_Int dest, HYPRE_Int tag, hypre_MPI_Comm comm, hypre_MPI_Request *request );

HYPRE_Int
hypre_MPI_Reduce_flt( void *sendbuf, void *recvbuf, HYPRE_Int count, hypre_MPI_Datatype datatype, hypre_MPI_Op op, HYPRE_Int root, hypre_MPI_Comm comm );
HYPRE_Int
hypre_MPI_Reduce_dbl( void *sendbuf, void *recvbuf, HYPRE_Int count, hypre_MPI_Datatype datatype, hypre_MPI_Op op, HYPRE_Int root, hypre_MPI_Comm comm );
HYPRE_Int
hypre_MPI_Reduce_long_dbl( void *sendbuf, void *recvbuf, HYPRE_Int count, hypre_MPI_Datatype datatype, hypre_MPI_Op op, HYPRE_Int root, hypre_MPI_Comm comm );

HYPRE_Int
hypre_MPI_Request_free_flt( hypre_MPI_Request *request );
HYPRE_Int
hypre_MPI_Request_free_dbl( hypre_MPI_Request *request );
HYPRE_Int
hypre_MPI_Request_free_long_dbl( hypre_MPI_Request *request );

HYPRE_Int
hypre_MPI_Scan_flt( void *sendbuf, void *recvbuf, HYPRE_Int count, hypre_MPI_Datatype datatype, hypre_MPI_Op op, hypre_MPI_Comm comm );
HYPRE_Int
hypre_MPI_Scan_dbl( void *sendbuf, void *recvbuf, HYPRE_Int count, hypre_MPI_Datatype datatype, hypre_MPI_Op op, hypre_MPI_Comm comm );
HYPRE_Int
hypre_MPI_Scan_long_dbl( void *sendbuf, void *recvbuf, HYPRE_Int count, hypre_MPI_Datatype datatype, hypre_MPI_Op op, hypre_MPI_Comm comm );

HYPRE_Int
hypre_MPI_Scatter_flt( void *sendbuf, HYPRE_Int sendcount, hypre_MPI_Datatype sendtype, void *recvbuf, HYPRE_Int recvcount, hypre_MPI_Datatype recvtype, HYPRE_Int root, hypre_MPI_Comm comm );
HYPRE_Int
hypre_MPI_Scatter_dbl( void *sendbuf, HYPRE_Int sendcount, hypre_MPI_Datatype sendtype, void *recvbuf, HYPRE_Int recvcount, hypre_MPI_Datatype recvtype, HYPRE_Int root, hypre_MPI_Comm comm );
HYPRE_Int
hypre_MPI_Scatter_long_dbl( void *sendbuf, HYPRE_Int sendcount, hypre_MPI_Datatype sendtype, void *recvbuf, HYPRE_Int recvcount, hypre_MPI_Datatype recvtype, HYPRE_Int root, hypre_MPI_Comm comm );

HYPRE_Int
hypre_MPI_Scatterv_flt( void *sendbuf, HYPRE_Int *sendcounts, HYPRE_Int *displs, hypre_MPI_Datatype sendtype, void *recvbuf, HYPRE_Int recvcount, hypre_MPI_Datatype recvtype, HYPRE_Int root, hypre_MPI_Comm comm );
HYPRE_Int
hypre_MPI_Scatterv_dbl( void *sendbuf, HYPRE_Int *sendcounts, HYPRE_Int *displs, hypre_MPI_Datatype sendtype, void *recvbuf, HYPRE_Int recvcount, hypre_MPI_Datatype recvtype, HYPRE_Int root, hypre_MPI_Comm comm );
HYPRE_Int
hypre_MPI_Scatterv_long_dbl( void *sendbuf, HYPRE_Int *sendcounts, HYPRE_Int *displs, hypre_MPI_Datatype sendtype, void *recvbuf, HYPRE_Int recvcount, hypre_MPI_Datatype recvtype, HYPRE_Int root, hypre_MPI_Comm comm );

HYPRE_Int
hypre_MPI_Send_flt( void *buf, HYPRE_Int count, hypre_MPI_Datatype datatype, HYPRE_Int dest, HYPRE_Int tag, hypre_MPI_Comm comm );
HYPRE_Int
hypre_MPI_Send_dbl( void *buf, HYPRE_Int count, hypre_MPI_Datatype datatype, HYPRE_Int dest, HYPRE_Int tag, hypre_MPI_Comm comm );
HYPRE_Int
hypre_MPI_Send_long_dbl( void *buf, HYPRE_Int count, hypre_MPI_Datatype datatype, HYPRE_Int dest, HYPRE_Int tag, hypre_MPI_Comm comm );

HYPRE_Int
hypre_MPI_Send_init_flt( void *buf, HYPRE_Int count, hypre_MPI_Datatype datatype, HYPRE_Int dest, HYPRE_Int tag, hypre_MPI_Comm comm, hypre_MPI_Request *request );
HYPRE_Int
hypre_MPI_Send_init_dbl( void *buf, HYPRE_Int count, hypre_MPI_Datatype datatype, HYPRE_Int dest, HYPRE_Int tag, hypre_MPI_Comm comm, hypre_MPI_Request *request );
HYPRE_Int
hypre_MPI_Send_init_long_dbl( void *buf, HYPRE_Int count, hypre_MPI_Datatype datatype, HYPRE_Int dest, HYPRE_Int tag, hypre_MPI_Comm comm, hypre_MPI_Request *request );

HYPRE_Int
hypre_MPI_Startall_flt( HYPRE_Int count, hypre_MPI_Request *array_of_requests );
HYPRE_Int
hypre_MPI_Startall_dbl( HYPRE_Int count, hypre_MPI_Request *array_of_requests );
HYPRE_Int
hypre_MPI_Startall_long_dbl( HYPRE_Int count, hypre_MPI_Request *array_of_requests );

HYPRE_Int
hypre_MPI_Test_flt( hypre_MPI_Request *request, HYPRE_Int *flag, hypre_MPI_Status *status );
HYPRE_Int
hypre_MPI_Test_dbl( hypre_MPI_Request *request, HYPRE_Int *flag, hypre_MPI_Status *status );
HYPRE_Int
hypre_MPI_Test_long_dbl( hypre_MPI_Request *request, HYPRE_Int *flag, hypre_MPI_Status *status );

HYPRE_Int
hypre_MPI_Testall_flt( HYPRE_Int count, hypre_MPI_Request *array_of_requests, HYPRE_Int *flag, hypre_MPI_Status *array_of_statuses );
HYPRE_Int
hypre_MPI_Testall_dbl( HYPRE_Int count, hypre_MPI_Request *array_of_requests, HYPRE_Int *flag, hypre_MPI_Status *array_of_statuses );
HYPRE_Int
hypre_MPI_Testall_long_dbl( HYPRE_Int count, hypre_MPI_Request *array_of_requests, HYPRE_Int *flag, hypre_MPI_Status *array_of_statuses );

HYPRE_Int
hypre_MPI_Type_commit_flt( hypre_MPI_Datatype *datatype );
HYPRE_Int
hypre_MPI_Type_commit_dbl( hypre_MPI_Datatype *datatype );
HYPRE_Int
hypre_MPI_Type_commit_long_dbl( hypre_MPI_Datatype *datatype );

HYPRE_Int
hypre_MPI_Type_contiguous_flt( HYPRE_Int count, hypre_MPI_Datatype oldtype, hypre_MPI_Datatype *newtype );
HYPRE_Int
hypre_MPI_Type_contiguous_dbl( HYPRE_Int count, hypre_MPI_Datatype oldtype, hypre_MPI_Datatype *newtype );
HYPRE_Int
hypre_MPI_Type_contiguous_long_dbl( HYPRE_Int count, hypre_MPI_Datatype oldtype, hypre_MPI_Datatype *newtype );

HYPRE_Int
hypre_MPI_Type_free_flt( hypre_MPI_Datatype *datatype );
HYPRE_Int
hypre_MPI_Type_free_dbl( hypre_MPI_Datatype *datatype );
HYPRE_Int
hypre_MPI_Type_free_long_dbl( hypre_MPI_Datatype *datatype );

HYPRE_Int
hypre_MPI_Type_hvector_flt( HYPRE_Int count, HYPRE_Int blocklength, hypre_MPI_Aint stride, hypre_MPI_Datatype oldtype, hypre_MPI_Datatype *newtype );
HYPRE_Int
hypre_MPI_Type_hvector_dbl( HYPRE_Int count, HYPRE_Int blocklength, hypre_MPI_Aint stride, hypre_MPI_Datatype oldtype, hypre_MPI_Datatype *newtype );
HYPRE_Int
hypre_MPI_Type_hvector_long_dbl( HYPRE_Int count, HYPRE_Int blocklength, hypre_MPI_Aint stride, hypre_MPI_Datatype oldtype, hypre_MPI_Datatype *newtype );

HYPRE_Int
hypre_MPI_Type_struct_flt( HYPRE_Int count, HYPRE_Int *array_of_blocklengths, hypre_MPI_Aint *array_of_displacements, hypre_MPI_Datatype *array_of_types, hypre_MPI_Datatype *newtype );
HYPRE_Int
hypre_MPI_Type_struct_dbl( HYPRE_Int count, HYPRE_Int *array_of_blocklengths, hypre_MPI_Aint *array_of_displacements, hypre_MPI_Datatype *array_of_types, hypre_MPI_Datatype *newtype );
HYPRE_Int
hypre_MPI_Type_struct_long_dbl( HYPRE_Int count, HYPRE_Int *array_of_blocklengths, hypre_MPI_Aint *array_of_displacements, hypre_MPI_Datatype *array_of_types, hypre_MPI_Datatype *newtype );

HYPRE_Int
hypre_MPI_Type_vector_flt( HYPRE_Int count, HYPRE_Int blocklength, HYPRE_Int stride, hypre_MPI_Datatype oldtype, hypre_MPI_Datatype *newtype );
HYPRE_Int
hypre_MPI_Type_vector_dbl( HYPRE_Int count, HYPRE_Int blocklength, HYPRE_Int stride, hypre_MPI_Datatype oldtype, hypre_MPI_Datatype *newtype );
HYPRE_Int
hypre_MPI_Type_vector_long_dbl( HYPRE_Int count, HYPRE_Int blocklength, HYPRE_Int stride, hypre_MPI_Datatype oldtype, hypre_MPI_Datatype *newtype );

HYPRE_Int
hypre_MPI_Wait_flt( hypre_MPI_Request *request, hypre_MPI_Status *status );
HYPRE_Int
hypre_MPI_Wait_dbl( hypre_MPI_Request *request, hypre_MPI_Status *status );
HYPRE_Int
hypre_MPI_Wait_long_dbl( hypre_MPI_Request *request, hypre_MPI_Status *status );

HYPRE_Int
hypre_MPI_Waitall_flt( HYPRE_Int count, hypre_MPI_Request *array_of_requests, hypre_MPI_Status *array_of_statuses );
HYPRE_Int
hypre_MPI_Waitall_dbl( HYPRE_Int count, hypre_MPI_Request *array_of_requests, hypre_MPI_Status *array_of_statuses );
HYPRE_Int
hypre_MPI_Waitall_long_dbl( HYPRE_Int count, hypre_MPI_Request *array_of_requests, hypre_MPI_Status *array_of_statuses );

HYPRE_Int
hypre_MPI_Waitany_flt( HYPRE_Int count, hypre_MPI_Request *array_of_requests, HYPRE_Int *index, hypre_MPI_Status *status );
HYPRE_Int
hypre_MPI_Waitany_dbl( HYPRE_Int count, hypre_MPI_Request *array_of_requests, HYPRE_Int *index, hypre_MPI_Status *status );
HYPRE_Int
hypre_MPI_Waitany_long_dbl( HYPRE_Int count, hypre_MPI_Request *array_of_requests, HYPRE_Int *index, hypre_MPI_Status *status );

hypre_double
hypre_MPI_Wtick_flt( void );
hypre_double
hypre_MPI_Wtick_dbl( void );
hypre_double
hypre_MPI_Wtick_long_dbl( void );

hypre_double
hypre_MPI_Wtime_flt( void );
hypre_double
hypre_MPI_Wtime_dbl( void );
hypre_double
hypre_MPI_Wtime_long_dbl( void );

hypre_MatrixStatsArray*
hypre_MatrixStatsArrayCreate_flt( HYPRE_Int capacity );
hypre_MatrixStatsArray*
hypre_MatrixStatsArrayCreate_dbl( HYPRE_Int capacity );
hypre_MatrixStatsArray*
hypre_MatrixStatsArrayCreate_long_dbl( HYPRE_Int capacity );

HYPRE_Int
hypre_MatrixStatsArrayDestroy_flt( hypre_MatrixStatsArray *stats_array );
HYPRE_Int
hypre_MatrixStatsArrayDestroy_dbl( hypre_MatrixStatsArray *stats_array );
HYPRE_Int
hypre_MatrixStatsArrayDestroy_long_dbl( hypre_MatrixStatsArray *stats_array );

HYPRE_Int
hypre_MatrixStatsArrayPrint_flt( HYPRE_Int num_hierarchies, HYPRE_Int *num_levels, HYPRE_Int use_divisors, HYPRE_Int shift, const char **messages, hypre_MatrixStatsArray *stats_array );
HYPRE_Int
hypre_MatrixStatsArrayPrint_dbl( HYPRE_Int num_hierarchies, HYPRE_Int *num_levels, HYPRE_Int use_divisors, HYPRE_Int shift, const char **messages, hypre_MatrixStatsArray *stats_array );
HYPRE_Int
hypre_MatrixStatsArrayPrint_long_dbl( HYPRE_Int num_hierarchies, HYPRE_Int *num_levels, HYPRE_Int use_divisors, HYPRE_Int shift, const char **messages, hypre_MatrixStatsArray *stats_array );

hypre_MatrixStats*
hypre_MatrixStatsCreate_flt( void );
hypre_MatrixStats*
hypre_MatrixStatsCreate_dbl( void );
hypre_MatrixStats*
hypre_MatrixStatsCreate_long_dbl( void );

HYPRE_Int
hypre_MatrixStatsDestroy_flt( hypre_MatrixStats *stats );
HYPRE_Int
hypre_MatrixStatsDestroy_dbl( hypre_MatrixStats *stats );
HYPRE_Int
hypre_MatrixStatsDestroy_long_dbl( hypre_MatrixStats *stats );

void
hypre_MemPrefetch_flt( void *ptr, size_t size, HYPRE_MemoryLocation location );
void
hypre_MemPrefetch_dbl( void *ptr, size_t size, HYPRE_MemoryLocation location );
void
hypre_MemPrefetch_long_dbl( void *ptr, size_t size, HYPRE_MemoryLocation location );

void
hypre_Memcpy_flt( void *dst, void *src, size_t size, HYPRE_MemoryLocation loc_dst, HYPRE_MemoryLocation loc_src );
void
hypre_Memcpy_dbl( void *dst, void *src, size_t size, HYPRE_MemoryLocation loc_dst, HYPRE_MemoryLocation loc_src );
void
hypre_Memcpy_long_dbl( void *dst, void *src, size_t size, HYPRE_MemoryLocation loc_dst, HYPRE_MemoryLocation loc_src );

HYPRE_Int
hypre_MemoryPrintUsage_flt( MPI_Comm comm, HYPRE_Int level, const char *function, HYPRE_Int line );
HYPRE_Int
hypre_MemoryPrintUsage_dbl( MPI_Comm comm, HYPRE_Int level, const char *function, HYPRE_Int line );
HYPRE_Int
hypre_MemoryPrintUsage_long_dbl( MPI_Comm comm, HYPRE_Int level, const char *function, HYPRE_Int line );

void *
hypre_Memset_flt( void *ptr, HYPRE_Int value, size_t num, HYPRE_MemoryLocation location );
void *
hypre_Memset_dbl( void *ptr, HYPRE_Int value, size_t num, HYPRE_MemoryLocation location );
void *
hypre_Memset_long_dbl( void *ptr, HYPRE_Int value, size_t num, HYPRE_MemoryLocation location );

HYPRE_Int
hypre_PrefixSumInt_flt( HYPRE_Int nvals, HYPRE_Int *vals, HYPRE_Int *sums );
HYPRE_Int
hypre_PrefixSumInt_dbl( HYPRE_Int nvals, HYPRE_Int *vals, HYPRE_Int *sums );
HYPRE_Int
hypre_PrefixSumInt_long_dbl( HYPRE_Int nvals, HYPRE_Int *vals, HYPRE_Int *sums );

HYPRE_Int
hypre_PrintTiming_fcn_flt( const char *heading, MPI_Comm comm );
HYPRE_Int
hypre_PrintTiming_fcn_dbl( const char *heading, MPI_Comm comm );
HYPRE_Int
hypre_PrintTiming_fcn_long_dbl( const char *heading, MPI_Comm comm );

HYPRE_Real
hypre_Rand_flt( void );
HYPRE_Real
hypre_Rand_dbl( void );
HYPRE_Real
hypre_Rand_long_dbl( void );

HYPRE_Int
hypre_RandI_flt( void );
HYPRE_Int
hypre_RandI_dbl( void );
HYPRE_Int
hypre_RandI_long_dbl( void );

void *
hypre_ReAlloc_flt( void *ptr, size_t size, HYPRE_MemoryLocation location );
void *
hypre_ReAlloc_dbl( void *ptr, size_t size, HYPRE_MemoryLocation location );
void *
hypre_ReAlloc_long_dbl( void *ptr, size_t size, HYPRE_MemoryLocation location );

void *
hypre_ReAlloc_v2_flt( void *ptr, size_t old_size, size_t new_size, HYPRE_MemoryLocation location );
void *
hypre_ReAlloc_v2_dbl( void *ptr, size_t old_size, size_t new_size, HYPRE_MemoryLocation location );
void *
hypre_ReAlloc_v2_long_dbl( void *ptr, size_t old_size, size_t new_size, HYPRE_MemoryLocation location );

HYPRE_Int
hypre_RestoreLogLevel_flt( void );
HYPRE_Int
hypre_RestoreLogLevel_dbl( void );
HYPRE_Int
hypre_RestoreLogLevel_long_dbl( void );

void
hypre_SeedRand_flt( HYPRE_Int seed );
void
hypre_SeedRand_dbl( HYPRE_Int seed );
void
hypre_SeedRand_long_dbl( HYPRE_Int seed );

HYPRE_Int
hypre_SetDevice_flt( hypre_int device_id, hypre_Handle *hypre_handle_ );
HYPRE_Int
hypre_SetDevice_dbl( hypre_int device_id, hypre_Handle *hypre_handle_ );
HYPRE_Int
hypre_SetDevice_long_dbl( hypre_int device_id, hypre_Handle *hypre_handle_ );

HYPRE_Int
hypre_SetFinalized_flt( void );
HYPRE_Int
hypre_SetFinalized_dbl( void );
HYPRE_Int
hypre_SetFinalized_long_dbl( void );

HYPRE_Int
hypre_SetGaussSeidelMethod_flt( HYPRE_Int gs_method );
HYPRE_Int
hypre_SetGaussSeidelMethod_dbl( HYPRE_Int gs_method );
HYPRE_Int
hypre_SetGaussSeidelMethod_long_dbl( HYPRE_Int gs_method );

HYPRE_Int
hypre_SetGpuAwareMPI_flt( HYPRE_Int use_gpu_aware_mpi );
HYPRE_Int
hypre_SetGpuAwareMPI_dbl( HYPRE_Int use_gpu_aware_mpi );
HYPRE_Int
hypre_SetGpuAwareMPI_long_dbl( HYPRE_Int use_gpu_aware_mpi );

HYPRE_Int
hypre_SetInitialized_flt( void );
HYPRE_Int
hypre_SetInitialized_dbl( void );
HYPRE_Int
hypre_SetInitialized_long_dbl( void );

HYPRE_Int
hypre_SetLogLevel_flt( HYPRE_Int log_level );
HYPRE_Int
hypre_SetLogLevel_dbl( HYPRE_Int log_level );
HYPRE_Int
hypre_SetLogLevel_long_dbl( HYPRE_Int log_level );

HYPRE_Int
hypre_SetLogLevelSaved_flt( HYPRE_Int log_level_saved );
HYPRE_Int
hypre_SetLogLevelSaved_dbl( HYPRE_Int log_level_saved );
HYPRE_Int
hypre_SetLogLevelSaved_long_dbl( HYPRE_Int log_level_saved );

HYPRE_Int
hypre_SetSpGemmAlgorithm_flt( HYPRE_Int value );
HYPRE_Int
hypre_SetSpGemmAlgorithm_dbl( HYPRE_Int value );
HYPRE_Int
hypre_SetSpGemmAlgorithm_long_dbl( HYPRE_Int value );

HYPRE_Int
hypre_SetSpGemmBinned_flt( HYPRE_Int value );
HYPRE_Int
hypre_SetSpGemmBinned_dbl( HYPRE_Int value );
HYPRE_Int
hypre_SetSpGemmBinned_long_dbl( HYPRE_Int value );

HYPRE_Int
hypre_SetSpGemmRownnzEstimateMethod_flt( HYPRE_Int value );
HYPRE_Int
hypre_SetSpGemmRownnzEstimateMethod_dbl( HYPRE_Int value );
HYPRE_Int
hypre_SetSpGemmRownnzEstimateMethod_long_dbl( HYPRE_Int value );

HYPRE_Int
hypre_SetSpGemmRownnzEstimateMultFactor_flt( hypre_float value );
HYPRE_Int
hypre_SetSpGemmRownnzEstimateMultFactor_dbl( hypre_double value );
HYPRE_Int
hypre_SetSpGemmRownnzEstimateMultFactor_long_dbl( hypre_long_double value );

HYPRE_Int
hypre_SetSpGemmRownnzEstimateNSamples_flt( HYPRE_Int value );
HYPRE_Int
hypre_SetSpGemmRownnzEstimateNSamples_dbl( HYPRE_Int value );
HYPRE_Int
hypre_SetSpGemmRownnzEstimateNSamples_long_dbl( HYPRE_Int value );

HYPRE_Int
hypre_SetSpGemmUseVendor_flt( HYPRE_Int use_vendor );
HYPRE_Int
hypre_SetSpGemmUseVendor_dbl( HYPRE_Int use_vendor );
HYPRE_Int
hypre_SetSpGemmUseVendor_long_dbl( HYPRE_Int use_vendor );

HYPRE_Int
hypre_SetSpMVUseVendor_flt( HYPRE_Int use_vendor );
HYPRE_Int
hypre_SetSpMVUseVendor_dbl( HYPRE_Int use_vendor );
HYPRE_Int
hypre_SetSpMVUseVendor_long_dbl( HYPRE_Int use_vendor );

HYPRE_Int
hypre_SetSpTransUseVendor_flt( HYPRE_Int use_vendor );
HYPRE_Int
hypre_SetSpTransUseVendor_dbl( HYPRE_Int use_vendor );
HYPRE_Int
hypre_SetSpTransUseVendor_long_dbl( HYPRE_Int use_vendor );

HYPRE_Int
hypre_SetUseGpuRand_flt( HYPRE_Int use_gpurand );
HYPRE_Int
hypre_SetUseGpuRand_dbl( HYPRE_Int use_gpurand );
HYPRE_Int
hypre_SetUseGpuRand_long_dbl( HYPRE_Int use_gpurand );

HYPRE_Int
hypre_UniqueIntArrayND_flt( HYPRE_Int ndim, HYPRE_Int *size, HYPRE_Int **array );
HYPRE_Int
hypre_UniqueIntArrayND_dbl( HYPRE_Int ndim, HYPRE_Int *size, HYPRE_Int **array );
HYPRE_Int
hypre_UniqueIntArrayND_long_dbl( HYPRE_Int ndim, HYPRE_Int *size, HYPRE_Int **array );

void
hypre_UnorderedBigIntMapCreate_flt( hypre_UnorderedBigIntMap *m, HYPRE_Int inCapacity, HYPRE_Int concurrencyLevel );
void
hypre_UnorderedBigIntMapCreate_dbl( hypre_UnorderedBigIntMap *m, HYPRE_Int inCapacity, HYPRE_Int concurrencyLevel );
void
hypre_UnorderedBigIntMapCreate_long_dbl( hypre_UnorderedBigIntMap *m, HYPRE_Int inCapacity, HYPRE_Int concurrencyLevel );

void
hypre_UnorderedBigIntMapDestroy_flt( hypre_UnorderedBigIntMap *m );
void
hypre_UnorderedBigIntMapDestroy_dbl( hypre_UnorderedBigIntMap *m );
void
hypre_UnorderedBigIntMapDestroy_long_dbl( hypre_UnorderedBigIntMap *m );

HYPRE_BigInt *
hypre_UnorderedBigIntSetCopyToArray_flt( hypre_UnorderedBigIntSet *s, HYPRE_Int *len );
HYPRE_BigInt *
hypre_UnorderedBigIntSetCopyToArray_dbl( hypre_UnorderedBigIntSet *s, HYPRE_Int *len );
HYPRE_BigInt *
hypre_UnorderedBigIntSetCopyToArray_long_dbl( hypre_UnorderedBigIntSet *s, HYPRE_Int *len );

void
hypre_UnorderedBigIntSetCreate_flt( hypre_UnorderedBigIntSet *s, HYPRE_Int inCapacity, HYPRE_Int concurrencyLevel );
void
hypre_UnorderedBigIntSetCreate_dbl( hypre_UnorderedBigIntSet *s, HYPRE_Int inCapacity, HYPRE_Int concurrencyLevel );
void
hypre_UnorderedBigIntSetCreate_long_dbl( hypre_UnorderedBigIntSet *s, HYPRE_Int inCapacity, HYPRE_Int concurrencyLevel );

void
hypre_UnorderedBigIntSetDestroy_flt( hypre_UnorderedBigIntSet *s );
void
hypre_UnorderedBigIntSetDestroy_dbl( hypre_UnorderedBigIntSet *s );
void
hypre_UnorderedBigIntSetDestroy_long_dbl( hypre_UnorderedBigIntSet *s );

void
hypre_UnorderedIntMapCreate_flt( hypre_UnorderedIntMap *m, HYPRE_Int inCapacity, HYPRE_Int concurrencyLevel );
void
hypre_UnorderedIntMapCreate_dbl( hypre_UnorderedIntMap *m, HYPRE_Int inCapacity, HYPRE_Int concurrencyLevel );
void
hypre_UnorderedIntMapCreate_long_dbl( hypre_UnorderedIntMap *m, HYPRE_Int inCapacity, HYPRE_Int concurrencyLevel );

void
hypre_UnorderedIntMapDestroy_flt( hypre_UnorderedIntMap *m );
void
hypre_UnorderedIntMapDestroy_dbl( hypre_UnorderedIntMap *m );
void
hypre_UnorderedIntMapDestroy_long_dbl( hypre_UnorderedIntMap *m );

HYPRE_Int *
hypre_UnorderedIntSetCopyToArray_flt( hypre_UnorderedIntSet *s, HYPRE_Int *len );
HYPRE_Int *
hypre_UnorderedIntSetCopyToArray_dbl( hypre_UnorderedIntSet *s, HYPRE_Int *len );
HYPRE_Int *
hypre_UnorderedIntSetCopyToArray_long_dbl( hypre_UnorderedIntSet *s, HYPRE_Int *len );

void
hypre_UnorderedIntSetCreate_flt( hypre_UnorderedIntSet *s, HYPRE_Int inCapacity, HYPRE_Int concurrencyLevel );
void
hypre_UnorderedIntSetCreate_dbl( hypre_UnorderedIntSet *s, HYPRE_Int inCapacity, HYPRE_Int concurrencyLevel );
void
hypre_UnorderedIntSetCreate_long_dbl( hypre_UnorderedIntSet *s, HYPRE_Int inCapacity, HYPRE_Int concurrencyLevel );

void
hypre_UnorderedIntSetDestroy_flt( hypre_UnorderedIntSet *s );
void
hypre_UnorderedIntSetDestroy_dbl( hypre_UnorderedIntSet *s );
void
hypre_UnorderedIntSetDestroy_long_dbl( hypre_UnorderedIntSet *s );

void
hypre__Free_flt( void *ptr, hypre_MemoryLocation location );
void
hypre__Free_dbl( void *ptr, hypre_MemoryLocation location );
void
hypre__Free_long_dbl( void *ptr, hypre_MemoryLocation location );

void *
hypre__MAlloc_flt( size_t size, hypre_MemoryLocation location );
void *
hypre__MAlloc_dbl( size_t size, hypre_MemoryLocation location );
void *
hypre__MAlloc_long_dbl( size_t size, hypre_MemoryLocation location );

void
hypre_big_merge_sort_flt( HYPRE_BigInt *in, HYPRE_BigInt *temp, HYPRE_Int len, HYPRE_BigInt **sorted );
void
hypre_big_merge_sort_dbl( HYPRE_BigInt *in, HYPRE_BigInt *temp, HYPRE_Int len, HYPRE_BigInt **sorted );
void
hypre_big_merge_sort_long_dbl( HYPRE_BigInt *in, HYPRE_BigInt *temp, HYPRE_Int len, HYPRE_BigInt **sorted );

void
hypre_big_sort_and_create_inverse_map_flt( HYPRE_BigInt *in, HYPRE_Int len, HYPRE_BigInt **out, hypre_UnorderedBigIntMap *inverse_map );
void
hypre_big_sort_and_create_inverse_map_dbl( HYPRE_BigInt *in, HYPRE_Int len, HYPRE_BigInt **out, hypre_UnorderedBigIntMap *inverse_map );
void
hypre_big_sort_and_create_inverse_map_long_dbl( HYPRE_BigInt *in, HYPRE_Int len, HYPRE_BigInt **out, hypre_UnorderedBigIntMap *inverse_map );

HYPRE_Int
hypre_bind_device_flt( HYPRE_Int myid, HYPRE_Int nproc, MPI_Comm comm );
HYPRE_Int
hypre_bind_device_dbl( HYPRE_Int myid, HYPRE_Int nproc, MPI_Comm comm );
HYPRE_Int
hypre_bind_device_long_dbl( HYPRE_Int myid, HYPRE_Int nproc, MPI_Comm comm );

HYPRE_Int
hypre_bind_device_id_flt( HYPRE_Int device_id_in, HYPRE_Int myid, HYPRE_Int nproc, MPI_Comm comm );
HYPRE_Int
hypre_bind_device_id_dbl( HYPRE_Int device_id_in, HYPRE_Int myid, HYPRE_Int nproc, MPI_Comm comm );
HYPRE_Int
hypre_bind_device_id_long_dbl( HYPRE_Int device_id_in, HYPRE_Int myid, HYPRE_Int nproc, MPI_Comm comm );

hypre_LinkList
hypre_create_elt_flt( HYPRE_Int Item );
hypre_LinkList
hypre_create_elt_dbl( HYPRE_Int Item );
hypre_LinkList
hypre_create_elt_long_dbl( HYPRE_Int Item );

void
hypre_dense_topo_sort_flt( const hypre_float *L, HYPRE_Int *ordering, HYPRE_Int n, HYPRE_Int is_col_major );
void
hypre_dense_topo_sort_dbl( const hypre_double *L, HYPRE_Int *ordering, HYPRE_Int n, HYPRE_Int is_col_major );
void
hypre_dense_topo_sort_long_dbl( const hypre_long_double *L, HYPRE_Int *ordering, HYPRE_Int n, HYPRE_Int is_col_major );

void
hypre_dispose_elt_flt( hypre_LinkList element_ptr );
void
hypre_dispose_elt_dbl( hypre_LinkList element_ptr );
void
hypre_dispose_elt_long_dbl( hypre_LinkList element_ptr );

void
hypre_enter_on_lists_flt( hypre_LinkList *LoL_head_ptr, hypre_LinkList *LoL_tail_ptr, HYPRE_Int measure, HYPRE_Int index, HYPRE_Int *lists, HYPRE_Int *where );
void
hypre_enter_on_lists_dbl( hypre_LinkList *LoL_head_ptr, hypre_LinkList *LoL_tail_ptr, HYPRE_Int measure, HYPRE_Int index, HYPRE_Int *lists, HYPRE_Int *where );
void
hypre_enter_on_lists_long_dbl( hypre_LinkList *LoL_head_ptr, hypre_LinkList *LoL_tail_ptr, HYPRE_Int measure, HYPRE_Int index, HYPRE_Int *lists, HYPRE_Int *where );

void
hypre_error_code_restore_flt( void );
void
hypre_error_code_restore_dbl( void );
void
hypre_error_code_restore_long_dbl( void );

void
hypre_error_code_save_flt( void );
void
hypre_error_code_save_dbl( void );
void
hypre_error_code_save_long_dbl( void );

void
hypre_error_handler_flt( const char *filename, HYPRE_Int line, HYPRE_Int ierr, const char *msg );
void
hypre_error_handler_dbl( const char *filename, HYPRE_Int line, HYPRE_Int ierr, const char *msg );
void
hypre_error_handler_long_dbl( const char *filename, HYPRE_Int line, HYPRE_Int ierr, const char *msg );

void
hypre_error_handler_clear_messages_flt( void );
void
hypre_error_handler_clear_messages_dbl( void );
void
hypre_error_handler_clear_messages_long_dbl( void );

hypre_Handle*
hypre_handle_flt( void );
hypre_Handle*
hypre_handle_dbl( void );
hypre_Handle*
hypre_handle_long_dbl( void );

void
hypre_merge_sort_flt( HYPRE_Int *in, HYPRE_Int *temp, HYPRE_Int len, HYPRE_Int **sorted );
void
hypre_merge_sort_dbl( HYPRE_Int *in, HYPRE_Int *temp, HYPRE_Int len, HYPRE_Int **sorted );
void
hypre_merge_sort_long_dbl( HYPRE_Int *in, HYPRE_Int *temp, HYPRE_Int len, HYPRE_Int **sorted );

HYPRE_Int
hypre_mm_is_valid_flt( MM_typecode matcode );
HYPRE_Int
hypre_mm_is_valid_dbl( MM_typecode matcode );
HYPRE_Int
hypre_mm_is_valid_long_dbl( MM_typecode matcode );

HYPRE_Int
hypre_mm_read_banner_flt( FILE *f, MM_typecode *matcode );
HYPRE_Int
hypre_mm_read_banner_dbl( FILE *f, MM_typecode *matcode );
HYPRE_Int
hypre_mm_read_banner_long_dbl( FILE *f, MM_typecode *matcode );

HYPRE_Int
hypre_mm_read_mtx_crd_size_flt( FILE *f, HYPRE_Int *M, HYPRE_Int *N, HYPRE_Int *nz );
HYPRE_Int
hypre_mm_read_mtx_crd_size_dbl( FILE *f, HYPRE_Int *M, HYPRE_Int *N, HYPRE_Int *nz );
HYPRE_Int
hypre_mm_read_mtx_crd_size_long_dbl( FILE *f, HYPRE_Int *M, HYPRE_Int *N, HYPRE_Int *nz );

HYPRE_Int
hypre_multmod_flt( HYPRE_Int a, HYPRE_Int b, HYPRE_Int mod );
HYPRE_Int
hypre_multmod_dbl( HYPRE_Int a, HYPRE_Int b, HYPRE_Int mod );
HYPRE_Int
hypre_multmod_long_dbl( HYPRE_Int a, HYPRE_Int b, HYPRE_Int mod );

void
hypre_partition1D_flt( HYPRE_Int n, HYPRE_Int p, HYPRE_Int j, HYPRE_Int *s, HYPRE_Int *e );
void
hypre_partition1D_dbl( HYPRE_Int n, HYPRE_Int p, HYPRE_Int j, HYPRE_Int *s, HYPRE_Int *e );
void
hypre_partition1D_long_dbl( HYPRE_Int n, HYPRE_Int p, HYPRE_Int j, HYPRE_Int *s, HYPRE_Int *e );

HYPRE_Int
hypre_prefix_sum_flt( HYPRE_Int *in_out, HYPRE_Int *sum, HYPRE_Int *workspace );
HYPRE_Int
hypre_prefix_sum_dbl( HYPRE_Int *in_out, HYPRE_Int *sum, HYPRE_Int *workspace );
HYPRE_Int
hypre_prefix_sum_long_dbl( HYPRE_Int *in_out, HYPRE_Int *sum, HYPRE_Int *workspace );

HYPRE_Int
hypre_prefix_sum_multiple_flt( HYPRE_Int *in_out, HYPRE_Int *sum, HYPRE_Int n, HYPRE_Int *workspace );
HYPRE_Int
hypre_prefix_sum_multiple_dbl( HYPRE_Int *in_out, HYPRE_Int *sum, HYPRE_Int n, HYPRE_Int *workspace );
HYPRE_Int
hypre_prefix_sum_multiple_long_dbl( HYPRE_Int *in_out, HYPRE_Int *sum, HYPRE_Int n, HYPRE_Int *workspace );

HYPRE_Int
hypre_prefix_sum_pair_flt( HYPRE_Int *in_out1, HYPRE_Int *sum1, HYPRE_Int *in_out2, HYPRE_Int *sum2, HYPRE_Int *workspace );
HYPRE_Int
hypre_prefix_sum_pair_dbl( HYPRE_Int *in_out1, HYPRE_Int *sum1, HYPRE_Int *in_out2, HYPRE_Int *sum2, HYPRE_Int *workspace );
HYPRE_Int
hypre_prefix_sum_pair_long_dbl( HYPRE_Int *in_out1, HYPRE_Int *sum1, HYPRE_Int *in_out2, HYPRE_Int *sum2, HYPRE_Int *workspace );

HYPRE_Int
hypre_prefix_sum_triple_flt( HYPRE_Int *in_out1, HYPRE_Int *sum1, HYPRE_Int *in_out2, HYPRE_Int *sum2, HYPRE_Int *in_out3, HYPRE_Int *sum3, HYPRE_Int *workspace );
HYPRE_Int
hypre_prefix_sum_triple_dbl( HYPRE_Int *in_out1, HYPRE_Int *sum1, HYPRE_Int *in_out2, HYPRE_Int *sum2, HYPRE_Int *in_out3, HYPRE_Int *sum3, HYPRE_Int *workspace );
HYPRE_Int
hypre_prefix_sum_triple_long_dbl( HYPRE_Int *in_out1, HYPRE_Int *sum1, HYPRE_Int *in_out2, HYPRE_Int *sum2, HYPRE_Int *in_out3, HYPRE_Int *sum3, HYPRE_Int *workspace );

void
hypre_qsort0_flt( HYPRE_Int *v, HYPRE_Int left, HYPRE_Int right );
void
hypre_qsort0_dbl( HYPRE_Int *v, HYPRE_Int left, HYPRE_Int right );
void
hypre_qsort0_long_dbl( HYPRE_Int *v, HYPRE_Int left, HYPRE_Int right );

void
hypre_qsort1_flt( HYPRE_Int *v, hypre_float *w, HYPRE_Int left, HYPRE_Int right );
void
hypre_qsort1_dbl( HYPRE_Int *v, hypre_double *w, HYPRE_Int left, HYPRE_Int right );
void
hypre_qsort1_long_dbl( HYPRE_Int *v, hypre_long_double *w, HYPRE_Int left, HYPRE_Int right );

void
hypre_qsort2_flt( HYPRE_Int *v, hypre_float *w, HYPRE_Int left, HYPRE_Int right );
void
hypre_qsort2_dbl( HYPRE_Int *v, hypre_double *w, HYPRE_Int left, HYPRE_Int right );
void
hypre_qsort2_long_dbl( HYPRE_Int *v, hypre_long_double *w, HYPRE_Int left, HYPRE_Int right );

void
hypre_qsort2_abs_flt( HYPRE_Int *v, hypre_float *w, HYPRE_Int left, HYPRE_Int right );
void
hypre_qsort2_abs_dbl( HYPRE_Int *v, hypre_double *w, HYPRE_Int left, HYPRE_Int right );
void
hypre_qsort2_abs_long_dbl( HYPRE_Int *v, hypre_long_double *w, HYPRE_Int left, HYPRE_Int right );

void
hypre_qsort2i_flt( HYPRE_Int *v, HYPRE_Int *w, HYPRE_Int left, HYPRE_Int right );
void
hypre_qsort2i_dbl( HYPRE_Int *v, HYPRE_Int *w, HYPRE_Int left, HYPRE_Int right );
void
hypre_qsort2i_long_dbl( HYPRE_Int *v, HYPRE_Int *w, HYPRE_Int left, HYPRE_Int right );

void
hypre_qsort3_flt( hypre_float *v, HYPRE_Int *w, HYPRE_Int *z, HYPRE_Int left, HYPRE_Int right );
void
hypre_qsort3_dbl( hypre_double *v, HYPRE_Int *w, HYPRE_Int *z, HYPRE_Int left, HYPRE_Int right );
void
hypre_qsort3_long_dbl( hypre_long_double *v, HYPRE_Int *w, HYPRE_Int *z, HYPRE_Int left, HYPRE_Int right );

void
hypre_qsort3_abs_flt( hypre_float *v, HYPRE_Int *w, HYPRE_Int *z, HYPRE_Int left, HYPRE_Int right );
void
hypre_qsort3_abs_dbl( hypre_double *v, HYPRE_Int *w, HYPRE_Int *z, HYPRE_Int left, HYPRE_Int right );
void
hypre_qsort3_abs_long_dbl( hypre_long_double *v, HYPRE_Int *w, HYPRE_Int *z, HYPRE_Int left, HYPRE_Int right );

void
hypre_qsort3i_flt( HYPRE_Int *v, HYPRE_Int *w, HYPRE_Int *z, HYPRE_Int left, HYPRE_Int right );
void
hypre_qsort3i_dbl( HYPRE_Int *v, HYPRE_Int *w, HYPRE_Int *z, HYPRE_Int left, HYPRE_Int right );
void
hypre_qsort3i_long_dbl( HYPRE_Int *v, HYPRE_Int *w, HYPRE_Int *z, HYPRE_Int left, HYPRE_Int right );

void
hypre_qsort3ir_flt( HYPRE_Int *v, hypre_float *w, HYPRE_Int *z, HYPRE_Int left, HYPRE_Int right );
void
hypre_qsort3ir_dbl( HYPRE_Int *v, hypre_double *w, HYPRE_Int *z, HYPRE_Int left, HYPRE_Int right );
void
hypre_qsort3ir_long_dbl( HYPRE_Int *v, hypre_long_double *w, HYPRE_Int *z, HYPRE_Int left, HYPRE_Int right );

void
hypre_qsortND_flt( HYPRE_Int **v, HYPRE_Int ndim, HYPRE_Int left, HYPRE_Int right );
void
hypre_qsortND_dbl( HYPRE_Int **v, HYPRE_Int ndim, HYPRE_Int left, HYPRE_Int right );
void
hypre_qsortND_long_dbl( HYPRE_Int **v, HYPRE_Int ndim, HYPRE_Int left, HYPRE_Int right );

void
hypre_qsort_abs_flt( hypre_float *w, HYPRE_Int left, HYPRE_Int right );
void
hypre_qsort_abs_dbl( hypre_double *w, HYPRE_Int left, HYPRE_Int right );
void
hypre_qsort_abs_long_dbl( hypre_long_double *w, HYPRE_Int left, HYPRE_Int right );

void
hypre_remove_point_flt( hypre_LinkList *LoL_head_ptr, hypre_LinkList *LoL_tail_ptr, HYPRE_Int measure, HYPRE_Int index, HYPRE_Int *lists, HYPRE_Int *where );
void
hypre_remove_point_dbl( hypre_LinkList *LoL_head_ptr, hypre_LinkList *LoL_tail_ptr, HYPRE_Int measure, HYPRE_Int index, HYPRE_Int *lists, HYPRE_Int *where );
void
hypre_remove_point_long_dbl( hypre_LinkList *LoL_head_ptr, hypre_LinkList *LoL_tail_ptr, HYPRE_Int measure, HYPRE_Int index, HYPRE_Int *lists, HYPRE_Int *where );

char *
hypre_strcpy_flt( char *destination, const char *source );
char *
hypre_strcpy_dbl( char *destination, const char *source );
char *
hypre_strcpy_long_dbl( char *destination, const char *source );

void
hypre_swap_flt( HYPRE_Int *v, HYPRE_Int i, HYPRE_Int j );
void
hypre_swap_dbl( HYPRE_Int *v, HYPRE_Int i, HYPRE_Int j );
void
hypre_swap_long_dbl( HYPRE_Int *v, HYPRE_Int i, HYPRE_Int j );

void
hypre_swap2_flt( HYPRE_Int *v, hypre_float *w, HYPRE_Int i, HYPRE_Int j );
void
hypre_swap2_dbl( HYPRE_Int *v, hypre_double *w, HYPRE_Int i, HYPRE_Int j );
void
hypre_swap2_long_dbl( HYPRE_Int *v, hypre_long_double *w, HYPRE_Int i, HYPRE_Int j );

void
hypre_swap2i_flt( HYPRE_Int *v, HYPRE_Int *w, HYPRE_Int i, HYPRE_Int j );
void
hypre_swap2i_dbl( HYPRE_Int *v, HYPRE_Int *w, HYPRE_Int i, HYPRE_Int j );
void
hypre_swap2i_long_dbl( HYPRE_Int *v, HYPRE_Int *w, HYPRE_Int i, HYPRE_Int j );

void
hypre_swap3_d_flt( hypre_float *v, HYPRE_Int *w, HYPRE_Int *z, HYPRE_Int i, HYPRE_Int j );
void
hypre_swap3_d_dbl( hypre_double *v, HYPRE_Int *w, HYPRE_Int *z, HYPRE_Int i, HYPRE_Int j );
void
hypre_swap3_d_long_dbl( hypre_long_double *v, HYPRE_Int *w, HYPRE_Int *z, HYPRE_Int i, HYPRE_Int j );

void
hypre_swap3_d_perm_flt( HYPRE_Int *v, hypre_float *w, HYPRE_Int *z, HYPRE_Int i, HYPRE_Int j );
void
hypre_swap3_d_perm_dbl( HYPRE_Int *v, hypre_double *w, HYPRE_Int *z, HYPRE_Int i, HYPRE_Int j );
void
hypre_swap3_d_perm_long_dbl( HYPRE_Int *v, hypre_long_double *w, HYPRE_Int *z, HYPRE_Int i, HYPRE_Int j );

void
hypre_swap3i_flt( HYPRE_Int *v, HYPRE_Int *w, HYPRE_Int *z, HYPRE_Int i, HYPRE_Int j );
void
hypre_swap3i_dbl( HYPRE_Int *v, HYPRE_Int *w, HYPRE_Int *z, HYPRE_Int i, HYPRE_Int j );
void
hypre_swap3i_long_dbl( HYPRE_Int *v, HYPRE_Int *w, HYPRE_Int *z, HYPRE_Int i, HYPRE_Int j );

void
hypre_swap_c_flt( hypre_float *v, HYPRE_Int i, HYPRE_Int j );
void
hypre_swap_c_dbl( hypre_double *v, HYPRE_Int i, HYPRE_Int j );
void
hypre_swap_c_long_dbl( hypre_long_double *v, HYPRE_Int i, HYPRE_Int j );

void
hypre_swap_d_flt( hypre_float *v, HYPRE_Int i, HYPRE_Int j );
void
hypre_swap_d_dbl( hypre_double *v, HYPRE_Int i, HYPRE_Int j );
void
hypre_swap_d_long_dbl( hypre_long_double *v, HYPRE_Int i, HYPRE_Int j );

void
hypre_topo_sort_flt( const HYPRE_Int *row_ptr, const HYPRE_Int *col_inds, const hypre_float *data, HYPRE_Int *ordering, HYPRE_Int n );
void
hypre_topo_sort_dbl( const HYPRE_Int *row_ptr, const HYPRE_Int *col_inds, const hypre_double *data, HYPRE_Int *ordering, HYPRE_Int n );
void
hypre_topo_sort_long_dbl( const HYPRE_Int *row_ptr, const HYPRE_Int *col_inds, const hypre_long_double *data, HYPRE_Int *ordering, HYPRE_Int n );

void
hypre_union2_flt( HYPRE_Int n1, HYPRE_BigInt *arr1, HYPRE_Int n2, HYPRE_BigInt *arr2, HYPRE_Int *n3, HYPRE_BigInt *arr3, HYPRE_Int *map1, HYPRE_Int *map2 );
void
hypre_union2_dbl( HYPRE_Int n1, HYPRE_BigInt *arr1, HYPRE_Int n2, HYPRE_BigInt *arr2, HYPRE_Int *n3, HYPRE_BigInt *arr3, HYPRE_Int *map1, HYPRE_Int *map2 );
void
hypre_union2_long_dbl( HYPRE_Int n1, HYPRE_BigInt *arr1, HYPRE_Int n2, HYPRE_BigInt *arr2, HYPRE_Int *n3, HYPRE_BigInt *arr3, HYPRE_Int *map1, HYPRE_Int *map2 );

HYPRE_Real
time_getCPUSeconds_flt( void );
HYPRE_Real
time_getCPUSeconds_dbl( void );
HYPRE_Real
time_getCPUSeconds_long_dbl( void );

HYPRE_Real
time_getWallclockSeconds_flt( void );
HYPRE_Real
time_getWallclockSeconds_dbl( void );
HYPRE_Real
time_getWallclockSeconds_long_dbl( void );

void
utilities_FortranMatrixAdd_flt( hypre_float a, utilities_FortranMatrix* mtxA, utilities_FortranMatrix* mtxB, utilities_FortranMatrix* mtxC );
void
utilities_FortranMatrixAdd_dbl( hypre_double a, utilities_FortranMatrix* mtxA, utilities_FortranMatrix* mtxB, utilities_FortranMatrix* mtxC );
void
utilities_FortranMatrixAdd_long_dbl( hypre_long_double a, utilities_FortranMatrix* mtxA, utilities_FortranMatrix* mtxB, utilities_FortranMatrix* mtxC );

void
utilities_FortranMatrixAllocateData_flt( HYPRE_BigInt h, HYPRE_BigInt w, utilities_FortranMatrix* mtx );
void
utilities_FortranMatrixAllocateData_dbl( HYPRE_BigInt h, HYPRE_BigInt w, utilities_FortranMatrix* mtx );
void
utilities_FortranMatrixAllocateData_long_dbl( HYPRE_BigInt h, HYPRE_BigInt w, utilities_FortranMatrix* mtx );

void
utilities_FortranMatrixClear_flt( utilities_FortranMatrix* mtx );
void
utilities_FortranMatrixClear_dbl( utilities_FortranMatrix* mtx );
void
utilities_FortranMatrixClear_long_dbl( utilities_FortranMatrix* mtx );

void
utilities_FortranMatrixClearL_flt( utilities_FortranMatrix* mtx );
void
utilities_FortranMatrixClearL_dbl( utilities_FortranMatrix* mtx );
void
utilities_FortranMatrixClearL_long_dbl( utilities_FortranMatrix* mtx );

void
utilities_FortranMatrixCopy_flt( utilities_FortranMatrix* src, HYPRE_Int t, utilities_FortranMatrix* dest );
void
utilities_FortranMatrixCopy_dbl( utilities_FortranMatrix* src, HYPRE_Int t, utilities_FortranMatrix* dest );
void
utilities_FortranMatrixCopy_long_dbl( utilities_FortranMatrix* src, HYPRE_Int t, utilities_FortranMatrix* dest );

utilities_FortranMatrix*
utilities_FortranMatrixCreate_flt( void );
utilities_FortranMatrix*
utilities_FortranMatrixCreate_dbl( void );
utilities_FortranMatrix*
utilities_FortranMatrixCreate_long_dbl( void );

void
utilities_FortranMatrixDMultiply_flt( utilities_FortranMatrix* d, utilities_FortranMatrix* mtx );
void
utilities_FortranMatrixDMultiply_dbl( utilities_FortranMatrix* d, utilities_FortranMatrix* mtx );
void
utilities_FortranMatrixDMultiply_long_dbl( utilities_FortranMatrix* d, utilities_FortranMatrix* mtx );

void
utilities_FortranMatrixDestroy_flt( utilities_FortranMatrix* mtx );
void
utilities_FortranMatrixDestroy_dbl( utilities_FortranMatrix* mtx );
void
utilities_FortranMatrixDestroy_long_dbl( utilities_FortranMatrix* mtx );

HYPRE_Real
utilities_FortranMatrixFNorm_flt( utilities_FortranMatrix* mtx );
HYPRE_Real
utilities_FortranMatrixFNorm_dbl( utilities_FortranMatrix* mtx );
HYPRE_Real
utilities_FortranMatrixFNorm_long_dbl( utilities_FortranMatrix* mtx );

void
utilities_FortranMatrixGetDiagonal_flt( utilities_FortranMatrix* mtx, utilities_FortranMatrix* d );
void
utilities_FortranMatrixGetDiagonal_dbl( utilities_FortranMatrix* mtx, utilities_FortranMatrix* d );
void
utilities_FortranMatrixGetDiagonal_long_dbl( utilities_FortranMatrix* mtx, utilities_FortranMatrix* d );

HYPRE_BigInt
utilities_FortranMatrixGlobalHeight_flt( utilities_FortranMatrix* mtx );
HYPRE_BigInt
utilities_FortranMatrixGlobalHeight_dbl( utilities_FortranMatrix* mtx );
HYPRE_BigInt
utilities_FortranMatrixGlobalHeight_long_dbl( utilities_FortranMatrix* mtx );

HYPRE_BigInt
utilities_FortranMatrixHeight_flt( utilities_FortranMatrix* mtx );
HYPRE_BigInt
utilities_FortranMatrixHeight_dbl( utilities_FortranMatrix* mtx );
HYPRE_BigInt
utilities_FortranMatrixHeight_long_dbl( utilities_FortranMatrix* mtx );

void
utilities_FortranMatrixIndexCopy_flt( HYPRE_Int* index, utilities_FortranMatrix* src, HYPRE_Int t, utilities_FortranMatrix* dest );
void
utilities_FortranMatrixIndexCopy_dbl( HYPRE_Int* index, utilities_FortranMatrix* src, HYPRE_Int t, utilities_FortranMatrix* dest );
void
utilities_FortranMatrixIndexCopy_long_dbl( HYPRE_Int* index, utilities_FortranMatrix* src, HYPRE_Int t, utilities_FortranMatrix* dest );

HYPRE_Real
utilities_FortranMatrixMaxValue_flt( utilities_FortranMatrix* mtx );
HYPRE_Real
utilities_FortranMatrixMaxValue_dbl( utilities_FortranMatrix* mtx );
HYPRE_Real
utilities_FortranMatrixMaxValue_long_dbl( utilities_FortranMatrix* mtx );

void
utilities_FortranMatrixMultiply_flt( utilities_FortranMatrix* mtxA, HYPRE_Int tA, utilities_FortranMatrix* mtxB, HYPRE_Int tB, utilities_FortranMatrix* mtxC );
void
utilities_FortranMatrixMultiply_dbl( utilities_FortranMatrix* mtxA, HYPRE_Int tA, utilities_FortranMatrix* mtxB, HYPRE_Int tB, utilities_FortranMatrix* mtxC );
void
utilities_FortranMatrixMultiply_long_dbl( utilities_FortranMatrix* mtxA, HYPRE_Int tA, utilities_FortranMatrix* mtxB, HYPRE_Int tB, utilities_FortranMatrix* mtxC );

void
utilities_FortranMatrixMultiplyD_flt( utilities_FortranMatrix* mtx, utilities_FortranMatrix* d );
void
utilities_FortranMatrixMultiplyD_dbl( utilities_FortranMatrix* mtx, utilities_FortranMatrix* d );
void
utilities_FortranMatrixMultiplyD_long_dbl( utilities_FortranMatrix* mtx, utilities_FortranMatrix* d );

HYPRE_Int
utilities_FortranMatrixPrint_flt( utilities_FortranMatrix* mtx, const char *fileName );
HYPRE_Int
utilities_FortranMatrixPrint_dbl( utilities_FortranMatrix* mtx, const char *fileName );
HYPRE_Int
utilities_FortranMatrixPrint_long_dbl( utilities_FortranMatrix* mtx, const char *fileName );

void
utilities_FortranMatrixSelectBlock_flt( utilities_FortranMatrix* mtx, HYPRE_BigInt iFrom, HYPRE_BigInt iTo, HYPRE_BigInt jFrom, HYPRE_BigInt jTo, utilities_FortranMatrix* block );
void
utilities_FortranMatrixSelectBlock_dbl( utilities_FortranMatrix* mtx, HYPRE_BigInt iFrom, HYPRE_BigInt iTo, HYPRE_BigInt jFrom, HYPRE_BigInt jTo, utilities_FortranMatrix* block );
void
utilities_FortranMatrixSelectBlock_long_dbl( utilities_FortranMatrix* mtx, HYPRE_BigInt iFrom, HYPRE_BigInt iTo, HYPRE_BigInt jFrom, HYPRE_BigInt jTo, utilities_FortranMatrix* block );

void
utilities_FortranMatrixSetDiagonal_flt( utilities_FortranMatrix* mtx, utilities_FortranMatrix* d );
void
utilities_FortranMatrixSetDiagonal_dbl( utilities_FortranMatrix* mtx, utilities_FortranMatrix* d );
void
utilities_FortranMatrixSetDiagonal_long_dbl( utilities_FortranMatrix* mtx, utilities_FortranMatrix* d );

void
utilities_FortranMatrixSetToIdentity_flt( utilities_FortranMatrix* mtx );
void
utilities_FortranMatrixSetToIdentity_dbl( utilities_FortranMatrix* mtx );
void
utilities_FortranMatrixSetToIdentity_long_dbl( utilities_FortranMatrix* mtx );

void
utilities_FortranMatrixSymmetrize_flt( utilities_FortranMatrix* mtx );
void
utilities_FortranMatrixSymmetrize_dbl( utilities_FortranMatrix* mtx );
void
utilities_FortranMatrixSymmetrize_long_dbl( utilities_FortranMatrix* mtx );

void
utilities_FortranMatrixTransposeSquare_flt( utilities_FortranMatrix* mtx );
void
utilities_FortranMatrixTransposeSquare_dbl( utilities_FortranMatrix* mtx );
void
utilities_FortranMatrixTransposeSquare_long_dbl( utilities_FortranMatrix* mtx );

void
utilities_FortranMatrixUpperInv_flt( utilities_FortranMatrix* u );
void
utilities_FortranMatrixUpperInv_dbl( utilities_FortranMatrix* u );
void
utilities_FortranMatrixUpperInv_long_dbl( utilities_FortranMatrix* u );

HYPRE_Real
utilities_FortranMatrixValue_flt( utilities_FortranMatrix* mtx, HYPRE_BigInt i, HYPRE_BigInt j );
HYPRE_Real
utilities_FortranMatrixValue_dbl( utilities_FortranMatrix* mtx, HYPRE_BigInt i, HYPRE_BigInt j );
HYPRE_Real
utilities_FortranMatrixValue_long_dbl( utilities_FortranMatrix* mtx, HYPRE_BigInt i, HYPRE_BigInt j );

HYPRE_Real*
utilities_FortranMatrixValuePtr_flt( utilities_FortranMatrix* mtx, HYPRE_BigInt i, HYPRE_BigInt j );
HYPRE_Real*
utilities_FortranMatrixValuePtr_dbl( utilities_FortranMatrix* mtx, HYPRE_BigInt i, HYPRE_BigInt j );
HYPRE_Real*
utilities_FortranMatrixValuePtr_long_dbl( utilities_FortranMatrix* mtx, HYPRE_BigInt i, HYPRE_BigInt j );

HYPRE_Real*
utilities_FortranMatrixValues_flt( utilities_FortranMatrix* mtx );
HYPRE_Real*
utilities_FortranMatrixValues_dbl( utilities_FortranMatrix* mtx );
HYPRE_Real*
utilities_FortranMatrixValues_long_dbl( utilities_FortranMatrix* mtx );

HYPRE_BigInt
utilities_FortranMatrixWidth_flt( utilities_FortranMatrix* mtx );
HYPRE_BigInt
utilities_FortranMatrixWidth_dbl( utilities_FortranMatrix* mtx );
HYPRE_BigInt
utilities_FortranMatrixWidth_long_dbl( utilities_FortranMatrix* mtx );

void
utilities_FortranMatrixWrap_flt( hypre_float* v, HYPRE_BigInt gh, HYPRE_BigInt h, HYPRE_BigInt w, utilities_FortranMatrix* mtx );
void
utilities_FortranMatrixWrap_dbl( hypre_double* v, HYPRE_BigInt gh, HYPRE_BigInt h, HYPRE_BigInt w, utilities_FortranMatrix* mtx );
void
utilities_FortranMatrixWrap_long_dbl( hypre_long_double* v, HYPRE_BigInt gh, HYPRE_BigInt h, HYPRE_BigInt w, utilities_FortranMatrix* mtx );


/*** DO NOT EDIT THIS FILE DIRECTLY (use ../config/gen_code.sh to generate) ***/

/******************************************************************************
 * Copyright (c) 1998 Lawrence Livermore National Security, LLC and other
 * HYPRE Project Developers. See the top-level COPYRIGHT file for details.
 *
 * SPDX-License-Identifier: (Apache-2.0 OR MIT)
 ******************************************************************************/



/*** DO NOT EDIT THIS FILE DIRECTLY (use ../config/gen_code.sh to generate) ***/

/******************************************************************************
 * Copyright (c) 1998 Lawrence Livermore National Security, LLC and other
 * HYPRE Project Developers. See the top-level COPYRIGHT file for details.
 *
 * SPDX-License-Identifier: (Apache-2.0 OR MIT)
 ******************************************************************************/



#endif

#ifdef __cplusplus
}
#endif

#endif

