/*
 *
 *  Copyright (C) 2000 Silicon Graphics, Inc.  All Rights Reserved. 
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  Further, this software is distributed without any warranty that it is
 *  free of the rightful claim of any third person regarding infringement
 *  or the like.  Any license provided herein, whether implied or
 *  otherwise, applies only to this software file.  Patent licenses, if
 *  any, provided herein do not apply to combinations of this program with
 *  other software, or any other product whatsoever.
 * 
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
 *  Mountain View, CA  94043, or:
 * 
 *  http://www.sgi.com 
 * 
 *  For further information regarding this notice, see: 
 * 
 *  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
 *
 */

/*-------------------------------------------------------------
 *  This is an example from The Inventor Toolmaker,
 *  chapter 11.
 *
 *  This is the header file for the "DialNButton" device.
 *------------------------------------------------------------*/

#ifndef  _DIAL_N_BUTTON_
#define  _DIAL_N_BUTTON_

#include <X11/X.h>
#include <X11/extensions/XInput.h>
#include <Inventor/Xt/devices/SoXtDevice.h>
#include <Inventor/events/SoButtonEvent.h>

class ButtonBoxEvent;
class DialEvent;

class DialNButton : public SoXtDevice {
  public:
   // The first constructor uses the display set when SoXt::init is called.
   DialNButton();
   DialNButton(Display *d);
   ~DialNButton();
   
   // these functions will enable/disable this device for the widget.
   // the callback function f will be invoked when events occur in w.
   // data is the clientData which will be passed.
   virtual void        enable(Widget w, XtEventHandler f,
                           XtPointer data, Window win = (Window) NULL);
   virtual void        disable(Widget w, XtEventHandler f,
                           XtPointer data);
   
   //
   // this converts an X event into an SoEvent,
   // returning NULL if the event is not from this device.
   //
   virtual const SoEvent * translateEvent(XAnyEvent *xevent);
   
   // Return whether or not the dial+button device exists for use.
   // The first uses the display set when SoXt::init is called.
   static SbBool	exists() { return exists(SoXt::getDisplay()); }
   static SbBool	exists(Display *d);
   
  protected:
   // initialize the device
   static void		init(Display *d);
   static SbBool	firstTime;
   
   // these event types are retrieved from the X server at run time
   static int		motionEventType;
   static int		buttonPressEventType;
   static int		buttonReleaseEventType;
   
   // event classes passed to XSelectExtensionEvent
   static XEventClass	eventClasses[3]; // max of 3 event classes for this
   static int		eventTypes[3];	 // max of 3 event types for this
   
   // device id is set at runtime
   static XDevice	*device;
   
   // inventor events generated by this device
   ButtonBoxEvent	*buttonEvent;
   DialEvent		*dialEvent;

   // event translators!
   DialEvent	   *translateMotionEvent(XDeviceMotionEvent *me);
   ButtonBoxEvent  *translateButtonEvent(
                        XDeviceButtonEvent *be,
                        SoButtonEvent::State whichState);
};

#endif /* _DIAL_N_BUTTON_ */
