; This test aims to check ability to support "Arithmetic with Overflow" intrinsics
; in the special case when those intrinsics are being generated by the CodeGenPrepare;
; pass during translations with optimization (note -disable-lsr, to inhibit
; strength reduction pre-empting with a more preferable match for this pattern
; in llc arguments).

; RUN: llc -O3 -mtriple=spirv32-unknown-unknown %s -o - | FileCheck %s
; RUN: %if spirv-tools %{ llc -O3 -mtriple=spirv32-unknown-unknown %s -o - -filetype=obj | spirv-val %}

; RUN: llc -O3 -mtriple=spirv64-unknown-unknown %s -o - | FileCheck %s
; RUN: %if spirv-tools %{ llc -O3 -mtriple=spirv64-unknown-unknown %s -o - -filetype=obj | spirv-val %}

; RUN: llc -O3 -disable-lsr -mtriple=spirv32-unknown-unknown %s -o - | FileCheck --check-prefix=NOLSR %s
; RUN: %if spirv-tools %{ llc -O3 -disable-lsr -mtriple=spirv32-unknown-unknown %s -o - -filetype=obj | spirv-val %}

; RUN: llc -O3 -disable-lsr -mtriple=spirv64-unknown-unknown %s -o - | FileCheck --check-prefix=NOLSR %s
; RUN: %if spirv-tools %{ llc -O3 -disable-lsr -mtriple=spirv64-unknown-unknown %s -o - -filetype=obj | spirv-val %}

; CHECK-DAG: OpName %[[PhiRes:.*]] "lsr.iv"
; CHECK-DAG: OpName %[[IsOver:.*]] "fl"
; CHECK-DAG: OpName %[[Val:.*]] "lsr.iv.next"
; CHECK-DAG: %[[Int:.*]] = OpTypeInt 32 0
; CHECK-DAG: %[[Char:.*]] = OpTypeInt 8 0
; CHECK-DAG: %[[PtrChar:.*]] = OpTypePointer Generic %[[Char]]
; CHECK-DAG: %[[Bool:.*]] = OpTypeBool
; CHECK-DAG: %[[Const1:.*]] = OpConstant %[[Int]] 1{{$}}
; CHECK-DAG: %[[Zero:.*]] = OpConstantNull %[[Int]]
; CHECK-DAG: %[[Const42:.*]] = OpConstant %[[Char]] 42{{$}}

; CHECK: OpFunction
; CHECK: %[[A:.*]] = OpFunctionParameter %[[Int]]
; CHECK: %[[Ptr:.*]] = OpFunctionParameter %[[PtrChar]]
; CHECK: %[[APlusOne:.*]] = OpIAdd %[[Int]] %[[A]] %[[Const1]]
;	CHECK: OpBranch %[[#]]
;	CHECK: [[#]] = OpLabel
;	CHECK: %[[PhiRes]] = OpPhi %[[Int]] %[[Val]] %[[#]] %[[APlusOne]] %[[#]]
;	CHECK: %[[IsOver]] = OpIEqual %[[Bool]] %[[#]] %[[#]]
;	CHECK: OpBranchConditional %[[IsOver]] %[[#]] %[[#]]
;	CHECK: [[#]] = OpLabel
;	CHECK: OpStore %[[Ptr]] %[[Const42]] Aligned 1
;	CHECK: [[Val]] = OpIAdd %[[Int]] %[[PhiRes]] %[[Const1]]
; CHECK: OpBranch %[[#]]
;	CHECK: [[#]] = OpLabel
;	OpReturnValue %[[PhiRes]]

; NOLSR-DAG: OpName %[[Val:.*]] "math"
; NOLSR-DAG: OpName %[[IsOver:.*]] "ov"
; NOLSR-DAG: %[[Int:.*]] = OpTypeInt 32 0
; NOLSR-DAG: %[[Char:.*]] = OpTypeInt 8 0
; NOLSR-DAG: %[[PtrChar:.*]] = OpTypePointer Generic %[[Char]]
; NOLSR-DAG: %[[Bool:.*]] = OpTypeBool
; NOLSR-DAG: %[[Struct:.*]] = OpTypeStruct %[[Int]] %[[Int]]
; NOLSR-DAG: %[[Const1:.*]] = OpConstant %[[Int]] 1
; NOLSR-DAG: %[[Const42:.*]] = OpConstant %[[Char]] 42
; NOLSR-DAG: %[[Zero:.*]] = OpConstantNull %[[Int]]

; NOLSR: OpFunction
; NOLSR: %[[A:.*]] = OpFunctionParameter %[[Int]]
; NOLSR: %[[Ptr:.*]] = OpFunctionParameter %[[PtrChar]]
; NOLSR: %[[#]] = OpLabel
; NOLSR: OpBranch %[[#]]
; NOLSR: %[[#]] = OpLabel
; NOLSR: %[[PhiRes:.*]] = OpPhi %[[Int]] %[[A]] %[[#]] %[[Val]] %[[#]]
; NOLSR: %[[AggRes:.*]] = OpIAddCarry %[[Struct]] %[[PhiRes]] %[[Const1]]
; NOLSR: %[[Val]] = OpCompositeExtract %[[Int]] %[[AggRes]] 0
; NOLSR: %[[Over:.*]] = OpCompositeExtract %[[Int]] %[[AggRes]] 1
; NOLSR: %[[IsOver]] = OpINotEqual %[[Bool:.*]] %[[Over]] %[[Zero]]
; NOLSR: OpBranchConditional %[[IsOver]] %[[#]] %[[#]]
; NOLSR: OpStore %[[Ptr]] %[[Const42]] Aligned 1
; NOLSR: OpBranch %[[#]]
; NOLSR: %[[#]] = OpLabel
; NOLSR: OpReturnValue %[[Val]]
; NOLSR: OpFunctionEnd

define spir_func i32 @foo(i32 %a, ptr addrspace(4) %p) {
entry:
  br label %l1

body:
  store i8 42, ptr addrspace(4) %p
  br label %l1

l1:
  %e = phi i32 [ %a, %entry ], [ %i, %body ]
  %i = add nsw i32 %e, 1
  %fl = icmp eq i32 %i, 0
  br i1 %fl, label %exit, label %body

exit:
  ret i32 %i
}
