# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, Literal, Mapping, Optional, TYPE_CHECKING, Union, overload

from .._utils.model_base import Model as _Model, rest_discriminator, rest_field
from ._enums import LimitType

if TYPE_CHECKING:
    from .. import models as _models


class AllocatedQuotaToSubscriptionList(_Model):
    """Quota allocated to subscriptions.

    :ivar value: List of Group Quota Limit allocated to subscriptions.
    :vartype value: list[~azure.mgmt.quota.models.AllocatedToSubscription]
    """

    value: Optional[list["_models.AllocatedToSubscription"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """List of Group Quota Limit allocated to subscriptions."""

    @overload
    def __init__(
        self,
        *,
        value: Optional[list["_models.AllocatedToSubscription"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AllocatedToSubscription(_Model):
    """SubscriptionIds and quota allocated to subscriptions from the GroupQuota.

    :ivar subscription_id: An Azure subscriptionId.
    :vartype subscription_id: str
    :ivar quota_allocated: The amount of quota allocated to this subscriptionId from the
     GroupQuotasEntity.
    :vartype quota_allocated: int
    """

    subscription_id: Optional[str] = rest_field(
        name="subscriptionId", visibility=["read", "create", "update", "delete", "query"]
    )
    """An Azure subscriptionId."""
    quota_allocated: Optional[int] = rest_field(
        name="quotaAllocated", visibility=["read", "create", "update", "delete", "query"]
    )
    """The amount of quota allocated to this subscriptionId from the GroupQuotasEntity."""

    @overload
    def __init__(
        self,
        *,
        subscription_id: Optional[str] = None,
        quota_allocated: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Resource(_Model):
    """Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.quota.models.SystemData
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}."""
    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the resource."""
    type: Optional[str] = rest_field(visibility=["read"])
    """The type of the resource. E.g. \"Microsoft.Compute/virtualMachines\" or
     \"Microsoft.Storage/storageAccounts\"."""
    system_data: Optional["_models.SystemData"] = rest_field(name="systemData", visibility=["read"])
    """Azure Resource Manager metadata containing createdBy and modifiedBy information."""


class ExtensionResource(Resource):
    """The base extension resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.quota.models.SystemData
    """


class CurrentQuotaLimitBase(ExtensionResource):
    """Quota limit.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.quota.models.SystemData
    :ivar properties: Quota properties for the specified resource, based on the API called, Quotas
     or Usages.
    :vartype properties: ~azure.mgmt.quota.models.QuotaProperties
    """

    properties: Optional["_models.QuotaProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Quota properties for the specified resource, based on the API called, Quotas or Usages."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.QuotaProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CurrentUsagesBase(ExtensionResource):
    """Resource usage.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.quota.models.SystemData
    :ivar properties: Usage properties for the specified resource.
    :vartype properties: ~azure.mgmt.quota.models.UsagesProperties
    """

    properties: Optional["_models.UsagesProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Usage properties for the specified resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.UsagesProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ErrorAdditionalInfo(_Model):
    """The resource management error additional info.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    type: Optional[str] = rest_field(visibility=["read"])
    """The additional info type."""
    info: Optional[Any] = rest_field(visibility=["read"])
    """The additional info."""


class ErrorDetail(_Model):
    """The error detail.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.quota.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.quota.models.ErrorAdditionalInfo]
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    target: Optional[str] = rest_field(visibility=["read"])
    """The error target."""
    details: Optional[list["_models.ErrorDetail"]] = rest_field(visibility=["read"])
    """The error details."""
    additional_info: Optional[list["_models.ErrorAdditionalInfo"]] = rest_field(
        name="additionalInfo", visibility=["read"]
    )
    """The error additional info."""


class ErrorResponse(_Model):
    """Error response.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.quota.models.ErrorDetail
    """

    error: Optional["_models.ErrorDetail"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error object."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.ErrorDetail"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ExceptionResponse(_Model):
    """Error.

    :ivar error: API error details.
    :vartype error: ~azure.mgmt.quota.models.ServiceError
    """

    error: Optional["_models.ServiceError"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """API error details."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.ServiceError"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class GroupQuotaDetails(_Model):
    """Group Quota details.

    :ivar resource_name: The resource name, such as SKU name.
    :vartype resource_name: str
    :ivar limit: The current Group Quota Limit at the parentId level.
    :vartype limit: int
    :ivar comment: Any comment related to quota request.
    :vartype comment: str
    :ivar unit: The usages units, such as Count and Bytes. When requesting quota, use the **unit**
     value returned in the GET response in the request body of your PUT operation.
    :vartype unit: str
    :ivar name: Name of the resource provided by the resource provider. This property is already
     included in the request URI, so it is a readonly property returned in the response.
    :vartype name: ~azure.mgmt.quota.models.GroupQuotaDetailsName
    :ivar available_limit: The available Group Quota Limit at the MG level. This Group quota can be
     allocated to subscription(s).
    :vartype available_limit: int
    :ivar allocated_to_subscriptions: Quota allocated to subscriptions.
    :vartype allocated_to_subscriptions: ~azure.mgmt.quota.models.AllocatedQuotaToSubscriptionList
    """

    resource_name: Optional[str] = rest_field(
        name="resourceName", visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource name, such as SKU name."""
    limit: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The current Group Quota Limit at the parentId level."""
    comment: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Any comment related to quota request."""
    unit: Optional[str] = rest_field(visibility=["read"])
    """The usages units, such as Count and Bytes. When requesting quota, use the **unit** value
     returned in the GET response in the request body of your PUT operation."""
    name: Optional["_models.GroupQuotaDetailsName"] = rest_field(visibility=["read"])
    """Name of the resource provided by the resource provider. This property is already included in
     the request URI, so it is a readonly property returned in the response."""
    available_limit: Optional[int] = rest_field(name="availableLimit", visibility=["read"])
    """The available Group Quota Limit at the MG level. This Group quota can be allocated to
     subscription(s)."""
    allocated_to_subscriptions: Optional["_models.AllocatedQuotaToSubscriptionList"] = rest_field(
        name="allocatedToSubscriptions", visibility=["read"]
    )
    """Quota allocated to subscriptions."""

    __flattened_items = ["value", "localized_value"]

    @overload
    def __init__(
        self,
        *,
        resource_name: Optional[str] = None,
        limit: Optional[int] = None,
        comment: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.name is None:
                return None
            return getattr(self.name, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.name is None:
                self.name = self._attr_to_rest_field["name"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class GroupQuotaDetailsName(_Model):
    """Name of the resource provided by the resource provider. This property is already included in
    the request URI, so it is a readonly property returned in the response.

    :ivar value: Resource name.
    :vartype value: str
    :ivar localized_value: Resource display name.
    :vartype localized_value: str
    """

    value: Optional[str] = rest_field(visibility=["read"])
    """Resource name."""
    localized_value: Optional[str] = rest_field(name="localizedValue", visibility=["read"])
    """Resource display name."""


class GroupQuotaLimit(_Model):
    """Group Quota limit.

    :ivar properties: Group Quota properties for the specified resource.
    :vartype properties: ~azure.mgmt.quota.models.GroupQuotaLimitProperties
    """

    properties: Optional["_models.GroupQuotaLimitProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Group Quota properties for the specified resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.GroupQuotaLimitProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ProxyResource(Resource):
    """Proxy Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.quota.models.SystemData
    """


class GroupQuotaLimitList(ProxyResource):
    """List of Group Quota Limit details.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.quota.models.SystemData
    :ivar properties:
    :vartype properties: ~azure.mgmt.quota.models.GroupQuotaLimitListProperties
    """

    properties: Optional["_models.GroupQuotaLimitListProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.GroupQuotaLimitListProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class GroupQuotaLimitListProperties(_Model):
    """GroupQuotaLimitListProperties.

    :ivar provisioning_state: Request status. Known values are: "Accepted", "Created", "Invalid",
     "Succeeded", "Escalated", "Failed", "InProgress", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.quota.models.RequestState
    :ivar value: List of Group Quota Limit details.
    :vartype value: list[~azure.mgmt.quota.models.GroupQuotaLimit]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    provisioning_state: Optional[Union[str, "_models.RequestState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Request status. Known values are: \"Accepted\", \"Created\", \"Invalid\", \"Succeeded\",
     \"Escalated\", \"Failed\", \"InProgress\", and \"Canceled\"."""
    value: Optional[list["_models.GroupQuotaLimit"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """List of Group Quota Limit details."""
    next_link: Optional[str] = rest_field(name="nextLink", visibility=["read"])
    """The URL to use for getting the next set of results."""

    @overload
    def __init__(
        self,
        *,
        value: Optional[list["_models.GroupQuotaLimit"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class GroupQuotaLimitProperties(GroupQuotaDetails):
    """Group Quota properties for the specified resource.

    :ivar resource_name: The resource name, such as SKU name.
    :vartype resource_name: str
    :ivar limit: The current Group Quota Limit at the parentId level.
    :vartype limit: int
    :ivar comment: Any comment related to quota request.
    :vartype comment: str
    :ivar unit: The usages units, such as Count and Bytes. When requesting quota, use the **unit**
     value returned in the GET response in the request body of your PUT operation.
    :vartype unit: str
    :ivar name: Name of the resource provided by the resource provider. This property is already
     included in the request URI, so it is a readonly property returned in the response.
    :vartype name: ~azure.mgmt.quota.models.GroupQuotaDetailsName
    :ivar available_limit: The available Group Quota Limit at the MG level. This Group quota can be
     allocated to subscription(s).
    :vartype available_limit: int
    :ivar allocated_to_subscriptions: Quota allocated to subscriptions.
    :vartype allocated_to_subscriptions: ~azure.mgmt.quota.models.AllocatedQuotaToSubscriptionList
    """

    __flattened_items = ["value", "localized_value"]

    @overload
    def __init__(
        self,
        *,
        resource_name: Optional[str] = None,
        limit: Optional[int] = None,
        comment: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.name is None:
                return None
            return getattr(self.name, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.name is None:
                self.name = self._attr_to_rest_field["name"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class GroupQuotaRequestBase(_Model):
    """The new GroupQuota limit requested.

    :ivar properties:
    :vartype properties: ~azure.mgmt.quota.models.GroupQuotaRequestBaseProperties
    """

    properties: Optional["_models.GroupQuotaRequestBaseProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.GroupQuotaRequestBaseProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class GroupQuotaRequestBaseProperties(_Model):
    """GroupQuotaRequestBaseProperties.

    :ivar limit: The new quota limit for the subscription. The incremental quota will be allocated
     from pre-approved group quota.
    :vartype limit: int
    :ivar name: Name of the resource provided by the resource provider. This property is already
     included in the request URI, so it is a readonly property returned in the response.
    :vartype name: ~azure.mgmt.quota.models.GroupQuotaRequestBasePropertiesName
    :ivar region: Location/Azure region for the quota requested for resource.
    :vartype region: str
    :ivar comments: GroupQuota Request comments and details for request. This is optional paramter
     to provide more details related to the requested resource.
    :vartype comments: str
    """

    limit: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The new quota limit for the subscription. The incremental quota will be allocated from
     pre-approved group quota."""
    name: Optional["_models.GroupQuotaRequestBasePropertiesName"] = rest_field(visibility=["read"])
    """Name of the resource provided by the resource provider. This property is already included in
     the request URI, so it is a readonly property returned in the response."""
    region: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Location/Azure region for the quota requested for resource."""
    comments: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """GroupQuota Request comments and details for request. This is optional paramter to provide more
     details related to the requested resource."""

    __flattened_items = ["value", "localized_value"]

    @overload
    def __init__(
        self,
        *,
        limit: Optional[int] = None,
        region: Optional[str] = None,
        comments: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.name is None:
                return None
            return getattr(self.name, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.name is None:
                self.name = self._attr_to_rest_field["name"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class GroupQuotaRequestBasePropertiesName(_Model):
    """Name of the resource provided by the resource provider. This property is already included in
    the request URI, so it is a readonly property returned in the response.

    :ivar value: Resource name.
    :vartype value: str
    :ivar localized_value: Resource display name.
    :vartype localized_value: str
    """

    value: Optional[str] = rest_field(visibility=["read"])
    """Resource name."""
    localized_value: Optional[str] = rest_field(name="localizedValue", visibility=["read"])
    """Resource display name."""


class GroupQuotasEnforcementStatus(ProxyResource):
    """The GroupQuota Enforcement status for a Azure Location/Region.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.quota.models.SystemData
    :ivar properties:
    :vartype properties: ~azure.mgmt.quota.models.GroupQuotasEnforcementStatusProperties
    """

    properties: Optional["_models.GroupQuotasEnforcementStatusProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.GroupQuotasEnforcementStatusProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class GroupQuotasEnforcementStatusProperties(_Model):
    """GroupQuotasEnforcementStatusProperties.

    :ivar enforcement_enabled: Is the GroupQuota Enforcement enabled for the Azure region. Known
     values are: "Enabled", "Disabled", and "NotAvailable".
    :vartype enforcement_enabled: str or ~azure.mgmt.quota.models.EnforcementState
    :ivar enforced_group_name: The name of the group that is enforced.
    :vartype enforced_group_name: str
    :ivar provisioning_state: Request status. Known values are: "Accepted", "Created", "Invalid",
     "Succeeded", "Escalated", "Failed", "InProgress", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.quota.models.RequestState
    :ivar fault_code: Details of the failure.
    :vartype fault_code: str
    """

    enforcement_enabled: Optional[Union[str, "_models.EnforcementState"]] = rest_field(
        name="enforcementEnabled", visibility=["read", "create", "update", "delete", "query"]
    )
    """Is the GroupQuota Enforcement enabled for the Azure region. Known values are: \"Enabled\",
     \"Disabled\", and \"NotAvailable\"."""
    enforced_group_name: Optional[str] = rest_field(name="enforcedGroupName", visibility=["read"])
    """The name of the group that is enforced."""
    provisioning_state: Optional[Union[str, "_models.RequestState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Request status. Known values are: \"Accepted\", \"Created\", \"Invalid\", \"Succeeded\",
     \"Escalated\", \"Failed\", \"InProgress\", and \"Canceled\"."""
    fault_code: Optional[str] = rest_field(name="faultCode", visibility=["read"])
    """Details of the failure."""

    @overload
    def __init__(
        self,
        *,
        enforcement_enabled: Optional[Union[str, "_models.EnforcementState"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class GroupQuotasEntity(ProxyResource):
    """Properties and filters for ShareQuota. The request parameter is optional, if there are no
    filters specified.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.quota.models.SystemData
    :ivar properties: Properties.
    :vartype properties: ~azure.mgmt.quota.models.GroupQuotasEntityProperties
    """

    properties: Optional["_models.GroupQuotasEntityProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Properties."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.GroupQuotasEntityProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class GroupQuotasEntityBase(_Model):
    """Properties and filters for ShareQuota. The request parameter is optional, if there are no
    filters specified.

    :ivar display_name: Display name of the GroupQuota entity.
    :vartype display_name: str
    :ivar group_type: Type of the group. Known values are: "AllocationGroup" and "EnforcedGroup".
    :vartype group_type: str or ~azure.mgmt.quota.models.GroupType
    :ivar provisioning_state: Provisioning state of the operation. Known values are: "Accepted",
     "Created", "Invalid", "Succeeded", "Escalated", "Failed", "InProgress", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.quota.models.RequestState
    """

    display_name: Optional[str] = rest_field(
        name="displayName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Display name of the GroupQuota entity."""
    group_type: Optional[Union[str, "_models.GroupType"]] = rest_field(name="groupType", visibility=["read"])
    """Type of the group. Known values are: \"AllocationGroup\" and \"EnforcedGroup\"."""
    provisioning_state: Optional[Union[str, "_models.RequestState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Provisioning state of the operation. Known values are: \"Accepted\", \"Created\", \"Invalid\",
     \"Succeeded\", \"Escalated\", \"Failed\", \"InProgress\", and \"Canceled\"."""

    @overload
    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class GroupQuotasEntityBasePatch(_Model):
    """Properties and filters for ShareQuota. The request parameter is optional, if there are no
    filters specified.

    :ivar display_name: Display name of the GroupQuota entity.
    :vartype display_name: str
    :ivar provisioning_state: Provisioning state of the operation. Known values are: "Accepted",
     "Created", "Invalid", "Succeeded", "Escalated", "Failed", "InProgress", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.quota.models.RequestState
    """

    display_name: Optional[str] = rest_field(
        name="displayName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Display name of the GroupQuota entity."""
    provisioning_state: Optional[Union[str, "_models.RequestState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Provisioning state of the operation. Known values are: \"Accepted\", \"Created\", \"Invalid\",
     \"Succeeded\", \"Escalated\", \"Failed\", \"InProgress\", and \"Canceled\"."""

    @overload
    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class GroupQuotasEntityPatch(ProxyResource):
    """Properties and filters for ShareQuota. The request parameter is optional, if there are no
    filters specified.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.quota.models.SystemData
    :ivar properties: Properties.
    :vartype properties: ~azure.mgmt.quota.models.GroupQuotasEntityPatchProperties
    """

    properties: Optional["_models.GroupQuotasEntityPatchProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Properties."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.GroupQuotasEntityPatchProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class GroupQuotasEntityPatchProperties(GroupQuotasEntityBasePatch):
    """Properties.

    :ivar display_name: Display name of the GroupQuota entity.
    :vartype display_name: str
    :ivar provisioning_state: Provisioning state of the operation. Known values are: "Accepted",
     "Created", "Invalid", "Succeeded", "Escalated", "Failed", "InProgress", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.quota.models.RequestState
    """

    @overload
    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class GroupQuotasEntityProperties(GroupQuotasEntityBase):
    """Properties.

    :ivar display_name: Display name of the GroupQuota entity.
    :vartype display_name: str
    :ivar group_type: Type of the group. Known values are: "AllocationGroup" and "EnforcedGroup".
    :vartype group_type: str or ~azure.mgmt.quota.models.GroupType
    :ivar provisioning_state: Provisioning state of the operation. Known values are: "Accepted",
     "Created", "Invalid", "Succeeded", "Escalated", "Failed", "InProgress", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.quota.models.RequestState
    """

    @overload
    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class GroupQuotaSubscriptionId(ProxyResource):
    """This represents a Azure subscriptionId that is associated with a GroupQuotasEntity.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.quota.models.SystemData
    :ivar properties:
    :vartype properties: ~azure.mgmt.quota.models.GroupQuotaSubscriptionIdProperties
    """

    properties: Optional["_models.GroupQuotaSubscriptionIdProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.GroupQuotaSubscriptionIdProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class GroupQuotaSubscriptionIdProperties(_Model):
    """GroupQuotaSubscriptionIdProperties.

    :ivar subscription_id: An Azure subscriptionId.
    :vartype subscription_id: str
    :ivar provisioning_state: Status of this subscriptionId being associated with the
     GroupQuotasEntity. Known values are: "Accepted", "Created", "Invalid", "Succeeded",
     "Escalated", "Failed", "InProgress", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.quota.models.RequestState
    """

    subscription_id: Optional[str] = rest_field(
        name="subscriptionId", visibility=["read", "create", "update", "delete", "query"]
    )
    """An Azure subscriptionId."""
    provisioning_state: Optional[Union[str, "_models.RequestState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Status of this subscriptionId being associated with the GroupQuotasEntity. Known values are:
     \"Accepted\", \"Created\", \"Invalid\", \"Succeeded\", \"Escalated\", \"Failed\",
     \"InProgress\", and \"Canceled\"."""

    @overload
    def __init__(
        self,
        *,
        subscription_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class GroupQuotaSubscriptionRequestStatus(ProxyResource):
    """The new quota limit request status.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.quota.models.SystemData
    :ivar properties:
    :vartype properties: ~azure.mgmt.quota.models.GroupQuotaSubscriptionRequestStatusProperties
    """

    properties: Optional["_models.GroupQuotaSubscriptionRequestStatusProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.GroupQuotaSubscriptionRequestStatusProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class GroupQuotaSubscriptionRequestStatusProperties(_Model):  # pylint: disable=name-too-long
    """GroupQuotaSubscriptionRequestStatusProperties.

    :ivar subscription_id: The subscription Id.
    :vartype subscription_id: str
    :ivar request_submit_time: The request submission time. The date conforms to the following
     format specified by the ISO 8601 standard: yyyy-MM-ddTHH:mm:ssZ.
    :vartype request_submit_time: ~datetime.datetime
    :ivar provisioning_state: Status of this subscriptionId being associated with the
     GroupQuotasEntity. Known values are: "Accepted", "Created", "Invalid", "Succeeded",
     "Escalated", "Failed", "InProgress", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.quota.models.RequestState
    """

    subscription_id: Optional[str] = rest_field(
        name="subscriptionId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The subscription Id."""
    request_submit_time: Optional[datetime.datetime] = rest_field(
        name="requestSubmitTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The request submission time. The date conforms to the following format specified by the ISO
     8601 standard: yyyy-MM-ddTHH:mm:ssZ."""
    provisioning_state: Optional[Union[str, "_models.RequestState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Status of this subscriptionId being associated with the GroupQuotasEntity. Known values are:
     \"Accepted\", \"Created\", \"Invalid\", \"Succeeded\", \"Escalated\", \"Failed\",
     \"InProgress\", and \"Canceled\"."""

    @overload
    def __init__(
        self,
        *,
        subscription_id: Optional[str] = None,
        request_submit_time: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class GroupQuotaUsagesBase(_Model):
    """Resource details with usages and GroupQuota.

    :ivar name: Name of the resource provided by the resource provider. This property is already
     included in the request URI, so it is a readonly property returned in the response.
    :vartype name: ~azure.mgmt.quota.models.GroupQuotaUsagesBaseName
    :ivar limit: Quota/limits for the resource.
    :vartype limit: int
    :ivar usages: Usages for the resource.
    :vartype usages: int
    :ivar unit: Representing the units of the usage quota. Possible values are: Count, Bytes,
     Seconds, Percent, CountPerSecond, BytesPerSecond. Based on -
     `https://armwiki.azurewebsites.net/api_contracts/UsagesAPIContract.html?q=usages
     <https://armwiki.azurewebsites.net/api_contracts/UsagesAPIContract.html?q=usages>`_ . Different
     RPs may have different units, Count, type as int64 should work for most of the integer values.
    :vartype unit: str
    """

    name: Optional["_models.GroupQuotaUsagesBaseName"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Name of the resource provided by the resource provider. This property is already included in
     the request URI, so it is a readonly property returned in the response."""
    limit: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Quota/limits for the resource."""
    usages: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Usages for the resource."""
    unit: Optional[str] = rest_field(visibility=["read"])
    """Representing the units of the usage quota. Possible values are: Count, Bytes, Seconds, Percent,
     CountPerSecond, BytesPerSecond. Based on -
     `https://armwiki.azurewebsites.net/api_contracts/UsagesAPIContract.html?q=usages
     <https://armwiki.azurewebsites.net/api_contracts/UsagesAPIContract.html?q=usages>`_ . Different
     RPs may have different units, Count, type as int64 should work for most of the integer values."""

    __flattened_items = ["value", "localized_value"]

    @overload
    def __init__(
        self,
        *,
        name: Optional["_models.GroupQuotaUsagesBaseName"] = None,
        limit: Optional[int] = None,
        usages: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.name is None:
                return None
            return getattr(self.name, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.name is None:
                self.name = self._attr_to_rest_field["name"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class GroupQuotaUsagesBaseName(_Model):
    """Name of the resource provided by the resource provider. This property is already included in
    the request URI, so it is a readonly property returned in the response.

    :ivar value: Resource name.
    :vartype value: str
    :ivar localized_value: Resource display name.
    :vartype localized_value: str
    """

    value: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource name."""
    localized_value: Optional[str] = rest_field(name="localizedValue", visibility=["read"])
    """Resource display name."""

    @overload
    def __init__(
        self,
        *,
        value: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class LimitJsonObject(_Model):
    """LimitJson abstract class.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    LimitObject

    :ivar limit_object_type: The limit object type. Required. "LimitValue"
    :vartype limit_object_type: str or ~azure.mgmt.quota.models.LimitType
    """

    __mapping__: dict[str, _Model] = {}
    limit_object_type: str = rest_discriminator(
        name="limitObjectType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The limit object type. Required. \"LimitValue\""""

    @overload
    def __init__(
        self,
        *,
        limit_object_type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class LimitObject(LimitJsonObject, discriminator="LimitValue"):
    """The resource quota limit value.

    :ivar value: The quota/limit value. Required.
    :vartype value: int
    :ivar limit_type: The quota or usages limit types. Known values are: "Independent" and
     "Shared".
    :vartype limit_type: str or ~azure.mgmt.quota.models.QuotaLimitTypes
    :ivar limit_object_type: The limit object type. Required.
    :vartype limit_object_type: str or ~azure.mgmt.quota.models.LIMIT_VALUE
    """

    value: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The quota/limit value. Required."""
    limit_type: Optional[Union[str, "_models.QuotaLimitTypes"]] = rest_field(
        name="limitType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The quota or usages limit types. Known values are: \"Independent\" and \"Shared\"."""
    limit_object_type: Literal[LimitType.LIMIT_VALUE] = rest_discriminator(name="limitObjectType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The limit object type. Required."""

    @overload
    def __init__(
        self,
        *,
        value: int,
        limit_type: Optional[Union[str, "_models.QuotaLimitTypes"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.limit_object_type = LimitType.LIMIT_VALUE  # type: ignore


class OperationDisplay(_Model):
    """OperationDisplay.

    :ivar provider: Provider name.
    :vartype provider: str
    :ivar resource: Resource name.
    :vartype resource: str
    :ivar operation: Operation name.
    :vartype operation: str
    :ivar description: Operation description.
    :vartype description: str
    """

    provider: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Provider name."""
    resource: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource name."""
    operation: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Operation name."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Operation description."""

    @overload
    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OperationResponse(_Model):
    """OperationResponse.

    :ivar name:
    :vartype name: str
    :ivar display:
    :vartype display: ~azure.mgmt.quota.models.OperationDisplay
    :ivar origin:
    :vartype origin: str
    """

    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    display: Optional["_models.OperationDisplay"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    origin: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["_models.OperationDisplay"] = None,
        origin: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class QuotaAllocationRequestBase(_Model):
    """The new quota request allocated to subscription.

    :ivar properties:
    :vartype properties: ~azure.mgmt.quota.models.QuotaAllocationRequestBaseProperties
    """

    properties: Optional["_models.QuotaAllocationRequestBaseProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.QuotaAllocationRequestBaseProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class QuotaAllocationRequestBaseProperties(_Model):
    """QuotaAllocationRequestBaseProperties.

    :ivar limit: The new quota limit for the subscription. The incremental quota will be allocated
     from pre-approved group quota.
    :vartype limit: int
    :ivar name: Name of the resource provided by the resource provider. This property is already
     included in the request URI, so it is a readonly property returned in the response.
    :vartype name: ~azure.mgmt.quota.models.QuotaAllocationRequestBasePropertiesName
    :ivar region: The location for which the subscription is allocated.
    :vartype region: str
    """

    limit: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The new quota limit for the subscription. The incremental quota will be allocated from
     pre-approved group quota."""
    name: Optional["_models.QuotaAllocationRequestBasePropertiesName"] = rest_field(visibility=["read"])
    """Name of the resource provided by the resource provider. This property is already included in
     the request URI, so it is a readonly property returned in the response."""
    region: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The location for which the subscription is allocated."""

    __flattened_items = ["value", "localized_value"]

    @overload
    def __init__(
        self,
        *,
        limit: Optional[int] = None,
        region: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.name is None:
                return None
            return getattr(self.name, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.name is None:
                self.name = self._attr_to_rest_field["name"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class QuotaAllocationRequestBasePropertiesName(_Model):
    """Name of the resource provided by the resource provider. This property is already included in
    the request URI, so it is a readonly property returned in the response.

    :ivar value: Resource name.
    :vartype value: str
    :ivar localized_value: Resource display name.
    :vartype localized_value: str
    """

    value: Optional[str] = rest_field(visibility=["read"])
    """Resource name."""
    localized_value: Optional[str] = rest_field(name="localizedValue", visibility=["read"])
    """Resource display name."""


class QuotaAllocationRequestStatus(ProxyResource):
    """The subscription quota allocation status.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.quota.models.SystemData
    :ivar properties:
    :vartype properties: ~azure.mgmt.quota.models.QuotaAllocationRequestStatusProperties
    """

    properties: Optional["_models.QuotaAllocationRequestStatusProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )

    __flattened_items = ["requested_resource", "request_submit_time", "provisioning_state", "fault_code"]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.QuotaAllocationRequestStatusProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class QuotaAllocationRequestStatusProperties(_Model):
    """QuotaAllocationRequestStatusProperties.

    :ivar requested_resource: The new quota request allocated to subscription.
    :vartype requested_resource: ~azure.mgmt.quota.models.QuotaAllocationRequestBase
    :ivar request_submit_time: The request submission time. The date conforms to the following
     format specified by the ISO 8601 standard: yyyy-MM-ddTHH:mm:ssZ.
    :vartype request_submit_time: ~datetime.datetime
    :ivar provisioning_state: Request status. Known values are: "Accepted", "Created", "Invalid",
     "Succeeded", "Escalated", "Failed", "InProgress", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.quota.models.RequestState
    :ivar fault_code: Details of the failure.
    :vartype fault_code: str
    """

    requested_resource: Optional["_models.QuotaAllocationRequestBase"] = rest_field(
        name="requestedResource", visibility=["read", "create", "update", "delete", "query"]
    )
    """The new quota request allocated to subscription."""
    request_submit_time: Optional[datetime.datetime] = rest_field(
        name="requestSubmitTime", visibility=["read"], format="rfc3339"
    )
    """The request submission time. The date conforms to the following format specified by the ISO
     8601 standard: yyyy-MM-ddTHH:mm:ssZ."""
    provisioning_state: Optional[Union[str, "_models.RequestState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Request status. Known values are: \"Accepted\", \"Created\", \"Invalid\", \"Succeeded\",
     \"Escalated\", \"Failed\", \"InProgress\", and \"Canceled\"."""
    fault_code: Optional[str] = rest_field(name="faultCode", visibility=["read"])
    """Details of the failure."""

    @overload
    def __init__(
        self,
        *,
        requested_resource: Optional["_models.QuotaAllocationRequestBase"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class QuotaProperties(_Model):
    """Quota properties for the specified resource.

    :ivar limit: Resource quota limit properties.
    :vartype limit: ~azure.mgmt.quota.models.LimitJsonObject
    :ivar unit: The quota units, such as Count and Bytes. When requesting quota, use the **unit**
     value returned in the GET response in the request body of your PUT operation.
    :vartype unit: str
    :ivar name: Resource name provided by the resource provider. Use this property name when
     requesting quota.
    :vartype name: ~azure.mgmt.quota.models.ResourceName
    :ivar resource_type: The name of the resource type. Optional field.
    :vartype resource_type: str
    :ivar quota_period: The time period over which the quota usage values are summarized. For
     example:
     *P1D (per one day)
     *PT1M (per one minute)
     *PT1S (per one second).
     This parameter is optional because, for some resources like compute, the period is irrelevant.
    :vartype quota_period: str
    :ivar is_quota_applicable: States if quota can be requested for this resource.
    :vartype is_quota_applicable: bool
    :ivar properties: Additional properties for the specific resource provider.
    :vartype properties: any
    """

    limit: Optional["_models.LimitJsonObject"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource quota limit properties."""
    unit: Optional[str] = rest_field(visibility=["read"])
    """The quota units, such as Count and Bytes. When requesting quota, use the **unit** value
     returned in the GET response in the request body of your PUT operation."""
    name: Optional["_models.ResourceName"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource name provided by the resource provider. Use this property name when requesting quota."""
    resource_type: Optional[str] = rest_field(
        name="resourceType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The name of the resource type. Optional field."""
    quota_period: Optional[str] = rest_field(name="quotaPeriod", visibility=["read"])
    """The time period over which the quota usage values are summarized. For example:
     *P1D (per one day)
     *PT1M (per one minute)
     *PT1S (per one second).
     This parameter is optional because, for some resources like compute, the period is irrelevant."""
    is_quota_applicable: Optional[bool] = rest_field(name="isQuotaApplicable", visibility=["read"])
    """States if quota can be requested for this resource."""
    properties: Optional[Any] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Additional properties for the specific resource provider."""

    @overload
    def __init__(
        self,
        *,
        limit: Optional["_models.LimitJsonObject"] = None,
        name: Optional["_models.ResourceName"] = None,
        resource_type: Optional[str] = None,
        properties: Optional[Any] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class QuotaRequestDetails(ExtensionResource):
    """List of quota requests with details.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.quota.models.SystemData
    :ivar properties: Quota request details.
    :vartype properties: ~azure.mgmt.quota.models.QuotaRequestProperties
    """

    properties: Optional["_models.QuotaRequestProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Quota request details."""

    __flattened_items = ["provisioning_state", "message", "error", "request_submit_time", "value"]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.QuotaRequestProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class QuotaRequestProperties(_Model):
    """Quota request properties.

    :ivar provisioning_state: The quota request status. Known values are: "Accepted", "Invalid",
     "Succeeded", "Failed", and "InProgress".
    :vartype provisioning_state: str or ~azure.mgmt.quota.models.QuotaRequestState
    :ivar message: User-friendly status message.
    :vartype message: str
    :ivar error: Error details of the quota request.
    :vartype error: ~azure.mgmt.quota.models.ServiceErrorDetail
    :ivar request_submit_time: The quota request submission time. The date conforms to the
     following format specified by the ISO 8601 standard: yyyy-MM-ddTHH:mm:ssZ.
    :vartype request_submit_time: ~datetime.datetime
    :ivar value: Quota request details.
    :vartype value: list[~azure.mgmt.quota.models.SubRequest]
    """

    provisioning_state: Optional[Union[str, "_models.QuotaRequestState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The quota request status. Known values are: \"Accepted\", \"Invalid\", \"Succeeded\",
     \"Failed\", and \"InProgress\"."""
    message: Optional[str] = rest_field(visibility=["read"])
    """User-friendly status message."""
    error: Optional["_models.ServiceErrorDetail"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Error details of the quota request."""
    request_submit_time: Optional[datetime.datetime] = rest_field(
        name="requestSubmitTime", visibility=["read"], format="rfc3339"
    )
    """The quota request submission time. The date conforms to the following format specified by the
     ISO 8601 standard: yyyy-MM-ddTHH:mm:ssZ."""
    value: Optional[list["_models.SubRequest"]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Quota request details."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.ServiceErrorDetail"] = None,
        value: Optional[list["_models.SubRequest"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ResourceName(_Model):
    """Name of the resource provided by the resource Provider. When requesting quota, use this
    property name.

    :ivar value: Resource name.
    :vartype value: str
    :ivar localized_value: Resource display name.
    :vartype localized_value: str
    """

    value: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource name."""
    localized_value: Optional[str] = rest_field(name="localizedValue", visibility=["read"])
    """Resource display name."""

    @overload
    def __init__(
        self,
        *,
        value: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ResourceUsages(ProxyResource):
    """Resource details with usages and GroupQuota.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.quota.models.SystemData
    :ivar properties: Resource details with usages and GroupQuota.
    :vartype properties: ~azure.mgmt.quota.models.GroupQuotaUsagesBase
    """

    properties: Optional["_models.GroupQuotaUsagesBase"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Resource details with usages and GroupQuota."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.GroupQuotaUsagesBase"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ServiceError(_Model):
    """API error details.

    :ivar code: Error code.
    :vartype code: str
    :ivar message: Error message.
    :vartype message: str
    :ivar details: List of error details.
    :vartype details: list[~azure.mgmt.quota.models.ServiceErrorDetail]
    """

    code: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Error code."""
    message: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Error message."""
    details: Optional[list["_models.ServiceErrorDetail"]] = rest_field(visibility=["read"])
    """List of error details."""

    @overload
    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ServiceErrorDetail(_Model):
    """Error details.

    :ivar code: Error code.
    :vartype code: str
    :ivar message: Error message.
    :vartype message: str
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """Error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """Error message."""


class SubmittedResourceRequestStatus(ProxyResource):
    """Status of a single GroupQuota request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.quota.models.SystemData
    :ivar properties:
    :vartype properties: ~azure.mgmt.quota.models.SubmittedResourceRequestStatusProperties
    """

    properties: Optional["_models.SubmittedResourceRequestStatusProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.SubmittedResourceRequestStatusProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SubmittedResourceRequestStatusProperties(_Model):
    """SubmittedResourceRequestStatusProperties.

    :ivar requested_resource: Requested Resource.
    :vartype requested_resource: ~azure.mgmt.quota.models.GroupQuotaRequestBase
    :ivar request_submit_time: The request submission time. The date conforms to the following
     format specified by the ISO 8601 standard: yyyy-MM-ddTHH:mm:ssZ.
    :vartype request_submit_time: ~datetime.datetime
    :ivar provisioning_state: Request status. Known values are: "Accepted", "Created", "Invalid",
     "Succeeded", "Escalated", "Failed", "InProgress", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.quota.models.RequestState
    :ivar fault_code: Details of the failure.
    :vartype fault_code: str
    """

    requested_resource: Optional["_models.GroupQuotaRequestBase"] = rest_field(
        name="requestedResource", visibility=["read", "create", "update", "delete", "query"]
    )
    """Requested Resource."""
    request_submit_time: Optional[datetime.datetime] = rest_field(
        name="requestSubmitTime", visibility=["read"], format="rfc3339"
    )
    """The request submission time. The date conforms to the following format specified by the ISO
     8601 standard: yyyy-MM-ddTHH:mm:ssZ."""
    provisioning_state: Optional[Union[str, "_models.RequestState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Request status. Known values are: \"Accepted\", \"Created\", \"Invalid\", \"Succeeded\",
     \"Escalated\", \"Failed\", \"InProgress\", and \"Canceled\"."""
    fault_code: Optional[str] = rest_field(name="faultCode", visibility=["read"])
    """Details of the failure."""

    @overload
    def __init__(
        self,
        *,
        requested_resource: Optional["_models.GroupQuotaRequestBase"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SubRequest(_Model):
    """Request property.

    :ivar name: Resource name.
    :vartype name: ~azure.mgmt.quota.models.ResourceName
    :ivar resource_type: Resource type for which the quota properties were requested.
    :vartype resource_type: str
    :ivar unit: Quota limit units, such as Count and Bytes. When requesting quota, use the **unit**
     value returned in the GET response in the request body of your PUT operation.
    :vartype unit: str
    :ivar provisioning_state: The quota request status. Known values are: "Accepted", "Invalid",
     "Succeeded", "Failed", and "InProgress".
    :vartype provisioning_state: str or ~azure.mgmt.quota.models.QuotaRequestState
    :ivar message: User-friendly status message.
    :vartype message: str
    :ivar sub_request_id: Quota request ID.
    :vartype sub_request_id: str
    :ivar limit: Resource quota limit properties.
    :vartype limit: ~azure.mgmt.quota.models.LimitJsonObject
    """

    name: Optional["_models.ResourceName"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource name."""
    resource_type: Optional[str] = rest_field(name="resourceType", visibility=["read"])
    """Resource type for which the quota properties were requested."""
    unit: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Quota limit units, such as Count and Bytes. When requesting quota, use the **unit** value
     returned in the GET response in the request body of your PUT operation."""
    provisioning_state: Optional[Union[str, "_models.QuotaRequestState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The quota request status. Known values are: \"Accepted\", \"Invalid\", \"Succeeded\",
     \"Failed\", and \"InProgress\"."""
    message: Optional[str] = rest_field(visibility=["read"])
    """User-friendly status message."""
    sub_request_id: Optional[str] = rest_field(name="subRequestId", visibility=["read"])
    """Quota request ID."""
    limit: Optional["_models.LimitJsonObject"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource quota limit properties."""

    @overload
    def __init__(
        self,
        *,
        name: Optional["_models.ResourceName"] = None,
        unit: Optional[str] = None,
        limit: Optional["_models.LimitJsonObject"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SubscriptionQuotaAllocations(_Model):
    """Quota allocated to a subscription for the specific Resource Provider, Location, ResourceName.
    This will include the GroupQuota and total quota allocated to the subscription. Only the Group
    quota allocated to the subscription can be allocated back to the MG Group Quota.

    :ivar properties: Quota properties for the specified resource.
    :vartype properties: ~azure.mgmt.quota.models.SubscriptionQuotaAllocationsProperties
    """

    properties: Optional["_models.SubscriptionQuotaAllocationsProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Quota properties for the specified resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.SubscriptionQuotaAllocationsProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SubscriptionQuotaAllocationsList(ProxyResource):
    """Subscription quota list.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.quota.models.SystemData
    :ivar properties:
    :vartype properties: ~azure.mgmt.quota.models.SubscriptionQuotaAllocationsListProperties
    """

    properties: Optional["_models.SubscriptionQuotaAllocationsListProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.SubscriptionQuotaAllocationsListProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SubscriptionQuotaAllocationsListProperties(_Model):  # pylint: disable=name-too-long
    """SubscriptionQuotaAllocationsListProperties.

    :ivar provisioning_state: Request status. Known values are: "Accepted", "Created", "Invalid",
     "Succeeded", "Escalated", "Failed", "InProgress", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.quota.models.RequestState
    :ivar value: Subscription quota list.
    :vartype value: list[~azure.mgmt.quota.models.SubscriptionQuotaAllocations]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    provisioning_state: Optional[Union[str, "_models.RequestState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Request status. Known values are: \"Accepted\", \"Created\", \"Invalid\", \"Succeeded\",
     \"Escalated\", \"Failed\", \"InProgress\", and \"Canceled\"."""
    value: Optional[list["_models.SubscriptionQuotaAllocations"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Subscription quota list."""
    next_link: Optional[str] = rest_field(name="nextLink", visibility=["read"])
    """The URL to use for getting the next set of results."""

    @overload
    def __init__(
        self,
        *,
        value: Optional[list["_models.SubscriptionQuotaAllocations"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SubscriptionQuotaDetails(_Model):
    """Subscription Quota details.

    :ivar resource_name: The resource name, such as SKU name.
    :vartype resource_name: str
    :ivar limit: The total quota limit for the subscription.
    :vartype limit: int
    :ivar shareable_quota: The shareable quota for the subscription.
    :vartype shareable_quota: int
    :ivar name: Name of the resource provided by the resource provider. This property is already
     included in the request URI, so it is a readonly property returned in the response.
    :vartype name: ~azure.mgmt.quota.models.SubscriptionQuotaDetailsName
    """

    resource_name: Optional[str] = rest_field(
        name="resourceName", visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource name, such as SKU name."""
    limit: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The total quota limit for the subscription."""
    shareable_quota: Optional[int] = rest_field(name="shareableQuota", visibility=["read"])
    """The shareable quota for the subscription."""
    name: Optional["_models.SubscriptionQuotaDetailsName"] = rest_field(visibility=["read"])
    """Name of the resource provided by the resource provider. This property is already included in
     the request URI, so it is a readonly property returned in the response."""

    __flattened_items = ["value", "localized_value"]

    @overload
    def __init__(
        self,
        *,
        resource_name: Optional[str] = None,
        limit: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.name is None:
                return None
            return getattr(self.name, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.name is None:
                self.name = self._attr_to_rest_field["name"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class SubscriptionQuotaAllocationsProperties(SubscriptionQuotaDetails):
    """Quota properties for the specified resource.

    :ivar resource_name: The resource name, such as SKU name.
    :vartype resource_name: str
    :ivar limit: The total quota limit for the subscription.
    :vartype limit: int
    :ivar shareable_quota: The shareable quota for the subscription.
    :vartype shareable_quota: int
    :ivar name: Name of the resource provided by the resource provider. This property is already
     included in the request URI, so it is a readonly property returned in the response.
    :vartype name: ~azure.mgmt.quota.models.SubscriptionQuotaDetailsName
    """

    __flattened_items = ["value", "localized_value"]

    @overload
    def __init__(
        self,
        *,
        resource_name: Optional[str] = None,
        limit: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.name is None:
                return None
            return getattr(self.name, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.name is None:
                self.name = self._attr_to_rest_field["name"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class SubscriptionQuotaDetailsName(_Model):
    """Name of the resource provided by the resource provider. This property is already included in
    the request URI, so it is a readonly property returned in the response.

    :ivar value: Resource name.
    :vartype value: str
    :ivar localized_value: Resource display name.
    :vartype localized_value: str
    """

    value: Optional[str] = rest_field(visibility=["read"])
    """Resource name."""
    localized_value: Optional[str] = rest_field(name="localizedValue", visibility=["read"])
    """Resource display name."""


class SystemData(_Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.quota.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.quota.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    created_by: Optional[str] = rest_field(name="createdBy", visibility=["read", "create", "update", "delete", "query"])
    """The identity that created the resource."""
    created_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="createdByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that created the resource. Known values are: \"User\", \"Application\",
     \"ManagedIdentity\", and \"Key\"."""
    created_at: Optional[datetime.datetime] = rest_field(
        name="createdAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource creation (UTC)."""
    last_modified_by: Optional[str] = rest_field(
        name="lastModifiedBy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The identity that last modified the resource."""
    last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="lastModifiedByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that last modified the resource. Known values are: \"User\",
     \"Application\", \"ManagedIdentity\", and \"Key\"."""
    last_modified_at: Optional[datetime.datetime] = rest_field(
        name="lastModifiedAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource last modification (UTC)."""

    @overload
    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UsagesObject(_Model):
    """The resource usages value.

    :ivar value: The usages value. Required.
    :vartype value: int
    :ivar usages_type: The quota or usages limit types. Known values are: "Individual" and
     "Combined".
    :vartype usages_type: str or ~azure.mgmt.quota.models.UsagesTypes
    """

    value: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The usages value. Required."""
    usages_type: Optional[Union[str, "_models.UsagesTypes"]] = rest_field(
        name="usagesType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The quota or usages limit types. Known values are: \"Individual\" and \"Combined\"."""

    @overload
    def __init__(
        self,
        *,
        value: int,
        usages_type: Optional[Union[str, "_models.UsagesTypes"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UsagesProperties(_Model):
    """Usage properties for the specified resource.

    :ivar usages: The quota limit properties for this resource.
    :vartype usages: ~azure.mgmt.quota.models.UsagesObject
    :ivar unit: The units for the quota usage, such as Count and Bytes. When requesting quota, use
     the **unit** value returned in the GET response in the request body of your PUT operation.
    :vartype unit: str
    :ivar name: Resource name provided by the resource provider. Use this property name when
     requesting quota.
    :vartype name: ~azure.mgmt.quota.models.ResourceName
    :ivar resource_type: The name of the resource type. Optional field.
    :vartype resource_type: str
    :ivar quota_period: The time period for the summary of the quota usage values. For example:
     *P1D (per one day)
     *PT1M (per one minute)
     *PT1S (per one second).
     This parameter is optional because it is not relevant for all resources such as compute.
    :vartype quota_period: str
    :ivar is_quota_applicable: States if quota can be requested for this resource.
    :vartype is_quota_applicable: bool
    :ivar properties: Additional properties for the specific resource provider.
    :vartype properties: any
    """

    usages: Optional["_models.UsagesObject"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The quota limit properties for this resource."""
    unit: Optional[str] = rest_field(visibility=["read"])
    """The units for the quota usage, such as Count and Bytes. When requesting quota, use the **unit**
     value returned in the GET response in the request body of your PUT operation."""
    name: Optional["_models.ResourceName"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource name provided by the resource provider. Use this property name when requesting quota."""
    resource_type: Optional[str] = rest_field(
        name="resourceType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The name of the resource type. Optional field."""
    quota_period: Optional[str] = rest_field(name="quotaPeriod", visibility=["read"])
    """The time period for the summary of the quota usage values. For example:
     *P1D (per one day)
     *PT1M (per one minute)
     *PT1S (per one second).
     This parameter is optional because it is not relevant for all resources such as compute."""
    is_quota_applicable: Optional[bool] = rest_field(name="isQuotaApplicable", visibility=["read"])
    """States if quota can be requested for this resource."""
    properties: Optional[Any] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Additional properties for the specific resource provider."""

    @overload
    def __init__(
        self,
        *,
        usages: Optional["_models.UsagesObject"] = None,
        name: Optional["_models.ResourceName"] = None,
        resource_type: Optional[str] = None,
        properties: Optional[Any] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
