% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defaults.R
\name{fp_border_default}
\alias{fp_border_default}
\title{Create border formatting with flextable defaults}
\usage{
fp_border_default(
  color = flextable_global$defaults$border.color,
  style = "solid",
  width = flextable_global$defaults$border.width
)
}
\arguments{
\item{color}{border color - single character value (e.g. "#000000" or "black")}

\item{style}{border style - single character value : See Details for supported
border styles.}

\item{width}{border width - an integer value : 0>= value}
}
\description{
Create a \code{\link[officer:fp_border]{officer::fp_border()}} object whose unspecified
arguments inherit from \code{\link[=set_flextable_defaults]{set_flextable_defaults()}} (border color, width).

Use \code{fp_border_default()} instead of \code{officer::fp_border()} so that
borders automatically match the table's default style.
}
\examples{
library(flextable)

set_flextable_defaults(
  border.color = "orange"
)

z <- flextable(head(cars))
z <- theme_vanilla(z)
z <- vline(
  z,
  j = 1, part = "all",
  border = officer::fp_border()
)
z <- vline(
  z,
  j = 2, part = "all",
  border = fp_border_default()
)
z

init_flextable_defaults()

}
\seealso{
\code{\link[=hline]{hline()}}, \code{\link[=vline]{vline()}}

Other functions for defining formatting properties: 
\code{\link{fp_text_default}()}
}
\concept{functions for defining formatting properties}
