<!-- markdownlint-disable first-line-h1 -->
<!-- markdownlint-disable no-duplicate-header -->

### What's new in this release

ROCm 5.7.1 is a point release with several bug fixes in the HIP runtime.

#### Installing all GPU AddressSanitizer packages with a single command

ROCm 5.7.1 simplifies the installation steps for the optional AddressSanitizer (ASan) packages. This
release provides the meta package *rocm-ml-sdk-asan* for ease of ASan installation. The following
command can be used to install all ASan packages rather than installing each package separately,

        sudo apt-get install rocm-ml-sdk-asan

For more detailed information about using the GPU AddressSanitizer, refer to the
[user guide](https://rocm.docs.amd.com/en/docs-5.7.1/understand/using_gpu_sanitizer.html)

### ROCm libraries

#### rocBLAS
A new functionality rocblas-gemm-tune and an environment variable
ROCBLAS_TENSILE_GEMM_OVERRIDE_PATH are added to rocBLAS in the ROCm 5.7.1 release.

`rocblas-gemm-tune` is used to find the best-performing GEMM kernel for each GEMM problem set. It
has a command line interface, which mimics the --yaml input used by rocblas-bench. To generate the
expected --yaml input, profile logging can be used, by setting the environment variable
ROCBLAS_LAYER4.

For more information on rocBLAS logging, see Logging in rocBLAS, in the
[API Reference Guide](https://rocm.docs.amd.com/projects/rocBLAS/en/docs-5.7.1/API_Reference_Guide.html#logging-in-rocblas).

An example input file: Expected output (note selected GEMM idx may differ): Where the far right values
(solution_index) are the indices of the best-performing kernels for those GEMMs in the rocBLAS kernel
library. These indices can be directly used in future GEMM calls. See
` rocBLAS/samples/example_user_driven_tuning.cpp` for sample code of directly using kernels via their
indices.

If the output is stored in a file, the results can be used to override default kernel selection with the
kernels found by setting the environment variable ROCBLAS_TENSILE_GEMM_OVERRIDE_PATH, which
points to the stored file.

For more details, refer to the
[rocBLAS Programmer's Guide](https://rocm.docs.amd.com/projects/rocBLAS/en/docs-5.7.1/Programmers_Guide.html).

#### HIP 5.7.1 (for ROCm 5.7.1)

ROCm 5.7.1 is a point release with several bug fixes in the HIP runtime.

### Defect fixes

The `hipPointerGetAttributes` API returns the correct HIP memory type as `hipMemoryTypeManaged`
for managed memory.
