# 2023-12-11 Triage Log

A quiet week overall. A few smaller crate (e.g., helloworld) benchmarks saw
significant improvements in
[#118568](https://github.com/rust-lang/rust/pull/118568), but this merely
restores performance regressed earlier.

Triage done by **@simulacrum**.
Revision range: [9358642..5701093](https://perf.rust-lang.org/?start=9358642e3b8560eee89e6f40aa996c8394a3db31&end=57010939ed1d00076b4af0ed06a81ec69ea5e4a8&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5%  | [0.2%, 1.3%]    | 111   |
| Regressions ❌ <br /> (secondary)  | 0.7%  | [0.1%, 1.5%]    | 34    |
| Improvements ✅ <br /> (primary)   | -5.2% | [-11.1%, -0.5%] | 18    |
| Improvements ✅ <br /> (secondary) | -4.6% | [-10.5%, -0.4%] | 72    |
| All ❌✅ (primary)                 | -0.3% | [-11.1%, 1.3%]  | 129   |

5 Regressions, 2 Improvements, 3 Mixed; 2 of them in rollups
69 artifact comparisons made in total

#### Regressions

compile-time evaluation: detect writes through immutable pointers [#118324](https://github.com/rust-lang/rust/pull/118324) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=f16c81fa79940da0c3e4cedd7b064ecdee2278bf&end=0e7f91b75e7484a713e2f644212cfc1aa7478a28&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -    | -            | 0     |
| Regressions ❌ <br /> (secondary)  | 0.9% | [0.3%, 1.4%] | 12    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | -    | -            | 0     |

> I feel like the remaining regression is small enough to be acceptable. We're doing more checks in const-eval, and there are no regressions in the builds of real crates.

(https://github.com/rust-lang/rust/pull/118324#issuecomment-1832836626)

Introduce support for `async gen` blocks [#118420](https://github.com/rust-lang/rust/pull/118420) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=2b399b52753eac351067e73f4ff0de829443b9a7&end=f967532a47eb728ada44473a5c4c2eca1a45fe30&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2% | [0.1%, 0.3%] | 23    |
| Regressions ❌ <br /> (secondary)  | 0.4% | [0.2%, 0.7%] | 3     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.2% | [0.1%, 0.3%] | 23    |

New functionality costs some additional time across some benchmarks.

Rollup of 6 pull requests [#118763](https://github.com/rust-lang/rust/pull/118763) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=2d2f1b2099a9cf10d4300042f5ea15a65a203dae&end=dc3a3539d595272c6a578c35f5eb6a85b867aca8&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4% | [0.2%, 0.5%] | 18    |
| Regressions ❌ <br /> (secondary)  | -    | -            | 0     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.4% | [0.2%, 0.5%] | 18    |

> We do a little bit more work after that PR because the reachable set is
> slightly bigger and that in turn means more MIR gets encoded and things like
> that.

(https://github.com/rust-lang/rust/pull/118763#issuecomment-1850073772)

Don't warn an empty pattern unreachable if we're not sure the data is valid [#118308](https://github.com/rust-lang/rust/pull/118308) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=c722d5191c26bbeea77dee2c06d814075ae785f2&end=06e02d5b259c1e88cbf0c74366d9e0a4c7cfd6d9&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.6% | [0.2%, 0.9%] | 4     |
| Regressions ❌ <br /> (secondary)  | 1.0% | [1.0%, 1.0%] | 6     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.6% | [0.2%, 0.9%] | 4     |

> Yeah I expected a perf regression because of the validity tracking. It adds
> an extra step for every constructor we try, and match-stress has an enum with
> 8000 of these. I don't think there's a way around it, I need to know the
> validity of every inspected place.

(https://github.com/rust-lang/rust/pull/118308#issuecomment-1831103831)

This adds costs particularly to crates with lots or large matches, seen across
a few primary workloads and within rustc bootstrap. This is a diagnostic
correctness fix, so some cost is acceptable.

Restore `const PartialEq` [#118661](https://github.com/rust-lang/rust/pull/118661) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=8b1ba11cb1176cd7b8a0f4b55d1c97ee9fd3662d&end=6f40082313d8374bdf962aba943a712d5322fae6&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.2%, 0.4%]   | 9     |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.2%, 0.6%]   | 11    |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.8% | [-0.8%, -0.8%] | 1     |
| All ❌✅ (primary)                 | 0.3%  | [0.2%, 0.4%]   | 9     |

Feature addition carrying likely unavoidable cost in some benchmarks.

#### Improvements

Avoid adding builtin functions to `symbols.o`  [#118568](https://github.com/rust-lang/rust/pull/118568) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=0e7f91b75e7484a713e2f644212cfc1aa7478a28&end=503e129328080e924c0ddfca6abf4c2812580102&stat=instructions:u)

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -               | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -               | 0     |
| Improvements ✅ <br /> (primary)   | -6.6% | [-11.0%, -0.7%] | 14    |
| Improvements ✅ <br /> (secondary) | -5.0% | [-10.7%, -0.3%] | 66    |
| All ❌✅ (primary)                 | -6.6% | [-11.0%, -0.7%] | 14    |

Smaller benchmarks show significant improvements, recovering a past performance
regression. See PR description for details.

Rollup of 8 pull requests [#118838](https://github.com/rust-lang/rust/pull/118838) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=57010939ed1d00076b4af0ed06a81ec69ea5e4a8&end=21cce21d8c012f14cf74d5afddd795d324600dac&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.9% | [-1.0%, -0.9%] | 6     |
| All ❌✅ (primary)                 | -     | -              | 0     |

https://github.com/rust-lang/rust/pull/118822 is the likely cause, but not
worth digging deeper on this improvement.

#### Mixed

split `NormalizesTo` out of `Projection` 3 [#118725](https://github.com/rust-lang/rust/pull/118725) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=d6fa38a9b2426487e010a6c16862132f89755e41&end=21982a4383a92ec00ec11204584b86f3f17c92ef&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.2%, 0.9%]   | 17    |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.2%, 0.3%]   | 3     |
| Improvements ✅ <br /> (primary)   | -2.6% | [-2.6%, -2.6%] | 1     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | 0.3%  | [-2.6%, 0.9%]  | 18    |

Moving code around in hot area, with slightly different work being done. Seems to add some cost to a few primary benchmarks.

See details in https://github.com/rust-lang/rust/pull/118725#issuecomment-1847121861

never_patterns: Parse match arms with no body [#118527](https://github.com/rust-lang/rust/pull/118527) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=ae612bedcbfc7098d1711eb35bc7ca994eb17a4c&end=2b399b52753eac351067e73f4ff0de829443b9a7&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.1%  | [0.1%, 0.1%]   | 1     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.9% | [-1.0%, -0.8%] | 2     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.5% | [-1.0%, 0.1%]  | 3     |

Regression is justified by the extra work for this new feature.

Improve `print_tts` [#114571](https://github.com/rust-lang/rust/pull/114571) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=d86d65bbc19b928387f68427fcc3a0da498d8a19&end=a9cb8ee82132b6ef0f8db3e3bc25f98dfae08c04&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2%  | [0.2%, 0.2%]   | 1     |
| Regressions ❌ <br /> (secondary)  | 0.8%  | [0.5%, 1.0%]   | 8     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.2% | [-0.3%, -0.2%] | 2     |
| All ❌✅ (primary)                 | 0.2%  | [0.2%, 0.2%]   | 1     |

Regressions mostly limited to secondary benchmarks. Single primary regression is in incr-unchanged and is relatively small.
