use core:io;
use core:geometry;
use graphics;
use ui;
use ui:pdf;
use lang:bs:macro;

/**
 * Utility functions for testing the implementation. Should be removed in the future.
 */
void basicTest() {
	File pdf;

	Page p(pdf, Rect(0, 0, 500, 800));
	pdf.root.pages << p;

	p.content.data << "175 720 m 175 500 l 300 800 400 600 v 100 650 50 75 re h S";

	Url url = cwdUrl / ".." / "test.pdf";
	print("Writing to ${url}...");
	OStream s = url.write;
	pdf.write(s);
	s.close();
	print("Done!");
}

void draw(Graphics g, Size size) on Render {
	SolidBrush blackBrush(black);
	SolidBrush redBrush(red);
	SolidBrush greenBrush(green);

	SolidBrush transparentBlackBrush(black);
	transparentBlackBrush.opacity = 0.8;

	Path path;
	path.start(Point(100, 100));
	path.bezier(Point(100, 50), Point(50, 100), Point(50, 50));
	path.close();

	path.start(Point(50, 100));
	path.bezier(Point(100, 100), Point(100, 150));

	g.draw(path, redBrush);

	g.line(Point(10, 10), Point(40, 40), blackBrush);
	g.draw(Rect(Point(10, 10), a4 - Size(20)), blackBrush);

	g.fill(Rect(Point(130, 30), Point(150, 40)), redBrush);
	Path p2;
	p2.start(Point(50, 200));
	p2.bezier(Point(70, 200), Point(70, 260), Point(50, 260));
	g.fill(p2, blackBrush);

	g.draw(Rect(Point(130, 100), Size(50, 50)), Size(10), blackBrush);
	g.oval(Rect(Point(140, 170), Size(30, 30)), redBrush);
	g.fill(Rect(Point(130, 160), Size(50, 50)), Size(10), transparentBlackBrush);

	g.oval(Rect(Point(130, 230), Size(40, 40)), blackBrush);
	g.fillOval(Rect(Point(70, 230), Size(40, 40)), redBrush);


	Font f("Arial", 20);
	Rect tRect(30, 140, 100, 140 + f.pxHeight);
	g.fill(tRect, blackBrush);
	g.text("Hello!", f, redBrush, tRect);

	tRect += Point(0, f.pxHeight);
	g.text("ÅÄÖ", f, blackBrush, tRect);

	Text t("Test Format!", f);
	t.layoutBorder = Size(50, 50);
	g.draw(t, blackBrush, Point(130, 40));

	// Clipping.
	g.push();
	g.transform = rotate(30 deg, Point(15, 15)) * translate(Point(65, 25));

	g.push(Rect(Point(), Size(30, 30)));
	g.fill(redBrush);
	g.fillOval(Rect(Point(-2, -2), Point(32, 32)), greenBrush);
	g.pop();

	g.pop();

	// Transparent overlays.
	g.push();
	g.transform = translate(Point(120, 50)) * rotate(10 deg);
	g.push(0.5);

	g.fill(Rect(0, 0, 30, 30), greenBrush);
	g.fill(Rect(15, 0, 30, 30), redBrush);

	g.pop();
	g.pop();

	// An image!
	if (x = named{res}.url) {
		Image i = loadImage(x / "flower-raw.ppm");
		Bitmap b(i);

		Size bSz = b.size;
		g.draw(b, Rect(Point(15, 190), bSz * 0.15), 0.8);
		g.draw(b, Rect(Point(100, 100), bSz * 0.5), Rect(Point(120, 250), bSz * 0.1), 0.5);

		Image j = loadImage(x / "ui_alpha.png");
		Bitmap c(j);

		g.draw(c, Rect(Point(20, 240), c.size * 0.4));

		// Using a bitmap as a pattern.
		BitmapBrush bBrush(b, scale(0.08));
		// g.text("Pattern", f, bBrush, Rect(50, 0, 200, 40));
		g.fill(Rect(100, 0, 150, 30), Size(4, 4), bBrush);
	}

	// Gradients.
	LinearGradient gradient([GradientStop(0, red), GradientStop(0.3, yellow), GradientStop(0.6, green), GradientStop(0.9, blue)], Point(15, 40), Point(15, 120));
	g.fill(Rect(15, 40, 30, 120), gradient);

	LinearGradient gradient2([GradientStop(0.2, red), GradientStop(0.4, yellow), GradientStop(0.6, green), GradientStop(0.8, blue)], Point(70, 190), Point(150, 190));
	g.draw(Text("Nice!", f), gradient2, Point(70, 190));

	// ...with transparency
	g.push();
	g.transform = translate(Point(100, 100));
	g.push();
	g.transform = rotate(45 deg);
	LinearGradient transparentGradient(red, Color(0.5, 1.0, 0.0, 0.0), Point(0, 0), Point(30, 30));
	g.fill(Rect(-2, -2, 32, 32), transparentGradient);
	g.draw(Rect(0, 0, 30, 30), blackBrush);
	g.fill(transparentGradient);

	g.pop();
	g.pop();

	// ... during a transform with transparency groups...
	g.push(0.8);
	g.transform = rotate(10 deg) * translate(Point(160, 20));
	g.fill(Rect(-2, -2, 32, 32), transparentGradient);
	g.draw(Rect(0, 0, 30, 30), blackBrush);

	g.pop();

	// What about radial gradients?
	g.push();
	g.transform = translate(Point(160, 220));
	RadialGradient radial(blue, Color(0.0, 0.5, 0.5, 0.0), Point(0, 0), 20);
	radial.transform = translate(Point(3, 0)) * scale(Size(1.5, 1.0));
	g.fill(Rect(0, 0, 20, 20), radial);
	g.pop();
}

class Preview extends Frame {
	init(Size sz, Float scale) {
		init("Preview", sz*scale);

		painter = PreviewPainter(scale);

		create();
	}
}

class PreviewPainter extends Painter {
	Float scale;

	init(Float scale) {
		init() { scale = scale; }
	}

	Bool render(Size sz, Graphics g) {
		g.transform(scale(scale));
		draw(g, sz);

		false;
	}
}

void test() {
	Font f("Arial", 20);
	save();

	Preview p(a4, 3);
	p.waitForClose;
}

void save() on Render {
	PdfGraphics g(a4, a4);

	draw(g, a4);

	g.nextPage();
	g.line(Point(0, 0), Point(a4), SolidBrush(black));

	Url url = cwdUrl / ".." / "test.pdf";
	print("Writing to ${url}...");
	g.save(url);
	print("Done!");
}
