# Backup and restore tool |uos-recovery-gui|

## Overview

To avoid data loss or damage caused by software defects, hardware damage, improper human operations, etc., you can backup and restore application data or system data to ensure the normal operation of the system.

You can click <img src="../common/uos-recovery.svg" height="40">on the home page of Control Center to enter the backup and restore tool，or find it directly in the launcher.

![backup_restore](fig/d_backup_restore.png)

## Backup

The backup and restore tool provides two conventional backup methods: system backup and data backup. The difference between the two is that system backup not only backs up the data in the system, but also backs up the installed applications, user settings, system parameters, etc., to quickly restore the entire system.

![backup](fig/backup.png)

### System backup

You can use System Backup to back up your system directory and quickly create a system restore point.

![system_backup](fig/system_backup.png)

1. Go to the backup and restore tool, select **Backup** > **System Backup**, and click **next**.

   1. In the Authentication pop-up window,verify the identity of the administrator user. After successful authentication, you can go to the system backup page, and you can set the backup mode and the method where the backup file is saved.

   2. Backup mode: system backup and full backup

     - System backup: Back up the root partition and boot partition

     - Full Backup: Back up the system files and user files of the entire disk

   3. Saving method: New Backup or System Incremental Backup

   > ![notes](../common/notes.svg)Note: A full backup can only be backed up on other storage media. Do not remove the storage media during the backup process.

2. Click **Backup**, the re-verification box pops up, click **Restart and Back Up**, and wait for the backup to complete.

   > ![attention](../common/attention.svg)Note: During the backup process, please do not unplug the power  or forceful shutdown to prevent data loss or damage.

### Data Backup

You can use Data Backup to  backup target files and target directories and prevent data loss or damage.

![data_backup](fig/data_backup.png)

1. Go to the backup and restore tool, select **Backup > Data Backup**, and click **Next**.

2. In the Authentication pop-up window, verify the identity of the current logged-in user. After successful authentication, you will enter the data backup page, where you can select the data that need to be backed up and storage devices .
  
   - Click<img src="../common/add.png" height="40">and select the files you want to back up.  The file directory will be displayed in the backup list below.
   - Click the **Storage Directory** drop-down box and select a storage device.
   
   > ![notes](../common/notes.svg)Note: Remarks information is optional.

3. Click **Start Backup** and wait for the backup to complete.
  
   > ![attention](../common/attention.svg)Note: Data backup can only be backed up to an external storage device, so please connect a removable storage device before entering the data backup. During the backup process, please do not remove the storage device, otherwise the backup will fail.

## Restore

The backup and restore tool provides three restore methods: System Restore, Data Restore, and Reset to factory settings.



### System restore

You can use System Restore to restore your system from a backed-up system restore point.

![system_restore](fig/system_restore.png)



1. Go to the backup and restore tool, select **Restore > System Restore**, and click **Next**.
2. In the Authentication pop-up window, verify the identity of the administrator user. After successful authentication, you will enter the system restore page. You can choose to restore from backup files or restore from a restore point.
2. Restore from backup files
   - 1. Click **Restore from backup file**.
     2. Click![loadfile](../common/loadfile.svg)to select the backup file.
     3. Click **Restore Now** to pop up the re-verification box, click Restart and Restore, and wait for the restore to complete.
   - Restore from a restore point
     1. Click **Restore from a restore point**.
     2. Select the backup file in the list.
     3. Click **Restore Now** to pop up the re-verification box, click **Restart and Restore**, and wait for the restore to complete.

> ![notes](../common/notes.svg)Note: Historical backup files is a must for using system restore.

### Data Restore

You can restore data from data backup.

![data_restore](fig/data_restore.png)

1. Go to the backup and restore tool, select **Restore > Data Restore**, and click **Next**.
2. In the Authentication pop-up window, verify the identity of the current logged-in user. After successful authentication, enter the data restoration page and select the data backup file in the list.
3. Click **Start Restore** and wait for the restore to complete.

> ![attention](../common/attention.svg)Note: Before entering data restoration, please access the removable storage device and ensure that historical backup data exists. During the restore process, please do not remove the removable storage device, otherwise the restore will fail.

### Reset to factory settings

You can restore your system to its initialization status by performing a factory reset.

![factory_reset](fig/factory_reset.png)

1. Go to the backup and restore tool, select **Restore > Reset to factory settings**, and click **Next**.
2. In the Authentication pop-up window, verify the identity of the administrator user. After successful authentication, enter the factory reset page and select whether to check **Keep personal files and apps**. The default is checked.
3. Click **Start Restore** and wait for the restore to complete.

## System Clone

In addition to the two conventional backup methods of system backup and data backup, the backup and restore tool also provides advanced functions - system clone, which can clone your system environment and data with one click and install it on other devices.

![full_backup](fig/full_backup.png)

1. Go to the backup and restore tool, select **Advanced > System Clone**, and click **Next**.
2. In the Authentication pop-up window,verify the identity of the administrator user. After success, enter the full machine backup page, click **Select a directory**, and select the directory where the uimg image file is stored.
3. Click **Create** and wait for the backup to complete

> ![notes](../common/notes.svg)Note: The cloned files can be installed through the installer.
