//
// Created by uos on 2022/5/16.
//

#ifndef UOS_RECOVERY_BACKUPFILEMANAGERDIALOG_H
#define UOS_RECOVERY_BACKUPFILEMANAGERDIALOG_H

#include "utils/global.h"
#include "common/BaseTableView.h"
#include "common/BaseItemDelegate.h"
#include "common/AuthorityUtils.h"
#include <DMainWindow>
#include <DTableView>
#include <QStandardItemModel>
#include <DGuiApplicationHelper>
#include <DLabel>
#include <DSpinner>
#include <DComboBox>

DTK_USE_NAMESPACE
DWIDGET_USE_NAMESPACE

class DeleteWidget : public QWidget
{
    Q_OBJECT
public:
    static bool m_isRemoving;
    explicit DeleteWidget(QWidget *parent = nullptr);
    void setBackupInfo(const BackupInfo &backupInfo);
    void setDeleteBtnVisible(bool visible);
    void setSpinnerVisible(bool visible);
    void stopSpinner();

Q_SIGNALS:
    void deleteBackupInfo(const BackupInfo &backupInfo);
public Q_SLOTS:
    void onDelete();
    void doAdminAuthorityTask(bool result, int type);
    void doCommonAuthorityTask(bool result, int type);

private:
    void checkAdminAuthority(AuthorityType type);
    void checkCommonAuthority(AuthorityType type);

private:
    DPushButton *m_deleteBtn = nullptr;
    DSpinner *m_spinner = nullptr;
    AuthorityUtils *m_adminAuthUtils = nullptr;
    AuthorityUtils *m_commonAuthUtils = nullptr;
    BackupInfo m_backupInfo;
};


class BackupFileDelegate : public BaseItemDelegate
{
    Q_OBJECT
public:
    explicit BackupFileDelegate(QObject *parent = nullptr);

    QWidget *createEditor(QWidget *widget, const QStyleOptionViewItem &styleOptionViewItem,
                          const QModelIndex &index) const override;

    void setEditorData(QWidget *editor, const QModelIndex &index) const override;
    void setModelData(QWidget *editor, QAbstractItemModel *model, const QModelIndex &index) const override;
};

class BackupFileManagerDialog : public DMainWindow
{
    Q_OBJECT
public:
    explicit BackupFileManagerDialog(QWidget *parent = nullptr);
    void initUI();
    void initTableView();
    void setData(BackupInfoList &backupInfos);
    void showToCenter();
    void removeBackupInfo(const QString &operateId);
    void setDeleteWidgetStatus(bool deleteBtnVisible, bool spinnerVisible, const QString &operateId);
    void showErrorDlg(const QString &msg);
    void setSystemBackupInfoData(const BackupInfoList &backupInfos);
    void setDataBackupInfoData(const BackupInfoList &backupInfos);
    void setGhostInfoData(const BackupInfoList &backupInfos);

Q_SIGNALS:
    void notifyDeleteBackupInfo(const BackupInfo &backupInfo);
    // void closeMainWindow();

// protected:
//     void closeEvent(QCloseEvent *event) override;

private Q_SLOTS:
    void onThemeChange();
    void onBackupTypeComboxIndexChanged(int index);
private:
    Dtk::Gui::DGuiApplicationHelper *m_guiHelper = nullptr;
    BaseTableView *m_tableView = nullptr;
    QStandardItemModel *m_model = nullptr;
    DComboBox *m_backupTypeCombox = nullptr;
    BackupInfoList m_allSystemBackupInfo;
    BackupInfoList m_allDataBackupInfo;
    BackupInfoList m_allGhostBackupInfo;
    QMap<QString, BackupInfo> m_allBackupInfo;
    bool m_isCommunity = false;
};


#endif //UOS_RECOVERY_BACKUPFILEMANAGERDIALOG_H
