//
// Created by 张雪明 <zhangxueming@uniontech.com> on 2023/11/14.
//

#ifndef UOS_RECOVERY_RECOVERY_SESSION_DBUS_SERVICE_H
#define UOS_RECOVERY_RECOVERY_SESSION_DBUS_SERVICE_H

#include <QObject>
#include <QDBusContext>

class MainWindow;
class MainWindowSnipe;

class RecoverySessionDbusService : public QObject, public QDBusContext {
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "com.deepin.daemon.UosRecoverySession")
public:
    explicit RecoverySessionDbusService(QObject *parent = nullptr);
    virtual ~RecoverySessionDbusService();

    Q_SCRIPTABLE void ShowNewBackupPage();
    Q_SCRIPTABLE void ShowNewRestorePage();
    Q_SCRIPTABLE void ShowNewFactoryRestorePage();

private:
    Q_SCRIPTABLE void ShowBackupPage();
    Q_SCRIPTABLE void ShowRestorePage();
    Q_SCRIPTABLE void ShowSystemClonePage();

private:
    MainWindow *m_mainWindow = nullptr;
    MainWindowSnipe *m_mainWinSnipe = nullptr;
};

#endif // UOS_RECOVERY_RECOVERY_SESSION_DBUS_SERVICE_H
