//
// Created by 张雪明 <zhangxueming@uniontech.com> on 2025/4/25.
//

#ifndef UOS_RECOVERY_IMMU_BACKUP_FRAME_H
#define UOS_RECOVERY_IMMU_BACKUP_FRAME_H
#include "common/ItemFrame.h"

// 自定义一个继承自 QWidget 的类，重写 paintEvent 方法
class BackgroundWidget : public QWidget
{
    Q_OBJECT
public:
    explicit BackgroundWidget(QWidget *parent = nullptr) : QWidget(parent), m_pixmap(nullptr) {}

    void setBackgroundPixmap(QPixmap *pixmap)
    {
        m_pixmap = pixmap;
        update(); // 触发重绘
    }

protected:
    void paintEvent(QPaintEvent *event) override
    {
        QWidget::paintEvent(event);
        if (m_pixmap && !m_pixmap->isNull()) {
            QPainter painter(this);
            painter.drawPixmap(rect(), *m_pixmap);
        }
    }

private:
    QPixmap *m_pixmap;
};

class ImmuBackupLeftFrame : public ItemFrame {
    Q_OBJECT
public:
    explicit ImmuBackupLeftFrame(const QString &title, const QString &description, const QString &icon, QWidget *parent = nullptr);
    void setSelectedPixmap(const QString &iconRes, const QSize &iconSize);
    void setSelectedHoverPixmap(const QString &iconRes, const QSize &iconSize);
    void setSelectedDarkPixmap(const QString &iconRes, const QSize &iconSize);
    void setSelectedDarkHoverPixmap(const QString &iconRes, const QSize &iconSize);
    void setSelectedBackground(const QString &selectStat) override; // 设置选中背景

protected:
    //void paintEvent(QPaintEvent *event) override;
    bool event(QEvent *e) override;

private:
    virtual void initHorizontalLayout() override;

private:
    QPixmap m_selectedPixmap;
    QPixmap m_selectedHoverPixmap;
    QPixmap m_selectedDarkPixmap;
    QPixmap m_selectedDarkHoverPixmap;
    BackgroundWidget *m_backgroundWidget = nullptr;
};

class ImmuBackupFrame : public ItemFrame {
    Q_OBJECT
public:
    explicit ImmuBackupFrame(const QString &title, const QString &description, const QString &icon, QWidget *parent = nullptr);

protected:
    //void paintEvent(QPaintEvent *event) override;
    bool event(QEvent *e) override;
    
private:
    virtual void initHorizontalLayout() override;
};

#endif //UOS_RECOVERY_IMMU_BACKUP_FRAME_H
