//
// Created by uos on 2022/3/29.
//

#include "SystemRecovery.h"
#include "utils/data-collection/EventLogMgr.h"

SystemRecovery::SystemRecovery()
{

}

SystemRecovery::~SystemRecovery()
{

}

void SystemRecovery::reportEventLog(const ResultInfo &resultInfo, OperateType opType, RecoveryType recoveryType)
{
    QJsonObject dataObj;
    if (opType == OperateType::SystemBackup) {
        BackupEventData backupData;
        backupData.tid = EventTid::TID_SYSTEM_BACKUP;
        backupData.resInfo = resultInfo;
        backupData.operateType = "SystemBackup";
        backupData.backupType = getRecoveryType(recoveryType);
        dataObj = backupData.marshal();
    } else if (opType == OperateType::SystemRestore) {
        RestoreEventData restoreData;
        restoreData.tid = EventTid::TID_SYSTEM_RESTORE;
        restoreData.resInfo = resultInfo;
        restoreData.operateType = "SystemRestore";
        restoreData.restoreType = getRecoveryType(recoveryType);
        dataObj = restoreData.marshal();
    } else {
        return;
    }

    EventLogMgr *eventLogMgr = EventLogMgr::getInstance();
    if (eventLogMgr->isInited()) {
        eventLogMgr->writeEventLog(dataObj);
    }
}

bool SystemRecovery::isRunning()
{
    return false;
}
