/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.graph;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.options.InternalProperties;

public class Tarjan {
    private List<LEdge> edgesToBeReversed;
    private int index = 0;
    protected List<Set<LNode>> stronglyConnectedComponents;
    private Stack<LNode> stack = new Stack();
    private HashMap<LNode, Integer> nodeToSCCID = new HashMap();

    public Tarjan(List<LEdge> edgesToBeReversed, List<Set<LNode>> stronglyConnectedComponents, HashMap<LNode, Integer> nodeToSCCID) {
        this.edgesToBeReversed = edgesToBeReversed;
        this.stronglyConnectedComponents = stronglyConnectedComponents;
        this.nodeToSCCID = nodeToSCCID;
    }

    public void tarjan(LGraph graph) {
        this.index = 0;
        this.stack = new Stack();
        for (LNode node : graph.getLayerlessNodes()) {
            if ((Integer)node.getProperty(InternalProperties.TARJAN_ID) != -1) continue;
            this.stronglyConnected(node);
            this.stack.clear();
        }
    }

    public void stronglyConnected(LNode v) {
        v.setProperty(InternalProperties.TARJAN_ID, this.index);
        v.setProperty(InternalProperties.TARJAN_LOWLINK, this.index);
        ++this.index;
        this.stack.push(v);
        v.setProperty(InternalProperties.TARJAN_ON_STACK, true);
        for (LEdge edge : v.getConnectedEdges()) {
            if (edge.getSource().getNode() != v && !this.edgesToBeReversed.contains((Object)edge) || edge.getSource().getNode() == v && this.edgesToBeReversed.contains((Object)edge)) continue;
            LNode target = null;
            target = edge.getTarget().getNode() == v ? edge.getSource().getNode() : edge.getTarget().getNode();
            if ((Integer)target.getProperty(InternalProperties.TARJAN_ID) == -1) {
                this.stronglyConnected(target);
                v.setProperty(InternalProperties.TARJAN_LOWLINK, Math.min((Integer)v.getProperty(InternalProperties.TARJAN_LOWLINK), (Integer)target.getProperty(InternalProperties.TARJAN_LOWLINK)));
                continue;
            }
            if (!((Boolean)target.getProperty(InternalProperties.TARJAN_ON_STACK)).booleanValue()) continue;
            v.setProperty(InternalProperties.TARJAN_LOWLINK, Math.min((Integer)v.getProperty(InternalProperties.TARJAN_LOWLINK), (Integer)target.getProperty(InternalProperties.TARJAN_ID)));
        }
        if (v.getProperty(InternalProperties.TARJAN_LOWLINK) == v.getProperty(InternalProperties.TARJAN_ID)) {
            HashSet<LNode> sCC = new HashSet<LNode>();
            LNode n = null;
            do {
                n = this.stack.pop();
                n.setProperty(InternalProperties.TARJAN_ON_STACK, false);
                sCC.add(n);
            } while (v != n);
            if (sCC.size() > 1) {
                int index = this.stronglyConnectedComponents.size();
                this.stronglyConnectedComponents.add(sCC);
                for (LNode node : sCC) {
                    this.nodeToSCCID.put(node, index);
                }
            }
        }
    }

    public void resetTarjan(LGraph graph) {
        for (LNode n : graph.getLayerlessNodes()) {
            n.setProperty(InternalProperties.TARJAN_ON_STACK, false);
            n.setProperty(InternalProperties.TARJAN_LOWLINK, -1);
            n.setProperty(InternalProperties.TARJAN_ID, -1);
            this.stack.clear();
            for (LEdge e : n.getConnectedEdges()) {
                e.setProperty(InternalProperties.IS_PART_OF_CYCLE, false);
            }
        }
    }
}

