/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Status;
import org.eclipse.fordiac.ide.application.editparts.SubAppForFBNetworkEditPart;
import org.eclipse.fordiac.ide.application.editparts.UISubAppNetworkEditPart;
import org.eclipse.fordiac.ide.model.commands.change.UntypeSubAppCommand;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.ui.editors.HandlerHelper;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class UntypeSubApplicationHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        SubApp subApp = UntypeSubApplicationHandler.getSelectedSubApp(selection);
        if (subApp != null) {
            CommandStack commandStack = HandlerHelper.getCommandStack((IEditorPart)editor);
            commandStack.execute((Command)new UntypeSubAppCommand(subApp));
            UntypeSubApplicationHandler.refreshSelection(subApp);
        }
        return Status.OK_STATUS;
    }

    public void setEnabled(Object evaluationContext) {
        Object selection = HandlerUtil.getVariable((Object)evaluationContext, (String)"selection");
        SubApp subApp = UntypeSubApplicationHandler.getSelectedSubApp(selection);
        this.setBaseEnabled(subApp != null && subApp.isTyped());
    }

    private static SubApp getSelectedSubApp(Object selection) {
        IStructuredSelection structSel;
        if (selection instanceof TreeSelection) {
            return null;
        }
        if (selection instanceof IStructuredSelection && !(structSel = (IStructuredSelection)selection).isEmpty() && structSel.size() == 1) {
            return UntypeSubApplicationHandler.getSubApp(structSel.getFirstElement());
        }
        return null;
    }

    private static SubApp getSubApp(Object currentElement) {
        if (currentElement instanceof SubAppForFBNetworkEditPart) {
            SubAppForFBNetworkEditPart subAppForFBNetworkEditPart = (SubAppForFBNetworkEditPart)currentElement;
            return subAppForFBNetworkEditPart.getModel();
        }
        if (currentElement instanceof UISubAppNetworkEditPart) {
            UISubAppNetworkEditPart uiSubAppNetworkEditPart = (UISubAppNetworkEditPart)((Object)currentElement);
            return uiSubAppNetworkEditPart.getSubApp();
        }
        return null;
    }

    private static void refreshSelection(SubApp subapp) {
        IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        HandlerHelper.getViewer((IEditorPart)editor).deselectAll();
        HandlerHelper.selectElement((Object)subapp, (GraphicalViewer)HandlerHelper.getViewer((IEditorPart)editor));
    }
}

