/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.fordiac.ide.deployment.DownloadRunnable;
import org.eclipse.fordiac.ide.deployment.IDeviceManagementCommunicationHandler;
import org.eclipse.fordiac.ide.deployment.Messages;
import org.eclipse.fordiac.ide.deployment.data.DeviceDeploymentData;
import org.eclipse.fordiac.ide.deployment.data.ResourceDeploymentData;
import org.eclipse.fordiac.ide.deployment.exceptions.DeploymentException;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public final class DeploymentCoordinator {
    public static void printUnsupportedDeviceProfileMessageBox(Device device, Resource res) {
        Display.getDefault().asyncExec(() -> {
            String resName;
            MessageBox messageBox = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 33);
            String string = resName = res != null ? res.getName() : "";
            if (device.getProfile() != null && !device.getProfile().isEmpty()) {
                messageBox.setMessage(MessageFormat.format(Messages.DeploymentCoordinator_MESSAGE_DefinedProfileNotSupported, device.getProfile(), device.getName(), resName));
            } else {
                messageBox.setMessage(MessageFormat.format(Messages.DeploymentCoordinator_MESSAGE_ProfileNotSet, device.getName(), resName));
            }
            messageBox.open();
        });
    }

    public static void performDeployment(Object[] selection, IDeviceManagementCommunicationHandler overrideDevMgmCommHandler, String profile) {
        Shell shell = Display.getDefault().getActiveShell();
        try {
            DownloadRunnable download = new DownloadRunnable(DeploymentCoordinator.createDeploymentdata(selection), overrideDevMgmCommHandler, null, profile);
            new ProgressMonitorDialog(shell).run(true, true, (IRunnableWithProgress)download);
            if (!download.getResult().isOK()) {
                ErrorDialog.openError((Shell)shell, null, null, (IStatus)download.getResult());
            }
        }
        catch (InvocationTargetException | DeploymentException ex) {
            MessageDialog.openError((Shell)shell, (String)Messages.DeploymentCoordinator_DepoymentError, (String)ex.getMessage());
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            MessageDialog.openInformation((Shell)shell, (String)Messages.DeploymentCoordinator_LABEL_DownloadAborted, (String)ex.getMessage());
        }
    }

    public static List<DeviceDeploymentData> createDeploymentdata(Object[] selection) throws DeploymentException {
        ArrayList<DeviceDeploymentData> data = new ArrayList<DeviceDeploymentData>();
        Object[] objectArray = selection;
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof Resource) {
                Resource resource = (Resource)object;
                DeviceDeploymentData devData = DeploymentCoordinator.getDevData(data, resource.getDevice());
                devData.addResourceData(new ResourceDeploymentData(resource));
            } else if (object instanceof Device) {
                Device device = (Device)object;
                DeviceDeploymentData devData = DeploymentCoordinator.getDevData(data, device);
                devData.setSeltectedDevParams(device.getVarDeclarations().stream().filter(devVar -> !"MGR_ID".equalsIgnoreCase(devVar.getName())).toList());
            }
            ++n2;
        }
        return data;
    }

    private static DeviceDeploymentData getDevData(List<DeviceDeploymentData> data, Device device) {
        DeviceDeploymentData retVal = null;
        for (DeviceDeploymentData devData : data) {
            if (device != devData.getDevice()) continue;
            retVal = devData;
            break;
        }
        if (retVal == null) {
            retVal = new DeviceDeploymentData(device);
            data.add(retVal);
        }
        return retVal;
    }

    private DeploymentCoordinator() {
        throw new UnsupportedOperationException("Utility class should not be instantiated!");
    }
}

