/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.draw2d;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.fordiac.ide.gef.draw2d.ITransparencyFigure;

public class SetableAlphaLabel
extends Label
implements ITransparencyFigure {
    private int alpha = 255;

    public SetableAlphaLabel() {
    }

    public SetableAlphaLabel(String text) {
        super(text);
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setAlpha(int alpha) {
        if (this.alpha != alpha) {
            this.alpha = alpha;
            this.repaint();
        }
    }

    public void paint(Graphics graphics) {
        graphics.setAlpha(this.alpha);
        super.paint(graphics);
    }

    @Override
    public void setTransparency(int value) {
        this.setAlpha(value);
    }

    @Override
    public int getTransparency() {
        return this.getAlpha();
    }

    protected void paintFigure(Graphics graphics) {
        Rectangle bounds = this.getBounds();
        if (this.isOpaque()) {
            graphics.fillRectangle(bounds);
        }
        if (this.getIcon() != null) {
            Point iconLocation = this.getIconLocation();
            graphics.drawImage(this.getIcon(), iconLocation.x + bounds.x, iconLocation.y + bounds.y);
        }
        Point textLocation = this.getTextLocation();
        int tx = bounds.x + textLocation.x;
        int ty = bounds.y + textLocation.y;
        if (!this.isEnabled()) {
            graphics.setForegroundColor(ColorConstants.buttonLightest);
            graphics.drawText(this.getSubStringText(), tx + 1, ty + 1);
            graphics.setForegroundColor(ColorConstants.buttonDarker);
        }
        Dimension subStringTextSize = this.getSubStringTextSize();
        if ((double)subStringTextSize.height * graphics.getAbsoluteScale() < 3.0) {
            graphics.setBackgroundColor(this.getForegroundColor());
            graphics.fillRectangle(tx, ty, subStringTextSize.width, subStringTextSize.height);
        } else {
            graphics.drawText(this.getSubStringText(), tx, ty);
        }
    }

    protected String getTruncationString() {
        return "\u2026";
    }
}

