/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group.performance.command;

import org.eclipse.nebula.widgets.nattable.command.AbstractLayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionUtil;
import org.eclipse.nebula.widgets.nattable.group.RowGroupUtils;
import org.eclipse.nebula.widgets.nattable.group.performance.GroupModel;
import org.eclipse.nebula.widgets.nattable.group.performance.RowGroupHeaderLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.reorder.command.RowReorderEndCommand;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;

public class GroupRowReorderEndCommandHandler
extends AbstractLayerCommandHandler<RowReorderEndCommand> {
    private final RowGroupHeaderLayer rowGroupHeaderLayer;

    public GroupRowReorderEndCommandHandler(RowGroupHeaderLayer rowGroupHeaderLayer) {
        this.rowGroupHeaderLayer = rowGroupHeaderLayer;
    }

    @Override
    protected boolean doCommand(RowReorderEndCommand command) {
        boolean reorderToTopEdge;
        int toRowPosition;
        int fromRowPosition = this.rowGroupHeaderLayer.getReorderFromRowPosition();
        boolean isValid = RowGroupUtils.isReorderValid(this.rowGroupHeaderLayer, fromRowPosition, toRowPosition = command.getToRowPosition(), reorderToTopEdge = command.isReorderToTopEdge());
        if (isValid) {
            int fromIndex = this.rowGroupHeaderLayer.getPositionLayer().getRowIndexByPosition(fromRowPosition);
            int toIndex = this.rowGroupHeaderLayer.getPositionLayer().getRowIndexByPosition(toRowPosition);
            SelectionLayer.MoveDirectionEnum moveDirection = PositionUtil.getVerticalMoveDirection(fromRowPosition, toRowPosition);
            int fromPositionToCheck = fromRowPosition;
            int toPositionToCheck = toRowPosition;
            if (SelectionLayer.MoveDirectionEnum.DOWN == moveDirection && reorderToTopEdge) {
                --toPositionToCheck;
            }
            boolean toggleCoordinateByEdge = false;
            GroupModel.Group groupToEnd = null;
            GroupModel.Group groupToStart = null;
            int level = 0;
            while (level < this.rowGroupHeaderLayer.getLevelCount()) {
                GroupModel.Group fromGroup = this.rowGroupHeaderLayer.getGroupByPosition(level, fromPositionToCheck);
                GroupModel.Group toGroup = this.rowGroupHeaderLayer.getGroupByPosition(level, toPositionToCheck);
                if (fromGroup != null && fromGroup.isCollapsed() && (!RowGroupUtils.isInTheSameGroup(this.rowGroupHeaderLayer, level, fromPositionToCheck, toPositionToCheck) || fromPositionToCheck == toPositionToCheck)) {
                    this.rowGroupHeaderLayer.expandGroup(this.rowGroupHeaderLayer.getGroupModel(level), fromGroup);
                    if (moveDirection != SelectionLayer.MoveDirectionEnum.DOWN) {
                        fromPositionToCheck = this.rowGroupHeaderLayer.getPositionLayer().getRowPositionByIndex(fromIndex);
                        this.rowGroupHeaderLayer.setReorderFromRowPosition(fromPositionToCheck);
                    } else {
                        toPositionToCheck = this.rowGroupHeaderLayer.getPositionLayer().getRowPositionByIndex(toIndex);
                        command.updateToRowPosition(toPositionToCheck);
                        if (SelectionLayer.MoveDirectionEnum.DOWN == moveDirection && reorderToTopEdge) {
                            --toPositionToCheck;
                        }
                    }
                }
                if (toGroup != null && SelectionLayer.MoveDirectionEnum.DOWN == moveDirection && toGroup.isGroupEnd(toPositionToCheck)) {
                    toggleCoordinateByEdge = true;
                    if (toGroup.isUnbreakable() && toGroup.getVisibleSpan() < toGroup.getOriginalSpan()) {
                        groupToEnd = toGroup;
                    }
                } else if (toGroup != null && SelectionLayer.MoveDirectionEnum.UP == moveDirection && toGroup.isGroupStart(toPositionToCheck) && toGroup.isUnbreakable() && toGroup.getVisibleSpan() < toGroup.getOriginalSpan()) {
                    groupToStart = toGroup;
                }
                ++level;
            }
            if (toggleCoordinateByEdge) {
                command.toggleCoordinateByEdge();
            }
            if (groupToEnd != null) {
                return this.rowGroupHeaderLayer.getPositionLayer().getUnderlyingLayerByPosition(0, 0).doCommand(new RowReorderEndToGroupEndCommand(command, groupToEnd));
            }
            if (groupToStart != null) {
                return this.rowGroupHeaderLayer.getPositionLayer().getUnderlyingLayerByPosition(0, 0).doCommand(new RowReorderEndToGroupStartCommand(command, groupToStart));
            }
        }
        return !isValid;
    }

    @Override
    public Class<RowReorderEndCommand> getCommandClass() {
        return RowReorderEndCommand.class;
    }

    class RowReorderEndToGroupEndCommand
    extends RowReorderEndCommand {
        private final GroupModel.Group group;

        public RowReorderEndToGroupEndCommand(RowReorderEndCommand command, GroupModel.Group group) {
            super(command);
            this.group = group;
        }

        protected RowReorderEndToGroupEndCommand(RowReorderEndToGroupEndCommand command) {
            super(command);
            this.group = command.group;
        }

        @Override
        public boolean convertToTargetLayer(ILayer targetLayer) {
            int groupEndPosition;
            boolean convert = super.convertToTargetLayer(targetLayer);
            if (convert && !this.isReorderToTopEdge() && targetLayer instanceof IUniqueIndexLayer && (groupEndPosition = this.group.getGroupEndPosition((IUniqueIndexLayer)targetLayer)) >= 0 && groupEndPosition > this.getToRowPosition()) {
                this.updateToRowPosition(groupEndPosition);
            }
            return convert;
        }

        @Override
        public RowReorderEndToGroupEndCommand cloneCommand() {
            return new RowReorderEndToGroupEndCommand(this);
        }
    }

    class RowReorderEndToGroupStartCommand
    extends RowReorderEndCommand {
        private final GroupModel.Group group;

        public RowReorderEndToGroupStartCommand(RowReorderEndCommand command, GroupModel.Group group) {
            super(command);
            this.group = group;
        }

        protected RowReorderEndToGroupStartCommand(RowReorderEndToGroupStartCommand command) {
            super(command);
            this.group = command.group;
        }

        @Override
        public boolean convertToTargetLayer(ILayer targetLayer) {
            int groupStartPosition;
            boolean convert = super.convertToTargetLayer(targetLayer);
            if (convert && this.isReorderToTopEdge() && targetLayer instanceof IUniqueIndexLayer && (groupStartPosition = ((IUniqueIndexLayer)targetLayer).getRowPositionByIndex(this.group.getStartIndex())) >= 0 && groupStartPosition < this.getToRowPosition()) {
                this.updateToRowPosition(groupStartPosition);
            }
            return convert;
        }

        @Override
        public RowReorderEndToGroupStartCommand cloneCommand() {
            return new RowReorderEndToGroupStartCommand(this);
        }
    }
}

