/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.layer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import org.eclipse.nebula.widgets.nattable.command.AbstractRegionCommand;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.AggregateConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelProvider;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.layer.cell.TranslatedLayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.painter.layer.ILayerPainter;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.nebula.widgets.nattable.ui.binding.UiBindingRegistry;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class CompositeLayer
extends AbstractLayer {
    private final int layoutXCount;
    private final int layoutYCount;
    private final HashMap<ILayer, String> childLayerToRegionNameMap = new HashMap();
    private final HashMap<String, ILayer> regionNameToChildLayerMap = new HashMap();
    private final HashMap<String, IConfigLabelAccumulator> regionNameToConfigLabelAccumulatorMap = new HashMap();
    private final ILayer[][] childLayerLayout;
    private final CompositeLayerPainter compositeLayerPainter = new CompositeLayerPainter();

    public CompositeLayer(int layoutXCount, int layoutYCount) {
        this.layoutXCount = layoutXCount;
        this.layoutYCount = layoutYCount;
        this.childLayerLayout = new ILayer[layoutXCount][layoutYCount];
        this.setLayerPainter(this.compositeLayerPainter);
    }

    @Override
    public void dispose() {
        int layoutX = 0;
        while (layoutX < this.layoutXCount) {
            int layoutY = 0;
            while (layoutY < this.layoutYCount) {
                ILayer childLayer = this.childLayerLayout[layoutX][layoutY];
                if (childLayer != null) {
                    childLayer.dispose();
                }
                ++layoutY;
            }
            ++layoutX;
        }
    }

    @Override
    public void saveState(String prefix, Properties properties) {
        int layoutX = 0;
        while (layoutX < this.layoutXCount) {
            int layoutY = 0;
            while (layoutY < this.layoutYCount) {
                ILayer childLayer = this.childLayerLayout[layoutX][layoutY];
                if (childLayer != null) {
                    String regionName = this.childLayerToRegionNameMap.get(childLayer);
                    childLayer.saveState(prefix + "." + regionName, properties);
                }
                ++layoutY;
            }
            ++layoutX;
        }
        super.saveState(prefix, properties);
    }

    @Override
    public void loadState(String prefix, Properties properties) {
        int layoutX = this.layoutXCount - 1;
        while (layoutX >= 0) {
            int layoutY = this.layoutYCount - 1;
            while (layoutY >= 0) {
                ILayer childLayer = this.childLayerLayout[layoutX][layoutY];
                if (childLayer != null) {
                    String regionName = this.childLayerToRegionNameMap.get(childLayer);
                    childLayer.loadState(prefix + "." + regionName, properties);
                }
                --layoutY;
            }
            --layoutX;
        }
        super.loadState(prefix, properties);
    }

    @Override
    public void configure(IConfigRegistry configRegistry, UiBindingRegistry uiBindingRegistry) {
        int layoutX = 0;
        while (layoutX < this.layoutXCount) {
            int layoutY = 0;
            while (layoutY < this.layoutYCount) {
                this.childLayerLayout[layoutX][layoutY].configure(configRegistry, uiBindingRegistry);
                ++layoutY;
            }
            ++layoutX;
        }
        super.configure(configRegistry, uiBindingRegistry);
    }

    @Override
    public boolean doCommand(ILayerCommand command) {
        if (super.doCommand(command)) {
            return true;
        }
        if (command instanceof AbstractRegionCommand && ((AbstractRegionCommand)command).label != null) {
            AbstractRegionCommand arc = (AbstractRegionCommand)command;
            ILayer child = this.getChildLayerByRegionName(arc.label);
            if (child != null) {
                child.doCommand(arc.cloneForRegion());
                return true;
            }
        }
        return this.doCommandOnChildLayers(command);
    }

    protected boolean doCommandOnChildLayers(ILayerCommand command) {
        int layoutX = 0;
        while (layoutX < this.layoutXCount) {
            int layoutY = 0;
            while (layoutY < this.layoutYCount) {
                ILayer childLayer = this.childLayerLayout[layoutX][layoutY];
                ILayerCommand childCommand = command.cloneCommand();
                if (childLayer.doCommand(childCommand)) {
                    return true;
                }
                ++layoutY;
            }
            ++layoutX;
        }
        return false;
    }

    @Override
    public int getColumnCount() {
        int columnCount = 0;
        int layoutX = 0;
        while (layoutX < this.layoutXCount) {
            columnCount += this.childLayerLayout[layoutX][0].getColumnCount();
            ++layoutX;
        }
        return columnCount;
    }

    @Override
    public int getPreferredColumnCount() {
        int preferredColumnCount = 0;
        int layoutX = 0;
        while (layoutX < this.layoutXCount) {
            preferredColumnCount += this.childLayerLayout[layoutX][0].getPreferredColumnCount();
            ++layoutX;
        }
        return preferredColumnCount;
    }

    @Override
    public int getColumnIndexByPosition(int compositeColumnPosition) {
        int layoutX = this.getLayoutXByColumnPosition(compositeColumnPosition);
        if (layoutX < 0) {
            return -1;
        }
        ILayer childLayer = this.childLayerLayout[layoutX][0];
        int childColumnPosition = compositeColumnPosition - this.getColumnPositionOffset(layoutX);
        return childLayer.getColumnIndexByPosition(childColumnPosition);
    }

    @Override
    public int localToUnderlyingColumnPosition(int localColumnPosition) {
        int layoutX = this.getLayoutXByColumnPosition(localColumnPosition);
        if (layoutX < 0) {
            return -1;
        }
        return localColumnPosition - this.getColumnPositionOffset(layoutX);
    }

    @Override
    public int underlyingToLocalColumnPosition(ILayer sourceUnderlyingLayer, int underlyingColumnPosition) {
        Point layoutCoordinate = this.getLayoutXYByChildLayer(sourceUnderlyingLayer);
        if (layoutCoordinate == null) {
            return -1;
        }
        return this.getColumnPositionOffset(layoutCoordinate.x) + underlyingColumnPosition;
    }

    @Override
    public Collection<Range> underlyingToLocalColumnPositions(ILayer sourceUnderlyingLayer, Collection<Range> underlyingColumnPositionRanges) {
        Point layoutCoordinate = this.getLayoutXYByChildLayer(sourceUnderlyingLayer);
        if (layoutCoordinate == null) {
            return null;
        }
        ArrayList<Range> localColumnPositionRanges = new ArrayList<Range>(underlyingColumnPositionRanges.size());
        int offset = this.getColumnPositionOffset(layoutCoordinate.x);
        for (Range underlyingColumnPositionRange : underlyingColumnPositionRanges) {
            localColumnPositionRanges.add(new Range(offset + underlyingColumnPositionRange.start, offset + underlyingColumnPositionRange.end));
        }
        return localColumnPositionRanges;
    }

    @Override
    public int getWidth() {
        int width = 0;
        int layoutX = 0;
        while (layoutX < this.layoutXCount) {
            width += this.childLayerLayout[layoutX][0].getWidth();
            ++layoutX;
        }
        return width;
    }

    @Override
    public int getPreferredWidth() {
        int preferredWidth = 0;
        int layoutX = 0;
        while (layoutX < this.layoutXCount) {
            preferredWidth += this.childLayerLayout[layoutX][0].getPreferredWidth();
            ++layoutX;
        }
        return preferredWidth;
    }

    @Override
    public int getColumnWidthByPosition(int column) {
        int layoutX = this.getLayoutXByColumnPosition(column);
        if (layoutX < 0) {
            return 0;
        }
        ILayer childLayer = this.childLayerLayout[layoutX][0];
        return childLayer.getColumnWidthByPosition(column - this.getColumnPositionOffset(layoutX));
    }

    @Override
    public boolean isColumnPositionResizable(int compositeColumnPosition) {
        int layoutX = this.getLayoutXByColumnPosition(compositeColumnPosition);
        if (layoutX < 0) {
            return false;
        }
        ILayer childLayer = this.childLayerLayout[layoutX][0];
        int childColumnPosition = compositeColumnPosition - this.getColumnPositionOffset(layoutX);
        return childLayer.isColumnPositionResizable(childColumnPosition);
    }

    @Override
    public int getColumnPositionByX(int x) {
        int layoutX = this.getLayoutXByPixelX(x);
        if (layoutX < 0) {
            return -1;
        }
        ILayer childLayer = this.childLayerLayout[layoutX][0];
        int childX = x - this.getWidthOffset(layoutX);
        int childColumnPosition = childLayer.getColumnPositionByX(childX);
        return this.getColumnPositionOffset(layoutX) + childColumnPosition;
    }

    @Override
    public int getStartXOfColumnPosition(int columnPosition) {
        int layoutX = this.getLayoutXByColumnPosition(columnPosition);
        if (layoutX < 0) {
            return -1;
        }
        ILayer childLayer = this.childLayerLayout[layoutX][0];
        int childColumnPosition = columnPosition - this.getColumnPositionOffset(layoutX);
        return this.getWidthOffset(layoutX) + childLayer.getStartXOfColumnPosition(childColumnPosition);
    }

    @Override
    public Collection<ILayer> getUnderlyingLayersByColumnPosition(int columnPosition) {
        HashSet<ILayer> underlyingLayers = new HashSet<ILayer>();
        int layoutX = 0;
        while (layoutX < this.childLayerLayout.length) {
            int columnPositionOffset = this.getColumnPositionOffset(layoutX);
            if (columnPosition >= columnPositionOffset && columnPosition < columnPositionOffset + this.childLayerLayout[layoutX][0].getColumnCount()) {
                int layoutY = 0;
                while (layoutY < this.childLayerLayout[layoutX].length) {
                    underlyingLayers.add(this.childLayerLayout[layoutX][layoutY]);
                    ++layoutY;
                }
                break;
            }
            ++layoutX;
        }
        return underlyingLayers;
    }

    @Override
    public int getRowCount() {
        int rowCount = 0;
        int layoutY = 0;
        while (layoutY < this.layoutYCount) {
            rowCount += this.childLayerLayout[0][layoutY].getRowCount();
            ++layoutY;
        }
        return rowCount;
    }

    @Override
    public int getPreferredRowCount() {
        int preferredRowCount = 0;
        int layoutY = 0;
        while (layoutY < this.layoutYCount) {
            preferredRowCount += this.childLayerLayout[0][layoutY].getPreferredRowCount();
            ++layoutY;
        }
        return preferredRowCount;
    }

    @Override
    public int getRowIndexByPosition(int compositeRowPosition) {
        int layoutY = this.getLayoutYByRowPosition(compositeRowPosition);
        if (layoutY < 0) {
            return -1;
        }
        ILayer childLayer = this.childLayerLayout[0][layoutY];
        int childRowPosition = compositeRowPosition - this.getRowPositionOffset(layoutY);
        return childLayer.getRowIndexByPosition(childRowPosition);
    }

    @Override
    public int localToUnderlyingRowPosition(int localRowPosition) {
        int layoutY = this.getLayoutYByRowPosition(localRowPosition);
        if (layoutY < 0) {
            return -1;
        }
        return localRowPosition - this.getRowPositionOffset(layoutY);
    }

    @Override
    public int underlyingToLocalRowPosition(ILayer sourceUnderlyingLayer, int underlyingRowPosition) {
        Point layoutCoordinate = this.getLayoutXYByChildLayer(sourceUnderlyingLayer);
        if (layoutCoordinate == null) {
            return -1;
        }
        return this.getRowPositionOffset(layoutCoordinate.y) + underlyingRowPosition;
    }

    @Override
    public Collection<Range> underlyingToLocalRowPositions(ILayer sourceUnderlyingLayer, Collection<Range> underlyingRowPositionRanges) {
        Point layoutCoordinate = this.getLayoutXYByChildLayer(sourceUnderlyingLayer);
        if (layoutCoordinate == null) {
            return null;
        }
        ArrayList<Range> localRowPositionRanges = new ArrayList<Range>(underlyingRowPositionRanges.size());
        int offset = this.getRowPositionOffset(layoutCoordinate.y);
        for (Range underlyingRowPositionRange : underlyingRowPositionRanges) {
            localRowPositionRanges.add(new Range(offset + underlyingRowPositionRange.start, offset + underlyingRowPositionRange.end));
        }
        return localRowPositionRanges;
    }

    @Override
    public int getHeight() {
        int height = 0;
        int layoutY = 0;
        while (layoutY < this.layoutYCount) {
            height += this.childLayerLayout[0][layoutY].getHeight();
            ++layoutY;
        }
        return height;
    }

    @Override
    public int getPreferredHeight() {
        int preferredHeight = 0;
        int layoutY = 0;
        while (layoutY < this.layoutYCount) {
            preferredHeight += this.childLayerLayout[0][layoutY].getPreferredHeight();
            ++layoutY;
        }
        return preferredHeight;
    }

    @Override
    public int getRowHeightByPosition(int row) {
        int layoutY = this.getLayoutYByRowPosition(row);
        if (layoutY < 0) {
            return 0;
        }
        ILayer childLayer = this.childLayerLayout[0][layoutY];
        return childLayer.getRowHeightByPosition(row - this.getRowPositionOffset(layoutY));
    }

    @Override
    public boolean isRowPositionResizable(int compositeRowPosition) {
        int layoutY = this.getLayoutYByRowPosition(compositeRowPosition);
        if (layoutY < 0) {
            return false;
        }
        ILayer childLayer = this.childLayerLayout[0][layoutY];
        int childRowPosition = compositeRowPosition - this.getRowPositionOffset(layoutY);
        return childLayer.isRowPositionResizable(childRowPosition);
    }

    @Override
    public int getRowPositionByY(int y) {
        int layoutY = this.getLayoutYByPixelY(y);
        if (layoutY < 0) {
            return -1;
        }
        ILayer childLayer = this.childLayerLayout[0][layoutY];
        int childY = y - this.getHeightOffset(layoutY);
        int childRowPosition = childLayer.getRowPositionByY(childY);
        return this.getRowPositionOffset(layoutY) + childRowPosition;
    }

    @Override
    public int getStartYOfRowPosition(int rowPosition) {
        int layoutY = this.getLayoutYByRowPosition(rowPosition);
        if (layoutY < 0) {
            return -1;
        }
        ILayer childLayer = this.childLayerLayout[0][layoutY];
        int childRowPosition = rowPosition - this.getRowPositionOffset(layoutY);
        return this.getHeightOffset(layoutY) + childLayer.getStartYOfRowPosition(childRowPosition);
    }

    @Override
    public Collection<ILayer> getUnderlyingLayersByRowPosition(int rowPosition) {
        HashSet<ILayer> underlyingLayers = new HashSet<ILayer>();
        int layoutY = 0;
        while (layoutY < this.childLayerLayout[0].length) {
            int rowPositionOffset = this.getRowPositionOffset(layoutY);
            if (rowPosition >= rowPositionOffset && rowPosition < rowPositionOffset + this.childLayerLayout[0][layoutY].getRowCount()) {
                int layoutX = 0;
                while (layoutX < this.childLayerLayout.length) {
                    underlyingLayers.add(this.childLayerLayout[layoutX][layoutY]);
                    ++layoutX;
                }
                break;
            }
            ++layoutY;
        }
        return underlyingLayers;
    }

    @Override
    public ILayerCell getCellByPosition(int compositeColumnPosition, int compositeRowPosition) {
        int childRowPosition;
        Point layoutCoordinate = this.getLayoutXYByPosition(compositeColumnPosition, compositeRowPosition);
        if (layoutCoordinate == null) {
            return null;
        }
        ILayer childLayer = this.childLayerLayout[layoutCoordinate.x][layoutCoordinate.y];
        int childColumnPosition = compositeColumnPosition - this.getColumnPositionOffset(layoutCoordinate.x);
        ILayerCell cell = childLayer.getCellByPosition(childColumnPosition, childRowPosition = compositeRowPosition - this.getRowPositionOffset(layoutCoordinate.y));
        if (cell != null) {
            cell = new TranslatedLayerCell(cell, this, this.underlyingToLocalColumnPosition(childLayer, cell.getOriginColumnPosition()), this.underlyingToLocalRowPosition(childLayer, cell.getOriginRowPosition()), this.underlyingToLocalColumnPosition(childLayer, cell.getColumnPosition()), this.underlyingToLocalRowPosition(childLayer, cell.getRowPosition()));
        }
        return cell;
    }

    @Override
    public Rectangle getBoundsByPosition(int compositeColumnPosition, int compositeRowPosition) {
        int childRowPosition;
        Point layoutCoordinate = this.getLayoutXYByPosition(compositeColumnPosition, compositeRowPosition);
        if (layoutCoordinate == null) {
            return null;
        }
        ILayer childLayer = this.childLayerLayout[layoutCoordinate.x][layoutCoordinate.y];
        int childColumnPosition = compositeColumnPosition - this.getColumnPositionOffset(layoutCoordinate.x);
        Rectangle bounds = childLayer.getBoundsByPosition(childColumnPosition, childRowPosition = compositeRowPosition - this.getRowPositionOffset(layoutCoordinate.y));
        if (bounds != null) {
            bounds.x += this.getWidthOffset(layoutCoordinate.x);
            bounds.y += this.getHeightOffset(layoutCoordinate.y);
        }
        return bounds;
    }

    @Override
    public DisplayMode getDisplayModeByPosition(int compositeColumnPosition, int compositeRowPosition) {
        Point layoutCoordinate = this.getLayoutXYByPosition(compositeColumnPosition, compositeRowPosition);
        if (layoutCoordinate == null) {
            return super.getDisplayModeByPosition(compositeColumnPosition, compositeRowPosition);
        }
        ILayer childLayer = this.childLayerLayout[layoutCoordinate.x][layoutCoordinate.y];
        return childLayer.getDisplayModeByPosition(compositeColumnPosition - this.getColumnPositionOffset(layoutCoordinate.x), compositeRowPosition - this.getRowPositionOffset(layoutCoordinate.y));
    }

    @Override
    public LabelStack getConfigLabelsByPosition(int compositeColumnPosition, int compositeRowPosition) {
        Point layoutCoordinate = this.getLayoutXYByPosition(compositeColumnPosition, compositeRowPosition);
        if (layoutCoordinate == null) {
            return new LabelStack(new String[0]);
        }
        ILayer childLayer = this.childLayerLayout[layoutCoordinate.x][layoutCoordinate.y];
        int childColumnPosition = compositeColumnPosition - this.getColumnPositionOffset(layoutCoordinate.x);
        int childRowPosition = compositeRowPosition - this.getRowPositionOffset(layoutCoordinate.y);
        LabelStack configLabels = childLayer.getConfigLabelsByPosition(childColumnPosition, childRowPosition);
        String regionName = this.childLayerToRegionNameMap.get(childLayer);
        IConfigLabelAccumulator configLabelAccumulator = this.regionNameToConfigLabelAccumulatorMap.get(regionName);
        if (configLabelAccumulator != null) {
            configLabelAccumulator.accumulateConfigLabels(configLabels, childColumnPosition, childRowPosition);
        }
        configLabels.addLabel(regionName);
        return configLabels;
    }

    @Override
    public Object getDataValueByPosition(int compositeColumnPosition, int compositeRowPosition) {
        Point layoutCoordinate = this.getLayoutXYByPosition(compositeColumnPosition, compositeRowPosition);
        if (layoutCoordinate == null) {
            return null;
        }
        ILayer childLayer = this.childLayerLayout[layoutCoordinate.x][layoutCoordinate.y];
        return childLayer.getDataValueByPosition(compositeColumnPosition - this.getColumnPositionOffset(layoutCoordinate.x), compositeRowPosition - this.getRowPositionOffset(layoutCoordinate.y));
    }

    @Override
    public ICellPainter getCellPainter(int compositeColumnPosition, int compositeRowPosition, ILayerCell cell, IConfigRegistry configRegistry) {
        Point layoutCoordinate = this.getLayoutXYByPosition(compositeColumnPosition, compositeRowPosition);
        if (layoutCoordinate == null) {
            return null;
        }
        ILayer childLayer = this.childLayerLayout[layoutCoordinate.x][layoutCoordinate.y];
        return childLayer.getCellPainter(compositeColumnPosition - this.getColumnPositionOffset(layoutCoordinate.x), compositeRowPosition - this.getRowPositionOffset(layoutCoordinate.y), cell, configRegistry);
    }

    public void setChildLayer(String regionName, ILayer childLayer, int layoutX, int layoutY) {
        if (childLayer == null) {
            throw new IllegalArgumentException("Cannot set null child layer");
        }
        this.childLayerToRegionNameMap.put(childLayer, regionName);
        this.regionNameToChildLayerMap.put(regionName, childLayer);
        childLayer.addLayerListener(this);
        this.childLayerLayout[layoutX][layoutY] = childLayer;
        childLayer.setClientAreaProvider(() -> this.getChildClientArea(layoutX, layoutY));
    }

    public IConfigLabelAccumulator getConfigLabelAccumulatorByRegionName(String regionName) {
        return this.regionNameToConfigLabelAccumulatorMap.get(regionName);
    }

    public void setConfigLabelAccumulatorForRegion(String regionName, IConfigLabelAccumulator configLabelAccumulator) {
        this.regionNameToConfigLabelAccumulatorMap.put(regionName, configLabelAccumulator);
    }

    public void addConfigLabelAccumulatorForRegion(String regionName, IConfigLabelAccumulator configLabelAccumulator) {
        AggregateConfigLabelAccumulator aggregateAccumulator;
        IConfigLabelAccumulator existingConfigLabelAccumulator = this.regionNameToConfigLabelAccumulatorMap.get(regionName);
        if (existingConfigLabelAccumulator instanceof AggregateConfigLabelAccumulator) {
            aggregateAccumulator = (AggregateConfigLabelAccumulator)existingConfigLabelAccumulator;
        } else {
            aggregateAccumulator = new AggregateConfigLabelAccumulator();
            if (existingConfigLabelAccumulator != null) {
                aggregateAccumulator.add(existingConfigLabelAccumulator);
            }
            this.regionNameToConfigLabelAccumulatorMap.put(regionName, aggregateAccumulator);
        }
        aggregateAccumulator.add(configLabelAccumulator);
    }

    private Rectangle getChildClientArea(int layoutX, int layoutY) {
        ILayer childLayer = this.childLayerLayout[layoutX][layoutY];
        Rectangle compositeClientArea = this.getClientAreaProvider().getClientArea();
        if (childLayer.isDynamicSizeLayer()) {
            if (this.childLayerLayout[layoutX].length > layoutY + 1) {
                int bottomY = layoutY + 1;
                while (bottomY < this.childLayerLayout[layoutX].length) {
                    ILayer bottomChildLayer = this.childLayerLayout[layoutX][bottomY];
                    int bottomHeight = bottomChildLayer.getPreferredHeight();
                    if (bottomHeight < compositeClientArea.height) {
                        compositeClientArea.height -= bottomHeight;
                    }
                    ++bottomY;
                }
            }
            if (this.childLayerLayout.length > layoutX + 1) {
                int rightX = layoutX + 1;
                while (rightX < this.childLayerLayout.length) {
                    ILayer rightChildLayer = this.childLayerLayout[rightX][layoutY];
                    int rightWidth = rightChildLayer.getPreferredWidth();
                    if (rightWidth < compositeClientArea.width) {
                        compositeClientArea.width -= rightWidth;
                    }
                    ++rightX;
                }
            }
        }
        Rectangle childClientArea = new Rectangle(compositeClientArea.x + this.getWidthOffset(layoutX), compositeClientArea.y + this.getHeightOffset(layoutY), childLayer.getPreferredWidth(), childLayer.getPreferredHeight());
        return compositeClientArea.intersection(childClientArea);
    }

    public ILayer getChildLayerByLayoutCoordinate(int layoutX, int layoutY) {
        if (layoutX < 0 || layoutX >= this.layoutXCount || layoutY < 0 || layoutY >= this.layoutYCount) {
            return null;
        }
        return this.childLayerLayout[layoutX][layoutY];
    }

    public ILayer getChildLayerByRegionName(String regionName) {
        return this.regionNameToChildLayerMap.get(regionName);
    }

    @Override
    public LabelStack getRegionLabelsByXY(int x, int y) {
        Point layoutCoordinate = this.getLayoutXYByPixelXY(x, y);
        if (layoutCoordinate == null) {
            return null;
        }
        ILayer childLayer = this.childLayerLayout[layoutCoordinate.x][layoutCoordinate.y];
        int childX = x - this.getWidthOffset(layoutCoordinate.x);
        int childY = y - this.getHeightOffset(layoutCoordinate.y);
        LabelStack regionLabels = childLayer.getRegionLabelsByXY(childX, childY);
        String regionName = this.childLayerToRegionNameMap.get(childLayer);
        regionLabels.addLabel(regionName);
        return regionLabels;
    }

    @Override
    public ILayer getUnderlyingLayerByPosition(int columnPosition, int rowPosition) {
        Point layoutCoordinate = this.getLayoutXYByPosition(columnPosition, rowPosition);
        if (layoutCoordinate != null) {
            return this.childLayerLayout[layoutCoordinate.x][layoutCoordinate.y];
        }
        return null;
    }

    protected Point getLayoutXYByChildLayer(ILayer childLayer) {
        int layoutX = 0;
        while (layoutX < this.layoutXCount) {
            int layoutY = 0;
            while (layoutY < this.layoutYCount) {
                if (this.childLayerLayout[layoutX][layoutY] == childLayer) {
                    return new Point(layoutX, layoutY);
                }
                ++layoutY;
            }
            ++layoutX;
        }
        return null;
    }

    protected int getLayoutXByPixelX(int x) {
        int layoutX = 0;
        while (layoutX < this.layoutXCount) {
            ILayer childLayer = this.childLayerLayout[layoutX][0];
            if (childLayer == null) {
                return -1;
            }
            int widthOffset = this.getWidthOffset(layoutX);
            if (x >= widthOffset && x < widthOffset + childLayer.getWidth()) {
                return layoutX;
            }
            ++layoutX;
        }
        return -1;
    }

    protected int getLayoutYByPixelY(int y) {
        int layoutY = 0;
        while (layoutY < this.layoutYCount) {
            ILayer childLayer = this.getChildLayerByLayoutCoordinate(0, layoutY);
            if (childLayer == null) {
                return -1;
            }
            int heightOffset = this.getHeightOffset(layoutY);
            if (y >= heightOffset && y < heightOffset + childLayer.getHeight()) {
                return layoutY;
            }
            ++layoutY;
        }
        return -1;
    }

    protected Point getLayoutXYByPixelXY(int x, int y) {
        int layoutX = 0;
        while (layoutX < this.layoutXCount) {
            ILayer childLayer = this.childLayerLayout[layoutX][0];
            if (childLayer == null) {
                return null;
            }
            int widthOffset = this.getWidthOffset(layoutX);
            if (x >= widthOffset && x < widthOffset + childLayer.getWidth()) break;
            ++layoutX;
        }
        int layoutY = 0;
        while (layoutY < this.layoutYCount) {
            ILayer childLayer = this.getChildLayerByLayoutCoordinate(layoutX, layoutY);
            if (childLayer == null) {
                return null;
            }
            int heightOffset = this.getHeightOffset(layoutY);
            if (y >= heightOffset && y < heightOffset + childLayer.getHeight()) {
                return new Point(layoutX, layoutY);
            }
            ++layoutY;
        }
        return null;
    }

    protected int getLayoutXByColumnPosition(int compositeColumnPosition) {
        int layoutX = 0;
        while (layoutX < this.layoutXCount) {
            ILayer childLayer = this.childLayerLayout[layoutX][0];
            int columnPositionOffset = this.getColumnPositionOffset(layoutX);
            if (compositeColumnPosition >= columnPositionOffset && compositeColumnPosition < columnPositionOffset + childLayer.getColumnCount()) {
                return layoutX;
            }
            ++layoutX;
        }
        return -1;
    }

    protected int getLayoutYByRowPosition(int compositeRowPosition) {
        int layoutY = 0;
        while (layoutY < this.layoutYCount) {
            ILayer childLayer = this.childLayerLayout[0][layoutY];
            int rowPositionOffset = this.getRowPositionOffset(layoutY);
            if (compositeRowPosition >= rowPositionOffset && compositeRowPosition < rowPositionOffset + childLayer.getRowCount()) {
                return layoutY;
            }
            ++layoutY;
        }
        return -1;
    }

    protected Point getLayoutXYByPosition(int compositeColumnPosition, int compositeRowPosition) {
        int layoutX = 0;
        while (layoutX < this.layoutXCount) {
            ILayer childLayer = this.childLayerLayout[layoutX][0];
            int columnPositionOffset = this.getColumnPositionOffset(layoutX);
            if (compositeColumnPosition >= columnPositionOffset && compositeColumnPosition < columnPositionOffset + childLayer.getColumnCount()) break;
            ++layoutX;
        }
        if (layoutX >= this.layoutXCount) {
            return null;
        }
        int layoutY = 0;
        while (layoutY < this.layoutYCount) {
            ILayer childLayer = this.childLayerLayout[layoutX][layoutY];
            int rowPositionOffset = this.getRowPositionOffset(layoutY);
            if (compositeRowPosition >= rowPositionOffset && compositeRowPosition < rowPositionOffset + childLayer.getRowCount()) {
                return new Point(layoutX, layoutY);
            }
            ++layoutY;
        }
        return null;
    }

    protected int getColumnPositionOffset(int layoutX) {
        int offset = 0;
        int x = 0;
        while (x < layoutX) {
            offset += this.childLayerLayout[x][0].getColumnCount();
            ++x;
        }
        return offset;
    }

    protected int getWidthOffset(int layoutX) {
        int offset = 0;
        int x = 0;
        while (x < layoutX) {
            offset += this.childLayerLayout[x][0].getWidth();
            ++x;
        }
        return offset;
    }

    protected int getRowPositionOffset(int layoutY) {
        int offset = 0;
        int y = 0;
        while (y < layoutY) {
            offset += this.childLayerLayout[0][y].getRowCount();
            ++y;
        }
        return offset;
    }

    protected int getHeightOffset(int layoutY) {
        int offset = 0;
        int y = 0;
        while (y < layoutY) {
            offset += this.childLayerLayout[0][y].getHeight();
            ++y;
        }
        return offset;
    }

    public int getLayoutXCount() {
        return this.layoutXCount;
    }

    public int getLayoutYCount() {
        return this.layoutYCount;
    }

    protected ILayer[][] getChildLayerLayout() {
        return this.childLayerLayout;
    }

    @Override
    public boolean isDynamicSizeLayer() {
        int layoutX = 0;
        while (layoutX < this.layoutXCount) {
            int layoutY = 0;
            while (layoutY < this.layoutYCount) {
                if (this.childLayerLayout[layoutX][layoutY].isDynamicSizeLayer()) {
                    return true;
                }
                ++layoutY;
            }
            ++layoutX;
        }
        return false;
    }

    @Override
    public Collection<String> getProvidedLabels() {
        Collection<String> labels = super.getProvidedLabels();
        int layoutX = 0;
        while (layoutX < this.layoutXCount) {
            int layoutY = 0;
            while (layoutY < this.layoutYCount) {
                ILayer childLayer = this.childLayerLayout[layoutX][layoutY];
                String regionName = this.childLayerToRegionNameMap.get(childLayer);
                labels.add(regionName);
                IConfigLabelAccumulator accumulator = this.regionNameToConfigLabelAccumulatorMap.get(regionName);
                if (accumulator instanceof IConfigLabelProvider) {
                    labels.addAll(((IConfigLabelProvider)accumulator).getProvidedLabels());
                }
                labels.addAll(childLayer.getProvidedLabels());
                ++layoutY;
            }
            ++layoutX;
        }
        return labels;
    }

    public class CompositeLayerPainter
    implements ILayerPainter {
        @Override
        public void paintLayer(ILayer natLayer, GC gc, int xOffset, int yOffset, Rectangle rectangle, IConfigRegistry configuration) {
            int x = xOffset;
            int layoutX = 0;
            while (layoutX < CompositeLayer.this.layoutXCount) {
                int y = yOffset;
                int layoutY = 0;
                while (layoutY < CompositeLayer.this.layoutYCount) {
                    ILayer childLayer = CompositeLayer.this.childLayerLayout[layoutX][layoutY];
                    Rectangle childLayerRectangle = new Rectangle(x, y, childLayer.getWidth(), childLayer.getHeight());
                    childLayerRectangle = rectangle.intersection(childLayerRectangle);
                    Rectangle originalClipping = gc.getClipping();
                    gc.setClipping(childLayerRectangle);
                    childLayer.getLayerPainter().paintLayer(natLayer, gc, x, y, childLayerRectangle, configuration);
                    this.processLayerPainterInformation(childLayer.getLayerPainter());
                    gc.setClipping(originalClipping);
                    y += childLayer.getHeight();
                    ++layoutY;
                }
                x += CompositeLayer.this.childLayerLayout[layoutX][0].getWidth();
                ++layoutX;
            }
        }

        protected void processLayerPainterInformation(ILayerPainter painter) {
        }

        @Override
        public Rectangle adjustCellBounds(int columnPosition, int rowPosition, Rectangle cellBounds) {
            Point layoutCoordinate = CompositeLayer.this.getLayoutXYByPosition(columnPosition, rowPosition);
            if (layoutCoordinate == null) {
                return null;
            }
            ILayer childLayer = CompositeLayer.this.childLayerLayout[layoutCoordinate.x][layoutCoordinate.y];
            if (childLayer == null) {
                return null;
            }
            int widthOffset = CompositeLayer.this.getWidthOffset(layoutCoordinate.x);
            int heightOffset = CompositeLayer.this.getHeightOffset(layoutCoordinate.y);
            cellBounds.x -= widthOffset;
            cellBounds.y -= heightOffset;
            ILayerPainter childLayerPainter = childLayer.getLayerPainter();
            int childColumnPosition = columnPosition - CompositeLayer.this.getColumnPositionOffset(layoutCoordinate.x);
            int childRowPosition = rowPosition - CompositeLayer.this.getRowPositionOffset(layoutCoordinate.y);
            Rectangle adjustedChildCellBounds = childLayerPainter.adjustCellBounds(childColumnPosition, childRowPosition, cellBounds);
            adjustedChildCellBounds.x += widthOffset;
            adjustedChildCellBounds.y += heightOffset;
            return adjustedChildCellBounds;
        }
    }
}

