/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.datatypeeditor.widgets;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.fordiac.ide.gef.annotation.GraphicalAnnotationModel;
import org.eclipse.fordiac.ide.gef.annotation.GraphicalAnnotationModelListener;
import org.eclipse.fordiac.ide.gef.nat.DefaultImportCopyPasteLayerConfiguration;
import org.eclipse.fordiac.ide.gef.nat.InitialValueEditorConfiguration;
import org.eclipse.fordiac.ide.gef.nat.TypeDeclarationEditorConfiguration;
import org.eclipse.fordiac.ide.gef.nat.VarDeclarationColumnAccessor;
import org.eclipse.fordiac.ide.gef.nat.VarDeclarationConfigLabelAccumulator;
import org.eclipse.fordiac.ide.gef.nat.VarDeclarationDataLayer;
import org.eclipse.fordiac.ide.gef.nat.VarDeclarationTableColumn;
import org.eclipse.fordiac.ide.model.commands.change.ChangeVariableOrderCommand;
import org.eclipse.fordiac.ide.model.commands.create.CreateMemberVariableCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteMemberVariableCommand;
import org.eclipse.fordiac.ide.model.commands.insert.InsertVariableCommand;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.emf.SingleRecursiveContentAdapter;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableObject;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.ui.widget.AddDeleteReorderToolbarWidget;
import org.eclipse.fordiac.ide.ui.widget.ChangeableListDataProvider;
import org.eclipse.fordiac.ide.ui.widget.CommandExecutor;
import org.eclipse.fordiac.ide.ui.widget.I4diacNatTableUtil;
import org.eclipse.fordiac.ide.ui.widget.IChangeableRowDataProvider;
import org.eclipse.fordiac.ide.ui.widget.NatTableColumnProvider;
import org.eclipse.fordiac.ide.ui.widget.NatTableWidgetFactory;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IEditableRule;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.IRowDataProvider;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.selection.RowPostSelectionProvider;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.selection.command.ClearAllSelectionsCommand;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class StructEditingComposite
extends Composite
implements CommandExecutor,
I4diacNatTableUtil {
    private NatTable natTable;
    private AddDeleteReorderToolbarWidget buttons;
    private final CommandStack cmdStack;
    private GraphicalAnnotationModel annotationModel;
    private StructuredType structType;
    private final IChangeableRowDataProvider<VarDeclaration> structMemberProvider;
    private RowPostSelectionProvider<VarDeclaration> selectionProvider;
    private final IWorkbenchSite site;
    protected boolean blockRefresh = false;
    private final Adapter adapter = new SingleRecursiveContentAdapter(){

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            if (!notification.isTouch()) {
                StructEditingComposite.this.notifyRefresh();
            }
        }
    };
    private final GraphicalAnnotationModelListener annotationModelListener = event -> this.notifyRefresh();

    private void notifyRefresh() {
        Display.getDefault().syncExec(() -> {
            if (this.structType != null && this.natTable != null && !this.natTable.isDisposed() && !this.blockRefresh) {
                this.natTable.refresh();
            }
        });
    }

    public StructEditingComposite(Composite parent, CommandStack cmdStack, StructuredType structType, GraphicalAnnotationModel annotationModel, IWorkbenchSite site) {
        super(parent, 0);
        this.structMemberProvider = new ChangeableListDataProvider((IColumnAccessor)new VarDeclarationColumnAccessor((CommandExecutor)this));
        this.cmdStack = cmdStack;
        this.annotationModel = annotationModel;
        this.site = site;
        this.setStructType(structType);
        this.createPartControl();
        this.addAnnotationModelListener();
    }

    private void createPartControl() {
        TabbedPropertySheetWidgetFactory widgetFactory = new TabbedPropertySheetWidgetFactory();
        this.setLayout((Layout)new GridLayout(2, false));
        this.setLayoutData(new GridData(4, 4, true, true));
        this.buttons = new AddDeleteReorderToolbarWidget();
        this.buttons.createControls((Composite)this, (FormToolkit)widgetFactory, (IServiceLocator)this.site);
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                StructEditingComposite.this.natTable.doCommand((ILayerCommand)new ClearAllSelectionsCommand());
            }
        });
        this.createNatTable();
        this.buttons.bindToTableViewer(this.natTable, (CommandExecutor)this, ref -> new CreateMemberVariableCommand(this.getType(), this.getInsertionIndex(), this.getVarName(), this.getDataType()), ref -> new DeleteMemberVariableCommand(this.getType(), (VarDeclaration)ref), ref -> new ChangeVariableOrderCommand(this.getType().getMemberVariables(), (VarDeclaration)ref, true), ref -> new ChangeVariableOrderCommand(this.getType().getMemberVariables(), (VarDeclaration)ref, false));
    }

    private void createNatTable() {
        VarDeclarationDataLayer inputDataLayer = new VarDeclarationDataLayer(this.structMemberProvider, VarDeclarationTableColumn.DEFAULT_COLUMNS);
        inputDataLayer.setConfigLabelAccumulator((IConfigLabelAccumulator)new VarDeclarationConfigLabelAccumulator(this.structMemberProvider, this::getAnnotationModel));
        NatTableColumnProvider columnProvider = new NatTableColumnProvider(VarDeclarationTableColumn.DEFAULT_COLUMNS);
        this.natTable = NatTableWidgetFactory.createRowNatTable((Composite)this, (DataLayer)inputDataLayer, (IDataProvider)columnProvider, (IEditableRule)IEditableRule.ALWAYS_EDITABLE, null, (I4diacNatTableUtil)this, (boolean)false);
        this.natTable.addConfiguration((IConfiguration)new InitialValueEditorConfiguration(this.structMemberProvider));
        this.natTable.addConfiguration((IConfiguration)new TypeDeclarationEditorConfiguration(this.structMemberProvider));
        this.natTable.addConfiguration((IConfiguration)new DefaultImportCopyPasteLayerConfiguration(columnProvider, (CommandExecutor)this));
        this.natTable.configure();
        this.selectionProvider = new StructEditingCompositeSelectionProvider(this.natTable, NatTableWidgetFactory.getSelectionLayer((NatTable)this.natTable), (IRowDataProvider<VarDeclaration>)this.structMemberProvider);
    }

    private DataType getDataType() {
        VarDeclaration memVar = this.getLastSelectedVariable();
        return memVar != null ? memVar.getType() : null;
    }

    private String getVarName() {
        VarDeclaration memVar = this.getLastSelectedVariable();
        return memVar != null ? memVar.getName() : null;
    }

    private int getInsertionIndex() {
        VarDeclaration memVar = this.getLastSelectedVariable();
        if (memVar == null) {
            return this.getType().getMemberVariables().size();
        }
        return this.getType().getMemberVariables().indexOf((Object)memVar) + 1;
    }

    private VarDeclaration getLastSelectedVariable() {
        return (VarDeclaration)NatTableWidgetFactory.getLastSelectedVariable((NatTable)this.natTable);
    }

    private StructuredType getType() {
        return this.structType;
    }

    public final void setStructType(StructuredType newStructType) {
        if (this.structType != newStructType) {
            if (this.structType != null) {
                this.structType.eAdapters().remove((Object)this.adapter);
            }
            this.structType = newStructType;
            if (this.structType != null) {
                this.structMemberProvider.setInput((List)this.structType.getMemberVariables());
                this.structType.eAdapters().add((Object)this.adapter);
            } else {
                this.structMemberProvider.setInput(Collections.emptyList());
            }
            if (this.natTable != null && !this.natTable.isDisposed()) {
                this.natTable.refresh();
            }
        }
    }

    protected void removeAnnotationModelListener() {
        if (this.annotationModel != null) {
            this.annotationModel.removeAnnotationModelListener(this.annotationModelListener);
        }
    }

    protected void addAnnotationModelListener() {
        if (this.annotationModel != null) {
            this.annotationModel.addAnnotationModelListener(this.annotationModelListener, true);
        }
    }

    public void executeCommand(Command cmd) {
        if (this.getType() != null && this.cmdStack != null && cmd != null && cmd.canExecute()) {
            this.blockRefresh = true;
            this.cmdStack.execute(cmd);
            this.blockRefresh = false;
        }
    }

    public void addEntry(Object entry, boolean isInput, int index, CompoundCommand cmd) {
        if (entry instanceof VarDeclaration) {
            VarDeclaration varEntry = (VarDeclaration)entry;
            cmd.add((Command)new InsertVariableCommand((LibraryElement)this.getType(), this.getType().getMemberVariables(), varEntry, index));
        }
    }

    public void executeCompoundCommand(CompoundCommand cmd) {
        this.executeCommand((Command)cmd);
        this.natTable.refresh();
    }

    public Object removeEntry(int index, CompoundCommand cmd) {
        VarDeclaration entry = (VarDeclaration)this.getEntry(index);
        cmd.add((Command)new DeleteMemberVariableCommand(this.getType(), entry));
        return entry;
    }

    public TypeLibrary getTypeLibrary() {
        return this.getType().getTypeLibrary();
    }

    public DataType getStruct() {
        return this.getType();
    }

    public Object getEntry(int index) {
        return this.getType().getMemberVariables().get(index);
    }

    public GraphicalAnnotationModel getAnnotationModel() {
        return this.annotationModel;
    }

    public void setAnnotationModel(GraphicalAnnotationModel annotationModel) {
        this.removeAnnotationModelListener();
        this.annotationModel = annotationModel;
        this.addAnnotationModelListener();
    }

    public ISelectionProvider getSelectionProvider() {
        return this.selectionProvider;
    }

    public boolean isEditable() {
        return true;
    }

    public void removeEntry(Object entry, CompoundCommand cmd) {
        if (entry instanceof VarDeclaration) {
            VarDeclaration varDecl = (VarDeclaration)entry;
            cmd.add((Command)new DeleteMemberVariableCommand(this.getType(), varDecl));
        }
    }

    public void dispose() {
        super.dispose();
        if (this.buttons != null) {
            this.buttons.dispose();
        }
        this.removeAnnotationModelListener();
        if (this.getType() != null) {
            this.getType().eAdapters().remove((Object)this.adapter);
        }
    }

    public static interface ConfigurablObjectListener {
        public void handleObjectChanged(ConfigurableObject var1);
    }

    private class StructEditingCompositeSelectionProvider
    extends RowPostSelectionProvider<VarDeclaration> {
        public StructEditingCompositeSelectionProvider(NatTable natTable, SelectionLayer selectionLayer, IRowDataProvider<VarDeclaration> rowDataProvider) {
            super(natTable, selectionLayer, rowDataProvider, false);
        }

        public ISelection getSelection() {
            ISelection selection = super.getSelection();
            if (selection.isEmpty()) {
                return new StructuredSelection((Object)StructEditingComposite.this.structType);
            }
            return selection;
        }
    }
}

