/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.debug.ui.view;

import java.util.Iterator;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.FreeformFigure;
import org.eclipse.draw2d.FreeformLayeredPane;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.FreeformViewport;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.RangeModel;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.fordiac.ide.debug.EvaluatorDebugElement;
import org.eclipse.fordiac.ide.debug.EvaluatorDebugTarget;
import org.eclipse.fordiac.ide.debug.EvaluatorProcess;
import org.eclipse.fordiac.ide.debug.ui.view.FBDebugViewClockWidget;
import org.eclipse.fordiac.ide.debug.ui.view.FBDebugViewEditPartFactory;
import org.eclipse.fordiac.ide.debug.ui.view.actions.RepeatEventAction;
import org.eclipse.fordiac.ide.gef.FordiacContextMenuProvider;
import org.eclipse.fordiac.ide.gef.figures.AbstractFreeformFigure;
import org.eclipse.fordiac.ide.model.eval.fb.FBEvaluator;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.KeyStroke;
import org.eclipse.gef.MouseWheelHandler;
import org.eclipse.gef.MouseWheelZoomHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.FreeformGraphicalRootEditPart;
import org.eclipse.gef.editparts.GridLayer;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.DirectEditAction;
import org.eclipse.gef.ui.actions.UpdateAction;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.part.ViewPart;

public class FBDebugView
extends ViewPart
implements IDebugContextListener,
ISelectionListener {
    private GraphicalViewer viewer;
    private ActionRegistry actionRegistry;
    private KeyHandler sharedKeyHandler;
    private RepeatEventAction repeatEventAction;
    private final FBDebugViewClockWidget clockWidget = new FBDebugViewClockWidget();

    public void createPartControl(Composite parent) {
        this.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this);
        GridLayoutFactory.fillDefaults().applyTo(parent);
        this.createGraphicalViewer(parent);
        Composite clockControl = this.clockWidget.createControl(parent);
        clockControl.setVisible(false);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)clockControl);
        this.createToolBarEntries();
        this.hookDebugListeners();
    }

    private void hookDebugListeners() {
        DebugUITools.addPartDebugContextListener((IWorkbenchPartSite)this.getSite(), (IDebugContextListener)this);
    }

    private void createToolBarEntries() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolBar = actionBars.getToolBarManager();
        toolBar.add(this.createRepeatEventAction());
    }

    private IAction createRepeatEventAction() {
        this.repeatEventAction = new RepeatEventAction();
        return this.repeatEventAction;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (((Object)((Object)this)).equals(this.getSite().getPage().getActivePart())) {
            this.updateActions();
        }
    }

    private void createGraphicalViewer(Composite parent) {
        this.viewer = new ScrollingGraphicalViewer(){

            public void setContents(Object contents) {
                if (contents == null) {
                    this.getRootEditPart().setContents(null);
                } else {
                    super.setContents(contents);
                }
            }
        };
        this.viewer.createControl(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.viewer.getControl());
        EditDomain editDomain = new EditDomain();
        editDomain.addViewer((EditPartViewer)this.viewer);
        this.configureGraphicalViewer();
        this.initializeGraphicalViewer();
        this.hookGraphicalViewer();
    }

    private void configureGraphicalViewer() {
        this.viewer.getControl().setBackground(ColorConstants.listBackground);
        ScalableFreeformRootEditPart root = FBDebugView.createRootEditPart();
        this.viewer.setRootEditPart((RootEditPart)root);
        this.viewer.setEditPartFactory((EditPartFactory)new FBDebugViewEditPartFactory());
        this.viewer.setContextMenu((MenuManager)new FordiacContextMenuProvider((EditPartViewer)this.viewer, root.getZoomManager(), this.getActionRegistry()));
        this.viewer.setProperty(MouseWheelHandler.KeyGenerator.getKey((int)SWT.MOD1), (Object)MouseWheelZoomHandler.SINGLETON);
        KeyHandler viewerKeyHandler = new GraphicalViewerKeyHandler(this.viewer).setParent(this.getCommonKeyHandler());
        this.viewer.setKeyHandler(viewerKeyHandler);
    }

    private void initializeGraphicalViewer() {
    }

    private void hookGraphicalViewer() {
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
    }

    private static ScalableFreeformRootEditPart createRootEditPart() {
        return new ScalableFreeformRootEditPart(){

            protected IFigure createFigure() {
                FreeformViewport viewPort = (FreeformViewport)super.createFigure();
                this.getLayer("Primary Layer").setLayoutManager((LayoutManager)new FreeformLayout());
                GridLayer grid = (GridLayer)this.getLayer("Grid Layer");
                if (grid != null) {
                    grid.setVisible(false);
                }
                FreeformLayeredPane drawingArea = (FreeformLayeredPane)viewPort.getContents();
                ZeroOffestFreeformCanvas editorBackground = new ZeroOffestFreeformCanvas();
                viewPort.setContents((IFigure)editorBackground);
                editorBackground.setContents((FreeformFigure)drawingArea);
                return viewPort;
            }

            protected void refreshGridLayer() {
            }
        };
    }

    private ActionRegistry getActionRegistry() {
        if (this.actionRegistry == null) {
            this.actionRegistry = this.createActionRegistry();
        }
        return this.actionRegistry;
    }

    public void dispose() {
        DebugUITools.removePartDebugContextListener((IWorkbenchPartSite)this.getSite(), (IDebugContextListener)this);
        this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener((ISelectionListener)this);
    }

    public <T> T getAdapter(Class<T> type) {
        if (type == ActionRegistry.class) {
            return type.cast(this.getActionRegistry());
        }
        return (T)super.getAdapter(type);
    }

    private KeyHandler getCommonKeyHandler() {
        if (this.sharedKeyHandler == null) {
            this.sharedKeyHandler = new KeyHandler();
            this.sharedKeyHandler.put(KeyStroke.getPressed((int)0x100000B, (int)0), this.getActionRegistry().getAction((Object)"org.eclipse.gef.direct_edit"));
        }
        return this.sharedKeyHandler;
    }

    public void setFocus() {
    }

    public void debugContextChanged(DebugContextEvent event) {
        if ((event.getFlags() & 1) > 0) {
            this.contextActivated(event.getContext());
        }
    }

    private void contextActivated(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structSel = (IStructuredSelection)selection;
            Object source = structSel.getFirstElement();
            if (source == null) {
                this.setContents(null);
                this.clockWidget.getControl().setVisible(false);
            } else {
                EvaluatorProcess evaluator = FBDebugView.getFBEvaluatorDebugContext(source);
                this.clockWidget.getControl().setVisible(true);
                if (!this.isViewerContent(evaluator)) {
                    this.setContents(evaluator);
                }
            }
        }
    }

    private void setContents(EvaluatorProcess evaluator) {
        this.viewer.setContents((Object)evaluator);
        this.repeatEventAction.updateEvaluator(evaluator);
        this.clockWidget.setProcess(evaluator);
        this.clockWidget.refresh(true);
        this.setScrollPosition();
    }

    private boolean isViewerContent(EvaluatorProcess evaluator) {
        EditPart content = this.viewer.getContents();
        return content != null && content.getModel() == evaluator || evaluator == null;
    }

    private static EvaluatorProcess getFBEvaluatorDebugContext(Object source) {
        EvaluatorProcess ep;
        Object evaluatorProcess = source;
        if (evaluatorProcess instanceof EvaluatorDebugElement) {
            EvaluatorDebugElement evalDebugElem = (EvaluatorDebugElement)evaluatorProcess;
            evaluatorProcess = evalDebugElem.getDebugTarget();
        }
        if (evaluatorProcess instanceof EvaluatorDebugTarget) {
            EvaluatorDebugTarget evalDebugTarget = (EvaluatorDebugTarget)evaluatorProcess;
            evaluatorProcess = evalDebugTarget.getProcess();
        }
        if (evaluatorProcess instanceof EvaluatorProcess && (ep = (EvaluatorProcess)evaluatorProcess).getEvaluator() instanceof FBEvaluator) {
            return ep;
        }
        return null;
    }

    private void setScrollPosition() {
        Control control = this.viewer.getControl();
        if (control instanceof FigureCanvas) {
            FigureCanvas canvas = (FigureCanvas)control;
            Display.getDefault().asyncExec(() -> {
                if (!canvas.isDisposed()) {
                    this.viewer.flush();
                    if (this.viewer.getSelectedEditParts().isEmpty()) {
                        Point scrollPos = FBDebugView.getInitialScrollPos(this.viewer);
                        canvas.scrollTo(scrollPos.x, scrollPos.y);
                    }
                }
            });
        }
    }

    private static Point getInitialScrollPos(GraphicalViewer viewer) {
        FreeformGraphicalRootEditPart rootEditPart = (FreeformGraphicalRootEditPart)viewer.getRootEditPart();
        FreeformViewport rootviewPort = (FreeformViewport)rootEditPart.getFigure();
        return new Point(FBDebugView.calculateCenterScrollPos(rootviewPort.getHorizontalRangeModel()), FBDebugView.calculateCenterScrollPos(rootviewPort.getVerticalRangeModel()));
    }

    private static int calculateCenterScrollPos(RangeModel rangeModel) {
        int center = (rangeModel.getMaximum() + rangeModel.getMinimum()) / 2;
        return center - rangeModel.getExtent() / 2;
    }

    private ActionRegistry createActionRegistry() {
        ActionRegistry newAR = new ActionRegistry();
        DirectEditAction action = new DirectEditAction((IWorkbenchPart)this);
        newAR.registerAction((IAction)action);
        return newAR;
    }

    private void updateActions() {
        ActionRegistry registry = this.getActionRegistry();
        Iterator actionIter = registry.getActions();
        while (actionIter.hasNext()) {
            IAction action = (IAction)actionIter.next();
            if (!(action instanceof UpdateAction)) continue;
            UpdateAction updateAction = (UpdateAction)action;
            updateAction.update();
        }
    }

    public static final class ZeroOffestFreeformCanvas
    extends AbstractFreeformFigure {
        private Point contentOffset;

        protected Rectangle calculateFreeformExtent() {
            Rectangle newExtents = this.getContents().getFreeformExtent().getCopy();
            this.contentOffset = newExtents.getTopLeft();
            newExtents.x = 0;
            newExtents.y = 0;
            return newExtents;
        }

        protected void setChildBounds(Rectangle childBounds) {
            childBounds.x = this.contentOffset.x;
            childBounds.y = this.contentOffset.y;
            super.setChildBounds(childBounds);
        }

        protected void paintChildren(Graphics graphics) {
            graphics.translate(-this.contentOffset.x, -this.contentOffset.y);
            super.paintChildren(graphics);
        }

        public void translateFromParent(Translatable t) {
            t.performTranslate(this.contentOffset.x, this.contentOffset.y);
        }

        public void translateToParent(Translatable t) {
            t.performTranslate(-this.contentOffset.x, -this.contentOffset.y);
        }

        public Rectangle getClientArea(Rectangle rect) {
            Rectangle clientArea = super.getClientArea(rect);
            clientArea.translate(this.contentOffset);
            return clientArea;
        }
    }
}

