/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.search;

import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.helpers.FBNetworkHelper;
import org.eclipse.fordiac.ide.model.libraryElement.Algorithm;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.ICallable;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.Method;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.SimpleFBType;

public class SearchNameDictionary {
    private final HashMap<FBNetworkElement, Stack<List<FBNetworkElement>>> map = new HashMap();

    public void addEntry(FBNetworkElement fbnetworkElement, List<FBNetworkElement> composites) {
        this.map.computeIfAbsent(fbnetworkElement, elem -> new Stack());
        this.map.get(fbnetworkElement).push(composites);
    }

    public String hierarchicalName(Object element) {
        if (element instanceof FBNetworkElement) {
            FBNetworkElement fbne = (FBNetworkElement)element;
            if (fbne.eContainer() instanceof BasicFBType || fbne.eContainer() instanceof SimpleFBType) {
                return this.hierarchicalName(fbne, true);
            }
            if (this.map.containsKey(fbne)) {
                return this.hierarchicalName(fbne, false);
            }
            EObject root = EcoreUtil.getRootContainer((EObject)fbne);
            StringBuilder sb = new StringBuilder();
            if (root instanceof AutomationSystem) {
                AutomationSystem system = (AutomationSystem)root;
                sb.append(system.getName() + ".");
            }
            return sb.toString() + FBNetworkHelper.getFullHierarchicalName((FBNetworkElement)fbne);
        }
        if (element instanceof IInterfaceElement) {
            IInterfaceElement ie = (IInterfaceElement)element;
            String parentName = FBNetworkHelper.getFullHierarchicalName((FBNetworkElement)ie.getBlockFBNetworkElement());
            if (parentName == null && ie.eContainer() != null) {
                EObject eObject = ie.eContainer();
                if (eObject instanceof INamedElement) {
                    INamedElement econ = (INamedElement)eObject;
                    parentName = econ.getName();
                } else {
                    EObject eObject2 = ie.eContainer().eContainer();
                    if (eObject2 instanceof INamedElement) {
                        INamedElement econParent = (INamedElement)eObject2;
                        parentName = econParent.getName();
                    }
                }
            }
            return parentName + "." + ie.getName();
        }
        if (element instanceof Device) {
            Device device = (Device)element;
            return device.getAutomationSystem().getName() + "." + device.getName();
        }
        if (element instanceof Resource) {
            Resource res = (Resource)element;
            return res.getDevice().getAutomationSystem().getName() + "." + res.getDevice().getName() + "." + res.getName();
        }
        if (element instanceof ICallable) {
            EObject eObject;
            ICallable call = (ICallable)element;
            if ((element instanceof Algorithm || element instanceof Method) && (eObject = call.eContainer()) instanceof INamedElement) {
                INamedElement namedElement = (INamedElement)eObject;
                return namedElement.getName() + "." + call.getName();
            }
        }
        if (element instanceof LibraryElement) {
            LibraryElement libElement = (LibraryElement)element;
            return libElement.getTypeEntry().getFullTypeName();
        }
        if (element instanceof INamedElement) {
            INamedElement namedElement = (INamedElement)element;
            return namedElement.getName();
        }
        return element.toString();
    }

    private String hierarchicalName(FBNetworkElement element, boolean isInternal) {
        Stack<List<FBNetworkElement>> stack = this.map.get(element);
        if (stack == null) {
            String name = FBNetworkHelper.getFullHierarchicalName((FBNetworkElement)element);
            return isInternal ? name + "(internal)" : name;
        }
        List<FBNetworkElement> path = stack.pop();
        if (stack.isEmpty()) {
            this.map.remove(element);
        }
        FBNetworkElement first = path.get(0);
        String firstElementName = FBNetworkHelper.getFullHierarchicalName((FBNetworkElement)first);
        Application application = first.getFbNetwork().getApplication();
        StringBuilder sb = new StringBuilder();
        if (application != null) {
            sb.append(application.getAutomationSystem().getName()).append(".");
        }
        sb.append(firstElementName);
        int i = 1;
        while (i < path.size()) {
            SearchNameDictionary.addNameToPath(path.get(i), sb, false);
            ++i;
        }
        SearchNameDictionary.addNameToPath(element, sb, isInternal);
        return sb.toString();
    }

    private static void addNameToPath(FBNetworkElement element, StringBuilder sb, boolean isInternal) {
        sb.append(".");
        String name = isInternal ? element.getName() : FBNetworkHelper.getFullHierarchicalName((FBNetworkElement)element);
        name = name.substring(name.indexOf(46) + 1);
        sb.append(name);
        if (isInternal) {
            sb.append("(internal)");
        }
    }
}

