/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.bulkeditor.editors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.bulkeditor.editors.SearchHelper;
import org.eclipse.fordiac.ide.gef.nat.AbstractColumnAccessor;
import org.eclipse.fordiac.ide.gef.nat.AttributeColumnAccessor;
import org.eclipse.fordiac.ide.gef.nat.AttributeConfigLabelAccumulator;
import org.eclipse.fordiac.ide.gef.nat.AttributeDeclarationColumnAccessor;
import org.eclipse.fordiac.ide.gef.nat.AttributeDeclarationConfigLabelAccumulator;
import org.eclipse.fordiac.ide.gef.nat.AttributeDeclarationTableColumn;
import org.eclipse.fordiac.ide.gef.nat.AttributeEditableRule;
import org.eclipse.fordiac.ide.gef.nat.AttributeTableColumn;
import org.eclipse.fordiac.ide.gef.nat.DefaultImportCopyPasteLayerConfiguration;
import org.eclipse.fordiac.ide.gef.nat.InitialValueEditorConfiguration;
import org.eclipse.fordiac.ide.gef.nat.SorterModel;
import org.eclipse.fordiac.ide.gef.nat.TypeDeclarationEditorConfiguration;
import org.eclipse.fordiac.ide.gef.nat.VarDeclarationColumnAccessor;
import org.eclipse.fordiac.ide.gef.nat.VarDeclarationConfigLabelAccumulator;
import org.eclipse.fordiac.ide.gef.nat.VarDeclarationDataLayer;
import org.eclipse.fordiac.ide.gef.nat.VarDeclarationTableColumn;
import org.eclipse.fordiac.ide.model.commands.create.AddNewImportCommand;
import org.eclipse.fordiac.ide.model.helpers.ImportHelper;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.AttributeDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableObject;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.model.ui.nat.DataTypeSelectionTreeContentProvider;
import org.eclipse.fordiac.ide.model.ui.nat.TypeSelectionTreeContentProvider;
import org.eclipse.fordiac.ide.model.ui.widgets.AttributeSelectionContentProvider;
import org.eclipse.fordiac.ide.model.ui.widgets.DataTypeSelectionContentProvider;
import org.eclipse.fordiac.ide.model.ui.widgets.ITypeSelectionContentProvider;
import org.eclipse.fordiac.ide.model.ui.widgets.ImportContentProposal;
import org.eclipse.fordiac.ide.model.ui.widgets.ImportTypeSelectionProposalProvider;
import org.eclipse.fordiac.ide.model.ui.widgets.TypeSelectionButton;
import org.eclipse.fordiac.ide.ui.widget.ChangeableListDataProvider;
import org.eclipse.fordiac.ide.ui.widget.CommandExecutor;
import org.eclipse.fordiac.ide.ui.widget.NatTableColumnEditableRule;
import org.eclipse.fordiac.ide.ui.widget.NatTableColumnProvider;
import org.eclipse.fordiac.ide.ui.widget.NatTableWidgetFactory;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.config.AbstractRegistryConfiguration;
import org.eclipse.nebula.widgets.nattable.config.EditableRule;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IEditableRule;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.IRowDataProvider;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.editor.ICellEditor;
import org.eclipse.nebula.widgets.nattable.edit.editor.TextCellEditor;
import org.eclipse.nebula.widgets.nattable.grid.command.AutoResizeColumnCommandHandler;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.resize.command.AutoResizeColumnsCommand;
import org.eclipse.nebula.widgets.nattable.sort.config.SingleClickSortConfiguration;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class BulkEditorNatTable {
    private final CommandExecutor commandExecutor;
    private final Composite parent;
    private int currentMode;
    private boolean dynamicTable;
    private NatTable natTable;
    private List<Attribute> currentAttributeList;
    private SorterModel<Attribute> attributeSorterModel;
    private SorterModel<VarDeclaration> varDeclarationSorterModel;
    private ChangeableListDataProvider<Attribute> attributeProvider;
    private ChangeableListDataProvider<VarDeclaration> varDeclProvider;

    public BulkEditorNatTable(Composite parent, CommandExecutor commandExecutor, int initialMode) {
        this.parent = parent;
        this.commandExecutor = commandExecutor;
        this.changeNatTable(initialMode);
    }

    public void updateList(List<EObject> mappedList) {
        this.currentAttributeList = Collections.emptyList();
        if (this.currentMode == 0 && (mappedList.isEmpty() || mappedList.getFirst() instanceof VarDeclaration)) {
            List<VarDeclaration> list = BulkEditorNatTable.mapList(mappedList, VarDeclaration.class);
            this.varDeclProvider.setInput(list);
            this.varDeclarationSorterModel.setSortingList(list);
        } else if (this.currentMode == 1 && (mappedList.isEmpty() || mappedList.getFirst() instanceof Attribute)) {
            List<Attribute> list = BulkEditorNatTable.mapList(mappedList, Attribute.class);
            this.currentAttributeList = list;
            this.attributeProvider.setInput(list);
            this.attributeSorterModel.setSortingList(list);
            DataLayer dataLayer = NatTableWidgetFactory.getDataLayer((NatTable)this.natTable);
            if (this.dynamicTable && dataLayer.getRowCount() > 0) {
                dataLayer.doCommand((ILayerCommand)new AutoResizeColumnsCommand(this.natTable, IntStream.range(0, dataLayer.getColumnCount()).toArray()));
                int colPos = 0;
                while (colPos < dataLayer.getColumnCount()) {
                    int currentWidth = dataLayer.getColumnWidthByPosition(colPos);
                    dataLayer.setColumnWidthByPosition(colPos, Math.max(currentWidth, 100));
                    ++colPos;
                }
            }
        }
        this.natTable.getDisplay().asyncExec(() -> {
            GridData natTableGridData = new GridData(4, 128, true, false);
            int height = (int)(24.0 * (double)Display.getCurrent().getDPI().x / 96.0);
            if (!mappedList.isEmpty()) {
                height = Math.max(height, NatTableWidgetFactory.getDataLayer((NatTable)this.natTable).getBoundsByPosition((int)0, (int)0).height);
            }
            natTableGridData.heightHint = Math.max(300, mappedList.size() * height + 1);
            this.natTable.setLayoutData((Object)natTableGridData);
            this.parent.layout(true, true);
            Point size = this.parent.computeSize(-1, -1);
            ScrolledComposite scrolledComposite = (ScrolledComposite)this.parent.getParent();
            scrolledComposite.setMinSize(size);
            this.natTable.refresh();
        });
    }

    public List<Attribute> getCurrentList() {
        return this.currentAttributeList;
    }

    public void changeNatTable(int selectionIndex) {
        this.currentMode = selectionIndex;
        this.dynamicTable = false;
        if (this.natTable != null) {
            this.natTable.dispose();
        }
        if (this.currentMode == 0) {
            this.createDefaultVarDeclTable();
        } else {
            this.createDefaultAttributeTable();
        }
        this.natTable.addConfiguration((IConfiguration)new SingleClickSortConfiguration());
        this.natTable.configure();
        this.natTable.addListener(37, event -> {
            ScrolledComposite scrolledParent = (ScrolledComposite)this.parent.getParent();
            Point origin = scrolledParent.getOrigin();
            int newY = Math.max(0, origin.y - event.count * 20);
            scrolledParent.setOrigin(origin.x, newY);
        });
    }

    public void createDefaultVarDeclTable() {
        VarDeclarationColumnAccessor accessor = new VarDeclarationColumnAccessor(this.commandExecutor, VarDeclarationTableColumn.DEFAULT_COLUMNS_WITH_LOCATION);
        this.varDeclProvider = new ChangeableListDataProvider((IColumnAccessor)accessor);
        this.varDeclarationSorterModel = new SorterModel((AbstractColumnAccessor)accessor);
        VarDeclarationDataLayer inputDataLayer = new VarDeclarationDataLayer(this.varDeclProvider, VarDeclarationTableColumn.DEFAULT_COLUMNS_WITH_LOCATION);
        VarDeclarationConfigLabelAccumulator configLabelProvider = new VarDeclarationConfigLabelAccumulator((IRowDataProvider)this.varDeclProvider, () -> null, VarDeclarationTableColumn.DEFAULT_COLUMNS_WITH_LOCATION){

            public void accumulateConfigLabels(LabelStack configLabels, int columnPosition, int rowPosition) {
                super.accumulateConfigLabels(configLabels, columnPosition, rowPosition);
                switch ((VarDeclarationTableColumn)this.getColumns().get(columnPosition)) {
                    case NAME: {
                        configLabels.addLabelOnTop("LEFT_TRUNCATING");
                        break;
                    }
                    case TYPE: {
                        configLabels.addLabelOnTop("LEFT_TRUNCATING");
                        break;
                    }
                }
            }
        };
        inputDataLayer.setConfigLabelAccumulator((IConfigLabelAccumulator)configLabelProvider);
        NatTableColumnProvider columnProvider = new NatTableColumnProvider(VarDeclarationTableColumn.DEFAULT_COLUMNS_WITH_LOCATION);
        this.natTable = NatTableWidgetFactory.createRowNatTable((Composite)this.parent, (DataLayer)inputDataLayer, (IDataProvider)columnProvider, (IEditableRule)new NatTableColumnEditableRule((IEditableRule)new LinkedElementsEditableRule(this.varDeclProvider), VarDeclarationTableColumn.DEFAULT_COLUMNS_WITH_LOCATION, VarDeclarationTableColumn.EDITABLE_COMMENT_VALUE), null, null, this.varDeclarationSorterModel, (boolean)false);
        this.natTable.addConfiguration((IConfiguration)new InitialValueEditorConfiguration(this.varDeclProvider));
        this.natTable.addConfiguration((IConfiguration)new TypeDeclarationEditorConfiguration(this.varDeclProvider));
        this.natTable.addConfiguration((IConfiguration)new DefaultImportCopyPasteLayerConfiguration(columnProvider, this.commandExecutor));
    }

    public void createDefaultAttributeTable() {
        AttributeColumnAccessor accessor = new AttributeColumnAccessor(this.commandExecutor, AttributeTableColumn.DEFAULT_COLUMNS_WITH_LOCATION);
        this.attributeProvider = new ChangeableListDataProvider((IColumnAccessor)accessor);
        this.attributeSorterModel = new SorterModel((AbstractColumnAccessor)accessor);
        DataLayer dataLayer = new DataLayer(this.attributeProvider);
        AttributeConfigLabelAccumulator configLabelProvider = new AttributeConfigLabelAccumulator((IRowDataProvider)this.attributeProvider, () -> null, AttributeTableColumn.DEFAULT_COLUMNS_WITH_LOCATION){

            public void accumulateConfigLabels(LabelStack configLabels, int columnPosition, int rowPosition) {
                super.accumulateConfigLabels(configLabels, columnPosition, rowPosition);
                switch ((AttributeTableColumn)this.getColumns().get(columnPosition)) {
                    case NAME: {
                        configLabels.addLabelOnTop("LEFT_TRUNCATING");
                        break;
                    }
                    case TYPE: {
                        configLabels.addLabelOnTop("LEFT_TRUNCATING");
                        break;
                    }
                }
            }
        };
        dataLayer.setConfigLabelAccumulator((IConfigLabelAccumulator)configLabelProvider);
        NatTableColumnProvider columnProvider = new NatTableColumnProvider(AttributeTableColumn.DEFAULT_COLUMNS_WITH_LOCATION);
        this.natTable = NatTableWidgetFactory.createRowNatTable((Composite)this.parent, (DataLayer)dataLayer, (IDataProvider)columnProvider, (IEditableRule)new AttributeEditableRule((IEditableRule)new LinkedElementsEditableRule(this.attributeProvider), AttributeTableColumn.DEFAULT_COLUMNS_WITH_LOCATION, AttributeTableColumn.EDITABLE_COMMENT_VALUE, this.attributeProvider), (ICellEditor)new TypeSelectionButton(() -> {
            int relevantRowIndex = NatTableWidgetFactory.getSelectionLayer((NatTable)this.natTable).getLastSelectedCellPosition().getRowPosition();
            EObject eObject = EcoreUtil.getRootContainer((EObject)((EObject)this.attributeProvider.getRowObject(relevantRowIndex)));
            if (eObject instanceof LibraryElement) {
                LibraryElement libElement = (LibraryElement)eObject;
                return libElement.getTypeLibrary();
            }
            return null;
        }, (ITypeSelectionContentProvider)DataTypeSelectionContentProvider.INSTANCE, (TypeSelectionTreeContentProvider)DataTypeSelectionTreeContentProvider.INSTANCE), null, this.attributeSorterModel, (boolean)false);
        this.natTable.addConfiguration((IConfiguration)new InitialValueEditorConfiguration(this.attributeProvider));
        this.natTable.addConfiguration((IConfiguration)new DefaultImportCopyPasteLayerConfiguration(columnProvider, this.commandExecutor));
        Predicate<TypeEntry> targetFilter = entry -> {
            LibraryElement libraryElement = entry.getType();
            if (libraryElement instanceof AttributeDeclaration) {
                AttributeDeclaration decl = (AttributeDeclaration)libraryElement;
                int relevantRowIndex = NatTableWidgetFactory.getSelectionLayer((NatTable)this.natTable).getLastSelectedCellPosition().getRowPosition();
                EObject eObject = ((Attribute)this.attributeProvider.getRowObject(relevantRowIndex)).eContainer();
                if (eObject instanceof ConfigurableObject) {
                    ConfigurableObject configurableObject = (ConfigurableObject)eObject;
                    return decl.isValidObject(configurableObject);
                }
            }
            return true;
        };
        final AttributeNameCellEditor attributeNameCellEditor = new AttributeNameCellEditor();
        attributeNameCellEditor.enableContentProposal((IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)new ImportTypeSelectionProposalProvider(() -> {
            int relevantRowIndex = NatTableWidgetFactory.getSelectionLayer((NatTable)this.natTable).getLastSelectedCellPosition().getRowPosition();
            return ((Attribute)this.attributeProvider.getRowObject(relevantRowIndex)).eContainer();
        }, TypeLibrary::getAttributeTypeEntry, (ITypeSelectionContentProvider)AttributeSelectionContentProvider.INSTANCE, targetFilter), KeyStroke.getInstance((int)262144, (int)32), null);
        this.natTable.addConfiguration((IConfiguration)new AbstractRegistryConfiguration(){

            public void configureRegistry(IConfigRegistry configRegistry) {
                configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)attributeNameCellEditor, DisplayMode.EDIT, "ATTRIBUTE_PROPOSAL_CELL");
            }
        });
    }

    public void createDynamicNatTable(AttributeDeclaration attributeDeclaration) {
        this.dynamicTable = true;
        if (this.natTable != null) {
            this.natTable.dispose();
        }
        AttributeDeclarationTableColumn.AttributeDeclarationTableColumnProvider tableColumnProider = new AttributeDeclarationTableColumn.AttributeDeclarationTableColumnProvider(attributeDeclaration);
        List columns = tableColumnProider.getColumns();
        Set editColumns = tableColumnProider.getEditableColumns();
        AttributeDeclarationColumnAccessor accessor = new AttributeDeclarationColumnAccessor(this.commandExecutor, columns);
        this.attributeProvider = new ChangeableListDataProvider((IColumnAccessor)accessor);
        this.attributeSorterModel = new SorterModel((AbstractColumnAccessor)accessor);
        DataLayer dataLayer = new DataLayer(this.attributeProvider);
        NatTableColumnProvider dataProvider = new NatTableColumnProvider(columns);
        dataLayer.setConfigLabelAccumulator((IConfigLabelAccumulator)new AttributeDeclarationConfigLabelAccumulator(this.attributeProvider, () -> null, columns));
        this.natTable = NatTableWidgetFactory.createRowNatTable((Composite)this.parent, (DataLayer)dataLayer, (IDataProvider)dataProvider, (IEditableRule)new NatTableColumnEditableRule(IEditableRule.ALWAYS_EDITABLE, columns, editColumns), (ICellEditor)new TypeSelectionButton(() -> {
            int relevantRowIndex = NatTableWidgetFactory.getSelectionLayer((NatTable)this.natTable).getLastSelectedCellPosition().getRowPosition();
            EObject eObject = EcoreUtil.getRootContainer((EObject)((EObject)this.attributeProvider.getRowObject(relevantRowIndex)));
            if (eObject instanceof LibraryElement) {
                LibraryElement libElement = (LibraryElement)eObject;
                return libElement.getTypeLibrary();
            }
            return null;
        }, (ITypeSelectionContentProvider)DataTypeSelectionContentProvider.INSTANCE, (TypeSelectionTreeContentProvider)DataTypeSelectionTreeContentProvider.INSTANCE), null, this.attributeSorterModel, (boolean)false);
        this.natTable.addConfiguration((IConfiguration)new SingleClickSortConfiguration());
        dataLayer.setColumnPercentageSizing(false);
        dataLayer.registerCommandHandler((ILayerCommandHandler)new AutoResizeColumnCommandHandler((ILayer)dataLayer, (ILayer)dataLayer));
        this.natTable.configure();
        this.natTable.addListener(37, event -> {
            if ((event.stateMask & 0x20000) != 0) {
                return;
            }
            ScrolledComposite scrolledParent = (ScrolledComposite)this.parent.getParent();
            Point origin = scrolledParent.getOrigin();
            int newY = Math.max(0, origin.y - event.count * 20);
            scrolledParent.setOrigin(origin.x, newY);
        });
    }

    public NatTable getCurrentTable() {
        return this.natTable;
    }

    private static <T> List<T> mapList(List<EObject> ori, Class<T> clazz) {
        ArrayList<T> result = new ArrayList<T>();
        for (EObject obj : ori) {
            if (!clazz.isInstance(obj)) continue;
            result.add(clazz.cast(obj));
        }
        return result;
    }

    private class AttributeNameCellEditor
    extends TextCellEditor {
        private AttributeNameCellEditor() {
        }

        protected void configureContentProposalAdapter(ContentProposalAdapter contentProposalAdapter) {
            contentProposalAdapter.addContentProposalListener(this::proposalAccepted);
            super.configureContentProposalAdapter(contentProposalAdapter);
        }

        protected void proposalAccepted(IContentProposal proposal) {
            if (proposal instanceof ImportContentProposal) {
                ImportContentProposal importProposal = (ImportContentProposal)proposal;
                EObject eObject = EcoreUtil.getRootContainer((EObject)((Attribute)BulkEditorNatTable.this.attributeProvider.getRowObject(this.getRowIndex())).eContainer());
                if (eObject instanceof LibraryElement) {
                    LibraryElement libraryElement = (LibraryElement)eObject;
                    if (!ImportHelper.matchesImports((String)importProposal.getImportedNamespace(), (LibraryElement)libraryElement)) {
                        BulkEditorNatTable.this.commandExecutor.executeCommand((Command)new AddNewImportCommand(libraryElement, importProposal.getImportedNamespace()));
                    }
                }
            }
        }
    }

    private class LinkedElementsEditableRule
    extends EditableRule {
        private final ChangeableListDataProvider<? extends EObject> provider;

        public LinkedElementsEditableRule(ChangeableListDataProvider<? extends EObject> provider) {
            this.provider = provider;
        }

        public boolean isEditable(int columnIndex, int rowIndex) {
            EObject rootElement = EcoreUtil.getRootContainer((EObject)((EObject)this.provider.getRowObject(rowIndex)));
            if (rootElement instanceof LibraryElement) {
                LibraryElement libElement = (LibraryElement)rootElement;
                return SearchHelper.linkedElementsFilter.test(libElement.getTypeEntry());
            }
            return true;
        }
    }
}

