/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.nat;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.helpers.PackageNameHelper;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.ui.widget.DataObjectTransfer;
import org.eclipse.fordiac.ide.ui.widget.FordiacCopyDataCommandHandler;
import org.eclipse.fordiac.ide.ui.widget.ImportTransfer;
import org.eclipse.fordiac.ide.ui.widget.NatTableColumn;
import org.eclipse.fordiac.ide.ui.widget.NatTableColumnProvider;
import org.eclipse.nebula.widgets.nattable.copy.command.CopyDataToClipboardCommand;
import org.eclipse.nebula.widgets.nattable.data.ListDataProvider;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;

public class CopyDataImportCommandHandler
extends FordiacCopyDataCommandHandler {
    private final NatTableColumnProvider<? extends NatTableColumn> columnProvider;
    private final Map<? extends NatTableColumn, Function<EObject, LibraryElement>> colMapper;

    public CopyDataImportCommandHandler(SelectionLayer selectionLayer, NatTableColumnProvider<? extends NatTableColumn> columnProvider, Map<? extends NatTableColumn, Function<EObject, LibraryElement>> colMapper) {
        super(selectionLayer);
        this.columnProvider = columnProvider;
        this.colMapper = colMapper;
    }

    protected void internalDoCommand(CopyDataToClipboardCommand command, ILayerCell[][] assembledCopiedDataStructure) {
        super.internalDoCommand(command, assembledCopiedDataStructure);
        Map<Object, List<Object>> imports = this.getImports(assembledCopiedDataStructure);
        Clipboard clipboard = new Clipboard(Display.getDefault());
        Object objects = clipboard.getContents((Transfer)DataObjectTransfer.getInstance());
        Object textContent = clipboard.getContents((Transfer)TextTransfer.getInstance());
        if (objects != null) {
            clipboard.setContents(new Object[]{objects, imports}, new Transfer[]{DataObjectTransfer.getInstance(), ImportTransfer.getInstance()});
        } else if (textContent != null) {
            clipboard.setContents(new Object[]{textContent, imports}, new Transfer[]{TextTransfer.getInstance(), ImportTransfer.getInstance()});
        }
        clipboard.dispose();
    }

    private Map<Object, List<Object>> getImports(ILayerCell[][] assembledCopiedDataStructure) {
        ILayer iLayer = this.selectionLayer.getUnderlyingLayerByPosition(0, 0);
        if (iLayer instanceof DataLayer) {
            DataLayer dataLayer = (DataLayer)iLayer;
            ListDataProvider provider = (ListDataProvider)dataLayer.getDataProvider();
            List rowIndices = this.selectionLayer.getSelectedRowPositions().stream().flatMap(range -> range.getMembers().stream()).sorted().toList();
            return Arrays.stream(assembledCopiedDataStructure).flatMap(Arrays::stream).filter(Objects::nonNull).filter(cell -> this.colMapper.containsKey(this.columnProvider.getColumns().get(cell.getColumnIndex()))).map(cell -> {
                Object object = provider.getRowObject(cell.getRowIndex());
                if (object instanceof EObject) {
                    EObject eObject = (EObject)object;
                    LibraryElement element = this.colMapper.get(this.columnProvider.getColumns().get(cell.getColumnIndex())).apply(eObject);
                    if (PackageNameHelper.getPackageName((LibraryElement)element).isEmpty()) {
                        return null;
                    }
                    return Map.entry(PackageNameHelper.getFullTypeName((LibraryElement)element), rowIndices.indexOf(cell.getRowIndex()));
                }
                return null;
            }).filter(Objects::nonNull).filter(entry -> !((String)entry.getKey()).isEmpty()).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
        }
        return Map.of();
    }
}

