/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.vertiflex.p1yplacement;

import org.eclipse.elk.alg.vertiflex.InternalProperties;
import org.eclipse.elk.alg.vertiflex.VertiFlexLayoutPhases;
import org.eclipse.elk.alg.vertiflex.options.VertiFlexOptions;
import org.eclipse.elk.core.alg.ILayoutPhase;
import org.eclipse.elk.core.alg.LayoutProcessorConfiguration;
import org.eclipse.elk.core.math.ElkMargin;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.properties.IProperty;

public class NodeYPlacer
implements ILayoutPhase<VertiFlexLayoutPhases, ElkNode> {
    private double layerDistance;
    private double nodeNodeSpacing;

    public void process(ElkNode graph, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("YPlacer", 1.0f);
        this.layerDistance = (Double)graph.getProperty(VertiFlexOptions.LAYER_DISTANCE);
        this.nodeNodeSpacing = (Double)graph.getProperty(CoreOptions.SPACING_NODE_NODE);
        if (!graph.getChildren().isEmpty()) {
            ElkNode parent = (ElkNode)graph.getProperty(InternalProperties.ROOT_NODE);
            this.setYLevels(parent, 0.0);
        }
        progressMonitor.done();
    }

    private void setYLevels(ElkNode node, double minHeight) {
        if (node.hasProperty(VertiFlexOptions.VERTICAL_CONSTRAINT)) {
            minHeight = (Double)node.getProperty(VertiFlexOptions.VERTICAL_CONSTRAINT);
        }
        node.setY(minHeight);
        double newMinHeight = minHeight + this.layerDistance + node.getHeight() + Math.max(((ElkMargin)node.getProperty((IProperty)CoreOptions.MARGINS)).bottom, this.nodeNodeSpacing);
        int i = 0;
        while (i < node.getOutgoingEdges().size()) {
            ElkNode child = (ElkNode)((ElkEdge)node.getOutgoingEdges().get(i)).getTargets().get(0);
            this.setYLevels(child, newMinHeight);
            ++i;
        }
    }

    public LayoutProcessorConfiguration<VertiFlexLayoutPhases, ElkNode> getLayoutProcessorConfiguration(ElkNode graph) {
        return null;
    }
}

