/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.create;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.fordiac.ide.model.commands.create.CreateInterfaceElementCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteInterfaceCommand;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;

public class CreateStructFromInterfaceElementsCommand
extends Command {
    private List<VarDeclaration> elementsToRemove = new ArrayList<VarDeclaration>();
    private final int position;
    private boolean hasInputVariables;
    private final DataType datatype;
    private final CompoundCommand deleteCmds = new CompoundCommand();
    private Command addStructCmd;

    public CreateStructFromInterfaceElementsCommand(List<VarDeclaration> selection, DataType datatype) {
        this.elementsToRemove = Collections.unmodifiableList(selection);
        if (!this.elementsToRemove.isEmpty()) {
            this.hasInputVariables = this.elementsToRemove.get(0).isIsInput();
        }
        this.position = this.elementsToRemove.isEmpty() ? 0 : this.getTopMostPosition();
        this.datatype = datatype;
    }

    private int getTopMostPosition() {
        int topPos = this.getInterfaceElementList().size();
        List<VarDeclaration> il = this.getInterfaceElementList();
        for (VarDeclaration varDecl : this.elementsToRemove) {
            int currPos = il.indexOf(varDecl);
            if (currPos >= topPos) continue;
            topPos = currPos;
        }
        return topPos;
    }

    private List<VarDeclaration> getInterfaceElementList() {
        if (this.hasInputVariables) {
            return this.getInterfaceList().getInputVars();
        }
        return this.getInterfaceList().getOutputVars();
    }

    private InterfaceList getInterfaceList() {
        return this.elementsToRemove.get(0).getInterfaceList();
    }

    public boolean canExecute() {
        if (this.elementsToRemove.isEmpty()) {
            return false;
        }
        InterfaceList il = this.getInterfaceList();
        if (il.getBlockFBNetworkElement().getTypeEntry() != null) {
            return false;
        }
        boolean isInputs = this.elementsToRemove.get(0).isIsInput();
        for (VarDeclaration varDecl : this.elementsToRemove) {
            if (varDecl.isIsInput() != isInputs) {
                return false;
            }
            VarDeclaration element = il.getVariable(varDecl.getName());
            if (element.getInputConnections().isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void execute() {
        for (VarDeclaration varDecl : this.elementsToRemove) {
            this.deleteCmds.add((Command)new DeleteInterfaceCommand((IInterfaceElement)varDecl));
        }
        this.addStructCmd = new CreateInterfaceElementCommand(this.datatype, this.getInterfaceList(), this.hasInputVariables, this.position);
        this.deleteCmds.execute();
        this.addStructCmd.execute();
    }

    public void undo() {
        this.addStructCmd.undo();
        this.deleteCmds.undo();
    }

    public void redo() {
        this.deleteCmds.redo();
        this.addStructCmd.redo();
    }
}

