/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group;

import java.util.Collection;
import org.eclipse.collections.api.factory.primitive.IntSets;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.nebula.widgets.nattable.group.RowGroupUtils;
import org.eclipse.nebula.widgets.nattable.group.command.RowGroupExpandCollapseCommandHandler;
import org.eclipse.nebula.widgets.nattable.group.model.IRowGroup;
import org.eclipse.nebula.widgets.nattable.group.model.IRowGroupModel;
import org.eclipse.nebula.widgets.nattable.group.model.IRowGroupModelListener;
import org.eclipse.nebula.widgets.nattable.hideshow.AbstractRowHideShowLayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.util.ArrayUtil;

public class RowGroupExpandCollapseLayer<T>
extends AbstractRowHideShowLayer
implements IRowGroupModelListener {
    private final IRowGroupModel<T> model;

    public RowGroupExpandCollapseLayer(IUniqueIndexLayer underlyingLayer, IRowGroupModel<T> model) {
        super(underlyingLayer);
        this.model = model;
        model.registerRowGroupModelListener(this);
        this.registerCommandHandler(new RowGroupExpandCollapseCommandHandler(this));
    }

    public IRowGroupModel<T> getModel() {
        return this.model;
    }

    @Override
    public boolean isRowIndexHidden(int rowIndex) {
        boolean isCollapsedAndNotStaticRow;
        if (rowIndex >= this.model.getDataProvider().getRowCount()) {
            return true;
        }
        IUniqueIndexLayer underlyingLayer = this.getUnderlyingLayer();
        boolean isHiddeninUnderlyingLayer = RowGroupUtils.isRowIndexHiddenInUnderLyingLayer(rowIndex, this, underlyingLayer);
        T row = this.model.getRowFromIndexCache(rowIndex);
        IRowGroup<T> rowGroup = this.model.getRowGroupForRow(row);
        if (rowGroup == null) {
            return false;
        }
        boolean bl = isCollapsedAndNotStaticRow = RowGroupUtils.isCollapsed(this.model, rowGroup) && !rowGroup.getOwnStaticMemberRows().contains(row);
        return isHiddeninUnderlyingLayer || isCollapsedAndNotStaticRow;
    }

    @Override
    public Collection<Integer> getHiddenRowIndexes() {
        return ArrayUtil.asIntegerList(this.getHiddenRowIndexesArray());
    }

    @Override
    public int[] getHiddenRowIndexesArray() {
        MutableIntSet hiddenRowIndexes = IntSets.mutable.empty();
        IUniqueIndexLayer underlyingLayer = this.getUnderlyingLayer();
        int underlyingColumnCount = underlyingLayer.getRowCount();
        int i = 0;
        while (i < underlyingColumnCount) {
            int rowIndex = underlyingLayer.getRowIndexByPosition(i);
            if (this.isRowIndexHidden(rowIndex)) {
                hiddenRowIndexes.add(rowIndex);
            }
            ++i;
        }
        return hiddenRowIndexes.toSortedArray();
    }

    @Override
    public boolean hasHiddenRows() {
        for (IRowGroup<T> rowGroup : this.model.getRowGroups()) {
            if (!rowGroup.isCollapsed()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void rowGroupModelChanged() {
        this.invalidateCache();
    }

    @Override
    protected synchronized void invalidateCache() {
        super.invalidateCache();
        this.model.invalidateIndexCache();
    }
}

