/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.reorder.command;

import org.eclipse.nebula.widgets.nattable.command.AbstractLayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.reorder.ColumnReorderLayer;
import org.eclipse.nebula.widgets.nattable.reorder.command.MultiColumnReorderCommand;

public class MultiColumnReorderCommandHandler
extends AbstractLayerCommandHandler<MultiColumnReorderCommand> {
    private final ColumnReorderLayer columnReorderLayer;

    public MultiColumnReorderCommandHandler(ColumnReorderLayer columnReorderLayer) {
        this.columnReorderLayer = columnReorderLayer;
    }

    @Override
    protected boolean doCommand(MultiColumnReorderCommand command) {
        int[] fromColumnPositions = command.getFromColumnPositionsArray();
        int toColumnPosition = command.getToColumnPosition();
        boolean reorderToLeftEdge = command.isReorderToLeftEdge();
        if (!command.isReorderByIndex()) {
            this.columnReorderLayer.reorderMultipleColumnPositions(fromColumnPositions, toColumnPosition, reorderToLeftEdge);
        } else {
            this.columnReorderLayer.reorderMultipleColumnIndexes(fromColumnPositions, toColumnPosition, reorderToLeftEdge);
        }
        return true;
    }

    @Override
    public Class<MultiColumnReorderCommand> getCommandClass() {
        return MultiColumnReorderCommand.class;
    }
}

